/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.DHInterface;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import io.dcloud.PdrR;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.internal.splash.ISplash;

public class SplashView
extends RelativeLayout {
    public static int STYLE_DEFAULT = 0;
    public static int STYLE_BLACK = 1;
    public static int STYLE_WHITE = 2;
    protected boolean mShowSplashScreen;
    protected boolean mShowSplashWaiting;
    final String TAG;
    int screenWidth;
    int screenHeight;
    boolean showBitmap;
    private boolean hasAdSplash;

    public SplashView(Context context, Bitmap bitmap) {
        SplashView splashView = this;
        SplashView splashView2 = this;
        super(context);
        splashView2.mShowSplashScreen = false;
        splashView2.mShowSplashWaiting = false;
        splashView2.TAG = "SplashView";
        splashView2.showBitmap = false;
        splashView2.hasAdSplash = false;
        splashView2.setBackgroundColor(-1);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        splashView.screenWidth = displayMetrics.widthPixels;
        splashView.screenHeight = displayMetrics.heightPixels;
        if (NinePatch.isNinePatchChunk((byte[])bitmap.getNinePatchChunk())) {
            Rect rect;
            NinePatchDrawable ninePatchDrawable;
            displayMetrics = ninePatchDrawable;
            context = context.getResources();
            byte[] byArray = bitmap.getNinePatchChunk();
            Rect rect2 = rect;
            rect = new Rect();
            ninePatchDrawable = new NinePatchDrawable((Resources)context, bitmap, byArray, rect2, null);
        } else {
            BitmapDrawable bitmapDrawable;
            displayMetrics = bitmapDrawable;
            bitmapDrawable = new BitmapDrawable(context.getResources(), bitmap);
        }
        if (Build.VERSION.SDK_INT < 16) {
            this.setBackgroundDrawable((Drawable)displayMetrics);
            return;
        }
        this.setBackground((Drawable)displayMetrics);
    }

    public void showWaiting() {
        this.showWaiting(STYLE_DEFAULT);
    }

    protected void onShowProgressBar(ViewGroup viewGroup, int n5) {
        RelativeLayout.LayoutParams layoutParams;
        ProgressBar progressBar;
        if (splashView2.hasAdSplash) {
            return;
        }
        SplashView splashView = splashView2;
        Logger.d("Main_Path", "showWaiting style=" + n5);
        ProgressBar progressBar2 = progressBar;
        progressBar = new ProgressBar(splashView2.getContext());
        int n6 = PdrUtil.parseInt("7%", splashView.screenWidth, -1);
        splashView.setGravity(17);
        Drawable drawable2 = null;
        if (n5 == STYLE_BLACK) {
            drawable2 = splashView2.getContext().getResources().getDrawable(PdrR.DRAWBLE_PROGRESSBAR_BLACK_SNOW);
        } else if (n5 == STYLE_WHITE) {
            drawable2 = splashView2.getContext().getResources().getDrawable(PdrR.DRAWBLE_PROGRESSBAR_WHITE_SNOW);
        }
        if (drawable2 != null) {
            progressBar2.setIndeterminateDrawable(drawable2);
        }
        SplashView splashView2 = layoutParams;
        int n7 = n6;
        layoutParams = new RelativeLayout.LayoutParams(n7, n7);
        viewGroup.addView((View)progressBar2, (ViewGroup.LayoutParams)splashView2);
        Logger.d("Main_Path", "onShowProgressBar");
    }

    public void showWaiting(final int n5) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                SplashView splashView = SplashView.this;
                splashView.onShowProgressBar((ViewGroup)splashView, n5);
            }
        };
        this.post(runnable2);
    }

    protected void dispatchDraw(Canvas canvas) {
        if (DeviceInfo.sStatusBarHeight <= 0) {
            Logger.d("SplashView", "paint() before DeviceInfo.updateScreenInfo()");
            DeviceInfo.updateStatusBarHeight((Activity)this.getContext());
        }
        Logger.d("SplashView", "dispatchDraw.....");
        super.dispatchDraw(canvas);
    }

    public void addView(View view, int n5, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n5, layoutParams);
        if (view instanceof ISplash) {
            this.hasAdSplash = true;
            return;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (this.hasAdSplash) {
            return super.dispatchTouchEvent(motionEvent);
        }
        return true;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return true;
    }
}

