/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.module;

import android.os.Handler;
import android.os.Message;
import android.util.SparseArray;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXHashMap;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;

public class WXTimerModule
extends WXModule
implements Destroyable,
Handler.Callback {
    private static final String TAG = "timer";
    private Handler handler = new Handler(WXBridgeManager.getInstance().getJSLooper(), (Handler.Callback)this);
    private SparseArray<Integer> antiIntAutoBoxing = new SparseArray();

    private void checkIfTimerInBack(int n) {
        WXSDKInstance wXSDKInstance = WXSDKManager.getInstance().getSDKInstance(String.valueOf(n));
        if (wXSDKInstance != null && wXSDKInstance.isViewDisAppear()) {
            wXSDKInstance.getApmForInstance().updateDiffStats("wxTimerInBackCount", 1.0);
            return;
        }
    }

    private WXJSObject[] createTimerArgs(int n, int n2, boolean bl) {
        WXJSObject wXJSObject;
        WXJSObject wXJSObject2;
        WXHashMap<String, Object> wXHashMap;
        ArrayList arrayList;
        Object[] objectArray = arrayList;
        objectArray();
        objectArray.add(n2);
        objectArray.add(new HashMap());
        arrayList.add(bl);
        Object object = wXHashMap;
        new WXHashMap<String, Object>().put("method", "callback");
        ((WXHashMap)object).put("args", objectArray);
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = object;
        object = wXJSObject2;
        wXJSObject2 = new WXJSObject(2, String.valueOf(n));
        WXJSObject wXJSObject3 = wXJSObject;
        wXJSObject = new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(objectArray));
        return new WXJSObject[]{object, wXJSObject3};
    }

    private void postOrHoldMessage(int n, int n2, int n3, int n4) {
        if (this.mWXSDKInstance.isPreRenderMode()) {
            this.postMessage(n, n2, n3, n4);
            return;
        }
        this.postMessage(n, n2, n3, n4);
    }

    private void removeOrHoldMessage(int n, int n2) {
        if (this.mWXSDKInstance.isPreRenderMode()) {
            int n3 = n2;
            this.handler.removeMessages(n, this.antiIntAutoBoxing.get(n3, (Object)n3));
            return;
        }
        int n4 = n2;
        this.handler.removeMessages(n, this.antiIntAutoBoxing.get(n4, (Object)n4));
    }

    private void postMessage(int n, @IntRange(from=1L) int n2, @IntRange(from=0L) int n3, int n4) {
        if (n3 >= 0 && n2 > 0) {
            if (wXTimerModule2.antiIntAutoBoxing.get(n2) == null) {
                int n5 = n2;
                wXTimerModule2.antiIntAutoBoxing.put(n5, (Object)n5);
            }
            WXTimerModule wXTimerModule = wXTimerModule2;
            WXTimerModule wXTimerModule2 = wXTimerModule.handler.obtainMessage(n, n4, n3, wXTimerModule2.antiIntAutoBoxing.get(n2));
            wXTimerModule.handler.sendMessageDelayed((Message)wXTimerModule2, (long)n3);
            return;
        }
        WXLogUtils.e(TAG, "interval < 0 or funcId <=0");
    }

    @JSMethod(uiThread=false)
    public void setTimeout(@IntRange(from=1L) int n, @FloatRange(from=0.0) float f) {
        WXSDKInstance wXSDKInstance = this.mWXSDKInstance;
        if (wXSDKInstance != null) {
            WXTimerModule wXTimerModule = this;
            int n2 = (int)f;
            int n3 = WXUtils.parseInt(wXSDKInstance.getInstanceId());
            wXTimerModule.postOrHoldMessage(11, n, n2, n3);
            if (wXTimerModule.mWXSDKInstance.getWXPerformance() != null) {
                ++this.mWXSDKInstance.getWXPerformance().timerInvokeCount;
            }
            this.mWXSDKInstance.getApmForInstance().updateFSDiffStats("wxFSTimerCount", 1.0);
            return;
        }
    }

    @JSMethod(uiThread=false)
    public void setInterval(@IntRange(from=1L) int n, @FloatRange(from=0.0) float f) {
        WXSDKInstance wXSDKInstance = this.mWXSDKInstance;
        if (wXSDKInstance != null) {
            WXTimerModule wXTimerModule = this;
            int n2 = (int)f;
            int n3 = WXUtils.parseInt(wXSDKInstance.getInstanceId());
            wXTimerModule.postOrHoldMessage(12, n, n2, n3);
            if (wXTimerModule.mWXSDKInstance.getWXPerformance() != null) {
                ++this.mWXSDKInstance.getWXPerformance().timerInvokeCount;
            }
            this.mWXSDKInstance.getApmForInstance().updateFSDiffStats("wxFSTimerCount", 1.0);
            return;
        }
    }

    @JSMethod(uiThread=false)
    public void clearTimeout(@IntRange(from=1L) int n) {
        if (n <= 0) {
            return;
        }
        this.removeOrHoldMessage(11, n);
    }

    @JSMethod(uiThread=false)
    public void clearInterval(@IntRange(from=1L) int n) {
        if (n <= 0) {
            return;
        }
        this.removeOrHoldMessage(12, n);
    }

    @Override
    public void destroy() {
        if (this.handler != null) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(TAG, "Timer Module removeAllMessages: ");
            }
            WXTimerModule wXTimerModule = this;
            wXTimerModule.handler.removeCallbacksAndMessages(null);
            wXTimerModule.antiIntAutoBoxing.clear();
            return;
        }
    }

    public boolean handleMessage(Message message) {
        int n = 0;
        if (message != null) {
            int n2 = message.what;
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(TAG, "Timer Module handleMessage : " + message.what);
            }
            if (n2 != 11) {
                if (n2 == 12 && message.obj != null) {
                    Message message2 = message;
                    wXJSObjectArray.checkIfTimerInBack(message.arg1);
                    int n3 = (Integer)message2.obj;
                    n = message2.arg2;
                    n2 = message2.arg1;
                    super.postMessage(12, n3, n, n2);
                    WXJSObject[] wXJSObjectArray = super.createTimerArgs(message.arg1, (Integer)message.obj, true);
                    WXBridgeManager.getInstance().invokeExecJS(String.valueOf(message.arg1), null, "callJS", wXJSObjectArray, true);
                    return true;
                }
            } else if (message.obj != null) {
                wXJSObjectArray.checkIfTimerInBack(message.arg1);
                WXJSObject[] wXJSObjectArray = wXJSObjectArray.createTimerArgs(message.arg1, (Integer)message.obj, false);
                WXBridgeManager.getInstance().invokeExecJS(String.valueOf(message.arg1), null, "callJS", wXJSObjectArray, true);
                return true;
            }
        }
        return n != 0;
    }

    @VisibleForTesting
    void setHandler(Handler handler) {
        this.handler = handler;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface MessageType {
    }
}

