/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.media.weex.weex_video.ijkplayer.media;

import android.view.View;
import java.lang.ref.WeakReference;

public final class MeasureHelper {
    private WeakReference<View> mWeakView;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mVideoSarNum;
    private int mVideoSarDen;
    private int mVideoRotationDegree;
    private int mMeasuredWidth;
    private int mMeasuredHeight;
    private int mCurrentAspectRatio = 0;

    public MeasureHelper(View view) {
        this.mWeakView = new WeakReference<View>(view);
    }

    public View getView() {
        if (this.mWeakView == null) {
            return null;
        }
        return (View)this.mWeakView.get();
    }

    public void setVideoSize(int videoWidth, int videoHeight) {
        this.mVideoWidth = videoWidth;
        this.mVideoHeight = videoHeight;
    }

    public void setVideoSampleAspectRatio(int videoSarNum, int videoSarDen) {
        this.mVideoSarNum = videoSarNum;
        this.mVideoSarDen = videoSarDen;
    }

    public void setVideoRotation(int videoRotationDegree) {
        this.mVideoRotationDegree = videoRotationDegree;
    }

    public void doMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mVideoRotationDegree == 90 || this.mVideoRotationDegree == 270) {
            int tempSpec = widthMeasureSpec;
            widthMeasureSpec = heightMeasureSpec;
            heightMeasureSpec = tempSpec;
        }
        int width = View.getDefaultSize((int)this.mVideoWidth, (int)widthMeasureSpec);
        int height = View.getDefaultSize((int)this.mVideoHeight, (int)heightMeasureSpec);
        if (this.mCurrentAspectRatio == 3) {
            width = widthMeasureSpec;
            height = heightMeasureSpec;
        } else if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthSpecMode == Integer.MIN_VALUE || heightSpecMode == Integer.MIN_VALUE) {
                float displayAspectRatio;
                float specAspectRatio = (float)widthSpecSize / (float)heightSpecSize;
                switch (this.mCurrentAspectRatio) {
                    case 4: {
                        displayAspectRatio = 1.7777778f;
                        if (this.mVideoRotationDegree != 90 && this.mVideoRotationDegree != 270) break;
                        displayAspectRatio = 1.0f / displayAspectRatio;
                        break;
                    }
                    case 5: {
                        displayAspectRatio = 1.3333334f;
                        if (this.mVideoRotationDegree != 90 && this.mVideoRotationDegree != 270) break;
                        displayAspectRatio = 1.0f / displayAspectRatio;
                        break;
                    }
                    default: {
                        displayAspectRatio = (float)this.mVideoWidth / (float)this.mVideoHeight;
                        if (this.mVideoSarNum <= 0 || this.mVideoSarDen <= 0) break;
                        displayAspectRatio = displayAspectRatio * (float)this.mVideoSarNum / (float)this.mVideoSarDen;
                    }
                }
                boolean shouldBeWider = displayAspectRatio > specAspectRatio;
                switch (this.mCurrentAspectRatio) {
                    case 0: 
                    case 4: 
                    case 5: {
                        if (shouldBeWider) {
                            width = widthSpecSize;
                            height = (int)((float)width / displayAspectRatio);
                            break;
                        }
                        height = heightSpecSize;
                        width = (int)((float)height * displayAspectRatio);
                        break;
                    }
                    case 1: {
                        if (shouldBeWider) {
                            height = heightSpecSize;
                            width = (int)((float)height * displayAspectRatio);
                            break;
                        }
                        width = widthSpecSize;
                        height = (int)((float)width / displayAspectRatio);
                        break;
                    }
                    default: {
                        if (shouldBeWider) {
                            width = Math.min(this.mVideoWidth, widthSpecSize);
                            height = (int)((float)width / displayAspectRatio);
                            break;
                        }
                        height = Math.min(this.mVideoHeight, heightSpecSize);
                        width = (int)((float)height * displayAspectRatio);
                        break;
                    }
                }
            } else if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (this.mVideoWidth * height < width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                } else if (this.mVideoWidth * height > width * this.mVideoHeight) {
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * this.mVideoHeight / this.mVideoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * this.mVideoWidth / this.mVideoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                }
            } else {
                width = this.mVideoWidth;
                height = this.mVideoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * this.mVideoWidth / this.mVideoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            }
        }
        this.mMeasuredWidth = width;
        this.mMeasuredHeight = height;
    }

    public int getMeasuredWidth() {
        return this.mMeasuredWidth;
    }

    public int getMeasuredHeight() {
        return this.mMeasuredHeight;
    }

    public void setAspectRatio(int aspectRatio) {
        this.mCurrentAspectRatio = aspectRatio;
    }
}

