/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.Dimension;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.Writer;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.datamatrix.encoder.DefaultPlacement;
import com.dcloud.zxing2.datamatrix.encoder.ErrorCorrection;
import com.dcloud.zxing2.datamatrix.encoder.HighLevelEncoder;
import com.dcloud.zxing2.datamatrix.encoder.SymbolInfo;
import com.dcloud.zxing2.datamatrix.encoder.SymbolShapeHint;
import com.dcloud.zxing2.qrcode.encoder.ByteMatrix;
import java.util.Map;

public final class DataMatrixWriter
implements Writer {
    private static BitMatrix encodeLowLevel(DefaultPlacement defaultPlacement, SymbolInfo symbolInfo) {
        ByteMatrix byteMatrix;
        SymbolInfo symbolInfo2 = symbolInfo;
        int n5 = symbolInfo2.getSymbolDataWidth();
        int n6 = symbolInfo2.getSymbolDataHeight();
        ByteMatrix byteMatrix2 = byteMatrix;
        SymbolInfo symbolInfo3 = symbolInfo;
        int n7 = symbolInfo3.getSymbolWidth();
        byteMatrix = new ByteMatrix(n7, symbolInfo3.getSymbolHeight());
        n7 = 0;
        for (int i5 = 0; i5 < n6; ++i5) {
            int n8;
            int n9;
            int n10;
            if (i5 % symbolInfo.matrixHeight == 0) {
                n10 = 0;
                for (n9 = 0; n9 < symbolInfo.getSymbolWidth(); ++n9) {
                    n8 = n9 % 2 == 0 ? 1 : 0;
                    byteMatrix2.set(n10, n7, n8 != 0);
                    ++n10;
                }
                ++n7;
            }
            n10 = 0;
            for (n9 = 0; n9 < n5; ++n9) {
                if (n9 % symbolInfo.matrixWidth == 0) {
                    byteMatrix2.set(n10, n7, true);
                    ++n10;
                }
                byteMatrix2.set(n10, n7, defaultPlacement.getBit(n9, i5));
                n8 = n10 + 1;
                int n11 = symbolInfo.matrixWidth;
                if (n9 % n11 == n11 - 1) {
                    n11 = i5 % 2 == 0 ? 1 : 0;
                    byteMatrix2.set(n8, n7, n11 != 0);
                    n10 += 2;
                    continue;
                }
                n10 = n8;
            }
            n10 = n7 + 1;
            n9 = symbolInfo.matrixHeight;
            if (i5 % n9 == n9 - 1) {
                n9 = 0;
                for (n8 = 0; n8 < symbolInfo.getSymbolWidth(); ++n8) {
                    byteMatrix2.set(n9, n10, true);
                    ++n9;
                }
                n7 += 2;
                continue;
            }
            n7 = n10;
        }
        return DataMatrixWriter.convertByteMatrixToBitMatrix(byteMatrix2);
    }

    private static BitMatrix convertByteMatrixToBitMatrix(ByteMatrix byteMatrix) {
        BitMatrix bitMatrix;
        ByteMatrix byteMatrix2 = byteMatrix;
        int n5 = byteMatrix2.getWidth();
        int n6 = byteMatrix2.getHeight();
        BitMatrix bitMatrix2 = bitMatrix;
        new BitMatrix(n5, n6).clear();
        for (int i5 = 0; i5 < n5; ++i5) {
            for (int i6 = 0; i6 < n6; ++i6) {
                if (byteMatrix.get(i5, i6) != 1) continue;
                bitMatrix2.set(i5, i6);
            }
        }
        return bitMatrix2;
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6) {
        return this.encode(string2, barcodeFormat, n5, n6, null);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat object, int n5, int n6, Map<EncodeHintType, ?> map) {
        if (!string2.isEmpty()) {
            if (object == BarcodeFormat.DATA_MATRIX) {
                if (n5 >= 0 && n6 >= 0) {
                    Object object2 = SymbolShapeHint.FORCE_NONE;
                    object = null;
                    Object object3 = null;
                    if (map != null) {
                        Object object4 = (SymbolShapeHint)((Object)map.get((Object)EncodeHintType.DATA_MATRIX_SHAPE));
                        if (object4 != null) {
                            object2 = object4;
                        }
                        if ((object4 = (Dimension)map.get((Object)EncodeHintType.MIN_SIZE)) != null) {
                            object = object4;
                        }
                        if ((object4 = (Dimension)map.get((Object)EncodeHintType.MAX_SIZE)) != null) {
                            object3 = object4;
                        }
                    }
                    String string3 = HighLevelEncoder.encodeHighLevel(string2, (SymbolShapeHint)((Object)object2), (Dimension)object, object3);
                    object2 = SymbolInfo.lookup(string3.length(), (SymbolShapeHint)((Object)object2), (Dimension)object, object3, true);
                    string2 = ErrorCorrection.encodeECC200(string3, (SymbolInfo)object2);
                    Object object5 = object2;
                    int n7 = ((SymbolInfo)object5).getSymbolDataWidth();
                    DefaultPlacement defaultPlacement = new DefaultPlacement(string2, n7, ((SymbolInfo)object5).getSymbolDataHeight());
                    defaultPlacement.place();
                    return DataMatrixWriter.encodeLowLevel(defaultPlacement, (SymbolInfo)object2);
                }
                throw new IllegalArgumentException("Requested dimensions are too small: " + n5 + 'x' + n6);
            }
            throw new IllegalArgumentException("Can only encode DATA_MATRIX, but got " + (Object)object);
        }
        throw new IllegalArgumentException("Found empty contents");
    }
}

