/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned.rss;

import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.oned.OneDReader;

public abstract class AbstractRSSReader
extends OneDReader {
    private static final float MAX_AVG_VARIANCE = 0.2f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.45f;
    private static final float MIN_FINDER_PATTERN_RATIO = 0.7916667f;
    private static final float MAX_FINDER_PATTERN_RATIO = 0.89285713f;
    private final int[] decodeFinderCounters = new int[4];
    private final int[] dataCharacterCounters;
    private final float[] oddRoundingErrors;
    private final float[] evenRoundingErrors;
    private final int[] oddCounts;
    private final int[] evenCounts;

    protected AbstractRSSReader() {
        int[] nArray = new int[8];
        Object object = nArray;
        v1.dataCharacterCounters = nArray;
        v1.oddRoundingErrors = new float[4];
        v1.evenRoundingErrors = new float[4];
        v1.oddCounts = new int[((Object)object).length / 2];
        v1.evenCounts = new int[((Object)object).length / 2];
    }

    protected static int parseFinderValue(int[] nArray, int[][] nArray2) throws NotFoundException {
        for (int i5 = 0; i5 < nArray2.length; ++i5) {
            if (!(OneDReader.patternMatchVariance(nArray, nArray2[i5], 0.45f) < 0.2f)) continue;
            return i5;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected static int count(int[] nArray) {
        int n5 = 0;
        int n6 = nArray.length;
        for (int i5 = 0; i5 < n6; ++i5) {
            n5 += nArray[i5];
        }
        return n5;
    }

    protected static void increment(int[] nArray, float[] fArray) {
        int n5 = 0;
        float f5 = fArray[0];
        for (int i5 = 1; i5 < nArray.length; ++i5) {
            float f6;
            float f7 = fArray[i5];
            if (!(f6 > f5)) continue;
            f5 = f7;
            n5 = i5;
        }
        nArray[n5] = nArray[n5] + 1;
    }

    protected static void decrement(int[] nArray, float[] fArray) {
        int n5 = 0;
        float f5 = fArray[0];
        for (int i5 = 1; i5 < nArray.length; ++i5) {
            float f6;
            float f7 = fArray[i5];
            if (!(f6 < f5)) continue;
            f5 = f7;
            n5 = i5;
        }
        nArray[n5] = nArray[n5] - 1;
    }

    protected static boolean isFinderPattern(int[] nArray) {
        float f5;
        int n5 = nArray[0] + nArray[1];
        int n6 = n5 + nArray[2] + nArray[3];
        float f6 = (float)n5 / (float)n6;
        if (f5 >= 0.7916667f && f6 <= 0.89285713f) {
            int n7 = Integer.MAX_VALUE;
            int n8 = Integer.MIN_VALUE;
            for (int n9 : nArray) {
                if (n9 > n8) {
                    n8 = n9;
                }
                if (n9 >= n7) continue;
                n7 = n9;
            }
            return n8 < n7 * 10;
        }
        return false;
    }

    protected final int[] getDecodeFinderCounters() {
        return this.decodeFinderCounters;
    }

    protected final int[] getDataCharacterCounters() {
        return this.dataCharacterCounters;
    }

    protected final float[] getOddRoundingErrors() {
        return this.oddRoundingErrors;
    }

    protected final float[] getEvenRoundingErrors() {
        return this.evenRoundingErrors;
    }

    protected final int[] getOddCounts() {
        return this.oddCounts;
    }

    protected final int[] getEvenCounts() {
        return this.evenCounts;
    }
}

