/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.media.video.ijkplayer;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import io.dcloud.common.DHInterface.IVideoPlayer;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.util.FileUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.media.video.VideoPlayerMgr;
import io.dcloud.media.video.ijkplayer.OnPlayerChangedListener;
import io.dcloud.media.video.ijkplayer.media.IjkPlayerView;
import io.dcloud.media.video.ijkplayer.option.EnumPlayStrategy;
import java.util.HashMap;
import org.json.JSONObject;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public class VideoPlayerView
extends FrameLayout
implements IVideoPlayer {
    private IjkPlayerView mPlayerView;
    private IWebview mIWebview;
    private String mUrl;
    private String mHeaderInfo;
    private String mPosterUrl;
    private JSONObject mOptions;
    private HashMap<String, HashMap<String, String>> mCallbacks;
    private boolean isAutoPlay = false;
    private boolean isLoopPlay = false;
    public JSONObject fullScreenOptions = null;
    public boolean videoHandleTouch = false;
    private int[] rect;

    public void setFullScreenOptions(JSONObject fullScreenOptions) {
        this.fullScreenOptions = fullScreenOptions;
    }

    public VideoPlayerView(@NonNull Activity context, IWebview webview, JSONObject style) {
        super((Context)context);
        this.mIWebview = webview;
        this.mPlayerView = new IjkPlayerView((Context)context, null, this);
        this.addView((View)this.mPlayerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mCallbacks = new HashMap();
        this.mPlayerView.init().setPlayerRootView((ViewGroup)this);
        this.mPlayerView.setOnInfoListener(new IMediaPlayer.OnInfoListener(){

            /*
             * Enabled aggressive block sorting
             */
            public boolean onInfo(IMediaPlayer iMediaPlayer, int status, int extra) {
                block10: {
                    block9: {
                        if (VideoPlayerView.this.mIWebview.obtainApp() == null) {
                            return false;
                        }
                        if (status == 336) {
                            VideoPlayerView.this.statusChanged("ended", "");
                            if (!VideoPlayerView.this.isLoopPlay) return false;
                            int seek = VideoPlayerView.this.mOptions.optInt("initial-time");
                            if (seek > 0) {
                                VideoPlayerView.this.mPlayerView.seekTo(seek * 1000);
                            }
                            VideoPlayerView.this.play();
                            return false;
                        }
                        if (status == 334) {
                            VideoPlayerView.this.statusChanged("play", "");
                            return false;
                        }
                        if (status == 335) {
                            VideoPlayerView.this.statusChanged("pause", "");
                            return false;
                        }
                        if (status == 331) {
                            VideoPlayerView.this.statusChanged("error", "");
                            return false;
                        }
                        if (status == 332) break block9;
                        if (status != 701) break block10;
                    }
                    VideoPlayerView.this.statusChanged("waiting", "");
                    return false;
                }
                if (status != 337) return false;
                VideoPlayerView.this.statusChanged("seekcomplete", StringUtil.format((String)"{'position':%d}", (Object[])new Object[]{VideoPlayerView.this.mPlayerView != null ? VideoPlayerView.this.mPlayerView.getCurPosition() : 0}));
                return false;
            }
        });
        this.mPlayerView.setOnPlayerChangedListener(new OnPlayerChangedListener(){

            @Override
            public void onChanged(String type, String msg) {
                VideoPlayerView.this.statusChanged(type, msg);
            }
        });
        this.initOptionsPlayerView(this.mPlayerView, style);
    }

    public boolean isVideoHandleTouch() {
        return this.videoHandleTouch;
    }

    public void initOptionsPlayerView(IjkPlayerView playerView, JSONObject options) {
        this.mOptions = options;
        String url = this.mOptions.optString("src");
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (!PdrUtil.isNetPath((String)url)) {
            Uri fileUri;
            url = this.mIWebview.obtainApp().convert2AbsFullPath(this.mIWebview.obtainFullUrl(), url);
            if (url.startsWith("/android_asset")) {
                url = url.replace("/android_asset", "");
            } else if (url.startsWith("android_asset")) {
                url = url.replace("android_asset", "");
            }
            if (!PdrUtil.isDeviceRootDir((String)url) && !TextUtils.isEmpty((CharSequence)url)) {
                url = this.mIWebview.obtainApp().checkPrivateDirAndCopy2Temp(url);
                url = this.mIWebview.obtainApp().convert2AbsFullPath(this.mIWebview.obtainFullUrl(), url);
            }
            if (!FileUtil.checkPrivatePath((Context)this.getContext(), (String)url) && (fileUri = FileUtil.getVideoFileUri((Context)this.getContext(), (String)url)) != null) {
                url = fileUri.toString();
            }
        }
        this.isAutoPlay = this.mOptions.optBoolean("autoplay", this.isAutoPlay);
        this.isLoopPlay = this.mOptions.optBoolean("loop", this.isLoopPlay);
        this.setPoster(this.mOptions.optString("poster"));
        if (!this.mOptions.isNull("muted")) {
            playerView.setMutePlayer(this.mOptions.optBoolean("muted", false));
        }
        boolean gestureSwitch = false;
        if (this.mOptions.optBoolean("page-gesture", false) || this.mOptions.optBoolean("vslide-gesture", false)) {
            gestureSwitch = true;
            this.videoHandleTouch = true;
        }
        playerView.setPageGesture(gestureSwitch);
        playerView.setIsFullScreenPageGesture(this.mOptions.optBoolean("vslide-gesture-in-fullscreen", true));
        playerView.setIsShowScreenLockButton(this.mOptions.optBoolean("show-screen-lock-button", false));
        playerView.setProgressVisibility(this.mOptions.optBoolean("show-progress", true));
        playerView.setFullscreenBntVisibility(this.mOptions.optBoolean("show-fullscreen-btn", true));
        playerView.setPlayBntVisibility(this.mOptions.optBoolean("show-play-btn", true));
        playerView.setIsEnableProgressGesture(this.mOptions.optBoolean("enable-progress-gesture", true));
        playerView.setmIsDoubleTapEnable(this.mOptions.optBoolean("enable-play-gesture", false));
        playerView.setLoadingVisibility(this.mOptions.optBoolean("show-loading", true));
        int orientation = this.mOptions.optInt("direction", -90);
        playerView.setDirection(orientation);
        playerView.setmDanmuList(this.mOptions.optString("danmu-list"));
        if (this.mOptions.has("objectFit")) {
            playerView.setScaleType(this.mOptions.optString("objectFit", "contain"));
        } else if (this.mOptions.has("object-fit")) {
            playerView.setScaleType(this.mOptions.optString("object-fit", "contain"));
        }
        playerView.isMuteBtnShow(this.mOptions.optBoolean("show-mute-btn", false));
        if (this.mOptions.has("codec")) {
            playerView.isUseMediaCodec(this.mOptions.optString("codec").equals("hardware"));
        }
        if (this.mOptions.has("advanced")) {
            playerView.setCustomAdvanced(this.mOptions.optString("advanced"));
        }
        if (this.mOptions.has("httpCache")) {
            playerView.setViewHttpCacheOpen(this.mOptions.optBoolean("httpCache", false));
        }
        if (this.mOptions.has("playStrategy")) {
            int flowStrategyFlag = this.mOptions.optInt("playStrategy", EnumPlayStrategy.DEFAULT.getFlagVal());
            EnumPlayStrategy enumPlayStrategy = EnumPlayStrategy.PLAY_SMOOTH;
            if (flowStrategyFlag == EnumPlayStrategy.PLAY_SMOOTH.getFlagVal()) {
                enumPlayStrategy = EnumPlayStrategy.PLAY_SMOOTH;
            } else if (flowStrategyFlag == EnumPlayStrategy.START_QUICK.getFlagVal()) {
                enumPlayStrategy = EnumPlayStrategy.START_QUICK;
            } else if (flowStrategyFlag == EnumPlayStrategy.M3U8_SMOOTH.getFlagVal()) {
                enumPlayStrategy = EnumPlayStrategy.M3U8_SMOOTH;
            } else if (flowStrategyFlag == EnumPlayStrategy.DEFAULT.getFlagVal()) {
                enumPlayStrategy = EnumPlayStrategy.DEFAULT;
            }
            playerView.setFlowStrategy(enumPlayStrategy);
        }
        String headerInfo = options.optString("header");
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            this.mPlayerView.setVideoPath(url, headerInfo);
            this.resetSeek(playerView);
        } else if (!this.mUrl.equalsIgnoreCase(url) || !this.mHeaderInfo.equalsIgnoreCase(headerInfo)) {
            this.mPlayerView.switchVideoPath(url, headerInfo);
            this.resetSeek(playerView);
            this.mPlayerView.setMutePlayer(this.mPlayerView.isMutePlayer());
        }
        playerView.setCenterPlayBntVisibility(this.mOptions.optBoolean("show-center-play-btn", true));
        playerView.setControls(this.mOptions.optBoolean("controls", true));
        playerView.setDuration(this.mOptions.optInt("duration", -1) * 1000);
        if (options.has("title")) {
            playerView.setTitle(options.optString("title"));
        }
        this.mUrl = url;
        this.mHeaderInfo = headerInfo;
    }

    public int getDirection() {
        if (this.mOptions != null && this.mOptions.has("direction")) {
            try {
                return Integer.parseInt(this.mOptions.optString("direction"));
            }
            catch (Exception e) {
                return Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    private void resetSeek(IjkPlayerView playerView) {
        int seek = this.mOptions.optInt("initial-time");
        playerView.seekTo(seek * 1000);
        this.mPlayerView.clearDanma();
        playerView.enableDanmaku(this.mOptions.optBoolean("enable-danmu", false));
        playerView.enableDanmuBtn(this.mOptions.optBoolean("danmu-btn", false));
        if (this.isAutoPlay) {
            this.play();
        }
    }

    public void play() {
        if (this.mPlayerView != null) {
            this.mPlayerView.start();
        }
    }

    public void pause() {
        if (this.mPlayerView != null) {
            this.mPlayerView.pause();
        }
    }

    public void resume() {
        if (this.mPlayerView != null) {
            this.mPlayerView.onResume();
        }
    }

    public void stop() {
        this.statusChanged("waiting", "");
        if (this.mPlayerView != null && !TextUtils.isEmpty((CharSequence)this.mUrl)) {
            this.mPlayerView.clearDanma();
            this.mPlayerView.switchVideoPath(this.mUrl, this.mHeaderInfo);
        }
    }

    public void close() {
        this.statusChanged("waiting", "");
        if (this.mPlayerView != null) {
            this.mPlayerView.stop();
            this.mPlayerView.onDestroy();
            this.mPlayerView = null;
        }
    }

    public void seek(String position) {
        int msec = Integer.parseInt(position);
        if (this.mPlayerView != null) {
            this.mPlayerView.seekTo(msec * 1000);
        }
    }

    public void sendDanmu(JSONObject danmu) {
        if (this.mPlayerView != null) {
            this.mPlayerView.sendDanmaku(danmu, true);
        }
    }

    public void playbackRate(String rate) {
        if (this.mPlayerView != null) {
            this.mPlayerView.playbackRate(rate);
        }
    }

    public boolean onBackPressed() {
        return this.mPlayerView.onBackPressed();
    }

    public void requestFullScreen(String direction) {
        int orientation = Integer.parseInt(direction);
        if (this.mPlayerView != null) {
            this.mPlayerView.fullScreen(orientation);
        }
    }

    public void exitFullScreen() {
        if (this.mPlayerView != null) {
            this.mPlayerView.exitFullScreen();
        }
    }

    public void setOptions(JSONObject options) {
        if (options != null) {
            this.mPlayerView.hiddenLoaded(true);
            this.initOptionsPlayerView(this.mPlayerView, options);
        }
    }

    private void setPoster(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mPosterUrl) || !this.mPosterUrl.equalsIgnoreCase(url)) {
            Glide.with((View)this).load(url).into(this.mPlayerView.mPlayerThumb);
        }
        this.mPosterUrl = url;
    }

    public void addEventListener(String event, String jsCallback, String webId) {
        HashMap<String, String> callBacks = this.mCallbacks.get(event);
        if (callBacks == null) {
            callBacks = new HashMap();
        }
        callBacks.put(jsCallback, webId);
        this.mCallbacks.put(event, callBacks);
    }

    public boolean isFullScreen() {
        if (this.mPlayerView != null) {
            return this.mPlayerView.isFullscreen();
        }
        return false;
    }

    public boolean isPlaying() {
        if (this.mPlayerView != null) {
            return this.mPlayerView.isPlaying();
        }
        return false;
    }

    public void release() {
        if (this.mPlayerView != null) {
            this.mPlayerView.onDestroy();
            this.mPlayerView = null;
        }
    }

    public boolean isPointInRect(float x, float y) {
        return this.rect != null && x > (float)this.rect[0] && x < (float)this.rect[2] && y > (float)this.rect[1] && y < (float)this.rect[3];
    }

    public void setRect(int[] rect) {
        this.rect = rect;
    }

    public void statusChanged(String type, String msg) {
        if (this.mCallbacks.containsKey(type)) {
            HashMap<String, String> callbacks = this.mCallbacks.get(type);
            for (String key : callbacks.keySet()) {
                IWebview eventWebview = PdrUtil.isEmpty((Object)callbacks.get(key)) ? this.mIWebview : VideoPlayerMgr.getInstance().findWebview(this.mIWebview, callbacks.get(key));
                JSUtil.execCallback((IWebview)eventWebview, (String)key, (String)msg, (int)JSUtil.OK, (!TextUtils.isEmpty((CharSequence)msg) ? 1 : 0) != 0, (boolean)true);
            }
        }
    }
}

