/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.Code93Reader;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import java.util.Map;

public class Code93Writer
extends OneDimensionalCodeWriter {
    private static void toIntArray(int n5, int[] nArray) {
        for (int i5 = 0; i5 < 9; ++i5) {
            int n6 = (n5 & 1 << 8 - i5) == 0 ? 0 : 1;
            nArray[i5] = n6;
        }
    }

    protected static int appendPattern(boolean[] blArray, int n5, int[] nArray, boolean n6) {
        n6 = nArray.length;
        for (int i5 = 0; i5 < n6; ++i5) {
            int n7 = n5 + 1;
            boolean bl = nArray[i5] != 0;
            blArray[n5] = bl;
            n5 = n7;
        }
        return 9;
    }

    private static int computeChecksumIndex(String string2, int n5) {
        int n6 = 1;
        int n7 = 0;
        for (int i5 = string2.length() - 1; i5 >= 0; --i5) {
            n7 += "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(string2.charAt(i5)) * n6;
            if (++n6 <= n5) continue;
            n6 = 1;
        }
        return n7 % 47;
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.CODE_93) {
            return super.encode(string2, barcodeFormat, n5, n6, map);
        }
        throw new IllegalArgumentException("Can only encode CODE_93, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String string2) {
        int n5 = string2.length();
        if (n5 <= 80) {
            int[] nArray = new int[9];
            boolean[] blArray = new boolean[(string2.length() + 4) * 9 + 1];
            Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[47], nArray);
            int n6 = Code93Writer.appendPattern(blArray, 0, nArray, true);
            for (int i5 = 0; i5 < n5; ++i5) {
                Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS["0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(string2.charAt(i5))], nArray);
                n6 += Code93Writer.appendPattern(blArray, n6, nArray, true);
            }
            n5 = Code93Writer.computeChecksumIndex(string2, 20);
            int[] nArray2 = Code93Reader.CHARACTER_ENCODINGS;
            Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[n5], nArray);
            int n7 = n6 + Code93Writer.appendPattern(blArray, n6, nArray, true);
            Code93Writer.toIntArray(nArray2[Code93Writer.computeChecksumIndex(string2 + "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".charAt(n5), 15)], nArray);
            int n8 = n7 + Code93Writer.appendPattern(blArray, n7, nArray, true);
            Code93Writer.toIntArray(nArray2[47], nArray);
            blArray[n8 + Code93Writer.appendPattern((boolean[])blArray, (int)n8, (int[])nArray, (boolean)true)] = true;
            return blArray;
        }
        throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n5);
    }
}

