/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.encoder;

import com.dcloud.zxing2.pdf417.encoder.BarcodeRow;

public final class BarcodeMatrix {
    private final BarcodeRow[] matrix;
    private int currentRow;
    private final int height;
    private final int width;

    BarcodeMatrix(int n5, int n6) {
        this.matrix = new BarcodeRow[n5];
        int n7 = this.matrix.length;
        for (int i5 = 0; i5 < n7; ++i5) {
            BarcodeRow barcodeRow;
            BarcodeRow barcodeRow2 = barcodeRow;
            barcodeRow = new BarcodeRow((n6 + 4) * 17 + 1);
            this.matrix[i5] = barcodeRow2;
        }
        BarcodeMatrix barcodeMatrix = this;
        this.width = n6 * 17;
        barcodeMatrix.height = n5;
        barcodeMatrix.currentRow = -1;
    }

    void set(int n5, int n6, byte by) {
        this.matrix[n6].set(n5, by);
    }

    void startRow() {
        ++this.currentRow;
    }

    BarcodeRow getCurrentRow() {
        return this.matrix[this.currentRow];
    }

    public byte[][] getMatrix() {
        return this.getScaledMatrix(1, 1);
    }

    public byte[][] getScaledMatrix(int n5, int n6) {
        int n7 = this.height;
        byte[][] byArray = new byte[n7 * n6][this.width * n5];
        int n8 = n7 * n6;
        for (int i5 = 0; i5 < n8; ++i5) {
            byArray[n8 - i5 - 1] = this.matrix[i5 / n6].getScaledRow(n5);
        }
        return byArray;
    }
}

