/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.tls.CertificateChainCleaner;
import dc.squareup.okio.ByteString;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class CertificatePinner {
    public static final CertificatePinner DEFAULT = new Builder().build();
    private final Set<Pin> pins;
    @Nullable
    private final CertificateChainCleaner certificateChainCleaner;

    CertificatePinner(Set<Pin> set, @Nullable CertificateChainCleaner certificateChainCleaner) {
        this.pins = set;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    public static String pin(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            return "sha256/" + CertificatePinner.sha256((X509Certificate)certificate).base64();
        }
        throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
    }

    static ByteString sha1(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha1();
    }

    static ByteString sha256(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha256();
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CertificatePinner) {
            object = (CertificatePinner)object;
            if (Util.equal(this.certificateChainCleaner, ((CertificatePinner)object).certificateChainCleaner) && this.pins.equals(((CertificatePinner)object).pins)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        CertificateChainCleaner certificateChainCleaner = this.certificateChainCleaner;
        return (certificateChainCleaner != null ? certificateChainCleaner.hashCode() : 0) * 31 + this.pins.hashCode();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void check(String string2, List<Certificate> list) throws SSLPeerUnverifiedException {
        List<Pin> list2 = ((CertificatePinner)((Object)certificateChainCleaner)).findMatchingPins(string2);
        if (list2.isEmpty()) return;
        CertificateChainCleaner certificateChainCleaner = ((CertificatePinner)((Object)certificateChainCleaner)).certificateChainCleaner;
        if (certificateChainCleaner != null) {
            list = certificateChainCleaner.clean(list, string2);
        }
        int n5 = list.size();
        for (int i5 = 0; i5 < n5; ++i5) {
            X509Certificate x509Certificate = (X509Certificate)list.get(i5);
            Object var6_13 = null;
            ByteString byteString = null;
            int n6 = list2.size();
            for (int i6 = 0; i6 < n6; ++i6) {
                Pin pin = list2.get(i6);
                if (pin.hashAlgorithm.equals("sha256/")) {
                    if (byteString == null) {
                        byteString = CertificatePinner.sha256(x509Certificate);
                    }
                    if (!pin.hash.equals(byteString)) continue;
                    return;
                } else {
                    void var6_12;
                    if (!pin.hashAlgorithm.equals("sha1/")) throw new AssertionError((Object)("unsupported hashAlgorithm: " + pin.hashAlgorithm));
                    if (var6_12 == null) {
                        ByteString byteString2 = CertificatePinner.sha1(x509Certificate);
                    }
                    if (!pin.hash.equals(var6_12)) continue;
                }
                return;
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("Certificate pinning failure!").append("\n  Peer certificate chain:");
        int n7 = list.size();
        for (n5 = 0; n5 < n7; ++n5) {
            X509Certificate x509Certificate = (X509Certificate)list.get(n5);
            stringBuilder.append("\n    ").append(CertificatePinner.pin(x509Certificate)).append(": ").append(x509Certificate.getSubjectDN().getName());
        }
        stringBuilder.append("\n  Pinned certificates for ").append(string2).append(":");
        int n8 = list2.size();
        for (int i7 = 0; i7 < n8; ++i7) {
            Pin pin = list2.get(i7);
            stringBuilder.append("\n    ").append(pin);
        }
        throw new SSLPeerUnverifiedException(stringBuilder.toString());
    }

    public void check(String string2, Certificate ... certificateArray) throws SSLPeerUnverifiedException {
        this.check(string2, Arrays.asList(certificateArray));
    }

    List<Pin> findMatchingPins(String string2) {
        CertificatePinner certificatePinner = object;
        Object object = Collections.EMPTY_LIST;
        for (Pin pin : certificatePinner.pins) {
            if (!pin.matches(string2)) continue;
            if (object.isEmpty()) {
                ArrayList arrayList;
                object = arrayList;
                arrayList = new ArrayList();
            }
            object.add(pin);
        }
        return object;
    }

    CertificatePinner withCertificateChainCleaner(@Nullable CertificateChainCleaner certificateChainCleaner) {
        if (Util.equal(this.certificateChainCleaner, certificateChainCleaner)) {
            return this;
        }
        return new CertificatePinner(this.pins, certificateChainCleaner);
    }

    static final class Pin {
        private static final String WILDCARD = "*.";
        final String pattern;
        final String canonicalHostname;
        final String hashAlgorithm;
        final ByteString hash;

        Pin(String string2, String string3) {
            block6: {
                block5: {
                    block4: {
                        this.pattern = string2;
                        string2 = string2.startsWith(WILDCARD) ? HttpUrl.get("http://" + string2.substring(2)).host() : HttpUrl.get("http://" + string2).host();
                        this.canonicalHostname = string2;
                        if (!string3.startsWith("sha1/")) break block4;
                        this.hashAlgorithm = "sha1/";
                        this.hash = ByteString.decodeBase64(string3.substring(5));
                        break block5;
                    }
                    if (!string3.startsWith("sha256/")) break block6;
                    this.hashAlgorithm = "sha256/";
                    this.hash = ByteString.decodeBase64(string3.substring(7));
                }
                if (this.hash != null) {
                    return;
                }
                throw new IllegalArgumentException("pins must be base64: " + string3);
            }
            throw new IllegalArgumentException("pins must start with 'sha256/' or 'sha1/': " + string3);
        }

        boolean matches(String string2) {
            if (this.pattern.startsWith(WILDCARD)) {
                int n5;
                String string3 = string2;
                int n6 = string3.indexOf(46);
                return string3.length() - n6 - 1 == this.canonicalHostname.length() && string2.regionMatches(false, n5 = n6 + 1, string2 = this.canonicalHostname, 0, n6 = string2.length());
            }
            return string2.equals(this.canonicalHostname);
        }

        public boolean equals(Object object) {
            if (object instanceof Pin) {
                object = (Pin)object;
                if (this.pattern.equals(((Pin)object).pattern) && this.hashAlgorithm.equals(((Pin)object).hashAlgorithm) && this.hash.equals(((Pin)object).hash)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return ((527 + this.pattern.hashCode()) * 31 + this.hashAlgorithm.hashCode()) * 31 + this.hash.hashCode();
        }

        public String toString() {
            return this.hashAlgorithm + this.hash.base64();
        }
    }

    public static final class Builder {
        private final List<Pin> pins;

        public Builder() {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            v1.pins = arrayList2;
        }

        public Builder add(String string2, String ... stringArray) {
            if (string2 != null) {
                for (String string3 : stringArray) {
                    this.pins.add(new Pin(string2, string3));
                }
                return this;
            }
            throw new NullPointerException("pattern == null");
        }

        public CertificatePinner build() {
            return new CertificatePinner(new LinkedHashSet<Pin>(this.pins), null);
        }
    }
}

