/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.universalchardet.prober.Big5Prober;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.UTF8Prober;

public class MBCSGroupProber
extends CharsetProber {
    private CharsetProber.ProbingState state;
    private List<CharsetProber> probers;
    private CharsetProber bestGuess;
    private int activeNum;

    public MBCSGroupProber() {
        MBCSGroupProber mBCSGroupProber = this;
        this.probers = new ArrayList<CharsetProber>();
        this.probers.add(new UTF8Prober());
        mBCSGroupProber.probers.add(new Big5Prober());
        mBCSGroupProber.reset();
    }

    @Override
    public String getCharSetName() {
        if (this.bestGuess == null) {
            MBCSGroupProber mBCSGroupProber = this;
            mBCSGroupProber.getConfidence();
            if (mBCSGroupProber.bestGuess == null) {
                this.bestGuess = this.probers.get(0);
            }
        }
        return this.bestGuess.getCharSetName();
    }

    @Override
    public float getConfidence() {
        float f5 = 0.0f;
        Object object = this.state;
        if (object == CharsetProber.ProbingState.FOUND_IT) {
            return 0.99f;
        }
        if (object == CharsetProber.ProbingState.NOT_ME) {
            return 0.01f;
        }
        for (CharsetProber charsetProber : this.probers) {
            float f6;
            if (!charsetProber.isActive()) continue;
            float f7 = charsetProber.getConfidence();
            if (!(f5 < f6)) continue;
            this.bestGuess = charsetProber;
            f5 = f7;
        }
        return f5;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] object, int n5, int n6) {
        int n7 = 1;
        byte[] byArray = new byte[n6];
        int n8 = 0;
        n6 = n5 + n6;
        while (n5 < n6) {
            byte by = object[n5];
            if ((by & 0x80) != 0) {
                n7 = n8 + 1;
                byArray[n8] = by;
                int n9 = n8 = 1;
                n8 = n7;
                n7 = n9;
            } else if (n7 != 0) {
                n7 = n8 + 1;
                byArray[n8] = by;
                int n10 = n8 = 0;
                n8 = n7;
                n7 = n10;
            }
            ++n5;
        }
        object = this.probers.iterator();
        while (object.hasNext()) {
            CharsetProber.ProbingState probingState;
            CharsetProber charsetProber = (CharsetProber)object.next();
            if (!charsetProber.isActive()) continue;
            CharsetProber.ProbingState probingState2 = charsetProber.handleData(byArray, 0, n8);
            if (probingState2 == (probingState = CharsetProber.ProbingState.FOUND_IT)) {
                MBCSGroupProber mBCSGroupProber = this;
                mBCSGroupProber.bestGuess = charsetProber;
                mBCSGroupProber.state = probingState;
                break;
            }
            if (probingState2 != (probingState2 = CharsetProber.ProbingState.NOT_ME)) continue;
            charsetProber.setActive(false);
            if (--this.activeNum > 0) continue;
            this.state = probingState2;
            break;
        }
        return this.state;
    }

    @Override
    public void reset() {
        this.activeNum = 0;
        for (CharsetProber charsetProber : this.probers) {
            charsetProber.reset();
            charsetProber.setActive(true);
            ++this.activeNum;
        }
        MBCSGroupProber mBCSGroupProber = this;
        mBCSGroupProber.bestGuess = null;
        mBCSGroupProber.state = CharsetProber.ProbingState.DETECTING;
    }

    @Override
    public void setOption() {
    }
}

