/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.Writer;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.pdf417.encoder.Compaction;
import com.dcloud.zxing2.pdf417.encoder.Dimensions;
import com.dcloud.zxing2.pdf417.encoder.PDF417;
import java.nio.charset.Charset;
import java.util.Map;

public final class PDF417Writer
implements Writer {
    static final int WHITE_SPACE = 30;
    static final int DEFAULT_ERROR_CORRECTION_LEVEL = 2;

    private static BitMatrix bitMatrixFromEncoder(PDF417 object, String string2, int n5, int n6, int n7, int n8) throws WriterException {
        PDF417 pDF417 = object;
        pDF417.generateBarcodeLogic(string2, n5);
        int n9 = 4;
        byte[][] byArray = pDF417.getBarcodeMatrix().getScaledMatrix(1, n9);
        boolean bl = false;
        boolean bl2 = n7 > n6;
        boolean bl3 = byArray[0].length < byArray.length;
        if (bl2 ^ bl3) {
            byArray = PDF417Writer.rotateArray(byArray);
            bl = true;
        }
        if ((n6 /= byArray[0].length) >= (n7 /= byArray.length)) {
            n6 = n7;
        }
        if (n6 > 1) {
            int n10 = n6;
            object = ((PDF417)object).getBarcodeMatrix().getScaledMatrix(n10, n10 * n9);
            if (bl) {
                object = PDF417Writer.rotateArray((byte[][])object);
            }
            return PDF417Writer.bitMatrixFrombitArray((byte[][])object, n8);
        }
        return PDF417Writer.bitMatrixFrombitArray(byArray, n8);
    }

    private static BitMatrix bitMatrixFrombitArray(byte[][] byArray, int n5) {
        BitMatrix bitMatrix;
        BitMatrix bitMatrix2 = bitMatrix;
        int n6 = n5 * 2;
        new BitMatrix(byArray[0].length + n6, byArray.length + n6).clear();
        n6 = 0;
        int n7 = bitMatrix2.getHeight() - n5 - 1;
        while (n6 < byArray.length) {
            for (int i5 = 0; i5 < byArray[0].length; ++i5) {
                if (byArray[n6][i5] != 1) continue;
                bitMatrix2.set(i5 + n5, n7);
            }
            ++n6;
            --n7;
        }
        return bitMatrix2;
    }

    private static byte[][] rotateArray(byte[][] byArray) {
        byte[][] byArray2 = new byte[byArray[0].length][byArray.length];
        for (int i5 = 0; i5 < byArray.length; ++i5) {
            int n5 = byArray.length - i5 - 1;
            for (int i6 = 0; i6 < byArray[0].length; ++i6) {
                byArray2[i6][n5] = byArray[i5][i6];
            }
        }
        return byArray2;
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.PDF_417) {
            PDF417 pDF417;
            PDF417 pDF4172 = pDF417;
            pDF417 = new PDF417();
            int n7 = 30;
            int n8 = 2;
            if (map != null) {
                EncodeHintType encodeHintType;
                EncodeHintType encodeHintType2 = EncodeHintType.PDF417_COMPACT;
                if (map.containsKey((Object)encodeHintType2)) {
                    pDF4172.setCompact(Boolean.valueOf(map.get((Object)encodeHintType2).toString()));
                }
                if (map.containsKey((Object)(encodeHintType2 = EncodeHintType.PDF417_COMPACTION))) {
                    pDF4172.setCompaction(Compaction.valueOf(map.get((Object)encodeHintType2).toString()));
                }
                if (map.containsKey((Object)(encodeHintType2 = EncodeHintType.PDF417_DIMENSIONS))) {
                    Dimensions dimensions = (Dimensions)map.get((Object)encodeHintType2);
                    int n9 = dimensions.getMaxCols();
                    int n10 = dimensions.getMinCols();
                    int n11 = dimensions.getMaxRows();
                    int n12 = dimensions.getMinRows();
                    pDF4172.setDimensions(n9, n10, n11, n12);
                }
                if (map.containsKey((Object)(encodeHintType = EncodeHintType.MARGIN))) {
                    n7 = Integer.parseInt(map.get((Object)encodeHintType).toString());
                }
                if (map.containsKey((Object)(encodeHintType = EncodeHintType.ERROR_CORRECTION))) {
                    n8 = Integer.parseInt(map.get((Object)encodeHintType).toString());
                }
                if (map.containsKey((Object)(encodeHintType = EncodeHintType.CHARACTER_SET))) {
                    pDF4172.setEncoding(Charset.forName(map.get((Object)encodeHintType).toString()));
                }
            }
            return PDF417Writer.bitMatrixFromEncoder(pDF4172, string2, n8, n5, n6, n7);
        }
        throw new IllegalArgumentException("Can only encode PDF_417, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6) throws WriterException {
        return this.encode(string2, barcodeFormat, n5, n6, null);
    }
}

