/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.downloader;

import android.content.Context;
import com.dcloud.android.downloader.callback.DCDownloadManager;
import com.dcloud.android.downloader.config.Config;
import com.dcloud.android.downloader.core.DownloadResponse;
import com.dcloud.android.downloader.core.DownloadResponseImpl;
import com.dcloud.android.downloader.core.DownloadTaskImpl;
import com.dcloud.android.downloader.core.task.DownloadTask;
import com.dcloud.android.downloader.db.DefaultDownloadDBController;
import com.dcloud.android.downloader.db.DownloadDBController;
import com.dcloud.android.downloader.domain.DownloadInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class DownloadManagerImpl
implements DCDownloadManager,
DownloadTaskImpl.DownloadTaskListener {
    private static final int MIN_EXECUTE_INTERVAL = 500;
    private static DownloadManagerImpl instance;
    private final ExecutorService executorService;
    private final ConcurrentHashMap<Integer, DownloadTask> cacheDownloadTask;
    private final List<DownloadInfo> downloadingCaches;
    private final Context context;
    private final DownloadResponse downloadResponse;
    private final DownloadDBController downloadDBController;
    private final Config config;
    private long lastExecuteTime;

    private DownloadManagerImpl(Context object, Config config) {
        this.context = object;
        if (config == null) {
            Config config2;
            config = config2;
            config2 = new Config();
        }
        this.config = config;
        if (config.getDownloadDBController() == null) {
            DefaultDownloadDBController defaultDownloadDBController;
            DefaultDownloadDBController defaultDownloadDBController2 = defaultDownloadDBController;
            defaultDownloadDBController = new DefaultDownloadDBController((Context)object, config);
            this.downloadDBController = defaultDownloadDBController2;
        } else {
            this.downloadDBController = config.getDownloadDBController();
        }
        if (this.downloadDBController.findAllDownloading() == null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
            this.downloadingCaches = object;
        } else {
            this.downloadingCaches = this.downloadDBController.findAllDownloading();
        }
        DownloadManagerImpl downloadManagerImpl = this;
        this.cacheDownloadTask = new ConcurrentHashMap();
        this.downloadDBController.pauseAllDownloading();
        downloadManagerImpl.executorService = Executors.newFixedThreadPool(config.getDownloadThread());
        downloadManagerImpl.downloadResponse = new DownloadResponseImpl(this.downloadDBController);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DCDownloadManager getInstance(Context context, Config config) {
        Class<DownloadManagerImpl> clazz = DownloadManagerImpl.class;
        synchronized (DownloadManagerImpl.class) {
            Throwable throwable2;
            block4: {
                block3: {
                    try {
                        if (instance != null) break block3;
                        instance = new DownloadManagerImpl(context, config);
                    }
                    catch (Throwable throwable2) {
                        break block4;
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return instance;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            throw throwable2;
        }
    }

    private void prepareDownload(DownloadInfo downloadInfo) {
        DownloadTaskImpl downloadTaskImpl;
        if (this.cacheDownloadTask.size() >= this.config.getDownloadThread()) {
            downloadInfo.setStatus(3);
            this.downloadResponse.onStatusChanged(downloadInfo);
            return;
        }
        DownloadTaskImpl downloadTaskImpl2 = downloadTaskImpl;
        DownloadManagerImpl downloadManagerImpl = this;
        ExecutorService executorService = downloadManagerImpl.executorService;
        DownloadResponse downloadResponse = downloadManagerImpl.downloadResponse;
        Config config = downloadManagerImpl.config;
        downloadTaskImpl2(executorService, downloadResponse, downloadInfo, config, this);
        this.cacheDownloadTask.put(downloadInfo.getId(), downloadTaskImpl2);
        downloadInfo.setStatus(1);
        this.downloadResponse.onStatusChanged(downloadInfo);
        downloadTaskImpl.start();
    }

    private void prepareDownloadNextTask() {
        for (DownloadInfo downloadInfo : this.downloadingCaches) {
            if (downloadInfo.getStatus() != 3) continue;
            this.prepareDownload(downloadInfo);
            return;
        }
    }

    @Override
    public void download(DownloadInfo downloadInfo) {
        this.downloadingCaches.add(downloadInfo);
        this.prepareDownload(downloadInfo);
    }

    @Override
    public void pause(DownloadInfo downloadInfo) {
        if (this.isExecute()) {
            DownloadManagerImpl downloadManagerImpl = this;
            downloadInfo.setStatus(4);
            downloadManagerImpl.cacheDownloadTask.remove(downloadInfo.getId());
            downloadManagerImpl.downloadResponse.onStatusChanged(downloadInfo);
            downloadManagerImpl.prepareDownloadNextTask();
            return;
        }
    }

    @Override
    public void resume(DownloadInfo downloadInfo) {
        if (this.isExecute()) {
            this.cacheDownloadTask.remove(downloadInfo.getId());
            this.prepareDownload(downloadInfo);
            return;
        }
    }

    @Override
    public void remove(DownloadInfo downloadInfo) {
        DownloadManagerImpl downloadManagerImpl = this;
        downloadInfo.setStatus(7);
        downloadManagerImpl.cacheDownloadTask.remove(downloadInfo.getId());
        downloadManagerImpl.downloadingCaches.remove(downloadInfo);
        downloadManagerImpl.downloadDBController.delete(downloadInfo);
        downloadManagerImpl.downloadResponse.onStatusChanged(downloadInfo);
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public DownloadInfo getDownloadById(int n5) {
        DownloadInfo downloadInfo = null;
        for (DownloadInfo downloadInfo2 : this.downloadingCaches) {
            if (downloadInfo2.getId() != n5) continue;
            downloadInfo = downloadInfo2;
            break;
        }
        if (downloadInfo == null) {
            return this.downloadDBController.findDownloadedInfoById(n5);
        }
        return downloadInfo;
    }

    @Override
    public List<DownloadInfo> findAllDownloading() {
        return this.downloadingCaches;
    }

    @Override
    public List<DownloadInfo> findAllDownloaded() {
        return this.downloadDBController.findAllDownloaded();
    }

    @Override
    public DownloadDBController getDownloadDBController() {
        return this.downloadDBController;
    }

    @Override
    public void onDownloadSuccess(DownloadInfo downloadInfo) {
        DownloadManagerImpl downloadManagerImpl = this;
        downloadManagerImpl.cacheDownloadTask.remove(downloadInfo.getId());
        downloadManagerImpl.downloadingCaches.remove(downloadInfo);
        downloadManagerImpl.prepareDownloadNextTask();
    }

    public boolean isExecute() {
        if (System.currentTimeMillis() - this.lastExecuteTime > 500L) {
            this.lastExecuteTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }
}

