/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.v4.view;

import android.os.Build;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import com.dcloud.android.v4.view.NestedScrollingParent;
import com.dcloud.android.v4.view.ViewParentCompatICS;
import com.dcloud.android.v4.view.ViewParentCompatKitKat;
import com.dcloud.android.v4.view.ViewParentCompatLollipop;

public class ViewParentCompat {
    static final ViewParentCompatImpl IMPL;

    private ViewParentCompat() {
    }

    public static boolean requestSendAccessibilityEvent(ViewParent viewParent, View view, AccessibilityEvent accessibilityEvent) {
        return IMPL.requestSendAccessibilityEvent(viewParent, view, accessibilityEvent);
    }

    public static boolean onStartNestedScroll(ViewParent viewParent, View view, View view2, int n5) {
        return IMPL.onStartNestedScroll(viewParent, view, view2, n5);
    }

    public static void onNestedScrollAccepted(ViewParent viewParent, View view, View view2, int n5) {
        IMPL.onNestedScrollAccepted(viewParent, view, view2, n5);
    }

    public static void onStopNestedScroll(ViewParent viewParent, View view) {
        IMPL.onStopNestedScroll(viewParent, view);
    }

    public static void onNestedScroll(ViewParent viewParent, View view, int n5, int n6, int n7, int n8) {
        IMPL.onNestedScroll(viewParent, view, n5, n6, n7, n8);
    }

    public static void onNestedPreScroll(ViewParent viewParent, View view, int n5, int n6, int[] nArray) {
        IMPL.onNestedPreScroll(viewParent, view, n5, n6, nArray);
    }

    public static boolean onNestedFling(ViewParent viewParent, View view, float f5, float f6, boolean bl) {
        return IMPL.onNestedFling(viewParent, view, f5, f6, bl);
    }

    public static boolean onNestedPreFling(ViewParent viewParent, View view, float f5, float f6) {
        return IMPL.onNestedPreFling(viewParent, view, f5, f6);
    }

    public static void notifySubtreeAccessibilityStateChanged(ViewParent viewParent, View view, View view2, int n5) {
        IMPL.notifySubtreeAccessibilityStateChanged(viewParent, view, view2, n5);
    }

    static {
        int n5 = Build.VERSION.SDK_INT;
        IMPL = n5 >= 21 ? new ViewParentCompatLollipopImpl() : (n5 >= 19 ? new ViewParentCompatKitKatImpl() : (n5 >= 14 ? new ViewParentCompatICSImpl() : new ViewParentCompatStubImpl()));
    }

    static interface ViewParentCompatImpl {
        public boolean requestSendAccessibilityEvent(ViewParent var1, View var2, AccessibilityEvent var3);

        public boolean onStartNestedScroll(ViewParent var1, View var2, View var3, int var4);

        public void onNestedScrollAccepted(ViewParent var1, View var2, View var3, int var4);

        public void onStopNestedScroll(ViewParent var1, View var2);

        public void onNestedScroll(ViewParent var1, View var2, int var3, int var4, int var5, int var6);

        public void onNestedPreScroll(ViewParent var1, View var2, int var3, int var4, int[] var5);

        public boolean onNestedFling(ViewParent var1, View var2, float var3, float var4, boolean var5);

        public boolean onNestedPreFling(ViewParent var1, View var2, float var3, float var4);

        public void notifySubtreeAccessibilityStateChanged(ViewParent var1, View var2, View var3, int var4);
    }

    static class ViewParentCompatLollipopImpl
    extends ViewParentCompatKitKatImpl {
        ViewParentCompatLollipopImpl() {
        }

        @Override
        public boolean onStartNestedScroll(ViewParent viewParent, View view, View view2, int n5) {
            return ViewParentCompatLollipop.onStartNestedScroll(viewParent, view, view2, n5);
        }

        @Override
        public void onNestedScrollAccepted(ViewParent viewParent, View view, View view2, int n5) {
            ViewParentCompatLollipop.onNestedScrollAccepted(viewParent, view, view2, n5);
        }

        @Override
        public void onStopNestedScroll(ViewParent viewParent, View view) {
            ViewParentCompatLollipop.onStopNestedScroll(viewParent, view);
        }

        @Override
        public void onNestedScroll(ViewParent viewParent, View view, int n5, int n6, int n7, int n8) {
            ViewParentCompatLollipop.onNestedScroll(viewParent, view, n5, n6, n7, n8);
        }

        @Override
        public void onNestedPreScroll(ViewParent viewParent, View view, int n5, int n6, int[] nArray) {
            ViewParentCompatLollipop.onNestedPreScroll(viewParent, view, n5, n6, nArray);
        }

        @Override
        public boolean onNestedFling(ViewParent viewParent, View view, float f5, float f6, boolean bl) {
            return ViewParentCompatLollipop.onNestedFling(viewParent, view, f5, f6, bl);
        }

        @Override
        public boolean onNestedPreFling(ViewParent viewParent, View view, float f5, float f6) {
            return ViewParentCompatLollipop.onNestedPreFling(viewParent, view, f5, f6);
        }
    }

    static class ViewParentCompatKitKatImpl
    extends ViewParentCompatICSImpl {
        ViewParentCompatKitKatImpl() {
        }

        @Override
        public void notifySubtreeAccessibilityStateChanged(ViewParent viewParent, View view, View view2, int n5) {
            ViewParentCompatKitKat.notifySubtreeAccessibilityStateChanged(viewParent, view, view2, n5);
        }
    }

    static class ViewParentCompatICSImpl
    extends ViewParentCompatStubImpl {
        ViewParentCompatICSImpl() {
        }

        @Override
        public boolean requestSendAccessibilityEvent(ViewParent viewParent, View view, AccessibilityEvent accessibilityEvent) {
            return ViewParentCompatICS.requestSendAccessibilityEvent(viewParent, view, accessibilityEvent);
        }
    }

    static class ViewParentCompatStubImpl
    implements ViewParentCompatImpl {
        ViewParentCompatStubImpl() {
        }

        @Override
        public boolean requestSendAccessibilityEvent(ViewParent viewParent, View view, AccessibilityEvent accessibilityEvent) {
            if (view == null) {
                return false;
            }
            ((AccessibilityManager)view.getContext().getSystemService("accessibility")).sendAccessibilityEvent(accessibilityEvent);
            return true;
        }

        @Override
        public boolean onStartNestedScroll(ViewParent viewParent, View view, View view2, int n5) {
            if (viewParent instanceof NestedScrollingParent) {
                return ((NestedScrollingParent)viewParent).onStartNestedScroll(view, view2, n5);
            }
            return false;
        }

        @Override
        public void onNestedScrollAccepted(ViewParent viewParent, View view, View view2, int n5) {
            if (viewParent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)viewParent).onNestedScrollAccepted(view, view2, n5);
                return;
            }
        }

        @Override
        public void onStopNestedScroll(ViewParent viewParent, View view) {
            if (viewParent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)viewParent).onStopNestedScroll(view);
                return;
            }
        }

        @Override
        public void onNestedScroll(ViewParent viewParent, View view, int n5, int n6, int n7, int n8) {
            if (viewParent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)viewParent).onNestedScroll(view, n5, n6, n7, n8);
                return;
            }
        }

        @Override
        public void onNestedPreScroll(ViewParent viewParent, View view, int n5, int n6, int[] nArray) {
            if (viewParent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)viewParent).onNestedPreScroll(view, n5, n6, nArray);
                return;
            }
        }

        @Override
        public boolean onNestedFling(ViewParent viewParent, View view, float f5, float f6, boolean bl) {
            if (viewParent instanceof NestedScrollingParent) {
                return ((NestedScrollingParent)viewParent).onNestedFling(view, f5, f6, bl);
            }
            return false;
        }

        @Override
        public boolean onNestedPreFling(ViewParent viewParent, View view, float f5, float f6) {
            if (viewParent instanceof NestedScrollingParent) {
                return ((NestedScrollingParent)viewParent).onNestedPreFling(view, f5, f6);
            }
            return false;
        }

        @Override
        public void notifySubtreeAccessibilityStateChanged(ViewParent viewParent, View view, View view2, int n5) {
        }
    }
}

