/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.aztec.encoder;

import com.dcloud.zxing2.aztec.encoder.HighLevelEncoder;
import com.dcloud.zxing2.aztec.encoder.Token;
import com.dcloud.zxing2.common.BitArray;
import io.dcloud.common.util.StringUtil;
import java.util.LinkedList;

final class State {
    static final State INITIAL_STATE = new State(Token.EMPTY, 0, 0, 0);
    private final int mode;
    private final Token token;
    private final int binaryShiftByteCount;
    private final int bitCount;

    private State(Token token, int n5, int n6, int n7) {
        this.token = token;
        this.mode = n5;
        this.binaryShiftByteCount = n6;
        this.bitCount = n7;
    }

    int getMode() {
        return this.mode;
    }

    Token getToken() {
        return this.token;
    }

    int getBinaryShiftByteCount() {
        return this.binaryShiftByteCount;
    }

    int getBitCount() {
        return this.bitCount;
    }

    State latchAndAppend(int n5, int n6) {
        State state = this;
        int n7 = state.bitCount;
        Token token = state.token;
        int n8 = state.mode;
        if (n5 != n8) {
            int n9 = n7;
            int n10 = HighLevelEncoder.LATCH_TABLE[n8][n5];
            n7 = n10 & 0xFFFF;
            int n11 = n10 >> 16;
            Token token2 = token.add(n7, n11);
            n7 = n11 = n9 + n11;
            token = token2;
        }
        n8 = n5 == 2 ? 4 : 5;
        Token token3 = token.add(n6, n8);
        return new State(token3, n5, 0, n7 += n8);
    }

    State shiftAndAppend(int n5, int n6) {
        State state = this;
        Token token = state.token;
        int n7 = state.mode;
        int n8 = n7 == 2 ? 4 : 5;
        Token token2 = token.add(HighLevelEncoder.SHIFT_TABLE[n7][n5], n8).add(n6, 5);
        State state2 = this;
        int n9 = state2.mode;
        int n10 = state2.bitCount + n8 + 5;
        return new State(token2, n9, 0, n10);
    }

    State addBinaryShiftChar(int n5) {
        State state;
        int n6;
        State state2 = this;
        Token token = state2.token;
        int n7 = state2.mode;
        int n8 = this.bitCount;
        if (n7 == 4 || n7 == 2) {
            int n9 = HighLevelEncoder.LATCH_TABLE[n7][0];
            int n10 = n9 & 0xFFFF;
            n7 = n9 >> 16;
            token = token.add(n10, n7);
            n8 += n7;
            n7 = 0;
        }
        int n11 = (n6 = this.binaryShiftByteCount) != 0 && n6 != 31 ? (n6 == 62 ? 9 : 8) : 18;
        State state3 = state;
        int n12 = n8 + n11;
        if (new State((Token)token, (int)n7, (int)(++n6), (int)n12).binaryShiftByteCount == 2078) {
            return state3.endBinaryShift(n5 + 1);
        }
        return state3;
    }

    State endBinaryShift(int n5) {
        int n6 = this.binaryShiftByteCount;
        if (n6 == 0) {
            return this;
        }
        Token token = this.token.addBinaryShift(n5 - n6, n6);
        State state = this;
        int n7 = state.mode;
        int n8 = state.bitCount;
        return new State(token, n7, 0, n8);
    }

    boolean isBetterThanOrEqualTo(State state) {
        int n5;
        int n6 = this.bitCount + (HighLevelEncoder.LATCH_TABLE[this.mode][state.mode] >> 16);
        int n7 = state.binaryShiftByteCount;
        if (n7 > 0 && ((n5 = this.binaryShiftByteCount) == 0 || n5 > n7)) {
            n6 += 10;
        }
        return n6 <= state.bitCount;
    }

    BitArray toBitArray(byte[] byArray) {
        BitArray bitArray;
        Object object;
        LinkedList linkedList;
        State state = object2;
        Object object2 = linkedList;
        linkedList = new LinkedList();
        for (object = (v45958).endBinaryShift((int)byArray.length).token; object != null; object = ((Token)object).getPrevious()) {
            object2.addFirst(object);
        }
        Object object3 = object2;
        object2 = bitArray;
        bitArray = new BitArray();
        object = object3.iterator();
        while (object.hasNext()) {
            ((Token)object.next()).appendTo((BitArray)object2, byArray);
        }
        return object2;
    }

    public String toString() {
        State state = string2;
        String string2 = HighLevelEncoder.MODE_NAMES[((State)((Object)string2)).mode];
        Integer n5 = state.bitCount;
        Integer n6 = state.binaryShiftByteCount;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        objectArray[1] = n5;
        objectArray[2] = n6;
        return StringUtil.format("%s bits=%d bytes=%d", objectArray2);
    }
}

