/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.client.result;

import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.client.result.AddressBookParsedResult;
import com.dcloud.zxing2.client.result.ResultParser;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VCardResultParser
extends ResultParser {
    private static final Pattern BEGIN_VCARD = Pattern.compile("BEGIN:VCARD", 2);
    private static final Pattern VCARD_LIKE_DATE = Pattern.compile("\\d{4}-?\\d{2}-?\\d{2}");
    private static final Pattern CR_LF_SPACE_TAB = Pattern.compile("\r\n[ \t]");
    private static final Pattern NEWLINE_ESCAPE = Pattern.compile("\\\\[nN]");
    private static final Pattern VCARD_ESCAPES = Pattern.compile("\\\\([,;\\\\])");
    private static final Pattern EQUALS = Pattern.compile("=");
    private static final Pattern SEMICOLON = Pattern.compile(";");
    private static final Pattern UNESCAPED_SEMICOLONS = Pattern.compile("(?<!\\\\);+");
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern SEMICOLON_OR_COMMA = Pattern.compile("[;,]");

    static List<List<String>> matchVCardPrefixedField(CharSequence charSequence, String string2, boolean bl, boolean bl2) {
        ArrayList<ArrayList<String[]>> arrayList = null;
        int n5 = 0;
        int n6 = string2.length();
        while (n5 < n6) {
            int n7;
            String[] stringArray = Pattern.compile("(?:^|\n)" + charSequence + "(?:;([^:]*))?:", 2).matcher(string2);
            if (n5 > 0) {
                --n5;
            }
            if (!stringArray.find(n5)) break;
            Matcher matcher = stringArray;
            n5 = matcher.end(0);
            stringArray = matcher.group(1);
            ArrayList<String[]> arrayList2 = null;
            boolean bl3 = false;
            String string3 = null;
            if (stringArray != null) {
                stringArray = SEMICOLON.split((CharSequence)stringArray);
                n7 = stringArray.length;
                for (int i5 = 0; i5 < n7; ++i5) {
                    Object object = stringArray[i5];
                    if (arrayList2 == null) {
                        ArrayList<String[]> arrayList3;
                        arrayList2 = arrayList3;
                        arrayList3 = new ArrayList<String[]>(1);
                    }
                    arrayList2.add((String[])object);
                    object = EQUALS.split((CharSequence)object, 2);
                    if (((String[])object).length <= 1) continue;
                    object = object[0];
                    String string4 = object[1];
                    if ("ENCODING".equalsIgnoreCase((String)object) && "QUOTED-PRINTABLE".equalsIgnoreCase(string4)) {
                        bl3 = true;
                        continue;
                    }
                    if (!"CHARSET".equalsIgnoreCase((String)object)) continue;
                    string3 = string4;
                }
            }
            int n8 = n5;
            while ((n8 = string2.indexOf(10, n8)) >= 0) {
                if (n8 < string2.length() - 1 && (string2.charAt(n7 = n8 + 1) == ' ' || string2.charAt(n7) == '\t')) {
                    n8 += 2;
                    continue;
                }
                if (!bl3 || (n8 < 1 || string2.charAt(n8 - 1) != '=') && (n8 < 2 || string2.charAt(n8 - 2) != '=')) break;
                ++n8;
            }
            if (n8 < 0) {
                n5 = n6;
                continue;
            }
            if (n8 > n5) {
                if (arrayList == null) {
                    ArrayList<ArrayList<String[]>> arrayList4;
                    arrayList = arrayList4;
                    arrayList4 = new ArrayList<ArrayList<String[]>>(1);
                }
                if (n8 >= 1 && string2.charAt(n8 - 1) == '\r') {
                    --n8;
                }
                String string5 = string2.substring(n5, n8);
                if (bl) {
                    string5 = string5.trim();
                }
                if (bl3) {
                    string5 = VCardResultParser.decodeQuotedPrintable(string5, string3);
                    if (bl2) {
                        string5 = UNESCAPED_SEMICOLONS.matcher(string5).replaceAll("\n").trim();
                    }
                } else {
                    if (bl2) {
                        string5 = UNESCAPED_SEMICOLONS.matcher(string5).replaceAll("\n").trim();
                    }
                    string5 = VCARD_ESCAPES.matcher(NEWLINE_ESCAPE.matcher(CR_LF_SPACE_TAB.matcher(string5).replaceAll("")).replaceAll("\n")).replaceAll("$1");
                }
                if (arrayList2 == null) {
                    ArrayList<String[]> arrayList5;
                    arrayList2 = arrayList5;
                    new ArrayList<String[]>(1).add((String[])string5);
                    arrayList.add(arrayList2);
                } else {
                    arrayList2.add(0, (String[])string5);
                    arrayList.add(arrayList2);
                }
            }
            n5 = n8 + 1;
        }
        return arrayList;
    }

    private static String decodeQuotedPrintable(CharSequence charSequence, String string2) {
        ByteArrayOutputStream byteArrayOutputStream;
        StringBuilder stringBuilder;
        int n5 = charSequence.length();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(n5);
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i5 = 0; i5 < n5; ++i5) {
            int n6 = charSequence.charAt(i5);
            if (n6 == 10 || n6 == 13) continue;
            if (n6 != 61) {
                VCardResultParser.maybeAppendFragment(byteArrayOutputStream2, string2, stringBuilder2);
                stringBuilder2.append((char)n6);
                continue;
            }
            if (i5 >= n5 - 2 || (n6 = charSequence.charAt(i5 + 1)) == 13 || n6 == 10) continue;
            int n7 = n6;
            n6 = charSequence.charAt(i5 += 2);
            int n8 = ResultParser.parseHexDigit((char)n7);
            n6 = ResultParser.parseHexDigit((char)n6);
            if (n8 < 0 || n6 < 0) continue;
            byteArrayOutputStream2.write((n8 << 4) + n6);
        }
        VCardResultParser.maybeAppendFragment(byteArrayOutputStream2, string2, stringBuilder2);
        return stringBuilder2.toString();
    }

    private static void maybeAppendFragment(ByteArrayOutputStream byteArrayOutputStream, String string2, StringBuilder stringBuilder) {
        if (byteArrayOutputStream.size() > 0) {
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (string2 == null) {
                String string3;
                string2 = string3;
                string3 = new String(byArray, Charset.forName("UTF-8"));
            } else {
                String string4;
                String string5 = string4;
                try {
                    string4 = new String(byArray, string2);
                    string2 = string5;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String string6;
                    string2 = string6;
                    string6 = new String(byArray, Charset.forName("UTF-8"));
                }
            }
            byteArrayOutputStream.reset();
            stringBuilder.append(string2);
            return;
        }
    }

    static List<String> matchSingleVCardPrefixedField(CharSequence object, String string2, boolean bl, boolean bl2) {
        if ((object = VCardResultParser.matchVCardPrefixedField((CharSequence)object, string2, bl, bl2)) != null && !object.isEmpty()) {
            return (List)object.get(0);
        }
        return null;
    }

    private static String toPrimaryValue(List<String> list) {
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    private static String[] toPrimaryValues(Collection<List<String>> collection) {
        if (collection != null && !collection.isEmpty()) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(collection.size());
            Iterator<List<String>> iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().get(0);
                if (string2 == null || string2.isEmpty()) continue;
                arrayList2.add(string2);
            }
            return arrayList2.toArray(new String[collection.size()]);
        }
        return null;
    }

    private static String[] toTypes(Collection<List<String>> collection) {
        if (collection != null && !collection.isEmpty()) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(collection.size());
            for (List<String> list : collection) {
                String string2 = null;
                for (int i5 = 1; i5 < list.size(); ++i5) {
                    String string3 = list.get(i5);
                    int n5 = string3.indexOf(61);
                    if (n5 < 0) {
                        string2 = string3;
                        break;
                    }
                    if (!"TYPE".equalsIgnoreCase(string3.substring(0, n5))) continue;
                    string2 = string3.substring(n5 + 1);
                    break;
                }
                arrayList2.add(string2);
            }
            return arrayList2.toArray(new String[collection.size()]);
        }
        return null;
    }

    private static boolean isLikeVCardDate(CharSequence charSequence) {
        return charSequence == null || VCARD_LIKE_DATE.matcher(charSequence).matches();
        {
        }
    }

    private static void formatNames(Iterable<List<String>> object) {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                StringBuilder stringBuilder;
                int n5;
                Object object2 = (List)object.next();
                String string2 = (String)object2.get(0);
                String[] stringArray = new String[5];
                int n6 = 0;
                for (int i5 = 0; i5 < 4 && (n5 = string2.indexOf(59, n6)) >= 0; ++i5) {
                    stringArray[i5] = string2.substring(n6, n5);
                    n6 = n5 + 1;
                }
                List list = object2;
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                stringArray2[i5] = string2.substring(n6);
                object2 = stringBuilder;
                stringBuilder = new StringBuilder(100);
                VCardResultParser.maybeAppendComponent(stringArray3, 3, (StringBuilder)object2);
                VCardResultParser.maybeAppendComponent(stringArray2, 1, (StringBuilder)object2);
                VCardResultParser.maybeAppendComponent(stringArray3, 2, (StringBuilder)object2);
                VCardResultParser.maybeAppendComponent(stringArray2, 0, (StringBuilder)object2);
                VCardResultParser.maybeAppendComponent(stringArray3, 4, (StringBuilder)object2);
                list.set(0, ((StringBuilder)object2).toString().trim());
            }
        }
    }

    private static void maybeAppendComponent(String[] stringArray, int n5, StringBuilder stringBuilder) {
        String string2 = stringArray[n5];
        if (string2 != null && !string2.isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[n5]);
            return;
        }
    }

    @Override
    public AddressBookParsedResult parse(Result stringArray) {
        Object object = ResultParser.getMassagedText((Result)stringArray);
        if ((stringArray = BEGIN_VCARD.matcher((CharSequence)object)).find() && stringArray.start() == 0) {
            Object object2;
            stringArray = VCardResultParser.matchVCardPrefixedField("FN", (String)object, true, false);
            if (stringArray == null) {
                stringArray = VCardResultParser.matchVCardPrefixedField("N", (String)object, true, false);
                VCardResultParser.formatNames(stringArray);
            }
            object2 = (object2 = VCardResultParser.matchSingleVCardPrefixedField("NICKNAME", (String)object, true, false)) == null ? null : COMMA.split(object2.get(0));
            String[] stringArray2 = VCardResultParser.matchVCardPrefixedField("TEL", (String)object, true, false);
            String[] stringArray3 = VCardResultParser.matchVCardPrefixedField("EMAIL", (String)object, true, false);
            String[] stringArray4 = VCardResultParser.matchSingleVCardPrefixedField("NOTE", (String)object, false, false);
            String[] stringArray5 = VCardResultParser.matchVCardPrefixedField("ADR", (String)object, true, true);
            Object object3 = VCardResultParser.matchSingleVCardPrefixedField("ORG", (String)object, true, true);
            List<String> list = VCardResultParser.matchSingleVCardPrefixedField("BDAY", (String)object, true, false);
            if (list != null && !VCardResultParser.isLikeVCardDate(list.get(0))) {
                list = null;
            }
            String[] stringArray6 = VCardResultParser.matchSingleVCardPrefixedField("TITLE", (String)object, true, false);
            String[] stringArray7 = VCardResultParser.matchVCardPrefixedField("URL", (String)object, true, false);
            Object object4 = VCardResultParser.matchSingleVCardPrefixedField("IMPP", (String)object, true, false);
            if ((object = (object = VCardResultParser.matchSingleVCardPrefixedField("GEO", (String)object, true, false)) == null ? null : SEMICOLON_OR_COMMA.split(object.get(0))) != null && ((List<String>)object).length != 2) {
                object = null;
            }
            String[] stringArray8 = stringArray7;
            String[] stringArray9 = stringArray6;
            List<String> list2 = list;
            List<String> list3 = object3;
            String[] stringArray10 = stringArray4;
            stringArray = VCardResultParser.toPrimaryValues(stringArray);
            stringArray2 = VCardResultParser.toPrimaryValues(stringArray2);
            stringArray3 = VCardResultParser.toTypes((Collection<List<String>>)stringArray2);
            stringArray4 = VCardResultParser.toPrimaryValues((Collection<List<String>>)stringArray3);
            stringArray5 = VCardResultParser.toTypes((Collection<List<String>>)stringArray3);
            object3 = VCardResultParser.toPrimaryValue(object4);
            list = VCardResultParser.toPrimaryValue((List<String>)stringArray10);
            stringArray6 = VCardResultParser.toPrimaryValues((Collection<List<String>>)stringArray5);
            stringArray7 = VCardResultParser.toTypes((Collection<List<String>>)stringArray5);
            object4 = VCardResultParser.toPrimaryValue(list3);
            String string2 = VCardResultParser.toPrimaryValue(list2);
            String string3 = VCardResultParser.toPrimaryValue((List<String>)stringArray9);
            String[] stringArray11 = VCardResultParser.toPrimaryValues((Collection<List<String>>)stringArray8);
            return new AddressBookParsedResult(stringArray, (String[])object2, null, stringArray2, stringArray3, stringArray4, stringArray5, (String)object3, (String)((Object)list), stringArray6, stringArray7, (String)object4, string2, string3, stringArray11, (String[])object);
        }
        return null;
    }
}

