/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.decoder;

import com.dcloud.zxing2.datamatrix.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    private DataBlock(int n5, byte[] byArray) {
        this.numDataCodewords = n5;
        this.codewords = byArray;
    }

    static DataBlock[] getDataBlocks(byte[] byArray, Version version) {
        int n5;
        int n6;
        int n7;
        int n8;
        Version.ECBlocks eCBlocks = version.getECBlocks();
        int n9 = 0;
        Version.ECB[] eCBArray = eCBlocks.getECBlocks();
        int n10 = eCBArray.length;
        for (n8 = 0; n8 < n10; ++n8) {
            n9 += eCBArray[n8].getCount();
        }
        DataBlock[] dataBlockArray = new DataBlock[n9];
        n10 = 0;
        for (Version.ECB eCB : eCBArray) {
            for (n7 = 0; n7 < eCB.getCount(); ++n7) {
                int n11 = eCB.getDataCodewords();
                int n12 = eCBlocks.getECCodewords() + n11;
                dataBlockArray[n10++] = new DataBlock(n11, new byte[n12]);
            }
        }
        int n13 = dataBlockArray[0].codewords.length - eCBlocks.getECCodewords();
        int n14 = n13 - 1;
        n8 = 0;
        for (n6 = 0; n6 < n14; ++n6) {
            for (int i5 = 0; i5 < n10; ++i5) {
                dataBlockArray[i5].codewords[n6] = byArray[n8++];
            }
        }
        boolean bl = version.getVersionNumber() == 24;
        n6 = bl ? 8 : n10;
        for (n5 = 0; n5 < n6; ++n5) {
            dataBlockArray[n5].codewords[n14] = byArray[n8++];
        }
        n14 = dataBlockArray[0].codewords.length;
        while (n13 < n14) {
            for (n6 = 0; n6 < n10; ++n6) {
                n5 = bl ? (n6 + 8) % n10 : n6;
                n7 = bl && n5 > 7 ? n13 - 1 : n13;
                dataBlockArray[n5].codewords[n7] = byArray[n8++];
            }
            ++n13;
        }
        if (n8 == byArray.length) {
            return dataBlockArray;
        }
        throw new IllegalArgumentException();
    }

    int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    byte[] getCodewords() {
        return this.codewords;
    }
}

