/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class CodaBarReader
extends OneDReader {
    private static final float MAX_ACCEPTABLE = 2.0f;
    private static final float PADDING = 1.5f;
    private static final String ALPHABET_STRING = "0123456789-$:/.+ABCD";
    static final char[] ALPHABET = "0123456789-$:/.+ABCD".toCharArray();
    static final int[] CHARACTER_ENCODINGS;
    private static final int MIN_CHARACTER_LENGTH = 3;
    private static final char[] STARTEND_ENCODING;
    private final StringBuilder decodeRowResult = new StringBuilder(20);
    private int[] counters = new int[80];
    private int counterLength = 0;

    private void setCounters(BitArray bitArray) throws NotFoundException {
        int n5;
        this.counterLength = 0;
        int n6 = bitArray.getNextUnset(0);
        if (n6 < (n5 = bitArray.getSize())) {
            int n7 = 1;
            int n8 = 0;
            while (n6 < n5) {
                if (bitArray.get(n6) ^ n7) {
                    ++n8;
                } else {
                    int n9 = n7;
                    this.counterAppend(n8);
                    n7 = 1;
                    int n10 = n8 = n9 ^ 1;
                    n8 = n7;
                    n7 = n10;
                }
                ++n6;
            }
            this.counterAppend(n8);
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private void counterAppend(int n5) {
        int[] nArray = ((CodaBarReader)object).counters;
        int n6 = ((CodaBarReader)object).counterLength;
        ((CodaBarReader)object).counters[n6] = n5;
        ((CodaBarReader)object).counterLength = n5 = n6 + 1;
        if (n5 >= nArray.length) {
            CodaBarReader codaBarReader = object;
            Object object = new int[n5 * 2];
            System.arraycopy(nArray, 0, object, 0, n5);
            codaBarReader.counters = (int[])object;
            return;
        }
    }

    private int findStartPattern() throws NotFoundException {
        for (int i5 = 1; i5 < this.counterLength; i5 += 2) {
            int n5 = this.toNarrowWidePattern(i5);
            if (n5 == -1 || !CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[n5])) continue;
            n5 = 0;
            for (int i6 = i5; i6 < i5 + 7; ++i6) {
                n5 += this.counters[i6];
            }
            if (i5 != 1 && this.counters[i5 - 1] < n5 / 2) continue;
            return i5;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static boolean arrayContains(char[] cArray, char c6) {
        if (cArray != null) {
            int n5 = cArray.length;
            for (int i5 = 0; i5 < n5; ++i5) {
                if (cArray[i5] != c6) continue;
                return true;
            }
        }
        return false;
    }

    private int toNarrowWidePattern(int n5) {
        Object object;
        Object object2;
        Object object3;
        int n6 = n5 + 7;
        if (n6 >= ((CodaBarReader)object4).counterLength) {
            return -1;
        }
        Object object4 = ((CodaBarReader)object4).counters;
        Object object5 = 0;
        Object object6 = Integer.MAX_VALUE;
        for (object3 = n5; object3 < n6; object3 += 2) {
            object2 = object4[object3];
            if (object2 < object6) {
                object6 = object2;
            }
            if (object2 <= object5) continue;
            object5 = object2;
        }
        object5 = (object6 + object5) / 2;
        object6 = 0;
        object3 = Integer.MAX_VALUE;
        for (object2 = (Object)(n5 + 1); object2 < n6; object2 += 2) {
            object = object4[object2];
            if (object < object3) {
                object3 = object;
            }
            if (object <= object6) continue;
            object6 = object;
        }
        n6 = (object3 + object6) / 2;
        object6 = 128;
        object3 = 0;
        for (object2 = (Object)false; object2 < 7; ++object2) {
            object = (object2 & 1) == 0 ? (Object)object5 : (Object)n6;
            object6 >>= 1;
            if (object4[n5 + object2] <= object) continue;
            object3 |= object6;
        }
        int n7 = 0;
        while (true) {
            int[] nArray = CHARACTER_ENCODINGS;
            if (n7 >= CHARACTER_ENCODINGS.length) break;
            if (nArray[n7] == object3) {
                return n7;
            }
            ++n7;
        }
        return -1;
    }

    static {
        int[] nArray = new int[20];
        int[] nArray2 = nArray;
        nArray[0] = 3;
        nArray2[1] = 6;
        nArray2[2] = 9;
        nArray2[3] = 96;
        nArray2[4] = 18;
        nArray2[5] = 66;
        nArray2[6] = 33;
        nArray2[7] = 36;
        nArray2[8] = 48;
        nArray2[9] = 72;
        nArray2[10] = 12;
        nArray2[11] = 24;
        nArray2[12] = 69;
        nArray2[13] = 81;
        nArray2[14] = 84;
        nArray2[15] = 21;
        nArray2[16] = 26;
        nArray2[17] = 41;
        nArray2[18] = 11;
        nArray2[19] = 14;
        CHARACTER_ENCODINGS = nArray2;
        STARTEND_ENCODING = new char[]{'A', 'B', 'C', 'D'};
    }

    @Override
    public Result decodeRow(int n5, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException {
        int n6;
        Arrays.fill(((CodaBarReader)object).counters, 0);
        ((CodaBarReader)object).setCounters(bitArray);
        int n7 = ((CodaBarReader)object).findStartPattern();
        ((CodaBarReader)object).decodeRowResult.setLength(0);
        int n8 = n7;
        while ((n6 = ((CodaBarReader)object).toNarrowWidePattern(n8)) != -1) {
            ((CodaBarReader)object).decodeRowResult.append((char)n6);
            int n9 = n8 + 8;
            if (((CodaBarReader)object).decodeRowResult.length() > 1 && CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[n6]) || n9 >= ((CodaBarReader)object).counterLength) {
                n6 = ((CodaBarReader)object).counters[n8 += 7];
                int n10 = 0;
                for (int i5 = -8; i5 < -1; ++i5) {
                    n10 += ((CodaBarReader)object).counters[n9 + i5];
                }
                if (n9 < ((CodaBarReader)object).counterLength && n6 < n10 / 2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                ((CodaBarReader)object).validatePattern(n7);
                for (n6 = 0; n6 < ((CodaBarReader)object).decodeRowResult.length(); ++n6) {
                    StringBuilder stringBuilder = ((CodaBarReader)object).decodeRowResult;
                    stringBuilder.setCharAt(n6, ALPHABET[stringBuilder.charAt(n6)]);
                }
                n6 = ((CodaBarReader)object).decodeRowResult.charAt(0);
                char[] cArray = STARTEND_ENCODING;
                if (CodaBarReader.arrayContains(STARTEND_ENCODING, (char)n6)) {
                    StringBuilder stringBuilder = ((CodaBarReader)object).decodeRowResult;
                    if (CodaBarReader.arrayContains(cArray, stringBuilder.charAt(stringBuilder.length() - 1))) {
                        if (((CodaBarReader)object).decodeRowResult.length() > 3) {
                            ResultPoint resultPoint;
                            ResultPoint resultPoint2;
                            if (map == null || !map.containsKey((Object)DecodeHintType.RETURN_CODABAR_START_END)) {
                                StringBuilder stringBuilder2 = ((CodaBarReader)object).decodeRowResult;
                                stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
                                ((CodaBarReader)object).decodeRowResult.deleteCharAt(0);
                            }
                            int n11 = 0;
                            for (n6 = 0; n6 < n7; ++n6) {
                                n11 += ((CodaBarReader)object).counters[n6];
                            }
                            float f5 = n11;
                            while (n7 < n8) {
                                n11 += ((CodaBarReader)object).counters[n7];
                                ++n7;
                            }
                            float f6 = n11;
                            Object object = resultPoint2;
                            float f7 = n5;
                            resultPoint2 = new ResultPoint(f5, f7);
                            ResultPoint resultPoint3 = resultPoint;
                            resultPoint = new ResultPoint(f6, f7);
                            ResultPoint[] resultPointArray = new ResultPoint[2];
                            ResultPoint[] resultPointArray2 = resultPointArray;
                            resultPointArray[0] = object;
                            resultPointArray[1] = resultPoint3;
                            object = BarcodeFormat.CODABAR;
                            return new Result(((CodaBarReader)object).decodeRowResult.toString(), null, resultPointArray2, (BarcodeFormat)((Object)object));
                        }
                        throw NotFoundException.getNotFoundInstance();
                    }
                    throw NotFoundException.getNotFoundInstance();
                }
                throw NotFoundException.getNotFoundInstance();
            }
            n8 = n9;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    void validatePattern(int n5) throws NotFoundException {
        int[] nArray = new int[4];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        int[] nArray3 = new int[4];
        int[] nArray4 = nArray3;
        nArray3[0] = 0;
        nArray3[1] = 0;
        nArray3[2] = 0;
        nArray3[3] = 0;
        int n6 = this.decodeRowResult.length() - 1;
        int n7 = 0;
        int n8 = n5;
        while (true) {
            int n9 = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(n7)];
            for (int i5 = 6; i5 >= 0; --i5) {
                int n10 = n9;
                n9 = (i5 & 1) + (n9 & 1) * 2;
                nArray2[n9] = nArray2[n9] + this.counters[n8 + i5];
                nArray4[n9] = nArray4[n9] + 1;
                n9 = n10 >> 1;
            }
            if (n7 >= n6) {
                float[] fArray = new float[4];
                float[] fArray2 = new float[4];
                for (n7 = 0; n7 < 2; ++n7) {
                    float f5;
                    fArray2[n7] = 0.0f;
                    n8 = n7 + 2;
                    int n11 = nArray2[n8];
                    int n12 = nArray4[n8];
                    fArray2[n8] = f5 = ((float)nArray2[n7] / (float)nArray4[n7] + (float)n11 / (float)n12) / 2.0f;
                    fArray[n7] = f5;
                    fArray[n8] = ((float)n11 * 2.0f + 1.5f) / (float)n12;
                }
                int n13 = 0;
                while (true) {
                    int n14 = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(n13)];
                    for (n7 = 6; n7 >= 0; --n7) {
                        float f6 = this.counters[n5 + n7];
                        n8 = (n7 & 1) + (n14 & 1) * 2;
                        if (!(f6 < fArray2[n8]) && !(f6 > fArray[n8])) {
                            n14 >>= 1;
                            continue;
                        }
                        throw NotFoundException.getNotFoundInstance();
                    }
                    if (n13 >= n6) {
                        return;
                    }
                    n5 += 8;
                    ++n13;
                }
            }
            n8 += 8;
            ++n7;
        }
    }
}

