/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.Code39Reader;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import java.util.Map;

public final class Code39Writer
extends OneDimensionalCodeWriter {
    private static void toIntArray(int n5, int[] nArray) {
        for (int i5 = 0; i5 < 9; ++i5) {
            int n6 = (n5 & 1 << 8 - i5) == 0 ? 1 : 2;
            nArray[i5] = n6;
        }
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.CODE_39) {
            return super.encode(string2, barcodeFormat, n5, n6, map);
        }
        throw new IllegalArgumentException("Can only encode CODE_39, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String string2) {
        int n5 = string2.length();
        if (n5 <= 80) {
            int n6;
            int n7;
            int n8 = 9;
            int[] nArray = new int[9];
            int n9 = n5 + 25;
            for (n7 = 0; n7 < n5; ++n7) {
                n6 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string2.charAt(n7));
                if (n6 >= 0) {
                    Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[n6], nArray);
                    for (n6 = 0; n6 < n8; ++n6) {
                        n9 += nArray[n6];
                    }
                    continue;
                }
                throw new IllegalArgumentException("Bad contents: " + string2);
            }
            boolean[] blArray = new boolean[n9];
            Code39Writer.toIntArray(Code39Reader.ASTERISK_ENCODING, nArray);
            int n10 = OneDimensionalCodeWriter.appendPattern(blArray, 0, nArray, true);
            int[] nArray2 = new int[1];
            int[] nArray3 = nArray2;
            nArray2[0] = 1;
            n7 = n10 + OneDimensionalCodeWriter.appendPattern(blArray, n10, nArray3, false);
            for (n6 = 0; n6 < n5; ++n6) {
                Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS["0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string2.charAt(n6))], nArray);
                int n11 = n7 + OneDimensionalCodeWriter.appendPattern(blArray, n7, nArray, true);
                n7 = n11 + OneDimensionalCodeWriter.appendPattern(blArray, n11, nArray3, false);
            }
            Code39Writer.toIntArray(Code39Reader.ASTERISK_ENCODING, nArray);
            OneDimensionalCodeWriter.appendPattern(blArray, n7, nArray, true);
            return blArray;
        }
        throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n5);
    }
}

