/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public final class PDF417Common {
    public static final int NUMBER_OF_CODEWORDS = 929;
    public static final int MAX_CODEWORDS_IN_BARCODE = 928;
    public static final int MIN_ROWS_IN_BARCODE = 3;
    public static final int MAX_ROWS_IN_BARCODE = 90;
    public static final int MODULES_IN_CODEWORD = 17;
    public static final int MODULES_IN_STOP_PATTERN = 18;
    public static final int BARS_IN_MODULE = 8;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final int[] SYMBOL_TABLE;
    private static final int[] CODEWORD_TABLE;

    private PDF417Common() {
    }

    public static int getBitCountSum(int[] nArray) {
        int n5 = 0;
        int n6 = nArray.length;
        for (int i5 = 0; i5 < n6; ++i5) {
            n5 += nArray[i5];
        }
        return n5;
    }

    public static int[] toIntArray(Collection<Integer> object) {
        if (object != null && !object.isEmpty()) {
            Collection<Integer> collection = object;
            object = new int[collection.size()];
            int n5 = 0;
            Iterator<Integer> iterator = collection.iterator();
            while (iterator.hasNext()) {
                object[n5++] = iterator.next();
            }
            return object;
        }
        return EMPTY_INT_ARRAY;
    }

    public static int getCodeword(int n5) {
        if ((n5 = Arrays.binarySearch(SYMBOL_TABLE, n5 & 0x3FFFF)) < 0) {
            return -1;
        }
        return (CODEWORD_TABLE[n5] - 1) % 929;
    }

    /*
     * Opcode count of 22311 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        int[] nArray = new int[2787];
        int[] nArray2 = nArray;
        nArray[0] = 66142;
        nArray2[1] = 66170;
        nArray2[2] = 66206;
        nArray2[3] = 66236;
        nArray2[4] = 66290;
        nArray2[5] = 66292;
        nArray2[6] = 66350;
        nArray2[7] = 66382;
        nArray2[8] = 66396;
        nArray2[9] = 66454;
        nArray2[10] = 66470;
        nArray2[11] = 66476;
        nArray2[12] = 66594;
        nArray2[13] = 66600;
        nArray2[14] = 66614;
        nArray2[15] = 66626;
        nArray2[16] = 66628;
        nArray2[17] = 66632;
        nArray2[18] = 66640;
        nArray2[19] = 66654;
        nArray2[20] = 66662;
        nArray2[21] = 66668;
        nArray2[22] = 66682;
        nArray2[23] = 66690;
        nArray2[24] = 66718;
        nArray2[25] = 66720;
        nArray2[26] = 66748;
        nArray2[27] = 66758;
        nArray2[28] = 66776;
        nArray2[29] = 66798;
        nArray2[30] = 66802;
        nArray2[31] = 66804;
        nArray2[32] = 66820;
        nArray2[33] = 66824;
        nArray2[34] = 66832;
        nArray2[35] = 66846;
        nArray2[36] = 66848;
        nArray2[37] = 66876;
        nArray2[38] = 66880;
        nArray2[39] = 66936;
        nArray2[40] = 66950;
        nArray2[41] = 66956;
        nArray2[42] = 66968;
        nArray2[43] = 66992;
        nArray2[44] = 67006;
        nArray2[45] = 67022;
        nArray2[46] = 67036;
        nArray2[47] = 67042;
        nArray2[48] = 67044;
        nArray2[49] = 67048;
        nArray2[50] = 67062;
        nArray2[51] = 67118;
        nArray2[52] = 67150;
        nArray2[53] = 67164;
        nArray2[54] = 67214;
        nArray2[55] = 67228;
        nArray2[56] = 67256;
        nArray2[57] = 67294;
        nArray2[58] = 67322;
        nArray2[59] = 67350;
        nArray2[60] = 67366;
        nArray2[61] = 67372;
        nArray2[62] = 67398;
        nArray2[63] = 67404;
        nArray2[64] = 67416;
        nArray2[65] = 67438;
        nArray2[66] = 67474;
        nArray2[67] = 67476;
        nArray2[68] = 67490;
        nArray2[69] = 67492;
        nArray2[70] = 67496;
        nArray2[71] = 67510;
        nArray2[72] = 67618;
        nArray2[73] = 67624;
        nArray2[74] = 67650;
        nArray2[75] = 67656;
        nArray2[76] = 67664;
        nArray2[77] = 67678;
        nArray2[78] = 67686;
        nArray2[79] = 67692;
        nArray2[80] = 67706;
        nArray2[81] = 67714;
        nArray2[82] = 67716;
        nArray2[83] = 67728;
        nArray2[84] = 67742;
        nArray2[85] = 67744;
        nArray2[86] = 67772;
        nArray2[87] = 67782;
        nArray2[88] = 67788;
        nArray2[89] = 67800;
        nArray2[90] = 67822;
        nArray2[91] = 67826;
        nArray2[92] = 67828;
        nArray2[93] = 67842;
        nArray2[94] = 67848;
        nArray2[95] = 67870;
        nArray2[96] = 67872;
        nArray2[97] = 67900;
        nArray2[98] = 67904;
        nArray2[99] = 67960;
        nArray2[100] = 67974;
        nArray2[101] = 67992;
        nArray2[102] = 68016;
        nArray2[103] = 68030;
        nArray2[104] = 68046;
        nArray2[105] = 68060;
        nArray2[106] = 68066;
        nArray2[107] = 68068;
        nArray2[108] = 68072;
        nArray2[109] = 68086;
        nArray2[110] = 68104;
        nArray2[111] = 68112;
        nArray2[112] = 68126;
        nArray2[113] = 68128;
        nArray2[114] = 68156;
        nArray2[115] = 68160;
        nArray2[116] = 68216;
        nArray2[117] = 68336;
        nArray2[118] = 68358;
        nArray2[119] = 68364;
        nArray2[120] = 68376;
        nArray2[121] = 68400;
        nArray2[122] = 68414;
        nArray2[123] = 68448;
        nArray2[124] = 68476;
        nArray2[125] = 68494;
        nArray2[126] = 68508;
        nArray2[127] = 68536;
        nArray2[128] = 68546;
        nArray2[129] = 68548;
        nArray2[130] = 68552;
        nArray2[131] = 68560;
        nArray2[132] = 68574;
        nArray2[133] = 68582;
        nArray2[134] = 68588;
        nArray2[135] = 68654;
        nArray2[136] = 68686;
        nArray2[137] = 68700;
        nArray2[138] = 68706;
        nArray2[139] = 68708;
        nArray2[140] = 68712;
        nArray2[141] = 68726;
        nArray2[142] = 68750;
        nArray2[143] = 68764;
        nArray2[144] = 68792;
        nArray2[145] = 68802;
        nArray2[146] = 68804;
        nArray2[147] = 68808;
        nArray2[148] = 68816;
        nArray2[149] = 68830;
        nArray2[150] = 68838;
        nArray2[151] = 68844;
        nArray2[152] = 68858;
        nArray2[153] = 68878;
        nArray2[154] = 68892;
        nArray2[155] = 68920;
        nArray2[156] = 68976;
        nArray2[157] = 68990;
        nArray2[158] = 68994;
        nArray2[159] = 68996;
        nArray2[160] = 69000;
        nArray2[161] = 69008;
        nArray2[162] = 69022;
        nArray2[163] = 69024;
        nArray2[164] = 69052;
        nArray2[165] = 69062;
        nArray2[166] = 69068;
        nArray2[167] = 69080;
        nArray2[168] = 69102;
        nArray2[169] = 69106;
        nArray2[170] = 69108;
        nArray2[171] = 69142;
        nArray2[172] = 69158;
        nArray2[173] = 69164;
        nArray2[174] = 69190;
        nArray2[175] = 69208;
        nArray2[176] = 69230;
        nArray2[177] = 69254;
        nArray2[178] = 69260;
        nArray2[179] = 69272;
        nArray2[180] = 69296;
        nArray2[181] = 69310;
        nArray2[182] = 69326;
        nArray2[183] = 69340;
        nArray2[184] = 69386;
        nArray2[185] = 69394;
        nArray2[186] = 69396;
        nArray2[187] = 69410;
        nArray2[188] = 69416;
        nArray2[189] = 69430;
        nArray2[190] = 69442;
        nArray2[191] = 69444;
        nArray2[192] = 69448;
        nArray2[193] = 69456;
        nArray2[194] = 69470;
        nArray2[195] = 69478;
        nArray2[196] = 69484;
        nArray2[197] = 69554;
        nArray2[198] = 69556;
        nArray2[199] = 69666;
        nArray2[200] = 69672;
        nArray2[201] = 69698;
        nArray2[202] = 69704;
        nArray2[203] = 69712;
        nArray2[204] = 69726;
        nArray2[205] = 69754;
        nArray2[206] = 69762;
        nArray2[207] = 69764;
        nArray2[208] = 69776;
        nArray2[209] = 69790;
        nArray2[210] = 69792;
        nArray2[211] = 69820;
        nArray2[212] = 69830;
        nArray2[213] = 69836;
        nArray2[214] = 69848;
        nArray2[215] = 69870;
        nArray2[216] = 69874;
        nArray2[217] = 69876;
        nArray2[218] = 69890;
        nArray2[219] = 69918;
        nArray2[220] = 69920;
        nArray2[221] = 69948;
        nArray2[222] = 69952;
        nArray2[223] = 70008;
        nArray2[224] = 70022;
        nArray2[225] = 70040;
        nArray2[226] = 70064;
        nArray2[227] = 70078;
        nArray2[228] = 70094;
        nArray2[229] = 70108;
        nArray2[230] = 70114;
        nArray2[231] = 70116;
        nArray2[232] = 70120;
        nArray2[233] = 70134;
        nArray2[234] = 70152;
        nArray2[235] = 70174;
        nArray2[236] = 70176;
        nArray2[237] = 70264;
        nArray2[238] = 70384;
        nArray2[239] = 70412;
        nArray2[240] = 70448;
        nArray2[241] = 70462;
        nArray2[242] = 70496;
        nArray2[243] = 70524;
        nArray2[244] = 70542;
        nArray2[245] = 70556;
        nArray2[246] = 70584;
        nArray2[247] = 70594;
        nArray2[248] = 70600;
        nArray2[249] = 70608;
        nArray2[250] = 70622;
        nArray2[251] = 70630;
        nArray2[252] = 70636;
        nArray2[253] = 70664;
        nArray2[254] = 70672;
        nArray2[255] = 70686;
        nArray2[256] = 70688;
        nArray2[257] = 70716;
        nArray2[258] = 70720;
        nArray2[259] = 70776;
        nArray2[260] = 70896;
        nArray2[261] = 71136;
        nArray2[262] = 71180;
        nArray2[263] = 71192;
        nArray2[264] = 71216;
        nArray2[265] = 71230;
        nArray2[266] = 71264;
        nArray2[267] = 71292;
        nArray2[268] = 71360;
        nArray2[269] = 71416;
        nArray2[270] = 71452;
        nArray2[271] = 71480;
        nArray2[272] = 71536;
        nArray2[273] = 71550;
        nArray2[274] = 71554;
        nArray2[275] = 71556;
        nArray2[276] = 71560;
        nArray2[277] = 71568;
        nArray2[278] = 71582;
        nArray2[279] = 71584;
        nArray2[280] = 71612;
        nArray2[281] = 71622;
        nArray2[282] = 71628;
        nArray2[283] = 71640;
        nArray2[284] = 71662;
        nArray2[285] = 71726;
        nArray2[286] = 71732;
        nArray2[287] = 71758;
        nArray2[288] = 71772;
        nArray2[289] = 71778;
        nArray2[290] = 71780;
        nArray2[291] = 71784;
        nArray2[292] = 71798;
        nArray2[293] = 71822;
        nArray2[294] = 71836;
        nArray2[295] = 71864;
        nArray2[296] = 71874;
        nArray2[297] = 71880;
        nArray2[298] = 71888;
        nArray2[299] = 71902;
        nArray2[300] = 71910;
        nArray2[301] = 71916;
        nArray2[302] = 71930;
        nArray2[303] = 71950;
        nArray2[304] = 71964;
        nArray2[305] = 71992;
        nArray2[306] = 72048;
        nArray2[307] = 72062;
        nArray2[308] = 72066;
        nArray2[309] = 72068;
        nArray2[310] = 72080;
        nArray2[311] = 72094;
        nArray2[312] = 72096;
        nArray2[313] = 72124;
        nArray2[314] = 72134;
        nArray2[315] = 72140;
        nArray2[316] = 72152;
        nArray2[317] = 72174;
        nArray2[318] = 72178;
        nArray2[319] = 72180;
        nArray2[320] = 72206;
        nArray2[321] = 72220;
        nArray2[322] = 72248;
        nArray2[323] = 72304;
        nArray2[324] = 72318;
        nArray2[325] = 72416;
        nArray2[326] = 72444;
        nArray2[327] = 72456;
        nArray2[328] = 72464;
        nArray2[329] = 72478;
        nArray2[330] = 72480;
        nArray2[331] = 72508;
        nArray2[332] = 72512;
        nArray2[333] = 72568;
        nArray2[334] = 72588;
        nArray2[335] = 72600;
        nArray2[336] = 72624;
        nArray2[337] = 72638;
        nArray2[338] = 72654;
        nArray2[339] = 72668;
        nArray2[340] = 72674;
        nArray2[341] = 72676;
        nArray2[342] = 72680;
        nArray2[343] = 72694;
        nArray2[344] = 72726;
        nArray2[345] = 72742;
        nArray2[346] = 72748;
        nArray2[347] = 72774;
        nArray2[348] = 72780;
        nArray2[349] = 72792;
        nArray2[350] = 72814;
        nArray2[351] = 72838;
        nArray2[352] = 72856;
        nArray2[353] = 72880;
        nArray2[354] = 72894;
        nArray2[355] = 72910;
        nArray2[356] = 72924;
        nArray2[357] = 72930;
        nArray2[358] = 72932;
        nArray2[359] = 72936;
        nArray2[360] = 72950;
        nArray2[361] = 72966;
        nArray2[362] = 72972;
        nArray2[363] = 72984;
        nArray2[364] = 73008;
        nArray2[365] = 73022;
        nArray2[366] = 73056;
        nArray2[367] = 73084;
        nArray2[368] = 73102;
        nArray2[369] = 73116;
        nArray2[370] = 73144;
        nArray2[371] = 73156;
        nArray2[372] = 73160;
        nArray2[373] = 73168;
        nArray2[374] = 73182;
        nArray2[375] = 73190;
        nArray2[376] = 73196;
        nArray2[377] = 73210;
        nArray2[378] = 73226;
        nArray2[379] = 73234;
        nArray2[380] = 73236;
        nArray2[381] = 73250;
        nArray2[382] = 73252;
        nArray2[383] = 73256;
        nArray2[384] = 73270;
        nArray2[385] = 73282;
        nArray2[386] = 73284;
        nArray2[387] = 73296;
        nArray2[388] = 73310;
        nArray2[389] = 73318;
        nArray2[390] = 73324;
        nArray2[391] = 73346;
        nArray2[392] = 73348;
        nArray2[393] = 73352;
        nArray2[394] = 73360;
        nArray2[395] = 73374;
        nArray2[396] = 73376;
        nArray2[397] = 73404;
        nArray2[398] = 73414;
        nArray2[399] = 73420;
        nArray2[400] = 73432;
        nArray2[401] = 73454;
        nArray2[402] = 73498;
        nArray2[403] = 73518;
        nArray2[404] = 73522;
        nArray2[405] = 73524;
        nArray2[406] = 73550;
        nArray2[407] = 73564;
        nArray2[408] = 73570;
        nArray2[409] = 73572;
        nArray2[410] = 73576;
        nArray2[411] = 73590;
        nArray2[412] = 73800;
        nArray2[413] = 73822;
        nArray2[414] = 73858;
        nArray2[415] = 73860;
        nArray2[416] = 73872;
        nArray2[417] = 73886;
        nArray2[418] = 73888;
        nArray2[419] = 73916;
        nArray2[420] = 73944;
        nArray2[421] = 73970;
        nArray2[422] = 73972;
        nArray2[423] = 73992;
        nArray2[424] = 74014;
        nArray2[425] = 74016;
        nArray2[426] = 74044;
        nArray2[427] = 74048;
        nArray2[428] = 74104;
        nArray2[429] = 74118;
        nArray2[430] = 74136;
        nArray2[431] = 74160;
        nArray2[432] = 74174;
        nArray2[433] = 74210;
        nArray2[434] = 74212;
        nArray2[435] = 74216;
        nArray2[436] = 74230;
        nArray2[437] = 74244;
        nArray2[438] = 74256;
        nArray2[439] = 74270;
        nArray2[440] = 74272;
        nArray2[441] = 74360;
        nArray2[442] = 74480;
        nArray2[443] = 74502;
        nArray2[444] = 74508;
        nArray2[445] = 74544;
        nArray2[446] = 74558;
        nArray2[447] = 74592;
        nArray2[448] = 74620;
        nArray2[449] = 74638;
        nArray2[450] = 74652;
        nArray2[451] = 74680;
        nArray2[452] = 74690;
        nArray2[453] = 74696;
        nArray2[454] = 74704;
        nArray2[455] = 74726;
        nArray2[456] = 74732;
        nArray2[457] = 74782;
        nArray2[458] = 74784;
        nArray2[459] = 74812;
        nArray2[460] = 74992;
        nArray2[461] = 75232;
        nArray2[462] = 75288;
        nArray2[463] = 75326;
        nArray2[464] = 75360;
        nArray2[465] = 75388;
        nArray2[466] = 75456;
        nArray2[467] = 75512;
        nArray2[468] = 75576;
        nArray2[469] = 75632;
        nArray2[470] = 75646;
        nArray2[471] = 75650;
        nArray2[472] = 75652;
        nArray2[473] = 75664;
        nArray2[474] = 75678;
        nArray2[475] = 75680;
        nArray2[476] = 75708;
        nArray2[477] = 75718;
        nArray2[478] = 75724;
        nArray2[479] = 75736;
        nArray2[480] = 75758;
        nArray2[481] = 75808;
        nArray2[482] = 75836;
        nArray2[483] = 75840;
        nArray2[484] = 75896;
        nArray2[485] = 76016;
        nArray2[486] = 76256;
        nArray2[487] = 76736;
        nArray2[488] = 76824;
        nArray2[489] = 76848;
        nArray2[490] = 76862;
        nArray2[491] = 76896;
        nArray2[492] = 76924;
        nArray2[493] = 76992;
        nArray2[494] = 77048;
        nArray2[495] = 77296;
        nArray2[496] = 77340;
        nArray2[497] = 77368;
        nArray2[498] = 77424;
        nArray2[499] = 77438;
        nArray2[500] = 77536;
        nArray2[501] = 77564;
        nArray2[502] = 77572;
        nArray2[503] = 77576;
        nArray2[504] = 77584;
        nArray2[505] = 77600;
        nArray2[506] = 77628;
        nArray2[507] = 77632;
        nArray2[508] = 77688;
        nArray2[509] = 77702;
        nArray2[510] = 77708;
        nArray2[511] = 77720;
        nArray2[512] = 77744;
        nArray2[513] = 77758;
        nArray2[514] = 77774;
        nArray2[515] = 77788;
        nArray2[516] = 77870;
        nArray2[517] = 77902;
        nArray2[518] = 77916;
        nArray2[519] = 77922;
        nArray2[520] = 77928;
        nArray2[521] = 77966;
        nArray2[522] = 77980;
        nArray2[523] = 78008;
        nArray2[524] = 78018;
        nArray2[525] = 78024;
        nArray2[526] = 78032;
        nArray2[527] = 78046;
        nArray2[528] = 78060;
        nArray2[529] = 78074;
        nArray2[530] = 78094;
        nArray2[531] = 78136;
        nArray2[532] = 78192;
        nArray2[533] = 78206;
        nArray2[534] = 78210;
        nArray2[535] = 78212;
        nArray2[536] = 78224;
        nArray2[537] = 78238;
        nArray2[538] = 78240;
        nArray2[539] = 78268;
        nArray2[540] = 78278;
        nArray2[541] = 78284;
        nArray2[542] = 78296;
        nArray2[543] = 78322;
        nArray2[544] = 78324;
        nArray2[545] = 78350;
        nArray2[546] = 78364;
        nArray2[547] = 78448;
        nArray2[548] = 78462;
        nArray2[549] = 78560;
        nArray2[550] = 78588;
        nArray2[551] = 78600;
        nArray2[552] = 78622;
        nArray2[553] = 78624;
        nArray2[554] = 78652;
        nArray2[555] = 78656;
        nArray2[556] = 78712;
        nArray2[557] = 78726;
        nArray2[558] = 78744;
        nArray2[559] = 78768;
        nArray2[560] = 78782;
        nArray2[561] = 78798;
        nArray2[562] = 78812;
        nArray2[563] = 78818;
        nArray2[564] = 78820;
        nArray2[565] = 78824;
        nArray2[566] = 78838;
        nArray2[567] = 78862;
        nArray2[568] = 78876;
        nArray2[569] = 78904;
        nArray2[570] = 78960;
        nArray2[571] = 78974;
        nArray2[572] = 79072;
        nArray2[573] = 79100;
        nArray2[574] = 79296;
        nArray2[575] = 79352;
        nArray2[576] = 79368;
        nArray2[577] = 79376;
        nArray2[578] = 79390;
        nArray2[579] = 79392;
        nArray2[580] = 79420;
        nArray2[581] = 79424;
        nArray2[582] = 79480;
        nArray2[583] = 79600;
        nArray2[584] = 79628;
        nArray2[585] = 79640;
        nArray2[586] = 79664;
        nArray2[587] = 79678;
        nArray2[588] = 79712;
        nArray2[589] = 79740;
        nArray2[590] = 79772;
        nArray2[591] = 79800;
        nArray2[592] = 79810;
        nArray2[593] = 79812;
        nArray2[594] = 79816;
        nArray2[595] = 79824;
        nArray2[596] = 79838;
        nArray2[597] = 79846;
        nArray2[598] = 79852;
        nArray2[599] = 79894;
        nArray2[600] = 79910;
        nArray2[601] = 79916;
        nArray2[602] = 79942;
        nArray2[603] = 79948;
        nArray2[604] = 79960;
        nArray2[605] = 79982;
        nArray2[606] = 79988;
        nArray2[607] = 80006;
        nArray2[608] = 80024;
        nArray2[609] = 80048;
        nArray2[610] = 80062;
        nArray2[611] = 80078;
        nArray2[612] = 80092;
        nArray2[613] = 80098;
        nArray2[614] = 80100;
        nArray2[615] = 80104;
        nArray2[616] = 80134;
        nArray2[617] = 80140;
        nArray2[618] = 80176;
        nArray2[619] = 80190;
        nArray2[620] = 80224;
        nArray2[621] = 80252;
        nArray2[622] = 80270;
        nArray2[623] = 80284;
        nArray2[624] = 80312;
        nArray2[625] = 80328;
        nArray2[626] = 80336;
        nArray2[627] = 80350;
        nArray2[628] = 80358;
        nArray2[629] = 80364;
        nArray2[630] = 80378;
        nArray2[631] = 80390;
        nArray2[632] = 80396;
        nArray2[633] = 80408;
        nArray2[634] = 80432;
        nArray2[635] = 80446;
        nArray2[636] = 80480;
        nArray2[637] = 80508;
        nArray2[638] = 80576;
        nArray2[639] = 80632;
        nArray2[640] = 80654;
        nArray2[641] = 80668;
        nArray2[642] = 80696;
        nArray2[643] = 80752;
        nArray2[644] = 80766;
        nArray2[645] = 80776;
        nArray2[646] = 80784;
        nArray2[647] = 80798;
        nArray2[648] = 80800;
        nArray2[649] = 80828;
        nArray2[650] = 80844;
        nArray2[651] = 80856;
        nArray2[652] = 80878;
        nArray2[653] = 80882;
        nArray2[654] = 80884;
        nArray2[655] = 80914;
        nArray2[656] = 80916;
        nArray2[657] = 80930;
        nArray2[658] = 80932;
        nArray2[659] = 80936;
        nArray2[660] = 80950;
        nArray2[661] = 80962;
        nArray2[662] = 80968;
        nArray2[663] = 80976;
        nArray2[664] = 80990;
        nArray2[665] = 80998;
        nArray2[666] = 81004;
        nArray2[667] = 81026;
        nArray2[668] = 81028;
        nArray2[669] = 81040;
        nArray2[670] = 81054;
        nArray2[671] = 81056;
        nArray2[672] = 81084;
        nArray2[673] = 81094;
        nArray2[674] = 81100;
        nArray2[675] = 81112;
        nArray2[676] = 81134;
        nArray2[677] = 81154;
        nArray2[678] = 81156;
        nArray2[679] = 81160;
        nArray2[680] = 81168;
        nArray2[681] = 81182;
        nArray2[682] = 81184;
        nArray2[683] = 81212;
        nArray2[684] = 81216;
        nArray2[685] = 81272;
        nArray2[686] = 81286;
        nArray2[687] = 81292;
        nArray2[688] = 81304;
        nArray2[689] = 81328;
        nArray2[690] = 81342;
        nArray2[691] = 81358;
        nArray2[692] = 81372;
        nArray2[693] = 81380;
        nArray2[694] = 81384;
        nArray2[695] = 81398;
        nArray2[696] = 81434;
        nArray2[697] = 81454;
        nArray2[698] = 81458;
        nArray2[699] = 81460;
        nArray2[700] = 81486;
        nArray2[701] = 81500;
        nArray2[702] = 81506;
        nArray2[703] = 81508;
        nArray2[704] = 81512;
        nArray2[705] = 81526;
        nArray2[706] = 81550;
        nArray2[707] = 81564;
        nArray2[708] = 81592;
        nArray2[709] = 81602;
        nArray2[710] = 81604;
        nArray2[711] = 81608;
        nArray2[712] = 81616;
        nArray2[713] = 81630;
        nArray2[714] = 81638;
        nArray2[715] = 81644;
        nArray2[716] = 81702;
        nArray2[717] = 81708;
        nArray2[718] = 81722;
        nArray2[719] = 81734;
        nArray2[720] = 81740;
        nArray2[721] = 81752;
        nArray2[722] = 81774;
        nArray2[723] = 81778;
        nArray2[724] = 81780;
        nArray2[725] = 82050;
        nArray2[726] = 82078;
        nArray2[727] = 82080;
        nArray2[728] = 82108;
        nArray2[729] = 82180;
        nArray2[730] = 82184;
        nArray2[731] = 82192;
        nArray2[732] = 82206;
        nArray2[733] = 82208;
        nArray2[734] = 82236;
        nArray2[735] = 82240;
        nArray2[736] = 82296;
        nArray2[737] = 82316;
        nArray2[738] = 82328;
        nArray2[739] = 82352;
        nArray2[740] = 82366;
        nArray2[741] = 82402;
        nArray2[742] = 82404;
        nArray2[743] = 82408;
        nArray2[744] = 82440;
        nArray2[745] = 82448;
        nArray2[746] = 82462;
        nArray2[747] = 82464;
        nArray2[748] = 82492;
        nArray2[749] = 82496;
        nArray2[750] = 82552;
        nArray2[751] = 82672;
        nArray2[752] = 82694;
        nArray2[753] = 82700;
        nArray2[754] = 82712;
        nArray2[755] = 82736;
        nArray2[756] = 82750;
        nArray2[757] = 82784;
        nArray2[758] = 82812;
        nArray2[759] = 82830;
        nArray2[760] = 82882;
        nArray2[761] = 82884;
        nArray2[762] = 82888;
        nArray2[763] = 82896;
        nArray2[764] = 82918;
        nArray2[765] = 82924;
        nArray2[766] = 82952;
        nArray2[767] = 82960;
        nArray2[768] = 82974;
        nArray2[769] = 82976;
        nArray2[770] = 83004;
        nArray2[771] = 83008;
        nArray2[772] = 83064;
        nArray2[773] = 83184;
        nArray2[774] = 83424;
        nArray2[775] = 83468;
        nArray2[776] = 83480;
        nArray2[777] = 83504;
        nArray2[778] = 83518;
        nArray2[779] = 83552;
        nArray2[780] = 83580;
        nArray2[781] = 83648;
        nArray2[782] = 83704;
        nArray2[783] = 83740;
        nArray2[784] = 83768;
        nArray2[785] = 83824;
        nArray2[786] = 83838;
        nArray2[787] = 83842;
        nArray2[788] = 83844;
        nArray2[789] = 83848;
        nArray2[790] = 83856;
        nArray2[791] = 83872;
        nArray2[792] = 83900;
        nArray2[793] = 83910;
        nArray2[794] = 83916;
        nArray2[795] = 83928;
        nArray2[796] = 83950;
        nArray2[797] = 83984;
        nArray2[798] = 84000;
        nArray2[799] = 84028;
        nArray2[800] = 84032;
        nArray2[801] = 84088;
        nArray2[802] = 84208;
        nArray2[803] = 84448;
        nArray2[804] = 84928;
        nArray2[805] = 85040;
        nArray2[806] = 85054;
        nArray2[807] = 85088;
        nArray2[808] = 85116;
        nArray2[809] = 85184;
        nArray2[810] = 85240;
        nArray2[811] = 85488;
        nArray2[812] = 85560;
        nArray2[813] = 85616;
        nArray2[814] = 85630;
        nArray2[815] = 85728;
        nArray2[816] = 85756;
        nArray2[817] = 85764;
        nArray2[818] = 85768;
        nArray2[819] = 85776;
        nArray2[820] = 85790;
        nArray2[821] = 85792;
        nArray2[822] = 85820;
        nArray2[823] = 85824;
        nArray2[824] = 85880;
        nArray2[825] = 85894;
        nArray2[826] = 85900;
        nArray2[827] = 85912;
        nArray2[828] = 85936;
        nArray2[829] = 85966;
        nArray2[830] = 85980;
        nArray2[831] = 86048;
        nArray2[832] = 86080;
        nArray2[833] = 86136;
        nArray2[834] = 86256;
        nArray2[835] = 86496;
        nArray2[836] = 86976;
        nArray2[837] = 88160;
        nArray2[838] = 88188;
        nArray2[839] = 88256;
        nArray2[840] = 88312;
        nArray2[841] = 88560;
        nArray2[842] = 89056;
        nArray2[843] = 89200;
        nArray2[844] = 89214;
        nArray2[845] = 89312;
        nArray2[846] = 89340;
        nArray2[847] = 89536;
        nArray2[848] = 89592;
        nArray2[849] = 89608;
        nArray2[850] = 89616;
        nArray2[851] = 89632;
        nArray2[852] = 89664;
        nArray2[853] = 89720;
        nArray2[854] = 89840;
        nArray2[855] = 89868;
        nArray2[856] = 89880;
        nArray2[857] = 89904;
        nArray2[858] = 89952;
        nArray2[859] = 89980;
        nArray2[860] = 89998;
        nArray2[861] = 90012;
        nArray2[862] = 90040;
        nArray2[863] = 90190;
        nArray2[864] = 90204;
        nArray2[865] = 90254;
        nArray2[866] = 90268;
        nArray2[867] = 90296;
        nArray2[868] = 90306;
        nArray2[869] = 90308;
        nArray2[870] = 90312;
        nArray2[871] = 90334;
        nArray2[872] = 90382;
        nArray2[873] = 90396;
        nArray2[874] = 90424;
        nArray2[875] = 90480;
        nArray2[876] = 90494;
        nArray2[877] = 90500;
        nArray2[878] = 90504;
        nArray2[879] = 90512;
        nArray2[880] = 90526;
        nArray2[881] = 90528;
        nArray2[882] = 90556;
        nArray2[883] = 90566;
        nArray2[884] = 90572;
        nArray2[885] = 90584;
        nArray2[886] = 90610;
        nArray2[887] = 90612;
        nArray2[888] = 90638;
        nArray2[889] = 90652;
        nArray2[890] = 90680;
        nArray2[891] = 90736;
        nArray2[892] = 90750;
        nArray2[893] = 90848;
        nArray2[894] = 90876;
        nArray2[895] = 90884;
        nArray2[896] = 90888;
        nArray2[897] = 90896;
        nArray2[898] = 90910;
        nArray2[899] = 90912;
        nArray2[900] = 90940;
        nArray2[901] = 90944;
        nArray2[902] = 91000;
        nArray2[903] = 91014;
        nArray2[904] = 91020;
        nArray2[905] = 91032;
        nArray2[906] = 91056;
        nArray2[907] = 91070;
        nArray2[908] = 91086;
        nArray2[909] = 91100;
        nArray2[910] = 91106;
        nArray2[911] = 91108;
        nArray2[912] = 91112;
        nArray2[913] = 91126;
        nArray2[914] = 91150;
        nArray2[915] = 91164;
        nArray2[916] = 91192;
        nArray2[917] = 91248;
        nArray2[918] = 91262;
        nArray2[919] = 91360;
        nArray2[920] = 91388;
        nArray2[921] = 91584;
        nArray2[922] = 91640;
        nArray2[923] = 91664;
        nArray2[924] = 91678;
        nArray2[925] = 91680;
        nArray2[926] = 91708;
        nArray2[927] = 91712;
        nArray2[928] = 91768;
        nArray2[929] = 91888;
        nArray2[930] = 91928;
        nArray2[931] = 91952;
        nArray2[932] = 91966;
        nArray2[933] = 92000;
        nArray2[934] = 92028;
        nArray2[935] = 92046;
        nArray2[936] = 92060;
        nArray2[937] = 92088;
        nArray2[938] = 92098;
        nArray2[939] = 92100;
        nArray2[940] = 92104;
        nArray2[941] = 92112;
        nArray2[942] = 92126;
        nArray2[943] = 92134;
        nArray2[944] = 92140;
        nArray2[945] = 92188;
        nArray2[946] = 92216;
        nArray2[947] = 92272;
        nArray2[948] = 92384;
        nArray2[949] = 92412;
        nArray2[950] = 92608;
        nArray2[951] = 92664;
        nArray2[952] = 93168;
        nArray2[953] = 93200;
        nArray2[954] = 93214;
        nArray2[955] = 93216;
        nArray2[956] = 93244;
        nArray2[957] = 93248;
        nArray2[958] = 93304;
        nArray2[959] = 93424;
        nArray2[960] = 93664;
        nArray2[961] = 93720;
        nArray2[962] = 93744;
        nArray2[963] = 93758;
        nArray2[964] = 93792;
        nArray2[965] = 93820;
        nArray2[966] = 93888;
        nArray2[967] = 93944;
        nArray2[968] = 93980;
        nArray2[969] = 94008;
        nArray2[970] = 94064;
        nArray2[971] = 94078;
        nArray2[972] = 94084;
        nArray2[973] = 94088;
        nArray2[974] = 94096;
        nArray2[975] = 94110;
        nArray2[976] = 94112;
        nArray2[977] = 94140;
        nArray2[978] = 94150;
        nArray2[979] = 94156;
        nArray2[980] = 94168;
        nArray2[981] = 94246;
        nArray2[982] = 94252;
        nArray2[983] = 94278;
        nArray2[984] = 94284;
        nArray2[985] = 94296;
        nArray2[986] = 94318;
        nArray2[987] = 94342;
        nArray2[988] = 94348;
        nArray2[989] = 94360;
        nArray2[990] = 94384;
        nArray2[991] = 94398;
        nArray2[992] = 94414;
        nArray2[993] = 94428;
        nArray2[994] = 94440;
        nArray2[995] = 94470;
        nArray2[996] = 94476;
        nArray2[997] = 94488;
        nArray2[998] = 94512;
        nArray2[999] = 94526;
        nArray2[1000] = 94560;
        nArray2[1001] = 94588;
        nArray2[1002] = 94606;
        nArray2[1003] = 94620;
        nArray2[1004] = 94648;
        nArray2[1005] = 94658;
        nArray2[1006] = 94660;
        nArray2[1007] = 94664;
        nArray2[1008] = 94672;
        nArray2[1009] = 94686;
        nArray2[1010] = 94694;
        nArray2[1011] = 94700;
        nArray2[1012] = 94714;
        nArray2[1013] = 94726;
        nArray2[1014] = 94732;
        nArray2[1015] = 94744;
        nArray2[1016] = 94768;
        nArray2[1017] = 94782;
        nArray2[1018] = 94816;
        nArray2[1019] = 94844;
        nArray2[1020] = 94912;
        nArray2[1021] = 94968;
        nArray2[1022] = 94990;
        nArray2[1023] = 95004;
        nArray2[1024] = 95032;
        nArray2[1025] = 95088;
        nArray2[1026] = 95102;
        nArray2[1027] = 95112;
        nArray2[1028] = 95120;
        nArray2[1029] = 95134;
        nArray2[1030] = 95136;
        nArray2[1031] = 95164;
        nArray2[1032] = 95180;
        nArray2[1033] = 95192;
        nArray2[1034] = 95214;
        nArray2[1035] = 95218;
        nArray2[1036] = 95220;
        nArray2[1037] = 95244;
        nArray2[1038] = 95256;
        nArray2[1039] = 95280;
        nArray2[1040] = 95294;
        nArray2[1041] = 95328;
        nArray2[1042] = 95356;
        nArray2[1043] = 95424;
        nArray2[1044] = 95480;
        nArray2[1045] = 95728;
        nArray2[1046] = 95758;
        nArray2[1047] = 95772;
        nArray2[1048] = 95800;
        nArray2[1049] = 95856;
        nArray2[1050] = 95870;
        nArray2[1051] = 95968;
        nArray2[1052] = 95996;
        nArray2[1053] = 96008;
        nArray2[1054] = 96016;
        nArray2[1055] = 96030;
        nArray2[1056] = 96032;
        nArray2[1057] = 96060;
        nArray2[1058] = 96064;
        nArray2[1059] = 96120;
        nArray2[1060] = 96152;
        nArray2[1061] = 96176;
        nArray2[1062] = 96190;
        nArray2[1063] = 96220;
        nArray2[1064] = 96226;
        nArray2[1065] = 96228;
        nArray2[1066] = 96232;
        nArray2[1067] = 96290;
        nArray2[1068] = 96292;
        nArray2[1069] = 96296;
        nArray2[1070] = 96310;
        nArray2[1071] = 96322;
        nArray2[1072] = 96324;
        nArray2[1073] = 96328;
        nArray2[1074] = 96336;
        nArray2[1075] = 96350;
        nArray2[1076] = 96358;
        nArray2[1077] = 96364;
        nArray2[1078] = 96386;
        nArray2[1079] = 96388;
        nArray2[1080] = 96392;
        nArray2[1081] = 96400;
        nArray2[1082] = 96414;
        nArray2[1083] = 96416;
        nArray2[1084] = 96444;
        nArray2[1085] = 96454;
        nArray2[1086] = 96460;
        nArray2[1087] = 96472;
        nArray2[1088] = 96494;
        nArray2[1089] = 96498;
        nArray2[1090] = 96500;
        nArray2[1091] = 96514;
        nArray2[1092] = 96516;
        nArray2[1093] = 96520;
        nArray2[1094] = 96528;
        nArray2[1095] = 96542;
        nArray2[1096] = 96544;
        nArray2[1097] = 96572;
        nArray2[1098] = 96576;
        nArray2[1099] = 96632;
        nArray2[1100] = 96646;
        nArray2[1101] = 96652;
        nArray2[1102] = 96664;
        nArray2[1103] = 96688;
        nArray2[1104] = 96702;
        nArray2[1105] = 96718;
        nArray2[1106] = 96732;
        nArray2[1107] = 96738;
        nArray2[1108] = 96740;
        nArray2[1109] = 96744;
        nArray2[1110] = 96758;
        nArray2[1111] = 96772;
        nArray2[1112] = 96776;
        nArray2[1113] = 96784;
        nArray2[1114] = 96798;
        nArray2[1115] = 96800;
        nArray2[1116] = 96828;
        nArray2[1117] = 96832;
        nArray2[1118] = 96888;
        nArray2[1119] = 97008;
        nArray2[1120] = 97030;
        nArray2[1121] = 97036;
        nArray2[1122] = 97048;
        nArray2[1123] = 97072;
        nArray2[1124] = 97086;
        nArray2[1125] = 97120;
        nArray2[1126] = 97148;
        nArray2[1127] = 97166;
        nArray2[1128] = 97180;
        nArray2[1129] = 97208;
        nArray2[1130] = 97220;
        nArray2[1131] = 97224;
        nArray2[1132] = 97232;
        nArray2[1133] = 97246;
        nArray2[1134] = 97254;
        nArray2[1135] = 97260;
        nArray2[1136] = 97326;
        nArray2[1137] = 97330;
        nArray2[1138] = 97332;
        nArray2[1139] = 97358;
        nArray2[1140] = 97372;
        nArray2[1141] = 97378;
        nArray2[1142] = 97380;
        nArray2[1143] = 97384;
        nArray2[1144] = 97398;
        nArray2[1145] = 97422;
        nArray2[1146] = 97436;
        nArray2[1147] = 97464;
        nArray2[1148] = 97474;
        nArray2[1149] = 97476;
        nArray2[1150] = 97480;
        nArray2[1151] = 97488;
        nArray2[1152] = 97502;
        nArray2[1153] = 97510;
        nArray2[1154] = 97516;
        nArray2[1155] = 97550;
        nArray2[1156] = 97564;
        nArray2[1157] = 97592;
        nArray2[1158] = 97648;
        nArray2[1159] = 97666;
        nArray2[1160] = 97668;
        nArray2[1161] = 97672;
        nArray2[1162] = 97680;
        nArray2[1163] = 97694;
        nArray2[1164] = 97696;
        nArray2[1165] = 97724;
        nArray2[1166] = 97734;
        nArray2[1167] = 97740;
        nArray2[1168] = 97752;
        nArray2[1169] = 97774;
        nArray2[1170] = 97830;
        nArray2[1171] = 97836;
        nArray2[1172] = 97850;
        nArray2[1173] = 97862;
        nArray2[1174] = 97868;
        nArray2[1175] = 97880;
        nArray2[1176] = 97902;
        nArray2[1177] = 97906;
        nArray2[1178] = 97908;
        nArray2[1179] = 97926;
        nArray2[1180] = 97932;
        nArray2[1181] = 97944;
        nArray2[1182] = 97968;
        nArray2[1183] = 97998;
        nArray2[1184] = 98012;
        nArray2[1185] = 98018;
        nArray2[1186] = 98020;
        nArray2[1187] = 98024;
        nArray2[1188] = 98038;
        nArray2[1189] = 98618;
        nArray2[1190] = 98674;
        nArray2[1191] = 98676;
        nArray2[1192] = 98838;
        nArray2[1193] = 98854;
        nArray2[1194] = 98874;
        nArray2[1195] = 98892;
        nArray2[1196] = 98904;
        nArray2[1197] = 98926;
        nArray2[1198] = 98930;
        nArray2[1199] = 98932;
        nArray2[1200] = 98968;
        nArray2[1201] = 99006;
        nArray2[1202] = 99042;
        nArray2[1203] = 99044;
        nArray2[1204] = 99048;
        nArray2[1205] = 99062;
        nArray2[1206] = 99166;
        nArray2[1207] = 99194;
        nArray2[1208] = 99246;
        nArray2[1209] = 99286;
        nArray2[1210] = 99350;
        nArray2[1211] = 99366;
        nArray2[1212] = 99372;
        nArray2[1213] = 99386;
        nArray2[1214] = 99398;
        nArray2[1215] = 99416;
        nArray2[1216] = 99438;
        nArray2[1217] = 99442;
        nArray2[1218] = 99444;
        nArray2[1219] = 99462;
        nArray2[1220] = 99504;
        nArray2[1221] = 99518;
        nArray2[1222] = 99534;
        nArray2[1223] = 99548;
        nArray2[1224] = 99554;
        nArray2[1225] = 99556;
        nArray2[1226] = 99560;
        nArray2[1227] = 99574;
        nArray2[1228] = 99590;
        nArray2[1229] = 99596;
        nArray2[1230] = 99608;
        nArray2[1231] = 99632;
        nArray2[1232] = 99646;
        nArray2[1233] = 99680;
        nArray2[1234] = 99708;
        nArray2[1235] = 99726;
        nArray2[1236] = 99740;
        nArray2[1237] = 99768;
        nArray2[1238] = 99778;
        nArray2[1239] = 99780;
        nArray2[1240] = 99784;
        nArray2[1241] = 99792;
        nArray2[1242] = 99806;
        nArray2[1243] = 99814;
        nArray2[1244] = 99820;
        nArray2[1245] = 99834;
        nArray2[1246] = 99858;
        nArray2[1247] = 99860;
        nArray2[1248] = 99874;
        nArray2[1249] = 99880;
        nArray2[1250] = 99894;
        nArray2[1251] = 99906;
        nArray2[1252] = 99920;
        nArray2[1253] = 99934;
        nArray2[1254] = 99962;
        nArray2[1255] = 99970;
        nArray2[1256] = 99972;
        nArray2[1257] = 99976;
        nArray2[1258] = 99984;
        nArray2[1259] = 99998;
        nArray2[1260] = 100000;
        nArray2[1261] = 100028;
        nArray2[1262] = 100038;
        nArray2[1263] = 100044;
        nArray2[1264] = 100056;
        nArray2[1265] = 100078;
        nArray2[1266] = 100082;
        nArray2[1267] = 100084;
        nArray2[1268] = 100142;
        nArray2[1269] = 100174;
        nArray2[1270] = 100188;
        nArray2[1271] = 100246;
        nArray2[1272] = 100262;
        nArray2[1273] = 100268;
        nArray2[1274] = 100306;
        nArray2[1275] = 100308;
        nArray2[1276] = 100390;
        nArray2[1277] = 100396;
        nArray2[1278] = 100410;
        nArray2[1279] = 100422;
        nArray2[1280] = 100428;
        nArray2[1281] = 100440;
        nArray2[1282] = 100462;
        nArray2[1283] = 100466;
        nArray2[1284] = 100468;
        nArray2[1285] = 100486;
        nArray2[1286] = 100504;
        nArray2[1287] = 100528;
        nArray2[1288] = 100542;
        nArray2[1289] = 100558;
        nArray2[1290] = 100572;
        nArray2[1291] = 100578;
        nArray2[1292] = 100580;
        nArray2[1293] = 100584;
        nArray2[1294] = 100598;
        nArray2[1295] = 100620;
        nArray2[1296] = 100656;
        nArray2[1297] = 100670;
        nArray2[1298] = 100704;
        nArray2[1299] = 100732;
        nArray2[1300] = 100750;
        nArray2[1301] = 100792;
        nArray2[1302] = 100802;
        nArray2[1303] = 100808;
        nArray2[1304] = 100816;
        nArray2[1305] = 100830;
        nArray2[1306] = 100838;
        nArray2[1307] = 100844;
        nArray2[1308] = 100858;
        nArray2[1309] = 100888;
        nArray2[1310] = 100912;
        nArray2[1311] = 100926;
        nArray2[1312] = 100960;
        nArray2[1313] = 100988;
        nArray2[1314] = 101056;
        nArray2[1315] = 101112;
        nArray2[1316] = 101148;
        nArray2[1317] = 101176;
        nArray2[1318] = 101232;
        nArray2[1319] = 101246;
        nArray2[1320] = 101250;
        nArray2[1321] = 101252;
        nArray2[1322] = 101256;
        nArray2[1323] = 101264;
        nArray2[1324] = 101278;
        nArray2[1325] = 101280;
        nArray2[1326] = 101308;
        nArray2[1327] = 101318;
        nArray2[1328] = 101324;
        nArray2[1329] = 101336;
        nArray2[1330] = 101358;
        nArray2[1331] = 101362;
        nArray2[1332] = 101364;
        nArray2[1333] = 101410;
        nArray2[1334] = 101412;
        nArray2[1335] = 101416;
        nArray2[1336] = 101430;
        nArray2[1337] = 101442;
        nArray2[1338] = 101448;
        nArray2[1339] = 101456;
        nArray2[1340] = 101470;
        nArray2[1341] = 101478;
        nArray2[1342] = 101498;
        nArray2[1343] = 101506;
        nArray2[1344] = 101508;
        nArray2[1345] = 101520;
        nArray2[1346] = 101534;
        nArray2[1347] = 101536;
        nArray2[1348] = 101564;
        nArray2[1349] = 101580;
        nArray2[1350] = 101618;
        nArray2[1351] = 101620;
        nArray2[1352] = 101636;
        nArray2[1353] = 101640;
        nArray2[1354] = 101648;
        nArray2[1355] = 101662;
        nArray2[1356] = 101664;
        nArray2[1357] = 101692;
        nArray2[1358] = 101696;
        nArray2[1359] = 101752;
        nArray2[1360] = 101766;
        nArray2[1361] = 101784;
        nArray2[1362] = 101838;
        nArray2[1363] = 101858;
        nArray2[1364] = 101860;
        nArray2[1365] = 101864;
        nArray2[1366] = 101934;
        nArray2[1367] = 101938;
        nArray2[1368] = 101940;
        nArray2[1369] = 101966;
        nArray2[1370] = 101980;
        nArray2[1371] = 101986;
        nArray2[1372] = 101988;
        nArray2[1373] = 101992;
        nArray2[1374] = 102030;
        nArray2[1375] = 102044;
        nArray2[1376] = 102072;
        nArray2[1377] = 102082;
        nArray2[1378] = 102084;
        nArray2[1379] = 102088;
        nArray2[1380] = 102096;
        nArray2[1381] = 102138;
        nArray2[1382] = 102166;
        nArray2[1383] = 102182;
        nArray2[1384] = 102188;
        nArray2[1385] = 102214;
        nArray2[1386] = 102220;
        nArray2[1387] = 102232;
        nArray2[1388] = 102254;
        nArray2[1389] = 102282;
        nArray2[1390] = 102290;
        nArray2[1391] = 102292;
        nArray2[1392] = 102306;
        nArray2[1393] = 102308;
        nArray2[1394] = 102312;
        nArray2[1395] = 102326;
        nArray2[1396] = 102444;
        nArray2[1397] = 102458;
        nArray2[1398] = 102470;
        nArray2[1399] = 102476;
        nArray2[1400] = 102488;
        nArray2[1401] = 102514;
        nArray2[1402] = 102516;
        nArray2[1403] = 102534;
        nArray2[1404] = 102552;
        nArray2[1405] = 102576;
        nArray2[1406] = 102590;
        nArray2[1407] = 102606;
        nArray2[1408] = 102620;
        nArray2[1409] = 102626;
        nArray2[1410] = 102632;
        nArray2[1411] = 102646;
        nArray2[1412] = 102662;
        nArray2[1413] = 102668;
        nArray2[1414] = 102704;
        nArray2[1415] = 102718;
        nArray2[1416] = 102752;
        nArray2[1417] = 102780;
        nArray2[1418] = 102798;
        nArray2[1419] = 102812;
        nArray2[1420] = 102840;
        nArray2[1421] = 102850;
        nArray2[1422] = 102856;
        nArray2[1423] = 102864;
        nArray2[1424] = 102878;
        nArray2[1425] = 102886;
        nArray2[1426] = 102892;
        nArray2[1427] = 102906;
        nArray2[1428] = 102936;
        nArray2[1429] = 102974;
        nArray2[1430] = 103008;
        nArray2[1431] = 103036;
        nArray2[1432] = 103104;
        nArray2[1433] = 103160;
        nArray2[1434] = 103224;
        nArray2[1435] = 103280;
        nArray2[1436] = 103294;
        nArray2[1437] = 103298;
        nArray2[1438] = 103300;
        nArray2[1439] = 103312;
        nArray2[1440] = 103326;
        nArray2[1441] = 103328;
        nArray2[1442] = 103356;
        nArray2[1443] = 103366;
        nArray2[1444] = 103372;
        nArray2[1445] = 103384;
        nArray2[1446] = 103406;
        nArray2[1447] = 103410;
        nArray2[1448] = 103412;
        nArray2[1449] = 103472;
        nArray2[1450] = 103486;
        nArray2[1451] = 103520;
        nArray2[1452] = 103548;
        nArray2[1453] = 103616;
        nArray2[1454] = 103672;
        nArray2[1455] = 103920;
        nArray2[1456] = 103992;
        nArray2[1457] = 104048;
        nArray2[1458] = 104062;
        nArray2[1459] = 104160;
        nArray2[1460] = 104188;
        nArray2[1461] = 104194;
        nArray2[1462] = 104196;
        nArray2[1463] = 104200;
        nArray2[1464] = 104208;
        nArray2[1465] = 104224;
        nArray2[1466] = 104252;
        nArray2[1467] = 104256;
        nArray2[1468] = 104312;
        nArray2[1469] = 104326;
        nArray2[1470] = 104332;
        nArray2[1471] = 104344;
        nArray2[1472] = 104368;
        nArray2[1473] = 104382;
        nArray2[1474] = 104398;
        nArray2[1475] = 104412;
        nArray2[1476] = 104418;
        nArray2[1477] = 104420;
        nArray2[1478] = 104424;
        nArray2[1479] = 104482;
        nArray2[1480] = 104484;
        nArray2[1481] = 104514;
        nArray2[1482] = 104520;
        nArray2[1483] = 104528;
        nArray2[1484] = 104542;
        nArray2[1485] = 104550;
        nArray2[1486] = 104570;
        nArray2[1487] = 104578;
        nArray2[1488] = 104580;
        nArray2[1489] = 104592;
        nArray2[1490] = 104606;
        nArray2[1491] = 104608;
        nArray2[1492] = 104636;
        nArray2[1493] = 104652;
        nArray2[1494] = 104690;
        nArray2[1495] = 104692;
        nArray2[1496] = 104706;
        nArray2[1497] = 104712;
        nArray2[1498] = 104734;
        nArray2[1499] = 104736;
        nArray2[1500] = 104764;
        nArray2[1501] = 104768;
        nArray2[1502] = 104824;
        nArray2[1503] = 104838;
        nArray2[1504] = 104856;
        nArray2[1505] = 104910;
        nArray2[1506] = 104930;
        nArray2[1507] = 104932;
        nArray2[1508] = 104936;
        nArray2[1509] = 104968;
        nArray2[1510] = 104976;
        nArray2[1511] = 104990;
        nArray2[1512] = 104992;
        nArray2[1513] = 105020;
        nArray2[1514] = 105024;
        nArray2[1515] = 105080;
        nArray2[1516] = 105200;
        nArray2[1517] = 105240;
        nArray2[1518] = 105278;
        nArray2[1519] = 105312;
        nArray2[1520] = 105372;
        nArray2[1521] = 105410;
        nArray2[1522] = 105412;
        nArray2[1523] = 105416;
        nArray2[1524] = 105424;
        nArray2[1525] = 105446;
        nArray2[1526] = 105518;
        nArray2[1527] = 105524;
        nArray2[1528] = 105550;
        nArray2[1529] = 105564;
        nArray2[1530] = 105570;
        nArray2[1531] = 105572;
        nArray2[1532] = 105576;
        nArray2[1533] = 105614;
        nArray2[1534] = 105628;
        nArray2[1535] = 105656;
        nArray2[1536] = 105666;
        nArray2[1537] = 105672;
        nArray2[1538] = 105680;
        nArray2[1539] = 105702;
        nArray2[1540] = 105722;
        nArray2[1541] = 105742;
        nArray2[1542] = 105756;
        nArray2[1543] = 105784;
        nArray2[1544] = 105840;
        nArray2[1545] = 105854;
        nArray2[1546] = 105858;
        nArray2[1547] = 105860;
        nArray2[1548] = 105864;
        nArray2[1549] = 105872;
        nArray2[1550] = 105888;
        nArray2[1551] = 105932;
        nArray2[1552] = 105970;
        nArray2[1553] = 105972;
        nArray2[1554] = 106006;
        nArray2[1555] = 106022;
        nArray2[1556] = 106028;
        nArray2[1557] = 106054;
        nArray2[1558] = 106060;
        nArray2[1559] = 106072;
        nArray2[1560] = 106100;
        nArray2[1561] = 106118;
        nArray2[1562] = 106124;
        nArray2[1563] = 106136;
        nArray2[1564] = 106160;
        nArray2[1565] = 106174;
        nArray2[1566] = 106190;
        nArray2[1567] = 106210;
        nArray2[1568] = 106212;
        nArray2[1569] = 106216;
        nArray2[1570] = 106250;
        nArray2[1571] = 106258;
        nArray2[1572] = 106260;
        nArray2[1573] = 106274;
        nArray2[1574] = 106276;
        nArray2[1575] = 106280;
        nArray2[1576] = 106306;
        nArray2[1577] = 106308;
        nArray2[1578] = 106312;
        nArray2[1579] = 106320;
        nArray2[1580] = 106334;
        nArray2[1581] = 106348;
        nArray2[1582] = 106394;
        nArray2[1583] = 106414;
        nArray2[1584] = 106418;
        nArray2[1585] = 106420;
        nArray2[1586] = 106566;
        nArray2[1587] = 106572;
        nArray2[1588] = 106610;
        nArray2[1589] = 106612;
        nArray2[1590] = 106630;
        nArray2[1591] = 106636;
        nArray2[1592] = 106648;
        nArray2[1593] = 106672;
        nArray2[1594] = 106686;
        nArray2[1595] = 106722;
        nArray2[1596] = 106724;
        nArray2[1597] = 106728;
        nArray2[1598] = 106742;
        nArray2[1599] = 106758;
        nArray2[1600] = 106764;
        nArray2[1601] = 106776;
        nArray2[1602] = 106800;
        nArray2[1603] = 106814;
        nArray2[1604] = 106848;
        nArray2[1605] = 106876;
        nArray2[1606] = 106894;
        nArray2[1607] = 106908;
        nArray2[1608] = 106936;
        nArray2[1609] = 106946;
        nArray2[1610] = 106948;
        nArray2[1611] = 106952;
        nArray2[1612] = 106960;
        nArray2[1613] = 106974;
        nArray2[1614] = 106982;
        nArray2[1615] = 106988;
        nArray2[1616] = 107032;
        nArray2[1617] = 107056;
        nArray2[1618] = 107070;
        nArray2[1619] = 107104;
        nArray2[1620] = 107132;
        nArray2[1621] = 107200;
        nArray2[1622] = 107256;
        nArray2[1623] = 107292;
        nArray2[1624] = 107320;
        nArray2[1625] = 107376;
        nArray2[1626] = 107390;
        nArray2[1627] = 107394;
        nArray2[1628] = 107396;
        nArray2[1629] = 107400;
        nArray2[1630] = 107408;
        nArray2[1631] = 107422;
        nArray2[1632] = 107424;
        nArray2[1633] = 107452;
        nArray2[1634] = 107462;
        nArray2[1635] = 107468;
        nArray2[1636] = 107480;
        nArray2[1637] = 107502;
        nArray2[1638] = 107506;
        nArray2[1639] = 107508;
        nArray2[1640] = 107544;
        nArray2[1641] = 107568;
        nArray2[1642] = 107582;
        nArray2[1643] = 107616;
        nArray2[1644] = 107644;
        nArray2[1645] = 107712;
        nArray2[1646] = 107768;
        nArray2[1647] = 108016;
        nArray2[1648] = 108060;
        nArray2[1649] = 108088;
        nArray2[1650] = 108144;
        nArray2[1651] = 108158;
        nArray2[1652] = 108256;
        nArray2[1653] = 108284;
        nArray2[1654] = 108290;
        nArray2[1655] = 108292;
        nArray2[1656] = 108296;
        nArray2[1657] = 108304;
        nArray2[1658] = 108318;
        nArray2[1659] = 108320;
        nArray2[1660] = 108348;
        nArray2[1661] = 108352;
        nArray2[1662] = 108408;
        nArray2[1663] = 108422;
        nArray2[1664] = 108428;
        nArray2[1665] = 108440;
        nArray2[1666] = 108464;
        nArray2[1667] = 108478;
        nArray2[1668] = 108494;
        nArray2[1669] = 108508;
        nArray2[1670] = 108514;
        nArray2[1671] = 108516;
        nArray2[1672] = 108520;
        nArray2[1673] = 108592;
        nArray2[1674] = 108640;
        nArray2[1675] = 108668;
        nArray2[1676] = 108736;
        nArray2[1677] = 108792;
        nArray2[1678] = 109040;
        nArray2[1679] = 109536;
        nArray2[1680] = 109680;
        nArray2[1681] = 109694;
        nArray2[1682] = 109792;
        nArray2[1683] = 109820;
        nArray2[1684] = 110016;
        nArray2[1685] = 110072;
        nArray2[1686] = 110084;
        nArray2[1687] = 110088;
        nArray2[1688] = 110096;
        nArray2[1689] = 110112;
        nArray2[1690] = 110140;
        nArray2[1691] = 110144;
        nArray2[1692] = 110200;
        nArray2[1693] = 110320;
        nArray2[1694] = 110342;
        nArray2[1695] = 110348;
        nArray2[1696] = 110360;
        nArray2[1697] = 110384;
        nArray2[1698] = 110398;
        nArray2[1699] = 110432;
        nArray2[1700] = 110460;
        nArray2[1701] = 110478;
        nArray2[1702] = 110492;
        nArray2[1703] = 110520;
        nArray2[1704] = 110532;
        nArray2[1705] = 110536;
        nArray2[1706] = 110544;
        nArray2[1707] = 110558;
        nArray2[1708] = 110658;
        nArray2[1709] = 110686;
        nArray2[1710] = 110714;
        nArray2[1711] = 110722;
        nArray2[1712] = 110724;
        nArray2[1713] = 110728;
        nArray2[1714] = 110736;
        nArray2[1715] = 110750;
        nArray2[1716] = 110752;
        nArray2[1717] = 110780;
        nArray2[1718] = 110796;
        nArray2[1719] = 110834;
        nArray2[1720] = 110836;
        nArray2[1721] = 110850;
        nArray2[1722] = 110852;
        nArray2[1723] = 110856;
        nArray2[1724] = 110864;
        nArray2[1725] = 110878;
        nArray2[1726] = 110880;
        nArray2[1727] = 110908;
        nArray2[1728] = 110912;
        nArray2[1729] = 110968;
        nArray2[1730] = 110982;
        nArray2[1731] = 111000;
        nArray2[1732] = 111054;
        nArray2[1733] = 111074;
        nArray2[1734] = 111076;
        nArray2[1735] = 111080;
        nArray2[1736] = 111108;
        nArray2[1737] = 111112;
        nArray2[1738] = 111120;
        nArray2[1739] = 111134;
        nArray2[1740] = 111136;
        nArray2[1741] = 111164;
        nArray2[1742] = 111168;
        nArray2[1743] = 111224;
        nArray2[1744] = 111344;
        nArray2[1745] = 111372;
        nArray2[1746] = 111422;
        nArray2[1747] = 111456;
        nArray2[1748] = 111516;
        nArray2[1749] = 111554;
        nArray2[1750] = 111556;
        nArray2[1751] = 111560;
        nArray2[1752] = 111568;
        nArray2[1753] = 111590;
        nArray2[1754] = 111632;
        nArray2[1755] = 111646;
        nArray2[1756] = 111648;
        nArray2[1757] = 111676;
        nArray2[1758] = 111680;
        nArray2[1759] = 111736;
        nArray2[1760] = 111856;
        nArray2[1761] = 112096;
        nArray2[1762] = 112152;
        nArray2[1763] = 112224;
        nArray2[1764] = 112252;
        nArray2[1765] = 112320;
        nArray2[1766] = 112440;
        nArray2[1767] = 112514;
        nArray2[1768] = 112516;
        nArray2[1769] = 112520;
        nArray2[1770] = 112528;
        nArray2[1771] = 112542;
        nArray2[1772] = 112544;
        nArray2[1773] = 112588;
        nArray2[1774] = 112686;
        nArray2[1775] = 112718;
        nArray2[1776] = 112732;
        nArray2[1777] = 112782;
        nArray2[1778] = 112796;
        nArray2[1779] = 112824;
        nArray2[1780] = 112834;
        nArray2[1781] = 112836;
        nArray2[1782] = 112840;
        nArray2[1783] = 112848;
        nArray2[1784] = 112870;
        nArray2[1785] = 112890;
        nArray2[1786] = 112910;
        nArray2[1787] = 112924;
        nArray2[1788] = 112952;
        nArray2[1789] = 113008;
        nArray2[1790] = 113022;
        nArray2[1791] = 113026;
        nArray2[1792] = 113028;
        nArray2[1793] = 113032;
        nArray2[1794] = 113040;
        nArray2[1795] = 113054;
        nArray2[1796] = 113056;
        nArray2[1797] = 113100;
        nArray2[1798] = 113138;
        nArray2[1799] = 113140;
        nArray2[1800] = 113166;
        nArray2[1801] = 113180;
        nArray2[1802] = 113208;
        nArray2[1803] = 113264;
        nArray2[1804] = 113278;
        nArray2[1805] = 113376;
        nArray2[1806] = 113404;
        nArray2[1807] = 113416;
        nArray2[1808] = 113424;
        nArray2[1809] = 113440;
        nArray2[1810] = 113468;
        nArray2[1811] = 113472;
        nArray2[1812] = 113560;
        nArray2[1813] = 113614;
        nArray2[1814] = 113634;
        nArray2[1815] = 113636;
        nArray2[1816] = 113640;
        nArray2[1817] = 113686;
        nArray2[1818] = 113702;
        nArray2[1819] = 113708;
        nArray2[1820] = 113734;
        nArray2[1821] = 113740;
        nArray2[1822] = 113752;
        nArray2[1823] = 113778;
        nArray2[1824] = 113780;
        nArray2[1825] = 113798;
        nArray2[1826] = 113804;
        nArray2[1827] = 113816;
        nArray2[1828] = 113840;
        nArray2[1829] = 113854;
        nArray2[1830] = 113870;
        nArray2[1831] = 113890;
        nArray2[1832] = 113892;
        nArray2[1833] = 113896;
        nArray2[1834] = 113926;
        nArray2[1835] = 113932;
        nArray2[1836] = 113944;
        nArray2[1837] = 113968;
        nArray2[1838] = 113982;
        nArray2[1839] = 114016;
        nArray2[1840] = 114044;
        nArray2[1841] = 114076;
        nArray2[1842] = 114114;
        nArray2[1843] = 114116;
        nArray2[1844] = 114120;
        nArray2[1845] = 114128;
        nArray2[1846] = 114150;
        nArray2[1847] = 114170;
        nArray2[1848] = 114194;
        nArray2[1849] = 114196;
        nArray2[1850] = 114210;
        nArray2[1851] = 114212;
        nArray2[1852] = 114216;
        nArray2[1853] = 114242;
        nArray2[1854] = 114244;
        nArray2[1855] = 114248;
        nArray2[1856] = 114256;
        nArray2[1857] = 114270;
        nArray2[1858] = 114278;
        nArray2[1859] = 114306;
        nArray2[1860] = 114308;
        nArray2[1861] = 114312;
        nArray2[1862] = 114320;
        nArray2[1863] = 114334;
        nArray2[1864] = 114336;
        nArray2[1865] = 114364;
        nArray2[1866] = 114380;
        nArray2[1867] = 114420;
        nArray2[1868] = 114458;
        nArray2[1869] = 114478;
        nArray2[1870] = 114482;
        nArray2[1871] = 114484;
        nArray2[1872] = 114510;
        nArray2[1873] = 114524;
        nArray2[1874] = 114530;
        nArray2[1875] = 114532;
        nArray2[1876] = 114536;
        nArray2[1877] = 114842;
        nArray2[1878] = 114866;
        nArray2[1879] = 114868;
        nArray2[1880] = 114970;
        nArray2[1881] = 114994;
        nArray2[1882] = 114996;
        nArray2[1883] = 115042;
        nArray2[1884] = 115044;
        nArray2[1885] = 115048;
        nArray2[1886] = 115062;
        nArray2[1887] = 115130;
        nArray2[1888] = 115226;
        nArray2[1889] = 115250;
        nArray2[1890] = 115252;
        nArray2[1891] = 115278;
        nArray2[1892] = 115292;
        nArray2[1893] = 115298;
        nArray2[1894] = 115300;
        nArray2[1895] = 115304;
        nArray2[1896] = 115318;
        nArray2[1897] = 115342;
        nArray2[1898] = 115394;
        nArray2[1899] = 115396;
        nArray2[1900] = 115400;
        nArray2[1901] = 115408;
        nArray2[1902] = 115422;
        nArray2[1903] = 115430;
        nArray2[1904] = 115436;
        nArray2[1905] = 115450;
        nArray2[1906] = 115478;
        nArray2[1907] = 115494;
        nArray2[1908] = 115514;
        nArray2[1909] = 115526;
        nArray2[1910] = 115532;
        nArray2[1911] = 115570;
        nArray2[1912] = 115572;
        nArray2[1913] = 115738;
        nArray2[1914] = 115758;
        nArray2[1915] = 115762;
        nArray2[1916] = 115764;
        nArray2[1917] = 115790;
        nArray2[1918] = 115804;
        nArray2[1919] = 115810;
        nArray2[1920] = 115812;
        nArray2[1921] = 115816;
        nArray2[1922] = 115830;
        nArray2[1923] = 115854;
        nArray2[1924] = 115868;
        nArray2[1925] = 115896;
        nArray2[1926] = 115906;
        nArray2[1927] = 115912;
        nArray2[1928] = 115920;
        nArray2[1929] = 115934;
        nArray2[1930] = 115942;
        nArray2[1931] = 115948;
        nArray2[1932] = 115962;
        nArray2[1933] = 115996;
        nArray2[1934] = 116024;
        nArray2[1935] = 116080;
        nArray2[1936] = 116094;
        nArray2[1937] = 116098;
        nArray2[1938] = 116100;
        nArray2[1939] = 116104;
        nArray2[1940] = 116112;
        nArray2[1941] = 116126;
        nArray2[1942] = 116128;
        nArray2[1943] = 116156;
        nArray2[1944] = 116166;
        nArray2[1945] = 116172;
        nArray2[1946] = 116184;
        nArray2[1947] = 116206;
        nArray2[1948] = 116210;
        nArray2[1949] = 116212;
        nArray2[1950] = 116246;
        nArray2[1951] = 116262;
        nArray2[1952] = 116268;
        nArray2[1953] = 116282;
        nArray2[1954] = 116294;
        nArray2[1955] = 116300;
        nArray2[1956] = 116312;
        nArray2[1957] = 116334;
        nArray2[1958] = 116338;
        nArray2[1959] = 116340;
        nArray2[1960] = 116358;
        nArray2[1961] = 116364;
        nArray2[1962] = 116376;
        nArray2[1963] = 116400;
        nArray2[1964] = 116414;
        nArray2[1965] = 116430;
        nArray2[1966] = 116444;
        nArray2[1967] = 116450;
        nArray2[1968] = 116452;
        nArray2[1969] = 116456;
        nArray2[1970] = 116498;
        nArray2[1971] = 116500;
        nArray2[1972] = 116514;
        nArray2[1973] = 116520;
        nArray2[1974] = 116534;
        nArray2[1975] = 116546;
        nArray2[1976] = 116548;
        nArray2[1977] = 116552;
        nArray2[1978] = 116560;
        nArray2[1979] = 116574;
        nArray2[1980] = 116582;
        nArray2[1981] = 116588;
        nArray2[1982] = 116602;
        nArray2[1983] = 116654;
        nArray2[1984] = 116694;
        nArray2[1985] = 116714;
        nArray2[1986] = 116762;
        nArray2[1987] = 116782;
        nArray2[1988] = 116786;
        nArray2[1989] = 116788;
        nArray2[1990] = 116814;
        nArray2[1991] = 116828;
        nArray2[1992] = 116834;
        nArray2[1993] = 116836;
        nArray2[1994] = 116840;
        nArray2[1995] = 116854;
        nArray2[1996] = 116878;
        nArray2[1997] = 116892;
        nArray2[1998] = 116920;
        nArray2[1999] = 116930;
        nArray2[2000] = 116936;
        nArray2[2001] = 116944;
        nArray2[2002] = 116958;
        nArray2[2003] = 116966;
        nArray2[2004] = 116972;
        nArray2[2005] = 116986;
        nArray2[2006] = 117006;
        nArray2[2007] = 117048;
        nArray2[2008] = 117104;
        nArray2[2009] = 117118;
        nArray2[2010] = 117122;
        nArray2[2011] = 117124;
        nArray2[2012] = 117136;
        nArray2[2013] = 117150;
        nArray2[2014] = 117152;
        nArray2[2015] = 117180;
        nArray2[2016] = 117190;
        nArray2[2017] = 117196;
        nArray2[2018] = 117208;
        nArray2[2019] = 117230;
        nArray2[2020] = 117234;
        nArray2[2021] = 117236;
        nArray2[2022] = 117304;
        nArray2[2023] = 117360;
        nArray2[2024] = 117374;
        nArray2[2025] = 117472;
        nArray2[2026] = 117500;
        nArray2[2027] = 117506;
        nArray2[2028] = 117508;
        nArray2[2029] = 117512;
        nArray2[2030] = 117520;
        nArray2[2031] = 117536;
        nArray2[2032] = 117564;
        nArray2[2033] = 117568;
        nArray2[2034] = 117624;
        nArray2[2035] = 117638;
        nArray2[2036] = 117644;
        nArray2[2037] = 117656;
        nArray2[2038] = 117680;
        nArray2[2039] = 117694;
        nArray2[2040] = 117710;
        nArray2[2041] = 117724;
        nArray2[2042] = 117730;
        nArray2[2043] = 117732;
        nArray2[2044] = 117736;
        nArray2[2045] = 117750;
        nArray2[2046] = 117782;
        nArray2[2047] = 117798;
        nArray2[2048] = 117804;
        nArray2[2049] = 117818;
        nArray2[2050] = 117830;
        nArray2[2051] = 117848;
        nArray2[2052] = 117874;
        nArray2[2053] = 117876;
        nArray2[2054] = 117894;
        nArray2[2055] = 117936;
        nArray2[2056] = 117950;
        nArray2[2057] = 117966;
        nArray2[2058] = 117986;
        nArray2[2059] = 117988;
        nArray2[2060] = 117992;
        nArray2[2061] = 118022;
        nArray2[2062] = 118028;
        nArray2[2063] = 118040;
        nArray2[2064] = 118064;
        nArray2[2065] = 118078;
        nArray2[2066] = 118112;
        nArray2[2067] = 118140;
        nArray2[2068] = 118172;
        nArray2[2069] = 118210;
        nArray2[2070] = 118212;
        nArray2[2071] = 118216;
        nArray2[2072] = 118224;
        nArray2[2073] = 118238;
        nArray2[2074] = 118246;
        nArray2[2075] = 118266;
        nArray2[2076] = 118306;
        nArray2[2077] = 118312;
        nArray2[2078] = 118338;
        nArray2[2079] = 118352;
        nArray2[2080] = 118366;
        nArray2[2081] = 118374;
        nArray2[2082] = 118394;
        nArray2[2083] = 118402;
        nArray2[2084] = 118404;
        nArray2[2085] = 118408;
        nArray2[2086] = 118416;
        nArray2[2087] = 118430;
        nArray2[2088] = 118432;
        nArray2[2089] = 118460;
        nArray2[2090] = 118476;
        nArray2[2091] = 118514;
        nArray2[2092] = 118516;
        nArray2[2093] = 118574;
        nArray2[2094] = 118578;
        nArray2[2095] = 118580;
        nArray2[2096] = 118606;
        nArray2[2097] = 118620;
        nArray2[2098] = 118626;
        nArray2[2099] = 118628;
        nArray2[2100] = 118632;
        nArray2[2101] = 118678;
        nArray2[2102] = 118694;
        nArray2[2103] = 118700;
        nArray2[2104] = 118730;
        nArray2[2105] = 118738;
        nArray2[2106] = 118740;
        nArray2[2107] = 118830;
        nArray2[2108] = 118834;
        nArray2[2109] = 118836;
        nArray2[2110] = 118862;
        nArray2[2111] = 118876;
        nArray2[2112] = 118882;
        nArray2[2113] = 118884;
        nArray2[2114] = 118888;
        nArray2[2115] = 118902;
        nArray2[2116] = 118926;
        nArray2[2117] = 118940;
        nArray2[2118] = 118968;
        nArray2[2119] = 118978;
        nArray2[2120] = 118980;
        nArray2[2121] = 118984;
        nArray2[2122] = 118992;
        nArray2[2123] = 119006;
        nArray2[2124] = 119014;
        nArray2[2125] = 119020;
        nArray2[2126] = 119034;
        nArray2[2127] = 119068;
        nArray2[2128] = 119096;
        nArray2[2129] = 119152;
        nArray2[2130] = 119166;
        nArray2[2131] = 119170;
        nArray2[2132] = 119172;
        nArray2[2133] = 119176;
        nArray2[2134] = 119184;
        nArray2[2135] = 119198;
        nArray2[2136] = 119200;
        nArray2[2137] = 119228;
        nArray2[2138] = 119238;
        nArray2[2139] = 119244;
        nArray2[2140] = 119256;
        nArray2[2141] = 119278;
        nArray2[2142] = 119282;
        nArray2[2143] = 119284;
        nArray2[2144] = 119324;
        nArray2[2145] = 119352;
        nArray2[2146] = 119408;
        nArray2[2147] = 119422;
        nArray2[2148] = 119520;
        nArray2[2149] = 119548;
        nArray2[2150] = 119554;
        nArray2[2151] = 119556;
        nArray2[2152] = 119560;
        nArray2[2153] = 119568;
        nArray2[2154] = 119582;
        nArray2[2155] = 119584;
        nArray2[2156] = 119612;
        nArray2[2157] = 119616;
        nArray2[2158] = 119672;
        nArray2[2159] = 119686;
        nArray2[2160] = 119692;
        nArray2[2161] = 119704;
        nArray2[2162] = 119728;
        nArray2[2163] = 119742;
        nArray2[2164] = 119758;
        nArray2[2165] = 119772;
        nArray2[2166] = 119778;
        nArray2[2167] = 119780;
        nArray2[2168] = 119784;
        nArray2[2169] = 119798;
        nArray2[2170] = 119920;
        nArray2[2171] = 119934;
        nArray2[2172] = 120032;
        nArray2[2173] = 120060;
        nArray2[2174] = 120256;
        nArray2[2175] = 120312;
        nArray2[2176] = 120324;
        nArray2[2177] = 120328;
        nArray2[2178] = 120336;
        nArray2[2179] = 120352;
        nArray2[2180] = 120384;
        nArray2[2181] = 120440;
        nArray2[2182] = 120560;
        nArray2[2183] = 120582;
        nArray2[2184] = 120588;
        nArray2[2185] = 120600;
        nArray2[2186] = 120624;
        nArray2[2187] = 120638;
        nArray2[2188] = 120672;
        nArray2[2189] = 120700;
        nArray2[2190] = 120718;
        nArray2[2191] = 120732;
        nArray2[2192] = 120760;
        nArray2[2193] = 120770;
        nArray2[2194] = 120772;
        nArray2[2195] = 120776;
        nArray2[2196] = 120784;
        nArray2[2197] = 120798;
        nArray2[2198] = 120806;
        nArray2[2199] = 120812;
        nArray2[2200] = 120870;
        nArray2[2201] = 120876;
        nArray2[2202] = 120890;
        nArray2[2203] = 120902;
        nArray2[2204] = 120908;
        nArray2[2205] = 120920;
        nArray2[2206] = 120946;
        nArray2[2207] = 120948;
        nArray2[2208] = 120966;
        nArray2[2209] = 120972;
        nArray2[2210] = 120984;
        nArray2[2211] = 121008;
        nArray2[2212] = 121022;
        nArray2[2213] = 121038;
        nArray2[2214] = 121058;
        nArray2[2215] = 121060;
        nArray2[2216] = 121064;
        nArray2[2217] = 121078;
        nArray2[2218] = 121100;
        nArray2[2219] = 121112;
        nArray2[2220] = 121136;
        nArray2[2221] = 121150;
        nArray2[2222] = 121184;
        nArray2[2223] = 121212;
        nArray2[2224] = 121244;
        nArray2[2225] = 121282;
        nArray2[2226] = 121284;
        nArray2[2227] = 121288;
        nArray2[2228] = 121296;
        nArray2[2229] = 121318;
        nArray2[2230] = 121338;
        nArray2[2231] = 121356;
        nArray2[2232] = 121368;
        nArray2[2233] = 121392;
        nArray2[2234] = 121406;
        nArray2[2235] = 121440;
        nArray2[2236] = 121468;
        nArray2[2237] = 121536;
        nArray2[2238] = 121592;
        nArray2[2239] = 121656;
        nArray2[2240] = 121730;
        nArray2[2241] = 121732;
        nArray2[2242] = 121736;
        nArray2[2243] = 121744;
        nArray2[2244] = 121758;
        nArray2[2245] = 121760;
        nArray2[2246] = 121804;
        nArray2[2247] = 121842;
        nArray2[2248] = 121844;
        nArray2[2249] = 121890;
        nArray2[2250] = 121922;
        nArray2[2251] = 121924;
        nArray2[2252] = 121928;
        nArray2[2253] = 121936;
        nArray2[2254] = 121950;
        nArray2[2255] = 121958;
        nArray2[2256] = 121978;
        nArray2[2257] = 121986;
        nArray2[2258] = 121988;
        nArray2[2259] = 121992;
        nArray2[2260] = 122000;
        nArray2[2261] = 122014;
        nArray2[2262] = 122016;
        nArray2[2263] = 122044;
        nArray2[2264] = 122060;
        nArray2[2265] = 122098;
        nArray2[2266] = 122100;
        nArray2[2267] = 122116;
        nArray2[2268] = 122120;
        nArray2[2269] = 122128;
        nArray2[2270] = 122142;
        nArray2[2271] = 122144;
        nArray2[2272] = 122172;
        nArray2[2273] = 122176;
        nArray2[2274] = 122232;
        nArray2[2275] = 122246;
        nArray2[2276] = 122264;
        nArray2[2277] = 122318;
        nArray2[2278] = 122338;
        nArray2[2279] = 122340;
        nArray2[2280] = 122344;
        nArray2[2281] = 122414;
        nArray2[2282] = 122418;
        nArray2[2283] = 122420;
        nArray2[2284] = 122446;
        nArray2[2285] = 122460;
        nArray2[2286] = 122466;
        nArray2[2287] = 122468;
        nArray2[2288] = 122472;
        nArray2[2289] = 122510;
        nArray2[2290] = 122524;
        nArray2[2291] = 122552;
        nArray2[2292] = 122562;
        nArray2[2293] = 122564;
        nArray2[2294] = 122568;
        nArray2[2295] = 122576;
        nArray2[2296] = 122598;
        nArray2[2297] = 122618;
        nArray2[2298] = 122646;
        nArray2[2299] = 122662;
        nArray2[2300] = 122668;
        nArray2[2301] = 122694;
        nArray2[2302] = 122700;
        nArray2[2303] = 122712;
        nArray2[2304] = 122738;
        nArray2[2305] = 122740;
        nArray2[2306] = 122762;
        nArray2[2307] = 122770;
        nArray2[2308] = 122772;
        nArray2[2309] = 122786;
        nArray2[2310] = 122788;
        nArray2[2311] = 122792;
        nArray2[2312] = 123018;
        nArray2[2313] = 123026;
        nArray2[2314] = 123028;
        nArray2[2315] = 123042;
        nArray2[2316] = 123044;
        nArray2[2317] = 123048;
        nArray2[2318] = 123062;
        nArray2[2319] = 123098;
        nArray2[2320] = 123146;
        nArray2[2321] = 123154;
        nArray2[2322] = 123156;
        nArray2[2323] = 123170;
        nArray2[2324] = 123172;
        nArray2[2325] = 123176;
        nArray2[2326] = 123190;
        nArray2[2327] = 123202;
        nArray2[2328] = 123204;
        nArray2[2329] = 123208;
        nArray2[2330] = 123216;
        nArray2[2331] = 123238;
        nArray2[2332] = 123244;
        nArray2[2333] = 123258;
        nArray2[2334] = 123290;
        nArray2[2335] = 123314;
        nArray2[2336] = 123316;
        nArray2[2337] = 123402;
        nArray2[2338] = 123410;
        nArray2[2339] = 123412;
        nArray2[2340] = 123426;
        nArray2[2341] = 123428;
        nArray2[2342] = 123432;
        nArray2[2343] = 123446;
        nArray2[2344] = 123458;
        nArray2[2345] = 123464;
        nArray2[2346] = 123472;
        nArray2[2347] = 123486;
        nArray2[2348] = 123494;
        nArray2[2349] = 123500;
        nArray2[2350] = 123514;
        nArray2[2351] = 123522;
        nArray2[2352] = 123524;
        nArray2[2353] = 123528;
        nArray2[2354] = 123536;
        nArray2[2355] = 123552;
        nArray2[2356] = 123580;
        nArray2[2357] = 123590;
        nArray2[2358] = 123596;
        nArray2[2359] = 123608;
        nArray2[2360] = 123630;
        nArray2[2361] = 123634;
        nArray2[2362] = 123636;
        nArray2[2363] = 123674;
        nArray2[2364] = 123698;
        nArray2[2365] = 123700;
        nArray2[2366] = 123740;
        nArray2[2367] = 123746;
        nArray2[2368] = 123748;
        nArray2[2369] = 123752;
        nArray2[2370] = 123834;
        nArray2[2371] = 123914;
        nArray2[2372] = 123922;
        nArray2[2373] = 123924;
        nArray2[2374] = 123938;
        nArray2[2375] = 123944;
        nArray2[2376] = 123958;
        nArray2[2377] = 123970;
        nArray2[2378] = 123976;
        nArray2[2379] = 123984;
        nArray2[2380] = 123998;
        nArray2[2381] = 124006;
        nArray2[2382] = 124012;
        nArray2[2383] = 124026;
        nArray2[2384] = 124034;
        nArray2[2385] = 124036;
        nArray2[2386] = 124048;
        nArray2[2387] = 124062;
        nArray2[2388] = 124064;
        nArray2[2389] = 124092;
        nArray2[2390] = 124102;
        nArray2[2391] = 124108;
        nArray2[2392] = 124120;
        nArray2[2393] = 124142;
        nArray2[2394] = 124146;
        nArray2[2395] = 124148;
        nArray2[2396] = 124162;
        nArray2[2397] = 124164;
        nArray2[2398] = 124168;
        nArray2[2399] = 124176;
        nArray2[2400] = 124190;
        nArray2[2401] = 124192;
        nArray2[2402] = 124220;
        nArray2[2403] = 124224;
        nArray2[2404] = 124280;
        nArray2[2405] = 124294;
        nArray2[2406] = 124300;
        nArray2[2407] = 124312;
        nArray2[2408] = 124336;
        nArray2[2409] = 124350;
        nArray2[2410] = 124366;
        nArray2[2411] = 124380;
        nArray2[2412] = 124386;
        nArray2[2413] = 124388;
        nArray2[2414] = 124392;
        nArray2[2415] = 124406;
        nArray2[2416] = 124442;
        nArray2[2417] = 124462;
        nArray2[2418] = 124466;
        nArray2[2419] = 124468;
        nArray2[2420] = 124494;
        nArray2[2421] = 124508;
        nArray2[2422] = 124514;
        nArray2[2423] = 124520;
        nArray2[2424] = 124558;
        nArray2[2425] = 124572;
        nArray2[2426] = 124600;
        nArray2[2427] = 124610;
        nArray2[2428] = 124612;
        nArray2[2429] = 124616;
        nArray2[2430] = 124624;
        nArray2[2431] = 124646;
        nArray2[2432] = 124666;
        nArray2[2433] = 124694;
        nArray2[2434] = 124710;
        nArray2[2435] = 124716;
        nArray2[2436] = 124730;
        nArray2[2437] = 124742;
        nArray2[2438] = 124748;
        nArray2[2439] = 124760;
        nArray2[2440] = 124786;
        nArray2[2441] = 124788;
        nArray2[2442] = 124818;
        nArray2[2443] = 124820;
        nArray2[2444] = 124834;
        nArray2[2445] = 124836;
        nArray2[2446] = 124840;
        nArray2[2447] = 124854;
        nArray2[2448] = 124946;
        nArray2[2449] = 124948;
        nArray2[2450] = 124962;
        nArray2[2451] = 124964;
        nArray2[2452] = 124968;
        nArray2[2453] = 124982;
        nArray2[2454] = 124994;
        nArray2[2455] = 124996;
        nArray2[2456] = 125000;
        nArray2[2457] = 125008;
        nArray2[2458] = 125022;
        nArray2[2459] = 125030;
        nArray2[2460] = 125036;
        nArray2[2461] = 125050;
        nArray2[2462] = 125058;
        nArray2[2463] = 125060;
        nArray2[2464] = 125064;
        nArray2[2465] = 125072;
        nArray2[2466] = 125086;
        nArray2[2467] = 125088;
        nArray2[2468] = 125116;
        nArray2[2469] = 125126;
        nArray2[2470] = 125132;
        nArray2[2471] = 125144;
        nArray2[2472] = 125166;
        nArray2[2473] = 125170;
        nArray2[2474] = 125172;
        nArray2[2475] = 125186;
        nArray2[2476] = 125188;
        nArray2[2477] = 125192;
        nArray2[2478] = 125200;
        nArray2[2479] = 125216;
        nArray2[2480] = 125244;
        nArray2[2481] = 125248;
        nArray2[2482] = 125304;
        nArray2[2483] = 125318;
        nArray2[2484] = 125324;
        nArray2[2485] = 125336;
        nArray2[2486] = 125360;
        nArray2[2487] = 125374;
        nArray2[2488] = 125390;
        nArray2[2489] = 125404;
        nArray2[2490] = 125410;
        nArray2[2491] = 125412;
        nArray2[2492] = 125416;
        nArray2[2493] = 125430;
        nArray2[2494] = 125444;
        nArray2[2495] = 125448;
        nArray2[2496] = 125456;
        nArray2[2497] = 125472;
        nArray2[2498] = 125504;
        nArray2[2499] = 125560;
        nArray2[2500] = 125680;
        nArray2[2501] = 125702;
        nArray2[2502] = 125708;
        nArray2[2503] = 125720;
        nArray2[2504] = 125744;
        nArray2[2505] = 125758;
        nArray2[2506] = 125792;
        nArray2[2507] = 125820;
        nArray2[2508] = 125838;
        nArray2[2509] = 125852;
        nArray2[2510] = 125880;
        nArray2[2511] = 125890;
        nArray2[2512] = 125892;
        nArray2[2513] = 125896;
        nArray2[2514] = 125904;
        nArray2[2515] = 125918;
        nArray2[2516] = 125926;
        nArray2[2517] = 125932;
        nArray2[2518] = 125978;
        nArray2[2519] = 125998;
        nArray2[2520] = 126002;
        nArray2[2521] = 126004;
        nArray2[2522] = 126030;
        nArray2[2523] = 126044;
        nArray2[2524] = 126050;
        nArray2[2525] = 126052;
        nArray2[2526] = 126056;
        nArray2[2527] = 126094;
        nArray2[2528] = 126108;
        nArray2[2529] = 126136;
        nArray2[2530] = 126146;
        nArray2[2531] = 126148;
        nArray2[2532] = 126152;
        nArray2[2533] = 126160;
        nArray2[2534] = 126182;
        nArray2[2535] = 126202;
        nArray2[2536] = 126222;
        nArray2[2537] = 126236;
        nArray2[2538] = 126264;
        nArray2[2539] = 126320;
        nArray2[2540] = 126334;
        nArray2[2541] = 126338;
        nArray2[2542] = 126340;
        nArray2[2543] = 126344;
        nArray2[2544] = 126352;
        nArray2[2545] = 126366;
        nArray2[2546] = 126368;
        nArray2[2547] = 126412;
        nArray2[2548] = 126450;
        nArray2[2549] = 126452;
        nArray2[2550] = 126486;
        nArray2[2551] = 126502;
        nArray2[2552] = 126508;
        nArray2[2553] = 126522;
        nArray2[2554] = 126534;
        nArray2[2555] = 126540;
        nArray2[2556] = 126552;
        nArray2[2557] = 126574;
        nArray2[2558] = 126578;
        nArray2[2559] = 126580;
        nArray2[2560] = 126598;
        nArray2[2561] = 126604;
        nArray2[2562] = 126616;
        nArray2[2563] = 126640;
        nArray2[2564] = 126654;
        nArray2[2565] = 126670;
        nArray2[2566] = 126684;
        nArray2[2567] = 126690;
        nArray2[2568] = 126692;
        nArray2[2569] = 126696;
        nArray2[2570] = 126738;
        nArray2[2571] = 126754;
        nArray2[2572] = 126756;
        nArray2[2573] = 126760;
        nArray2[2574] = 126774;
        nArray2[2575] = 126786;
        nArray2[2576] = 126788;
        nArray2[2577] = 126792;
        nArray2[2578] = 126800;
        nArray2[2579] = 126814;
        nArray2[2580] = 126822;
        nArray2[2581] = 126828;
        nArray2[2582] = 126842;
        nArray2[2583] = 126894;
        nArray2[2584] = 126898;
        nArray2[2585] = 126900;
        nArray2[2586] = 126934;
        nArray2[2587] = 127126;
        nArray2[2588] = 127142;
        nArray2[2589] = 127148;
        nArray2[2590] = 127162;
        nArray2[2591] = 127178;
        nArray2[2592] = 127186;
        nArray2[2593] = 127188;
        nArray2[2594] = 127254;
        nArray2[2595] = 127270;
        nArray2[2596] = 127276;
        nArray2[2597] = 127290;
        nArray2[2598] = 127302;
        nArray2[2599] = 127308;
        nArray2[2600] = 127320;
        nArray2[2601] = 127342;
        nArray2[2602] = 127346;
        nArray2[2603] = 127348;
        nArray2[2604] = 127370;
        nArray2[2605] = 127378;
        nArray2[2606] = 127380;
        nArray2[2607] = 127394;
        nArray2[2608] = 127396;
        nArray2[2609] = 127400;
        nArray2[2610] = 127450;
        nArray2[2611] = 127510;
        nArray2[2612] = 127526;
        nArray2[2613] = 127532;
        nArray2[2614] = 127546;
        nArray2[2615] = 127558;
        nArray2[2616] = 127576;
        nArray2[2617] = 127598;
        nArray2[2618] = 127602;
        nArray2[2619] = 127604;
        nArray2[2620] = 127622;
        nArray2[2621] = 127628;
        nArray2[2622] = 127640;
        nArray2[2623] = 127664;
        nArray2[2624] = 127678;
        nArray2[2625] = 127694;
        nArray2[2626] = 127708;
        nArray2[2627] = 127714;
        nArray2[2628] = 127716;
        nArray2[2629] = 127720;
        nArray2[2630] = 127734;
        nArray2[2631] = 127754;
        nArray2[2632] = 127762;
        nArray2[2633] = 127764;
        nArray2[2634] = 127778;
        nArray2[2635] = 127784;
        nArray2[2636] = 127810;
        nArray2[2637] = 127812;
        nArray2[2638] = 127816;
        nArray2[2639] = 127824;
        nArray2[2640] = 127838;
        nArray2[2641] = 127846;
        nArray2[2642] = 127866;
        nArray2[2643] = 127898;
        nArray2[2644] = 127918;
        nArray2[2645] = 127922;
        nArray2[2646] = 127924;
        nArray2[2647] = 128022;
        nArray2[2648] = 128038;
        nArray2[2649] = 128044;
        nArray2[2650] = 128058;
        nArray2[2651] = 128070;
        nArray2[2652] = 128076;
        nArray2[2653] = 128088;
        nArray2[2654] = 128110;
        nArray2[2655] = 128114;
        nArray2[2656] = 128116;
        nArray2[2657] = 128134;
        nArray2[2658] = 128140;
        nArray2[2659] = 128152;
        nArray2[2660] = 128176;
        nArray2[2661] = 128190;
        nArray2[2662] = 128206;
        nArray2[2663] = 128220;
        nArray2[2664] = 128226;
        nArray2[2665] = 128228;
        nArray2[2666] = 128232;
        nArray2[2667] = 128246;
        nArray2[2668] = 128262;
        nArray2[2669] = 128268;
        nArray2[2670] = 128280;
        nArray2[2671] = 128304;
        nArray2[2672] = 128318;
        nArray2[2673] = 128352;
        nArray2[2674] = 128380;
        nArray2[2675] = 128398;
        nArray2[2676] = 128412;
        nArray2[2677] = 128440;
        nArray2[2678] = 128450;
        nArray2[2679] = 128452;
        nArray2[2680] = 128456;
        nArray2[2681] = 128464;
        nArray2[2682] = 128478;
        nArray2[2683] = 128486;
        nArray2[2684] = 128492;
        nArray2[2685] = 128506;
        nArray2[2686] = 128522;
        nArray2[2687] = 128530;
        nArray2[2688] = 128532;
        nArray2[2689] = 128546;
        nArray2[2690] = 128548;
        nArray2[2691] = 128552;
        nArray2[2692] = 128566;
        nArray2[2693] = 128578;
        nArray2[2694] = 128580;
        nArray2[2695] = 128584;
        nArray2[2696] = 128592;
        nArray2[2697] = 128606;
        nArray2[2698] = 128614;
        nArray2[2699] = 128634;
        nArray2[2700] = 128642;
        nArray2[2701] = 128644;
        nArray2[2702] = 128648;
        nArray2[2703] = 128656;
        nArray2[2704] = 128670;
        nArray2[2705] = 128672;
        nArray2[2706] = 128700;
        nArray2[2707] = 128716;
        nArray2[2708] = 128754;
        nArray2[2709] = 128756;
        nArray2[2710] = 128794;
        nArray2[2711] = 128814;
        nArray2[2712] = 128818;
        nArray2[2713] = 128820;
        nArray2[2714] = 128846;
        nArray2[2715] = 128860;
        nArray2[2716] = 128866;
        nArray2[2717] = 128868;
        nArray2[2718] = 128872;
        nArray2[2719] = 128886;
        nArray2[2720] = 128918;
        nArray2[2721] = 128934;
        nArray2[2722] = 128940;
        nArray2[2723] = 128954;
        nArray2[2724] = 128978;
        nArray2[2725] = 128980;
        nArray2[2726] = 129178;
        nArray2[2727] = 129198;
        nArray2[2728] = 129202;
        nArray2[2729] = 129204;
        nArray2[2730] = 129238;
        nArray2[2731] = 129258;
        nArray2[2732] = 129306;
        nArray2[2733] = 129326;
        nArray2[2734] = 129330;
        nArray2[2735] = 129332;
        nArray2[2736] = 129358;
        nArray2[2737] = 129372;
        nArray2[2738] = 129378;
        nArray2[2739] = 129380;
        nArray2[2740] = 129384;
        nArray2[2741] = 129398;
        nArray2[2742] = 129430;
        nArray2[2743] = 129446;
        nArray2[2744] = 129452;
        nArray2[2745] = 129466;
        nArray2[2746] = 129482;
        nArray2[2747] = 129490;
        nArray2[2748] = 129492;
        nArray2[2749] = 129562;
        nArray2[2750] = 129582;
        nArray2[2751] = 129586;
        nArray2[2752] = 129588;
        nArray2[2753] = 129614;
        nArray2[2754] = 129628;
        nArray2[2755] = 129634;
        nArray2[2756] = 129636;
        nArray2[2757] = 129640;
        nArray2[2758] = 129654;
        nArray2[2759] = 129678;
        nArray2[2760] = 129692;
        nArray2[2761] = 129720;
        nArray2[2762] = 129730;
        nArray2[2763] = 129732;
        nArray2[2764] = 129736;
        nArray2[2765] = 129744;
        nArray2[2766] = 129758;
        nArray2[2767] = 129766;
        nArray2[2768] = 129772;
        nArray2[2769] = 129814;
        nArray2[2770] = 129830;
        nArray2[2771] = 129836;
        nArray2[2772] = 129850;
        nArray2[2773] = 129862;
        nArray2[2774] = 129868;
        nArray2[2775] = 129880;
        nArray2[2776] = 129902;
        nArray2[2777] = 129906;
        nArray2[2778] = 129908;
        nArray2[2779] = 129930;
        nArray2[2780] = 129938;
        nArray2[2781] = 129940;
        nArray2[2782] = 129954;
        nArray2[2783] = 129956;
        nArray2[2784] = 129960;
        nArray2[2785] = 129974;
        nArray2[2786] = 130010;
        SYMBOL_TABLE = nArray2;
        int[] nArray3 = new int[2787];
        nArray2 = nArray3;
        nArray3[0] = 2627;
        nArray2[1] = 1819;
        nArray2[2] = 2622;
        nArray2[3] = 2621;
        nArray2[4] = 1813;
        nArray2[5] = 1812;
        nArray2[6] = 2729;
        nArray2[7] = 2724;
        nArray2[8] = 2723;
        nArray2[9] = 2779;
        nArray2[10] = 2774;
        nArray2[11] = 2773;
        nArray2[12] = 902;
        nArray2[13] = 896;
        nArray2[14] = 908;
        nArray2[15] = 868;
        nArray2[16] = 865;
        nArray2[17] = 861;
        nArray2[18] = 859;
        nArray2[19] = 2511;
        nArray2[20] = 873;
        nArray2[21] = 871;
        nArray2[22] = 1780;
        nArray2[23] = 835;
        nArray2[24] = 2493;
        nArray2[25] = 825;
        nArray2[26] = 2491;
        nArray2[27] = 842;
        nArray2[28] = 837;
        nArray2[29] = 844;
        nArray2[30] = 1764;
        nArray2[31] = 1762;
        nArray2[32] = 811;
        nArray2[33] = 810;
        nArray2[34] = 809;
        nArray2[35] = 2483;
        nArray2[36] = 807;
        nArray2[37] = 2482;
        nArray2[38] = 806;
        nArray2[39] = 2480;
        nArray2[40] = 815;
        nArray2[41] = 814;
        nArray2[42] = 813;
        nArray2[43] = 812;
        nArray2[44] = 2484;
        nArray2[45] = 817;
        nArray2[46] = 816;
        nArray2[47] = 1745;
        nArray2[48] = 1744;
        nArray2[49] = 1742;
        nArray2[50] = 1746;
        nArray2[51] = 2655;
        nArray2[52] = 2637;
        nArray2[53] = 2635;
        nArray2[54] = 2626;
        nArray2[55] = 2625;
        nArray2[56] = 2623;
        nArray2[57] = 2628;
        nArray2[58] = 1820;
        nArray2[59] = 2752;
        nArray2[60] = 2739;
        nArray2[61] = 2737;
        nArray2[62] = 2728;
        nArray2[63] = 2727;
        nArray2[64] = 2725;
        nArray2[65] = 2730;
        nArray2[66] = 2785;
        nArray2[67] = 2783;
        nArray2[68] = 2778;
        nArray2[69] = 2777;
        nArray2[70] = 2775;
        nArray2[71] = 2780;
        nArray2[72] = 787;
        nArray2[73] = 781;
        nArray2[74] = 747;
        nArray2[75] = 739;
        nArray2[76] = 736;
        nArray2[77] = 2413;
        nArray2[78] = 754;
        nArray2[79] = 752;
        nArray2[80] = 1719;
        nArray2[81] = 692;
        nArray2[82] = 689;
        nArray2[83] = 681;
        nArray2[84] = 2371;
        nArray2[85] = 678;
        nArray2[86] = 2369;
        nArray2[87] = 700;
        nArray2[88] = 697;
        nArray2[89] = 694;
        nArray2[90] = 703;
        nArray2[91] = 1688;
        nArray2[92] = 1686;
        nArray2[93] = 642;
        nArray2[94] = 638;
        nArray2[95] = 2343;
        nArray2[96] = 631;
        nArray2[97] = 2341;
        nArray2[98] = 627;
        nArray2[99] = 2338;
        nArray2[100] = 651;
        nArray2[101] = 646;
        nArray2[102] = 643;
        nArray2[103] = 2345;
        nArray2[104] = 654;
        nArray2[105] = 652;
        nArray2[106] = 1652;
        nArray2[107] = 1650;
        nArray2[108] = 1647;
        nArray2[109] = 1654;
        nArray2[110] = 601;
        nArray2[111] = 599;
        nArray2[112] = 2322;
        nArray2[113] = 596;
        nArray2[114] = 2321;
        nArray2[115] = 594;
        nArray2[116] = 2319;
        nArray2[117] = 2317;
        nArray2[118] = 611;
        nArray2[119] = 610;
        nArray2[120] = 608;
        nArray2[121] = 606;
        nArray2[122] = 2324;
        nArray2[123] = 603;
        nArray2[124] = 2323;
        nArray2[125] = 615;
        nArray2[126] = 614;
        nArray2[127] = 612;
        nArray2[128] = 1617;
        nArray2[129] = 1616;
        nArray2[130] = 1614;
        nArray2[131] = 1612;
        nArray2[132] = 616;
        nArray2[133] = 1619;
        nArray2[134] = 1618;
        nArray2[135] = 2575;
        nArray2[136] = 2538;
        nArray2[137] = 2536;
        nArray2[138] = 905;
        nArray2[139] = 901;
        nArray2[140] = 898;
        nArray2[141] = 909;
        nArray2[142] = 2509;
        nArray2[143] = 2507;
        nArray2[144] = 2504;
        nArray2[145] = 870;
        nArray2[146] = 867;
        nArray2[147] = 864;
        nArray2[148] = 860;
        nArray2[149] = 2512;
        nArray2[150] = 875;
        nArray2[151] = 872;
        nArray2[152] = 1781;
        nArray2[153] = 2490;
        nArray2[154] = 2489;
        nArray2[155] = 2487;
        nArray2[156] = 2485;
        nArray2[157] = 1748;
        nArray2[158] = 836;
        nArray2[159] = 834;
        nArray2[160] = 832;
        nArray2[161] = 830;
        nArray2[162] = 2494;
        nArray2[163] = 827;
        nArray2[164] = 2492;
        nArray2[165] = 843;
        nArray2[166] = 841;
        nArray2[167] = 839;
        nArray2[168] = 845;
        nArray2[169] = 1765;
        nArray2[170] = 1763;
        nArray2[171] = 2701;
        nArray2[172] = 2676;
        nArray2[173] = 2674;
        nArray2[174] = 2653;
        nArray2[175] = 2648;
        nArray2[176] = 2656;
        nArray2[177] = 2634;
        nArray2[178] = 2633;
        nArray2[179] = 2631;
        nArray2[180] = 2629;
        nArray2[181] = 1821;
        nArray2[182] = 2638;
        nArray2[183] = 2636;
        nArray2[184] = 2770;
        nArray2[185] = 2763;
        nArray2[186] = 2761;
        nArray2[187] = 2750;
        nArray2[188] = 2745;
        nArray2[189] = 2753;
        nArray2[190] = 2736;
        nArray2[191] = 2735;
        nArray2[192] = 2733;
        nArray2[193] = 2731;
        nArray2[194] = 1848;
        nArray2[195] = 2740;
        nArray2[196] = 2738;
        nArray2[197] = 2786;
        nArray2[198] = 2784;
        nArray2[199] = 591;
        nArray2[200] = 588;
        nArray2[201] = 576;
        nArray2[202] = 569;
        nArray2[203] = 566;
        nArray2[204] = 2296;
        nArray2[205] = 1590;
        nArray2[206] = 537;
        nArray2[207] = 534;
        nArray2[208] = 526;
        nArray2[209] = 2276;
        nArray2[210] = 522;
        nArray2[211] = 2274;
        nArray2[212] = 545;
        nArray2[213] = 542;
        nArray2[214] = 539;
        nArray2[215] = 548;
        nArray2[216] = 1572;
        nArray2[217] = 1570;
        nArray2[218] = 481;
        nArray2[219] = 2245;
        nArray2[220] = 466;
        nArray2[221] = 2242;
        nArray2[222] = 462;
        nArray2[223] = 2239;
        nArray2[224] = 492;
        nArray2[225] = 485;
        nArray2[226] = 482;
        nArray2[227] = 2249;
        nArray2[228] = 496;
        nArray2[229] = 494;
        nArray2[230] = 1534;
        nArray2[231] = 1531;
        nArray2[232] = 1528;
        nArray2[233] = 1538;
        nArray2[234] = 413;
        nArray2[235] = 2196;
        nArray2[236] = 406;
        nArray2[237] = 2191;
        nArray2[238] = 2188;
        nArray2[239] = 425;
        nArray2[240] = 419;
        nArray2[241] = 2202;
        nArray2[242] = 415;
        nArray2[243] = 2199;
        nArray2[244] = 432;
        nArray2[245] = 430;
        nArray2[246] = 427;
        nArray2[247] = 1472;
        nArray2[248] = 1467;
        nArray2[249] = 1464;
        nArray2[250] = 433;
        nArray2[251] = 1476;
        nArray2[252] = 1474;
        nArray2[253] = 368;
        nArray2[254] = 367;
        nArray2[255] = 2160;
        nArray2[256] = 365;
        nArray2[257] = 2159;
        nArray2[258] = 362;
        nArray2[259] = 2157;
        nArray2[260] = 2155;
        nArray2[261] = 2152;
        nArray2[262] = 378;
        nArray2[263] = 377;
        nArray2[264] = 375;
        nArray2[265] = 2166;
        nArray2[266] = 372;
        nArray2[267] = 2165;
        nArray2[268] = 369;
        nArray2[269] = 2162;
        nArray2[270] = 383;
        nArray2[271] = 381;
        nArray2[272] = 379;
        nArray2[273] = 2168;
        nArray2[274] = 1419;
        nArray2[275] = 1418;
        nArray2[276] = 1416;
        nArray2[277] = 1414;
        nArray2[278] = 385;
        nArray2[279] = 1411;
        nArray2[280] = 384;
        nArray2[281] = 1423;
        nArray2[282] = 1422;
        nArray2[283] = 1420;
        nArray2[284] = 1424;
        nArray2[285] = 2461;
        nArray2[286] = 802;
        nArray2[287] = 2441;
        nArray2[288] = 2439;
        nArray2[289] = 790;
        nArray2[290] = 786;
        nArray2[291] = 783;
        nArray2[292] = 794;
        nArray2[293] = 2409;
        nArray2[294] = 2406;
        nArray2[295] = 2403;
        nArray2[296] = 750;
        nArray2[297] = 742;
        nArray2[298] = 738;
        nArray2[299] = 2414;
        nArray2[300] = 756;
        nArray2[301] = 753;
        nArray2[302] = 1720;
        nArray2[303] = 2367;
        nArray2[304] = 2365;
        nArray2[305] = 2362;
        nArray2[306] = 2359;
        nArray2[307] = 1663;
        nArray2[308] = 693;
        nArray2[309] = 691;
        nArray2[310] = 684;
        nArray2[311] = 2373;
        nArray2[312] = 680;
        nArray2[313] = 2370;
        nArray2[314] = 702;
        nArray2[315] = 699;
        nArray2[316] = 696;
        nArray2[317] = 704;
        nArray2[318] = 1690;
        nArray2[319] = 1687;
        nArray2[320] = 2337;
        nArray2[321] = 2336;
        nArray2[322] = 2334;
        nArray2[323] = 2332;
        nArray2[324] = 1624;
        nArray2[325] = 2329;
        nArray2[326] = 1622;
        nArray2[327] = 640;
        nArray2[328] = 637;
        nArray2[329] = 2344;
        nArray2[330] = 634;
        nArray2[331] = 2342;
        nArray2[332] = 630;
        nArray2[333] = 2340;
        nArray2[334] = 650;
        nArray2[335] = 648;
        nArray2[336] = 645;
        nArray2[337] = 2346;
        nArray2[338] = 655;
        nArray2[339] = 653;
        nArray2[340] = 1653;
        nArray2[341] = 1651;
        nArray2[342] = 1649;
        nArray2[343] = 1655;
        nArray2[344] = 2612;
        nArray2[345] = 2597;
        nArray2[346] = 2595;
        nArray2[347] = 2571;
        nArray2[348] = 2568;
        nArray2[349] = 2565;
        nArray2[350] = 2576;
        nArray2[351] = 2534;
        nArray2[352] = 2529;
        nArray2[353] = 2526;
        nArray2[354] = 1787;
        nArray2[355] = 2540;
        nArray2[356] = 2537;
        nArray2[357] = 907;
        nArray2[358] = 904;
        nArray2[359] = 900;
        nArray2[360] = 910;
        nArray2[361] = 2503;
        nArray2[362] = 2502;
        nArray2[363] = 2500;
        nArray2[364] = 2498;
        nArray2[365] = 1768;
        nArray2[366] = 2495;
        nArray2[367] = 1767;
        nArray2[368] = 2510;
        nArray2[369] = 2508;
        nArray2[370] = 2506;
        nArray2[371] = 869;
        nArray2[372] = 866;
        nArray2[373] = 863;
        nArray2[374] = 2513;
        nArray2[375] = 876;
        nArray2[376] = 874;
        nArray2[377] = 1782;
        nArray2[378] = 2720;
        nArray2[379] = 2713;
        nArray2[380] = 2711;
        nArray2[381] = 2697;
        nArray2[382] = 2694;
        nArray2[383] = 2691;
        nArray2[384] = 2702;
        nArray2[385] = 2672;
        nArray2[386] = 2670;
        nArray2[387] = 2664;
        nArray2[388] = 1828;
        nArray2[389] = 2678;
        nArray2[390] = 2675;
        nArray2[391] = 2647;
        nArray2[392] = 2646;
        nArray2[393] = 2644;
        nArray2[394] = 2642;
        nArray2[395] = 1823;
        nArray2[396] = 2639;
        nArray2[397] = 1822;
        nArray2[398] = 2654;
        nArray2[399] = 2652;
        nArray2[400] = 2650;
        nArray2[401] = 2657;
        nArray2[402] = 2771;
        nArray2[403] = 1855;
        nArray2[404] = 2765;
        nArray2[405] = 2762;
        nArray2[406] = 1850;
        nArray2[407] = 1849;
        nArray2[408] = 2751;
        nArray2[409] = 2749;
        nArray2[410] = 2747;
        nArray2[411] = 2754;
        nArray2[412] = 353;
        nArray2[413] = 2148;
        nArray2[414] = 344;
        nArray2[415] = 342;
        nArray2[416] = 336;
        nArray2[417] = 2142;
        nArray2[418] = 332;
        nArray2[419] = 2140;
        nArray2[420] = 345;
        nArray2[421] = 1375;
        nArray2[422] = 1373;
        nArray2[423] = 306;
        nArray2[424] = 2130;
        nArray2[425] = 299;
        nArray2[426] = 2128;
        nArray2[427] = 295;
        nArray2[428] = 2125;
        nArray2[429] = 319;
        nArray2[430] = 314;
        nArray2[431] = 311;
        nArray2[432] = 2132;
        nArray2[433] = 1354;
        nArray2[434] = 1352;
        nArray2[435] = 1349;
        nArray2[436] = 1356;
        nArray2[437] = 262;
        nArray2[438] = 257;
        nArray2[439] = 2101;
        nArray2[440] = 253;
        nArray2[441] = 2096;
        nArray2[442] = 2093;
        nArray2[443] = 274;
        nArray2[444] = 273;
        nArray2[445] = 267;
        nArray2[446] = 2107;
        nArray2[447] = 263;
        nArray2[448] = 2104;
        nArray2[449] = 280;
        nArray2[450] = 278;
        nArray2[451] = 275;
        nArray2[452] = 1316;
        nArray2[453] = 1311;
        nArray2[454] = 1308;
        nArray2[455] = 1320;
        nArray2[456] = 1318;
        nArray2[457] = 2052;
        nArray2[458] = 202;
        nArray2[459] = 2050;
        nArray2[460] = 2044;
        nArray2[461] = 2040;
        nArray2[462] = 219;
        nArray2[463] = 2063;
        nArray2[464] = 212;
        nArray2[465] = 2060;
        nArray2[466] = 208;
        nArray2[467] = 2055;
        nArray2[468] = 224;
        nArray2[469] = 221;
        nArray2[470] = 2066;
        nArray2[471] = 1260;
        nArray2[472] = 1258;
        nArray2[473] = 1252;
        nArray2[474] = 231;
        nArray2[475] = 1248;
        nArray2[476] = 229;
        nArray2[477] = 1266;
        nArray2[478] = 1264;
        nArray2[479] = 1261;
        nArray2[480] = 1268;
        nArray2[481] = 155;
        nArray2[482] = 1998;
        nArray2[483] = 153;
        nArray2[484] = 1996;
        nArray2[485] = 1994;
        nArray2[486] = 1991;
        nArray2[487] = 1988;
        nArray2[488] = 165;
        nArray2[489] = 164;
        nArray2[490] = 2007;
        nArray2[491] = 162;
        nArray2[492] = 2006;
        nArray2[493] = 159;
        nArray2[494] = 2003;
        nArray2[495] = 2000;
        nArray2[496] = 172;
        nArray2[497] = 171;
        nArray2[498] = 169;
        nArray2[499] = 2012;
        nArray2[500] = 166;
        nArray2[501] = 2010;
        nArray2[502] = 1186;
        nArray2[503] = 1184;
        nArray2[504] = 1182;
        nArray2[505] = 1179;
        nArray2[506] = 175;
        nArray2[507] = 1176;
        nArray2[508] = 173;
        nArray2[509] = 1192;
        nArray2[510] = 1191;
        nArray2[511] = 1189;
        nArray2[512] = 1187;
        nArray2[513] = 176;
        nArray2[514] = 1194;
        nArray2[515] = 1193;
        nArray2[516] = 2313;
        nArray2[517] = 2307;
        nArray2[518] = 2305;
        nArray2[519] = 592;
        nArray2[520] = 589;
        nArray2[521] = 2294;
        nArray2[522] = 2292;
        nArray2[523] = 2289;
        nArray2[524] = 578;
        nArray2[525] = 572;
        nArray2[526] = 568;
        nArray2[527] = 2297;
        nArray2[528] = 580;
        nArray2[529] = 1591;
        nArray2[530] = 2272;
        nArray2[531] = 2267;
        nArray2[532] = 2264;
        nArray2[533] = 1547;
        nArray2[534] = 538;
        nArray2[535] = 536;
        nArray2[536] = 529;
        nArray2[537] = 2278;
        nArray2[538] = 525;
        nArray2[539] = 2275;
        nArray2[540] = 547;
        nArray2[541] = 544;
        nArray2[542] = 541;
        nArray2[543] = 1574;
        nArray2[544] = 1571;
        nArray2[545] = 2237;
        nArray2[546] = 2235;
        nArray2[547] = 2229;
        nArray2[548] = 1493;
        nArray2[549] = 2225;
        nArray2[550] = 1489;
        nArray2[551] = 478;
        nArray2[552] = 2247;
        nArray2[553] = 470;
        nArray2[554] = 2244;
        nArray2[555] = 465;
        nArray2[556] = 2241;
        nArray2[557] = 493;
        nArray2[558] = 488;
        nArray2[559] = 484;
        nArray2[560] = 2250;
        nArray2[561] = 498;
        nArray2[562] = 495;
        nArray2[563] = 1536;
        nArray2[564] = 1533;
        nArray2[565] = 1530;
        nArray2[566] = 1539;
        nArray2[567] = 2187;
        nArray2[568] = 2186;
        nArray2[569] = 2184;
        nArray2[570] = 2182;
        nArray2[571] = 1432;
        nArray2[572] = 2179;
        nArray2[573] = 1430;
        nArray2[574] = 2176;
        nArray2[575] = 1427;
        nArray2[576] = 414;
        nArray2[577] = 412;
        nArray2[578] = 2197;
        nArray2[579] = 409;
        nArray2[580] = 2195;
        nArray2[581] = 405;
        nArray2[582] = 2193;
        nArray2[583] = 2190;
        nArray2[584] = 426;
        nArray2[585] = 424;
        nArray2[586] = 421;
        nArray2[587] = 2203;
        nArray2[588] = 418;
        nArray2[589] = 2201;
        nArray2[590] = 431;
        nArray2[591] = 429;
        nArray2[592] = 1473;
        nArray2[593] = 1471;
        nArray2[594] = 1469;
        nArray2[595] = 1466;
        nArray2[596] = 434;
        nArray2[597] = 1477;
        nArray2[598] = 1475;
        nArray2[599] = 2478;
        nArray2[600] = 2472;
        nArray2[601] = 2470;
        nArray2[602] = 2459;
        nArray2[603] = 2457;
        nArray2[604] = 2454;
        nArray2[605] = 2462;
        nArray2[606] = 803;
        nArray2[607] = 2437;
        nArray2[608] = 2432;
        nArray2[609] = 2429;
        nArray2[610] = 1726;
        nArray2[611] = 2443;
        nArray2[612] = 2440;
        nArray2[613] = 792;
        nArray2[614] = 789;
        nArray2[615] = 785;
        nArray2[616] = 2401;
        nArray2[617] = 2399;
        nArray2[618] = 2393;
        nArray2[619] = 1702;
        nArray2[620] = 2389;
        nArray2[621] = 1699;
        nArray2[622] = 2411;
        nArray2[623] = 2408;
        nArray2[624] = 2405;
        nArray2[625] = 745;
        nArray2[626] = 741;
        nArray2[627] = 2415;
        nArray2[628] = 758;
        nArray2[629] = 755;
        nArray2[630] = 1721;
        nArray2[631] = 2358;
        nArray2[632] = 2357;
        nArray2[633] = 2355;
        nArray2[634] = 2353;
        nArray2[635] = 1661;
        nArray2[636] = 2350;
        nArray2[637] = 1660;
        nArray2[638] = 2347;
        nArray2[639] = 1657;
        nArray2[640] = 2368;
        nArray2[641] = 2366;
        nArray2[642] = 2364;
        nArray2[643] = 2361;
        nArray2[644] = 1666;
        nArray2[645] = 690;
        nArray2[646] = 687;
        nArray2[647] = 2374;
        nArray2[648] = 683;
        nArray2[649] = 2372;
        nArray2[650] = 701;
        nArray2[651] = 698;
        nArray2[652] = 705;
        nArray2[653] = 1691;
        nArray2[654] = 1689;
        nArray2[655] = 2619;
        nArray2[656] = 2617;
        nArray2[657] = 2610;
        nArray2[658] = 2608;
        nArray2[659] = 2605;
        nArray2[660] = 2613;
        nArray2[661] = 2593;
        nArray2[662] = 2588;
        nArray2[663] = 2585;
        nArray2[664] = 1803;
        nArray2[665] = 2599;
        nArray2[666] = 2596;
        nArray2[667] = 2563;
        nArray2[668] = 2561;
        nArray2[669] = 2555;
        nArray2[670] = 1797;
        nArray2[671] = 2551;
        nArray2[672] = 1795;
        nArray2[673] = 2573;
        nArray2[674] = 2570;
        nArray2[675] = 2567;
        nArray2[676] = 2577;
        nArray2[677] = 2525;
        nArray2[678] = 2524;
        nArray2[679] = 2522;
        nArray2[680] = 2520;
        nArray2[681] = 1786;
        nArray2[682] = 2517;
        nArray2[683] = 1785;
        nArray2[684] = 2514;
        nArray2[685] = 1783;
        nArray2[686] = 2535;
        nArray2[687] = 2533;
        nArray2[688] = 2531;
        nArray2[689] = 2528;
        nArray2[690] = 1788;
        nArray2[691] = 2541;
        nArray2[692] = 2539;
        nArray2[693] = 906;
        nArray2[694] = 903;
        nArray2[695] = 911;
        nArray2[696] = 2721;
        nArray2[697] = 1844;
        nArray2[698] = 2715;
        nArray2[699] = 2712;
        nArray2[700] = 1838;
        nArray2[701] = 1836;
        nArray2[702] = 2699;
        nArray2[703] = 2696;
        nArray2[704] = 2693;
        nArray2[705] = 2703;
        nArray2[706] = 1827;
        nArray2[707] = 1826;
        nArray2[708] = 1824;
        nArray2[709] = 2673;
        nArray2[710] = 2671;
        nArray2[711] = 2669;
        nArray2[712] = 2666;
        nArray2[713] = 1829;
        nArray2[714] = 2679;
        nArray2[715] = 2677;
        nArray2[716] = 1858;
        nArray2[717] = 1857;
        nArray2[718] = 2772;
        nArray2[719] = 1854;
        nArray2[720] = 1853;
        nArray2[721] = 1851;
        nArray2[722] = 1856;
        nArray2[723] = 2766;
        nArray2[724] = 2764;
        nArray2[725] = 143;
        nArray2[726] = 1987;
        nArray2[727] = 139;
        nArray2[728] = 1986;
        nArray2[729] = 135;
        nArray2[730] = 133;
        nArray2[731] = 131;
        nArray2[732] = 1984;
        nArray2[733] = 128;
        nArray2[734] = 1983;
        nArray2[735] = 125;
        nArray2[736] = 1981;
        nArray2[737] = 138;
        nArray2[738] = 137;
        nArray2[739] = 136;
        nArray2[740] = 1985;
        nArray2[741] = 1133;
        nArray2[742] = 1132;
        nArray2[743] = 1130;
        nArray2[744] = 112;
        nArray2[745] = 110;
        nArray2[746] = 1974;
        nArray2[747] = 107;
        nArray2[748] = 1973;
        nArray2[749] = 104;
        nArray2[750] = 1971;
        nArray2[751] = 1969;
        nArray2[752] = 122;
        nArray2[753] = 121;
        nArray2[754] = 119;
        nArray2[755] = 117;
        nArray2[756] = 1977;
        nArray2[757] = 114;
        nArray2[758] = 1976;
        nArray2[759] = 124;
        nArray2[760] = 1115;
        nArray2[761] = 1114;
        nArray2[762] = 1112;
        nArray2[763] = 1110;
        nArray2[764] = 1117;
        nArray2[765] = 1116;
        nArray2[766] = 84;
        nArray2[767] = 83;
        nArray2[768] = 1953;
        nArray2[769] = 81;
        nArray2[770] = 1952;
        nArray2[771] = 78;
        nArray2[772] = 1950;
        nArray2[773] = 1948;
        nArray2[774] = 1945;
        nArray2[775] = 94;
        nArray2[776] = 93;
        nArray2[777] = 91;
        nArray2[778] = 1959;
        nArray2[779] = 88;
        nArray2[780] = 1958;
        nArray2[781] = 85;
        nArray2[782] = 1955;
        nArray2[783] = 99;
        nArray2[784] = 97;
        nArray2[785] = 95;
        nArray2[786] = 1961;
        nArray2[787] = 1086;
        nArray2[788] = 1085;
        nArray2[789] = 1083;
        nArray2[790] = 1081;
        nArray2[791] = 1078;
        nArray2[792] = 100;
        nArray2[793] = 1090;
        nArray2[794] = 1089;
        nArray2[795] = 1087;
        nArray2[796] = 1091;
        nArray2[797] = 49;
        nArray2[798] = 47;
        nArray2[799] = 1917;
        nArray2[800] = 44;
        nArray2[801] = 1915;
        nArray2[802] = 1913;
        nArray2[803] = 1910;
        nArray2[804] = 1907;
        nArray2[805] = 59;
        nArray2[806] = 1926;
        nArray2[807] = 56;
        nArray2[808] = 1925;
        nArray2[809] = 53;
        nArray2[810] = 1922;
        nArray2[811] = 1919;
        nArray2[812] = 66;
        nArray2[813] = 64;
        nArray2[814] = 1931;
        nArray2[815] = 61;
        nArray2[816] = 1929;
        nArray2[817] = 1042;
        nArray2[818] = 1040;
        nArray2[819] = 1038;
        nArray2[820] = 71;
        nArray2[821] = 1035;
        nArray2[822] = 70;
        nArray2[823] = 1032;
        nArray2[824] = 68;
        nArray2[825] = 1048;
        nArray2[826] = 1047;
        nArray2[827] = 1045;
        nArray2[828] = 1043;
        nArray2[829] = 1050;
        nArray2[830] = 1049;
        nArray2[831] = 12;
        nArray2[832] = 10;
        nArray2[833] = 1869;
        nArray2[834] = 1867;
        nArray2[835] = 1864;
        nArray2[836] = 1861;
        nArray2[837] = 21;
        nArray2[838] = 1880;
        nArray2[839] = 19;
        nArray2[840] = 1877;
        nArray2[841] = 1874;
        nArray2[842] = 1871;
        nArray2[843] = 28;
        nArray2[844] = 1888;
        nArray2[845] = 25;
        nArray2[846] = 1886;
        nArray2[847] = 22;
        nArray2[848] = 1883;
        nArray2[849] = 982;
        nArray2[850] = 980;
        nArray2[851] = 977;
        nArray2[852] = 974;
        nArray2[853] = 32;
        nArray2[854] = 30;
        nArray2[855] = 991;
        nArray2[856] = 989;
        nArray2[857] = 987;
        nArray2[858] = 984;
        nArray2[859] = 34;
        nArray2[860] = 995;
        nArray2[861] = 994;
        nArray2[862] = 992;
        nArray2[863] = 2151;
        nArray2[864] = 2150;
        nArray2[865] = 2147;
        nArray2[866] = 2146;
        nArray2[867] = 2144;
        nArray2[868] = 356;
        nArray2[869] = 355;
        nArray2[870] = 354;
        nArray2[871] = 2149;
        nArray2[872] = 2139;
        nArray2[873] = 2138;
        nArray2[874] = 2136;
        nArray2[875] = 2134;
        nArray2[876] = 1359;
        nArray2[877] = 343;
        nArray2[878] = 341;
        nArray2[879] = 338;
        nArray2[880] = 2143;
        nArray2[881] = 335;
        nArray2[882] = 2141;
        nArray2[883] = 348;
        nArray2[884] = 347;
        nArray2[885] = 346;
        nArray2[886] = 1376;
        nArray2[887] = 1374;
        nArray2[888] = 2124;
        nArray2[889] = 2123;
        nArray2[890] = 2121;
        nArray2[891] = 2119;
        nArray2[892] = 1326;
        nArray2[893] = 2116;
        nArray2[894] = 1324;
        nArray2[895] = 310;
        nArray2[896] = 308;
        nArray2[897] = 305;
        nArray2[898] = 2131;
        nArray2[899] = 302;
        nArray2[900] = 2129;
        nArray2[901] = 298;
        nArray2[902] = 2127;
        nArray2[903] = 320;
        nArray2[904] = 318;
        nArray2[905] = 316;
        nArray2[906] = 313;
        nArray2[907] = 2133;
        nArray2[908] = 322;
        nArray2[909] = 321;
        nArray2[910] = 1355;
        nArray2[911] = 1353;
        nArray2[912] = 1351;
        nArray2[913] = 1357;
        nArray2[914] = 2092;
        nArray2[915] = 2091;
        nArray2[916] = 2089;
        nArray2[917] = 2087;
        nArray2[918] = 1276;
        nArray2[919] = 2084;
        nArray2[920] = 1274;
        nArray2[921] = 2081;
        nArray2[922] = 1271;
        nArray2[923] = 259;
        nArray2[924] = 2102;
        nArray2[925] = 256;
        nArray2[926] = 2100;
        nArray2[927] = 252;
        nArray2[928] = 2098;
        nArray2[929] = 2095;
        nArray2[930] = 272;
        nArray2[931] = 269;
        nArray2[932] = 2108;
        nArray2[933] = 266;
        nArray2[934] = 2106;
        nArray2[935] = 281;
        nArray2[936] = 279;
        nArray2[937] = 277;
        nArray2[938] = 1317;
        nArray2[939] = 1315;
        nArray2[940] = 1313;
        nArray2[941] = 1310;
        nArray2[942] = 282;
        nArray2[943] = 1321;
        nArray2[944] = 1319;
        nArray2[945] = 2039;
        nArray2[946] = 2037;
        nArray2[947] = 2035;
        nArray2[948] = 2032;
        nArray2[949] = 1203;
        nArray2[950] = 2029;
        nArray2[951] = 1200;
        nArray2[952] = 1197;
        nArray2[953] = 207;
        nArray2[954] = 2053;
        nArray2[955] = 205;
        nArray2[956] = 2051;
        nArray2[957] = 201;
        nArray2[958] = 2049;
        nArray2[959] = 2046;
        nArray2[960] = 2043;
        nArray2[961] = 220;
        nArray2[962] = 218;
        nArray2[963] = 2064;
        nArray2[964] = 215;
        nArray2[965] = 2062;
        nArray2[966] = 211;
        nArray2[967] = 2059;
        nArray2[968] = 228;
        nArray2[969] = 226;
        nArray2[970] = 223;
        nArray2[971] = 2069;
        nArray2[972] = 1259;
        nArray2[973] = 1257;
        nArray2[974] = 1254;
        nArray2[975] = 232;
        nArray2[976] = 1251;
        nArray2[977] = 230;
        nArray2[978] = 1267;
        nArray2[979] = 1265;
        nArray2[980] = 1263;
        nArray2[981] = 2316;
        nArray2[982] = 2315;
        nArray2[983] = 2312;
        nArray2[984] = 2311;
        nArray2[985] = 2309;
        nArray2[986] = 2314;
        nArray2[987] = 2304;
        nArray2[988] = 2303;
        nArray2[989] = 2301;
        nArray2[990] = 2299;
        nArray2[991] = 1593;
        nArray2[992] = 2308;
        nArray2[993] = 2306;
        nArray2[994] = 590;
        nArray2[995] = 2288;
        nArray2[996] = 2287;
        nArray2[997] = 2285;
        nArray2[998] = 2283;
        nArray2[999] = 1578;
        nArray2[1000] = 2280;
        nArray2[1001] = 1577;
        nArray2[1002] = 2295;
        nArray2[1003] = 2293;
        nArray2[1004] = 2291;
        nArray2[1005] = 579;
        nArray2[1006] = 577;
        nArray2[1007] = 574;
        nArray2[1008] = 571;
        nArray2[1009] = 2298;
        nArray2[1010] = 582;
        nArray2[1011] = 581;
        nArray2[1012] = 1592;
        nArray2[1013] = 2263;
        nArray2[1014] = 2262;
        nArray2[1015] = 2260;
        nArray2[1016] = 2258;
        nArray2[1017] = 1545;
        nArray2[1018] = 2255;
        nArray2[1019] = 1544;
        nArray2[1020] = 2252;
        nArray2[1021] = 1541;
        nArray2[1022] = 2273;
        nArray2[1023] = 2271;
        nArray2[1024] = 2269;
        nArray2[1025] = 2266;
        nArray2[1026] = 1550;
        nArray2[1027] = 535;
        nArray2[1028] = 532;
        nArray2[1029] = 2279;
        nArray2[1030] = 528;
        nArray2[1031] = 2277;
        nArray2[1032] = 546;
        nArray2[1033] = 543;
        nArray2[1034] = 549;
        nArray2[1035] = 1575;
        nArray2[1036] = 1573;
        nArray2[1037] = 2224;
        nArray2[1038] = 2222;
        nArray2[1039] = 2220;
        nArray2[1040] = 1486;
        nArray2[1041] = 2217;
        nArray2[1042] = 1485;
        nArray2[1043] = 2214;
        nArray2[1044] = 1482;
        nArray2[1045] = 1479;
        nArray2[1046] = 2238;
        nArray2[1047] = 2236;
        nArray2[1048] = 2234;
        nArray2[1049] = 2231;
        nArray2[1050] = 1496;
        nArray2[1051] = 2228;
        nArray2[1052] = 1492;
        nArray2[1053] = 480;
        nArray2[1054] = 477;
        nArray2[1055] = 2248;
        nArray2[1056] = 473;
        nArray2[1057] = 2246;
        nArray2[1058] = 469;
        nArray2[1059] = 2243;
        nArray2[1060] = 490;
        nArray2[1061] = 487;
        nArray2[1062] = 2251;
        nArray2[1063] = 497;
        nArray2[1064] = 1537;
        nArray2[1065] = 1535;
        nArray2[1066] = 1532;
        nArray2[1067] = 2477;
        nArray2[1068] = 2476;
        nArray2[1069] = 2474;
        nArray2[1070] = 2479;
        nArray2[1071] = 2469;
        nArray2[1072] = 2468;
        nArray2[1073] = 2466;
        nArray2[1074] = 2464;
        nArray2[1075] = 1730;
        nArray2[1076] = 2473;
        nArray2[1077] = 2471;
        nArray2[1078] = 2453;
        nArray2[1079] = 2452;
        nArray2[1080] = 2450;
        nArray2[1081] = 2448;
        nArray2[1082] = 1729;
        nArray2[1083] = 2445;
        nArray2[1084] = 1728;
        nArray2[1085] = 2460;
        nArray2[1086] = 2458;
        nArray2[1087] = 2456;
        nArray2[1088] = 2463;
        nArray2[1089] = 805;
        nArray2[1090] = 804;
        nArray2[1091] = 2428;
        nArray2[1092] = 2427;
        nArray2[1093] = 2425;
        nArray2[1094] = 2423;
        nArray2[1095] = 1725;
        nArray2[1096] = 2420;
        nArray2[1097] = 1724;
        nArray2[1098] = 2417;
        nArray2[1099] = 1722;
        nArray2[1100] = 2438;
        nArray2[1101] = 2436;
        nArray2[1102] = 2434;
        nArray2[1103] = 2431;
        nArray2[1104] = 1727;
        nArray2[1105] = 2444;
        nArray2[1106] = 2442;
        nArray2[1107] = 793;
        nArray2[1108] = 791;
        nArray2[1109] = 788;
        nArray2[1110] = 795;
        nArray2[1111] = 2388;
        nArray2[1112] = 2386;
        nArray2[1113] = 2384;
        nArray2[1114] = 1697;
        nArray2[1115] = 2381;
        nArray2[1116] = 1696;
        nArray2[1117] = 2378;
        nArray2[1118] = 1694;
        nArray2[1119] = 1692;
        nArray2[1120] = 2402;
        nArray2[1121] = 2400;
        nArray2[1122] = 2398;
        nArray2[1123] = 2395;
        nArray2[1124] = 1703;
        nArray2[1125] = 2392;
        nArray2[1126] = 1701;
        nArray2[1127] = 2412;
        nArray2[1128] = 2410;
        nArray2[1129] = 2407;
        nArray2[1130] = 751;
        nArray2[1131] = 748;
        nArray2[1132] = 744;
        nArray2[1133] = 2416;
        nArray2[1134] = 759;
        nArray2[1135] = 757;
        nArray2[1136] = 1807;
        nArray2[1137] = 2620;
        nArray2[1138] = 2618;
        nArray2[1139] = 1806;
        nArray2[1140] = 1805;
        nArray2[1141] = 2611;
        nArray2[1142] = 2609;
        nArray2[1143] = 2607;
        nArray2[1144] = 2614;
        nArray2[1145] = 1802;
        nArray2[1146] = 1801;
        nArray2[1147] = 1799;
        nArray2[1148] = 2594;
        nArray2[1149] = 2592;
        nArray2[1150] = 2590;
        nArray2[1151] = 2587;
        nArray2[1152] = 1804;
        nArray2[1153] = 2600;
        nArray2[1154] = 2598;
        nArray2[1155] = 1794;
        nArray2[1156] = 1793;
        nArray2[1157] = 1791;
        nArray2[1158] = 1789;
        nArray2[1159] = 2564;
        nArray2[1160] = 2562;
        nArray2[1161] = 2560;
        nArray2[1162] = 2557;
        nArray2[1163] = 1798;
        nArray2[1164] = 2554;
        nArray2[1165] = 1796;
        nArray2[1166] = 2574;
        nArray2[1167] = 2572;
        nArray2[1168] = 2569;
        nArray2[1169] = 2578;
        nArray2[1170] = 1847;
        nArray2[1171] = 1846;
        nArray2[1172] = 2722;
        nArray2[1173] = 1843;
        nArray2[1174] = 1842;
        nArray2[1175] = 1840;
        nArray2[1176] = 1845;
        nArray2[1177] = 2716;
        nArray2[1178] = 2714;
        nArray2[1179] = 1835;
        nArray2[1180] = 1834;
        nArray2[1181] = 1832;
        nArray2[1182] = 1830;
        nArray2[1183] = 1839;
        nArray2[1184] = 1837;
        nArray2[1185] = 2700;
        nArray2[1186] = 2698;
        nArray2[1187] = 2695;
        nArray2[1188] = 2704;
        nArray2[1189] = 1817;
        nArray2[1190] = 1811;
        nArray2[1191] = 1810;
        nArray2[1192] = 897;
        nArray2[1193] = 862;
        nArray2[1194] = 1777;
        nArray2[1195] = 829;
        nArray2[1196] = 826;
        nArray2[1197] = 838;
        nArray2[1198] = 1760;
        nArray2[1199] = 1758;
        nArray2[1200] = 808;
        nArray2[1201] = 2481;
        nArray2[1202] = 1741;
        nArray2[1203] = 1740;
        nArray2[1204] = 1738;
        nArray2[1205] = 1743;
        nArray2[1206] = 2624;
        nArray2[1207] = 1818;
        nArray2[1208] = 2726;
        nArray2[1209] = 2776;
        nArray2[1210] = 782;
        nArray2[1211] = 740;
        nArray2[1212] = 737;
        nArray2[1213] = 1715;
        nArray2[1214] = 686;
        nArray2[1215] = 679;
        nArray2[1216] = 695;
        nArray2[1217] = 1682;
        nArray2[1218] = 1680;
        nArray2[1219] = 639;
        nArray2[1220] = 628;
        nArray2[1221] = 2339;
        nArray2[1222] = 647;
        nArray2[1223] = 644;
        nArray2[1224] = 1645;
        nArray2[1225] = 1643;
        nArray2[1226] = 1640;
        nArray2[1227] = 1648;
        nArray2[1228] = 602;
        nArray2[1229] = 600;
        nArray2[1230] = 597;
        nArray2[1231] = 595;
        nArray2[1232] = 2320;
        nArray2[1233] = 593;
        nArray2[1234] = 2318;
        nArray2[1235] = 609;
        nArray2[1236] = 607;
        nArray2[1237] = 604;
        nArray2[1238] = 1611;
        nArray2[1239] = 1610;
        nArray2[1240] = 1608;
        nArray2[1241] = 1606;
        nArray2[1242] = 613;
        nArray2[1243] = 1615;
        nArray2[1244] = 1613;
        nArray2[1245] = 2328;
        nArray2[1246] = 926;
        nArray2[1247] = 924;
        nArray2[1248] = 892;
        nArray2[1249] = 886;
        nArray2[1250] = 899;
        nArray2[1251] = 857;
        nArray2[1252] = 850;
        nArray2[1253] = 2505;
        nArray2[1254] = 1778;
        nArray2[1255] = 824;
        nArray2[1256] = 823;
        nArray2[1257] = 821;
        nArray2[1258] = 819;
        nArray2[1259] = 2488;
        nArray2[1260] = 818;
        nArray2[1261] = 2486;
        nArray2[1262] = 833;
        nArray2[1263] = 831;
        nArray2[1264] = 828;
        nArray2[1265] = 840;
        nArray2[1266] = 1761;
        nArray2[1267] = 1759;
        nArray2[1268] = 2649;
        nArray2[1269] = 2632;
        nArray2[1270] = 2630;
        nArray2[1271] = 2746;
        nArray2[1272] = 2734;
        nArray2[1273] = 2732;
        nArray2[1274] = 2782;
        nArray2[1275] = 2781;
        nArray2[1276] = 570;
        nArray2[1277] = 567;
        nArray2[1278] = 1587;
        nArray2[1279] = 531;
        nArray2[1280] = 527;
        nArray2[1281] = 523;
        nArray2[1282] = 540;
        nArray2[1283] = 1566;
        nArray2[1284] = 1564;
        nArray2[1285] = 476;
        nArray2[1286] = 467;
        nArray2[1287] = 463;
        nArray2[1288] = 2240;
        nArray2[1289] = 486;
        nArray2[1290] = 483;
        nArray2[1291] = 1524;
        nArray2[1292] = 1521;
        nArray2[1293] = 1518;
        nArray2[1294] = 1529;
        nArray2[1295] = 411;
        nArray2[1296] = 403;
        nArray2[1297] = 2192;
        nArray2[1298] = 399;
        nArray2[1299] = 2189;
        nArray2[1300] = 423;
        nArray2[1301] = 416;
        nArray2[1302] = 1462;
        nArray2[1303] = 1457;
        nArray2[1304] = 1454;
        nArray2[1305] = 428;
        nArray2[1306] = 1468;
        nArray2[1307] = 1465;
        nArray2[1308] = 2210;
        nArray2[1309] = 366;
        nArray2[1310] = 363;
        nArray2[1311] = 2158;
        nArray2[1312] = 360;
        nArray2[1313] = 2156;
        nArray2[1314] = 357;
        nArray2[1315] = 2153;
        nArray2[1316] = 376;
        nArray2[1317] = 373;
        nArray2[1318] = 370;
        nArray2[1319] = 2163;
        nArray2[1320] = 1410;
        nArray2[1321] = 1409;
        nArray2[1322] = 1407;
        nArray2[1323] = 1405;
        nArray2[1324] = 382;
        nArray2[1325] = 1402;
        nArray2[1326] = 380;
        nArray2[1327] = 1417;
        nArray2[1328] = 1415;
        nArray2[1329] = 1412;
        nArray2[1330] = 1421;
        nArray2[1331] = 2175;
        nArray2[1332] = 2174;
        nArray2[1333] = 777;
        nArray2[1334] = 774;
        nArray2[1335] = 771;
        nArray2[1336] = 784;
        nArray2[1337] = 732;
        nArray2[1338] = 725;
        nArray2[1339] = 722;
        nArray2[1340] = 2404;
        nArray2[1341] = 743;
        nArray2[1342] = 1716;
        nArray2[1343] = 676;
        nArray2[1344] = 674;
        nArray2[1345] = 668;
        nArray2[1346] = 2363;
        nArray2[1347] = 665;
        nArray2[1348] = 2360;
        nArray2[1349] = 685;
        nArray2[1350] = 1684;
        nArray2[1351] = 1681;
        nArray2[1352] = 626;
        nArray2[1353] = 624;
        nArray2[1354] = 622;
        nArray2[1355] = 2335;
        nArray2[1356] = 620;
        nArray2[1357] = 2333;
        nArray2[1358] = 617;
        nArray2[1359] = 2330;
        nArray2[1360] = 641;
        nArray2[1361] = 635;
        nArray2[1362] = 649;
        nArray2[1363] = 1646;
        nArray2[1364] = 1644;
        nArray2[1365] = 1642;
        nArray2[1366] = 2566;
        nArray2[1367] = 928;
        nArray2[1368] = 925;
        nArray2[1369] = 2530;
        nArray2[1370] = 2527;
        nArray2[1371] = 894;
        nArray2[1372] = 891;
        nArray2[1373] = 888;
        nArray2[1374] = 2501;
        nArray2[1375] = 2499;
        nArray2[1376] = 2496;
        nArray2[1377] = 858;
        nArray2[1378] = 856;
        nArray2[1379] = 854;
        nArray2[1380] = 851;
        nArray2[1381] = 1779;
        nArray2[1382] = 2692;
        nArray2[1383] = 2668;
        nArray2[1384] = 2665;
        nArray2[1385] = 2645;
        nArray2[1386] = 2643;
        nArray2[1387] = 2640;
        nArray2[1388] = 2651;
        nArray2[1389] = 2768;
        nArray2[1390] = 2759;
        nArray2[1391] = 2757;
        nArray2[1392] = 2744;
        nArray2[1393] = 2743;
        nArray2[1394] = 2741;
        nArray2[1395] = 2748;
        nArray2[1396] = 352;
        nArray2[1397] = 1382;
        nArray2[1398] = 340;
        nArray2[1399] = 337;
        nArray2[1400] = 333;
        nArray2[1401] = 1371;
        nArray2[1402] = 1369;
        nArray2[1403] = 307;
        nArray2[1404] = 300;
        nArray2[1405] = 296;
        nArray2[1406] = 2126;
        nArray2[1407] = 315;
        nArray2[1408] = 312;
        nArray2[1409] = 1347;
        nArray2[1410] = 1342;
        nArray2[1411] = 1350;
        nArray2[1412] = 261;
        nArray2[1413] = 258;
        nArray2[1414] = 250;
        nArray2[1415] = 2097;
        nArray2[1416] = 246;
        nArray2[1417] = 2094;
        nArray2[1418] = 271;
        nArray2[1419] = 268;
        nArray2[1420] = 264;
        nArray2[1421] = 1306;
        nArray2[1422] = 1301;
        nArray2[1423] = 1298;
        nArray2[1424] = 276;
        nArray2[1425] = 1312;
        nArray2[1426] = 1309;
        nArray2[1427] = 2115;
        nArray2[1428] = 203;
        nArray2[1429] = 2048;
        nArray2[1430] = 195;
        nArray2[1431] = 2045;
        nArray2[1432] = 191;
        nArray2[1433] = 2041;
        nArray2[1434] = 213;
        nArray2[1435] = 209;
        nArray2[1436] = 2056;
        nArray2[1437] = 1246;
        nArray2[1438] = 1244;
        nArray2[1439] = 1238;
        nArray2[1440] = 225;
        nArray2[1441] = 1234;
        nArray2[1442] = 222;
        nArray2[1443] = 1256;
        nArray2[1444] = 1253;
        nArray2[1445] = 1249;
        nArray2[1446] = 1262;
        nArray2[1447] = 2080;
        nArray2[1448] = 2079;
        nArray2[1449] = 154;
        nArray2[1450] = 1997;
        nArray2[1451] = 150;
        nArray2[1452] = 1995;
        nArray2[1453] = 147;
        nArray2[1454] = 1992;
        nArray2[1455] = 1989;
        nArray2[1456] = 163;
        nArray2[1457] = 160;
        nArray2[1458] = 2004;
        nArray2[1459] = 156;
        nArray2[1460] = 2001;
        nArray2[1461] = 1175;
        nArray2[1462] = 1174;
        nArray2[1463] = 1172;
        nArray2[1464] = 1170;
        nArray2[1465] = 1167;
        nArray2[1466] = 170;
        nArray2[1467] = 1164;
        nArray2[1468] = 167;
        nArray2[1469] = 1185;
        nArray2[1470] = 1183;
        nArray2[1471] = 1180;
        nArray2[1472] = 1177;
        nArray2[1473] = 174;
        nArray2[1474] = 1190;
        nArray2[1475] = 1188;
        nArray2[1476] = 2025;
        nArray2[1477] = 2024;
        nArray2[1478] = 2022;
        nArray2[1479] = 587;
        nArray2[1480] = 586;
        nArray2[1481] = 564;
        nArray2[1482] = 559;
        nArray2[1483] = 556;
        nArray2[1484] = 2290;
        nArray2[1485] = 573;
        nArray2[1486] = 1588;
        nArray2[1487] = 520;
        nArray2[1488] = 518;
        nArray2[1489] = 512;
        nArray2[1490] = 2268;
        nArray2[1491] = 508;
        nArray2[1492] = 2265;
        nArray2[1493] = 530;
        nArray2[1494] = 1568;
        nArray2[1495] = 1565;
        nArray2[1496] = 461;
        nArray2[1497] = 457;
        nArray2[1498] = 2233;
        nArray2[1499] = 450;
        nArray2[1500] = 2230;
        nArray2[1501] = 446;
        nArray2[1502] = 2226;
        nArray2[1503] = 479;
        nArray2[1504] = 471;
        nArray2[1505] = 489;
        nArray2[1506] = 1526;
        nArray2[1507] = 1523;
        nArray2[1508] = 1520;
        nArray2[1509] = 397;
        nArray2[1510] = 395;
        nArray2[1511] = 2185;
        nArray2[1512] = 392;
        nArray2[1513] = 2183;
        nArray2[1514] = 389;
        nArray2[1515] = 2180;
        nArray2[1516] = 2177;
        nArray2[1517] = 410;
        nArray2[1518] = 2194;
        nArray2[1519] = 402;
        nArray2[1520] = 422;
        nArray2[1521] = 1463;
        nArray2[1522] = 1461;
        nArray2[1523] = 1459;
        nArray2[1524] = 1456;
        nArray2[1525] = 1470;
        nArray2[1526] = 2455;
        nArray2[1527] = 799;
        nArray2[1528] = 2433;
        nArray2[1529] = 2430;
        nArray2[1530] = 779;
        nArray2[1531] = 776;
        nArray2[1532] = 773;
        nArray2[1533] = 2397;
        nArray2[1534] = 2394;
        nArray2[1535] = 2390;
        nArray2[1536] = 734;
        nArray2[1537] = 728;
        nArray2[1538] = 724;
        nArray2[1539] = 746;
        nArray2[1540] = 1717;
        nArray2[1541] = 2356;
        nArray2[1542] = 2354;
        nArray2[1543] = 2351;
        nArray2[1544] = 2348;
        nArray2[1545] = 1658;
        nArray2[1546] = 677;
        nArray2[1547] = 675;
        nArray2[1548] = 673;
        nArray2[1549] = 670;
        nArray2[1550] = 667;
        nArray2[1551] = 688;
        nArray2[1552] = 1685;
        nArray2[1553] = 1683;
        nArray2[1554] = 2606;
        nArray2[1555] = 2589;
        nArray2[1556] = 2586;
        nArray2[1557] = 2559;
        nArray2[1558] = 2556;
        nArray2[1559] = 2552;
        nArray2[1560] = 927;
        nArray2[1561] = 2523;
        nArray2[1562] = 2521;
        nArray2[1563] = 2518;
        nArray2[1564] = 2515;
        nArray2[1565] = 1784;
        nArray2[1566] = 2532;
        nArray2[1567] = 895;
        nArray2[1568] = 893;
        nArray2[1569] = 890;
        nArray2[1570] = 2718;
        nArray2[1571] = 2709;
        nArray2[1572] = 2707;
        nArray2[1573] = 2689;
        nArray2[1574] = 2687;
        nArray2[1575] = 2684;
        nArray2[1576] = 2663;
        nArray2[1577] = 2662;
        nArray2[1578] = 2660;
        nArray2[1579] = 2658;
        nArray2[1580] = 1825;
        nArray2[1581] = 2667;
        nArray2[1582] = 2769;
        nArray2[1583] = 1852;
        nArray2[1584] = 2760;
        nArray2[1585] = 2758;
        nArray2[1586] = 142;
        nArray2[1587] = 141;
        nArray2[1588] = 1139;
        nArray2[1589] = 1138;
        nArray2[1590] = 134;
        nArray2[1591] = 132;
        nArray2[1592] = 129;
        nArray2[1593] = 126;
        nArray2[1594] = 1982;
        nArray2[1595] = 1129;
        nArray2[1596] = 1128;
        nArray2[1597] = 1126;
        nArray2[1598] = 1131;
        nArray2[1599] = 113;
        nArray2[1600] = 111;
        nArray2[1601] = 108;
        nArray2[1602] = 105;
        nArray2[1603] = 1972;
        nArray2[1604] = 101;
        nArray2[1605] = 1970;
        nArray2[1606] = 120;
        nArray2[1607] = 118;
        nArray2[1608] = 115;
        nArray2[1609] = 1109;
        nArray2[1610] = 1108;
        nArray2[1611] = 1106;
        nArray2[1612] = 1104;
        nArray2[1613] = 123;
        nArray2[1614] = 1113;
        nArray2[1615] = 1111;
        nArray2[1616] = 82;
        nArray2[1617] = 79;
        nArray2[1618] = 1951;
        nArray2[1619] = 75;
        nArray2[1620] = 1949;
        nArray2[1621] = 72;
        nArray2[1622] = 1946;
        nArray2[1623] = 92;
        nArray2[1624] = 89;
        nArray2[1625] = 86;
        nArray2[1626] = 1956;
        nArray2[1627] = 1077;
        nArray2[1628] = 1076;
        nArray2[1629] = 1074;
        nArray2[1630] = 1072;
        nArray2[1631] = 98;
        nArray2[1632] = 1069;
        nArray2[1633] = 96;
        nArray2[1634] = 1084;
        nArray2[1635] = 1082;
        nArray2[1636] = 1079;
        nArray2[1637] = 1088;
        nArray2[1638] = 1968;
        nArray2[1639] = 1967;
        nArray2[1640] = 48;
        nArray2[1641] = 45;
        nArray2[1642] = 1916;
        nArray2[1643] = 42;
        nArray2[1644] = 1914;
        nArray2[1645] = 39;
        nArray2[1646] = 1911;
        nArray2[1647] = 1908;
        nArray2[1648] = 60;
        nArray2[1649] = 57;
        nArray2[1650] = 54;
        nArray2[1651] = 1923;
        nArray2[1652] = 50;
        nArray2[1653] = 1920;
        nArray2[1654] = 1031;
        nArray2[1655] = 1030;
        nArray2[1656] = 1028;
        nArray2[1657] = 1026;
        nArray2[1658] = 67;
        nArray2[1659] = 1023;
        nArray2[1660] = 65;
        nArray2[1661] = 1020;
        nArray2[1662] = 62;
        nArray2[1663] = 1041;
        nArray2[1664] = 1039;
        nArray2[1665] = 1036;
        nArray2[1666] = 1033;
        nArray2[1667] = 69;
        nArray2[1668] = 1046;
        nArray2[1669] = 1044;
        nArray2[1670] = 1944;
        nArray2[1671] = 1943;
        nArray2[1672] = 1941;
        nArray2[1673] = 11;
        nArray2[1674] = 9;
        nArray2[1675] = 1868;
        nArray2[1676] = 7;
        nArray2[1677] = 1865;
        nArray2[1678] = 1862;
        nArray2[1679] = 1859;
        nArray2[1680] = 20;
        nArray2[1681] = 1878;
        nArray2[1682] = 16;
        nArray2[1683] = 1875;
        nArray2[1684] = 13;
        nArray2[1685] = 1872;
        nArray2[1686] = 970;
        nArray2[1687] = 968;
        nArray2[1688] = 966;
        nArray2[1689] = 963;
        nArray2[1690] = 29;
        nArray2[1691] = 960;
        nArray2[1692] = 26;
        nArray2[1693] = 23;
        nArray2[1694] = 983;
        nArray2[1695] = 981;
        nArray2[1696] = 978;
        nArray2[1697] = 975;
        nArray2[1698] = 33;
        nArray2[1699] = 971;
        nArray2[1700] = 31;
        nArray2[1701] = 990;
        nArray2[1702] = 988;
        nArray2[1703] = 985;
        nArray2[1704] = 1906;
        nArray2[1705] = 1904;
        nArray2[1706] = 1902;
        nArray2[1707] = 993;
        nArray2[1708] = 351;
        nArray2[1709] = 2145;
        nArray2[1710] = 1383;
        nArray2[1711] = 331;
        nArray2[1712] = 330;
        nArray2[1713] = 328;
        nArray2[1714] = 326;
        nArray2[1715] = 2137;
        nArray2[1716] = 323;
        nArray2[1717] = 2135;
        nArray2[1718] = 339;
        nArray2[1719] = 1372;
        nArray2[1720] = 1370;
        nArray2[1721] = 294;
        nArray2[1722] = 293;
        nArray2[1723] = 291;
        nArray2[1724] = 289;
        nArray2[1725] = 2122;
        nArray2[1726] = 286;
        nArray2[1727] = 2120;
        nArray2[1728] = 283;
        nArray2[1729] = 2117;
        nArray2[1730] = 309;
        nArray2[1731] = 303;
        nArray2[1732] = 317;
        nArray2[1733] = 1348;
        nArray2[1734] = 1346;
        nArray2[1735] = 1344;
        nArray2[1736] = 245;
        nArray2[1737] = 244;
        nArray2[1738] = 242;
        nArray2[1739] = 2090;
        nArray2[1740] = 239;
        nArray2[1741] = 2088;
        nArray2[1742] = 236;
        nArray2[1743] = 2085;
        nArray2[1744] = 2082;
        nArray2[1745] = 260;
        nArray2[1746] = 2099;
        nArray2[1747] = 249;
        nArray2[1748] = 270;
        nArray2[1749] = 1307;
        nArray2[1750] = 1305;
        nArray2[1751] = 1303;
        nArray2[1752] = 1300;
        nArray2[1753] = 1314;
        nArray2[1754] = 189;
        nArray2[1755] = 2038;
        nArray2[1756] = 186;
        nArray2[1757] = 2036;
        nArray2[1758] = 183;
        nArray2[1759] = 2033;
        nArray2[1760] = 2030;
        nArray2[1761] = 2026;
        nArray2[1762] = 206;
        nArray2[1763] = 198;
        nArray2[1764] = 2047;
        nArray2[1765] = 194;
        nArray2[1766] = 216;
        nArray2[1767] = 1247;
        nArray2[1768] = 1245;
        nArray2[1769] = 1243;
        nArray2[1770] = 1240;
        nArray2[1771] = 227;
        nArray2[1772] = 1237;
        nArray2[1773] = 1255;
        nArray2[1774] = 2310;
        nArray2[1775] = 2302;
        nArray2[1776] = 2300;
        nArray2[1777] = 2286;
        nArray2[1778] = 2284;
        nArray2[1779] = 2281;
        nArray2[1780] = 565;
        nArray2[1781] = 563;
        nArray2[1782] = 561;
        nArray2[1783] = 558;
        nArray2[1784] = 575;
        nArray2[1785] = 1589;
        nArray2[1786] = 2261;
        nArray2[1787] = 2259;
        nArray2[1788] = 2256;
        nArray2[1789] = 2253;
        nArray2[1790] = 1542;
        nArray2[1791] = 521;
        nArray2[1792] = 519;
        nArray2[1793] = 517;
        nArray2[1794] = 514;
        nArray2[1795] = 2270;
        nArray2[1796] = 511;
        nArray2[1797] = 533;
        nArray2[1798] = 1569;
        nArray2[1799] = 1567;
        nArray2[1800] = 2223;
        nArray2[1801] = 2221;
        nArray2[1802] = 2218;
        nArray2[1803] = 2215;
        nArray2[1804] = 1483;
        nArray2[1805] = 2211;
        nArray2[1806] = 1480;
        nArray2[1807] = 459;
        nArray2[1808] = 456;
        nArray2[1809] = 453;
        nArray2[1810] = 2232;
        nArray2[1811] = 449;
        nArray2[1812] = 474;
        nArray2[1813] = 491;
        nArray2[1814] = 1527;
        nArray2[1815] = 1525;
        nArray2[1816] = 1522;
        nArray2[1817] = 2475;
        nArray2[1818] = 2467;
        nArray2[1819] = 2465;
        nArray2[1820] = 2451;
        nArray2[1821] = 2449;
        nArray2[1822] = 2446;
        nArray2[1823] = 801;
        nArray2[1824] = 800;
        nArray2[1825] = 2426;
        nArray2[1826] = 2424;
        nArray2[1827] = 2421;
        nArray2[1828] = 2418;
        nArray2[1829] = 1723;
        nArray2[1830] = 2435;
        nArray2[1831] = 780;
        nArray2[1832] = 778;
        nArray2[1833] = 775;
        nArray2[1834] = 2387;
        nArray2[1835] = 2385;
        nArray2[1836] = 2382;
        nArray2[1837] = 2379;
        nArray2[1838] = 1695;
        nArray2[1839] = 2375;
        nArray2[1840] = 1693;
        nArray2[1841] = 2396;
        nArray2[1842] = 735;
        nArray2[1843] = 733;
        nArray2[1844] = 730;
        nArray2[1845] = 727;
        nArray2[1846] = 749;
        nArray2[1847] = 1718;
        nArray2[1848] = 2616;
        nArray2[1849] = 2615;
        nArray2[1850] = 2604;
        nArray2[1851] = 2603;
        nArray2[1852] = 2601;
        nArray2[1853] = 2584;
        nArray2[1854] = 2583;
        nArray2[1855] = 2581;
        nArray2[1856] = 2579;
        nArray2[1857] = 1800;
        nArray2[1858] = 2591;
        nArray2[1859] = 2550;
        nArray2[1860] = 2549;
        nArray2[1861] = 2547;
        nArray2[1862] = 2545;
        nArray2[1863] = 1792;
        nArray2[1864] = 2542;
        nArray2[1865] = 1790;
        nArray2[1866] = 2558;
        nArray2[1867] = 929;
        nArray2[1868] = 2719;
        nArray2[1869] = 1841;
        nArray2[1870] = 2710;
        nArray2[1871] = 2708;
        nArray2[1872] = 1833;
        nArray2[1873] = 1831;
        nArray2[1874] = 2690;
        nArray2[1875] = 2688;
        nArray2[1876] = 2686;
        nArray2[1877] = 1815;
        nArray2[1878] = 1809;
        nArray2[1879] = 1808;
        nArray2[1880] = 1774;
        nArray2[1881] = 1756;
        nArray2[1882] = 1754;
        nArray2[1883] = 1737;
        nArray2[1884] = 1736;
        nArray2[1885] = 1734;
        nArray2[1886] = 1739;
        nArray2[1887] = 1816;
        nArray2[1888] = 1711;
        nArray2[1889] = 1676;
        nArray2[1890] = 1674;
        nArray2[1891] = 633;
        nArray2[1892] = 629;
        nArray2[1893] = 1638;
        nArray2[1894] = 1636;
        nArray2[1895] = 1633;
        nArray2[1896] = 1641;
        nArray2[1897] = 598;
        nArray2[1898] = 1605;
        nArray2[1899] = 1604;
        nArray2[1900] = 1602;
        nArray2[1901] = 1600;
        nArray2[1902] = 605;
        nArray2[1903] = 1609;
        nArray2[1904] = 1607;
        nArray2[1905] = 2327;
        nArray2[1906] = 887;
        nArray2[1907] = 853;
        nArray2[1908] = 1775;
        nArray2[1909] = 822;
        nArray2[1910] = 820;
        nArray2[1911] = 1757;
        nArray2[1912] = 1755;
        nArray2[1913] = 1584;
        nArray2[1914] = 524;
        nArray2[1915] = 1560;
        nArray2[1916] = 1558;
        nArray2[1917] = 468;
        nArray2[1918] = 464;
        nArray2[1919] = 1514;
        nArray2[1920] = 1511;
        nArray2[1921] = 1508;
        nArray2[1922] = 1519;
        nArray2[1923] = 408;
        nArray2[1924] = 404;
        nArray2[1925] = 400;
        nArray2[1926] = 1452;
        nArray2[1927] = 1447;
        nArray2[1928] = 1444;
        nArray2[1929] = 417;
        nArray2[1930] = 1458;
        nArray2[1931] = 1455;
        nArray2[1932] = 2208;
        nArray2[1933] = 364;
        nArray2[1934] = 361;
        nArray2[1935] = 358;
        nArray2[1936] = 2154;
        nArray2[1937] = 1401;
        nArray2[1938] = 1400;
        nArray2[1939] = 1398;
        nArray2[1940] = 1396;
        nArray2[1941] = 374;
        nArray2[1942] = 1393;
        nArray2[1943] = 371;
        nArray2[1944] = 1408;
        nArray2[1945] = 1406;
        nArray2[1946] = 1403;
        nArray2[1947] = 1413;
        nArray2[1948] = 2173;
        nArray2[1949] = 2172;
        nArray2[1950] = 772;
        nArray2[1951] = 726;
        nArray2[1952] = 723;
        nArray2[1953] = 1712;
        nArray2[1954] = 672;
        nArray2[1955] = 669;
        nArray2[1956] = 666;
        nArray2[1957] = 682;
        nArray2[1958] = 1678;
        nArray2[1959] = 1675;
        nArray2[1960] = 625;
        nArray2[1961] = 623;
        nArray2[1962] = 621;
        nArray2[1963] = 618;
        nArray2[1964] = 2331;
        nArray2[1965] = 636;
        nArray2[1966] = 632;
        nArray2[1967] = 1639;
        nArray2[1968] = 1637;
        nArray2[1969] = 1635;
        nArray2[1970] = 920;
        nArray2[1971] = 918;
        nArray2[1972] = 884;
        nArray2[1973] = 880;
        nArray2[1974] = 889;
        nArray2[1975] = 849;
        nArray2[1976] = 848;
        nArray2[1977] = 847;
        nArray2[1978] = 846;
        nArray2[1979] = 2497;
        nArray2[1980] = 855;
        nArray2[1981] = 852;
        nArray2[1982] = 1776;
        nArray2[1983] = 2641;
        nArray2[1984] = 2742;
        nArray2[1985] = 2787;
        nArray2[1986] = 1380;
        nArray2[1987] = 334;
        nArray2[1988] = 1367;
        nArray2[1989] = 1365;
        nArray2[1990] = 301;
        nArray2[1991] = 297;
        nArray2[1992] = 1340;
        nArray2[1993] = 1338;
        nArray2[1994] = 1335;
        nArray2[1995] = 1343;
        nArray2[1996] = 255;
        nArray2[1997] = 251;
        nArray2[1998] = 247;
        nArray2[1999] = 1296;
        nArray2[2000] = 1291;
        nArray2[2001] = 1288;
        nArray2[2002] = 265;
        nArray2[2003] = 1302;
        nArray2[2004] = 1299;
        nArray2[2005] = 2113;
        nArray2[2006] = 204;
        nArray2[2007] = 196;
        nArray2[2008] = 192;
        nArray2[2009] = 2042;
        nArray2[2010] = 1232;
        nArray2[2011] = 1230;
        nArray2[2012] = 1224;
        nArray2[2013] = 214;
        nArray2[2014] = 1220;
        nArray2[2015] = 210;
        nArray2[2016] = 1242;
        nArray2[2017] = 1239;
        nArray2[2018] = 1235;
        nArray2[2019] = 1250;
        nArray2[2020] = 2077;
        nArray2[2021] = 2075;
        nArray2[2022] = 151;
        nArray2[2023] = 148;
        nArray2[2024] = 1993;
        nArray2[2025] = 144;
        nArray2[2026] = 1990;
        nArray2[2027] = 1163;
        nArray2[2028] = 1162;
        nArray2[2029] = 1160;
        nArray2[2030] = 1158;
        nArray2[2031] = 1155;
        nArray2[2032] = 161;
        nArray2[2033] = 1152;
        nArray2[2034] = 157;
        nArray2[2035] = 1173;
        nArray2[2036] = 1171;
        nArray2[2037] = 1168;
        nArray2[2038] = 1165;
        nArray2[2039] = 168;
        nArray2[2040] = 1181;
        nArray2[2041] = 1178;
        nArray2[2042] = 2021;
        nArray2[2043] = 2020;
        nArray2[2044] = 2018;
        nArray2[2045] = 2023;
        nArray2[2046] = 585;
        nArray2[2047] = 560;
        nArray2[2048] = 557;
        nArray2[2049] = 1585;
        nArray2[2050] = 516;
        nArray2[2051] = 509;
        nArray2[2052] = 1562;
        nArray2[2053] = 1559;
        nArray2[2054] = 458;
        nArray2[2055] = 447;
        nArray2[2056] = 2227;
        nArray2[2057] = 472;
        nArray2[2058] = 1516;
        nArray2[2059] = 1513;
        nArray2[2060] = 1510;
        nArray2[2061] = 398;
        nArray2[2062] = 396;
        nArray2[2063] = 393;
        nArray2[2064] = 390;
        nArray2[2065] = 2181;
        nArray2[2066] = 386;
        nArray2[2067] = 2178;
        nArray2[2068] = 407;
        nArray2[2069] = 1453;
        nArray2[2070] = 1451;
        nArray2[2071] = 1449;
        nArray2[2072] = 1446;
        nArray2[2073] = 420;
        nArray2[2074] = 1460;
        nArray2[2075] = 2209;
        nArray2[2076] = 769;
        nArray2[2077] = 764;
        nArray2[2078] = 720;
        nArray2[2079] = 712;
        nArray2[2080] = 2391;
        nArray2[2081] = 729;
        nArray2[2082] = 1713;
        nArray2[2083] = 664;
        nArray2[2084] = 663;
        nArray2[2085] = 661;
        nArray2[2086] = 659;
        nArray2[2087] = 2352;
        nArray2[2088] = 656;
        nArray2[2089] = 2349;
        nArray2[2090] = 671;
        nArray2[2091] = 1679;
        nArray2[2092] = 1677;
        nArray2[2093] = 2553;
        nArray2[2094] = 922;
        nArray2[2095] = 919;
        nArray2[2096] = 2519;
        nArray2[2097] = 2516;
        nArray2[2098] = 885;
        nArray2[2099] = 883;
        nArray2[2100] = 881;
        nArray2[2101] = 2685;
        nArray2[2102] = 2661;
        nArray2[2103] = 2659;
        nArray2[2104] = 2767;
        nArray2[2105] = 2756;
        nArray2[2106] = 2755;
        nArray2[2107] = 140;
        nArray2[2108] = 1137;
        nArray2[2109] = 1136;
        nArray2[2110] = 130;
        nArray2[2111] = 127;
        nArray2[2112] = 1125;
        nArray2[2113] = 1124;
        nArray2[2114] = 1122;
        nArray2[2115] = 1127;
        nArray2[2116] = 109;
        nArray2[2117] = 106;
        nArray2[2118] = 102;
        nArray2[2119] = 1103;
        nArray2[2120] = 1102;
        nArray2[2121] = 1100;
        nArray2[2122] = 1098;
        nArray2[2123] = 116;
        nArray2[2124] = 1107;
        nArray2[2125] = 1105;
        nArray2[2126] = 1980;
        nArray2[2127] = 80;
        nArray2[2128] = 76;
        nArray2[2129] = 73;
        nArray2[2130] = 1947;
        nArray2[2131] = 1068;
        nArray2[2132] = 1067;
        nArray2[2133] = 1065;
        nArray2[2134] = 1063;
        nArray2[2135] = 90;
        nArray2[2136] = 1060;
        nArray2[2137] = 87;
        nArray2[2138] = 1075;
        nArray2[2139] = 1073;
        nArray2[2140] = 1070;
        nArray2[2141] = 1080;
        nArray2[2142] = 1966;
        nArray2[2143] = 1965;
        nArray2[2144] = 46;
        nArray2[2145] = 43;
        nArray2[2146] = 40;
        nArray2[2147] = 1912;
        nArray2[2148] = 36;
        nArray2[2149] = 1909;
        nArray2[2150] = 1019;
        nArray2[2151] = 1018;
        nArray2[2152] = 1016;
        nArray2[2153] = 1014;
        nArray2[2154] = 58;
        nArray2[2155] = 1011;
        nArray2[2156] = 55;
        nArray2[2157] = 1008;
        nArray2[2158] = 51;
        nArray2[2159] = 1029;
        nArray2[2160] = 1027;
        nArray2[2161] = 1024;
        nArray2[2162] = 1021;
        nArray2[2163] = 63;
        nArray2[2164] = 1037;
        nArray2[2165] = 1034;
        nArray2[2166] = 1940;
        nArray2[2167] = 1939;
        nArray2[2168] = 1937;
        nArray2[2169] = 1942;
        nArray2[2170] = 8;
        nArray2[2171] = 1866;
        nArray2[2172] = 4;
        nArray2[2173] = 1863;
        nArray2[2174] = 1;
        nArray2[2175] = 1860;
        nArray2[2176] = 956;
        nArray2[2177] = 954;
        nArray2[2178] = 952;
        nArray2[2179] = 949;
        nArray2[2180] = 946;
        nArray2[2181] = 17;
        nArray2[2182] = 14;
        nArray2[2183] = 969;
        nArray2[2184] = 967;
        nArray2[2185] = 964;
        nArray2[2186] = 961;
        nArray2[2187] = 27;
        nArray2[2188] = 957;
        nArray2[2189] = 24;
        nArray2[2190] = 979;
        nArray2[2191] = 976;
        nArray2[2192] = 972;
        nArray2[2193] = 1901;
        nArray2[2194] = 1900;
        nArray2[2195] = 1898;
        nArray2[2196] = 1896;
        nArray2[2197] = 986;
        nArray2[2198] = 1905;
        nArray2[2199] = 1903;
        nArray2[2200] = 350;
        nArray2[2201] = 349;
        nArray2[2202] = 1381;
        nArray2[2203] = 329;
        nArray2[2204] = 327;
        nArray2[2205] = 324;
        nArray2[2206] = 1368;
        nArray2[2207] = 1366;
        nArray2[2208] = 292;
        nArray2[2209] = 290;
        nArray2[2210] = 287;
        nArray2[2211] = 284;
        nArray2[2212] = 2118;
        nArray2[2213] = 304;
        nArray2[2214] = 1341;
        nArray2[2215] = 1339;
        nArray2[2216] = 1337;
        nArray2[2217] = 1345;
        nArray2[2218] = 243;
        nArray2[2219] = 240;
        nArray2[2220] = 237;
        nArray2[2221] = 2086;
        nArray2[2222] = 233;
        nArray2[2223] = 2083;
        nArray2[2224] = 254;
        nArray2[2225] = 1297;
        nArray2[2226] = 1295;
        nArray2[2227] = 1293;
        nArray2[2228] = 1290;
        nArray2[2229] = 1304;
        nArray2[2230] = 2114;
        nArray2[2231] = 190;
        nArray2[2232] = 187;
        nArray2[2233] = 184;
        nArray2[2234] = 2034;
        nArray2[2235] = 180;
        nArray2[2236] = 2031;
        nArray2[2237] = 177;
        nArray2[2238] = 2027;
        nArray2[2239] = 199;
        nArray2[2240] = 1233;
        nArray2[2241] = 1231;
        nArray2[2242] = 1229;
        nArray2[2243] = 1226;
        nArray2[2244] = 217;
        nArray2[2245] = 1223;
        nArray2[2246] = 1241;
        nArray2[2247] = 2078;
        nArray2[2248] = 2076;
        nArray2[2249] = 584;
        nArray2[2250] = 555;
        nArray2[2251] = 554;
        nArray2[2252] = 552;
        nArray2[2253] = 550;
        nArray2[2254] = 2282;
        nArray2[2255] = 562;
        nArray2[2256] = 1586;
        nArray2[2257] = 507;
        nArray2[2258] = 506;
        nArray2[2259] = 504;
        nArray2[2260] = 502;
        nArray2[2261] = 2257;
        nArray2[2262] = 499;
        nArray2[2263] = 2254;
        nArray2[2264] = 515;
        nArray2[2265] = 1563;
        nArray2[2266] = 1561;
        nArray2[2267] = 445;
        nArray2[2268] = 443;
        nArray2[2269] = 441;
        nArray2[2270] = 2219;
        nArray2[2271] = 438;
        nArray2[2272] = 2216;
        nArray2[2273] = 435;
        nArray2[2274] = 2212;
        nArray2[2275] = 460;
        nArray2[2276] = 454;
        nArray2[2277] = 475;
        nArray2[2278] = 1517;
        nArray2[2279] = 1515;
        nArray2[2280] = 1512;
        nArray2[2281] = 2447;
        nArray2[2282] = 798;
        nArray2[2283] = 797;
        nArray2[2284] = 2422;
        nArray2[2285] = 2419;
        nArray2[2286] = 770;
        nArray2[2287] = 768;
        nArray2[2288] = 766;
        nArray2[2289] = 2383;
        nArray2[2290] = 2380;
        nArray2[2291] = 2376;
        nArray2[2292] = 721;
        nArray2[2293] = 719;
        nArray2[2294] = 717;
        nArray2[2295] = 714;
        nArray2[2296] = 731;
        nArray2[2297] = 1714;
        nArray2[2298] = 2602;
        nArray2[2299] = 2582;
        nArray2[2300] = 2580;
        nArray2[2301] = 2548;
        nArray2[2302] = 2546;
        nArray2[2303] = 2543;
        nArray2[2304] = 923;
        nArray2[2305] = 921;
        nArray2[2306] = 2717;
        nArray2[2307] = 2706;
        nArray2[2308] = 2705;
        nArray2[2309] = 2683;
        nArray2[2310] = 2682;
        nArray2[2311] = 2680;
        nArray2[2312] = 1771;
        nArray2[2313] = 1752;
        nArray2[2314] = 1750;
        nArray2[2315] = 1733;
        nArray2[2316] = 1732;
        nArray2[2317] = 1731;
        nArray2[2318] = 1735;
        nArray2[2319] = 1814;
        nArray2[2320] = 1707;
        nArray2[2321] = 1670;
        nArray2[2322] = 1668;
        nArray2[2323] = 1631;
        nArray2[2324] = 1629;
        nArray2[2325] = 1626;
        nArray2[2326] = 1634;
        nArray2[2327] = 1599;
        nArray2[2328] = 1598;
        nArray2[2329] = 1596;
        nArray2[2330] = 1594;
        nArray2[2331] = 1603;
        nArray2[2332] = 1601;
        nArray2[2333] = 2326;
        nArray2[2334] = 1772;
        nArray2[2335] = 1753;
        nArray2[2336] = 1751;
        nArray2[2337] = 1581;
        nArray2[2338] = 1554;
        nArray2[2339] = 1552;
        nArray2[2340] = 1504;
        nArray2[2341] = 1501;
        nArray2[2342] = 1498;
        nArray2[2343] = 1509;
        nArray2[2344] = 1442;
        nArray2[2345] = 1437;
        nArray2[2346] = 1434;
        nArray2[2347] = 401;
        nArray2[2348] = 1448;
        nArray2[2349] = 1445;
        nArray2[2350] = 2206;
        nArray2[2351] = 1392;
        nArray2[2352] = 1391;
        nArray2[2353] = 1389;
        nArray2[2354] = 1387;
        nArray2[2355] = 1384;
        nArray2[2356] = 359;
        nArray2[2357] = 1399;
        nArray2[2358] = 1397;
        nArray2[2359] = 1394;
        nArray2[2360] = 1404;
        nArray2[2361] = 2171;
        nArray2[2362] = 2170;
        nArray2[2363] = 1708;
        nArray2[2364] = 1672;
        nArray2[2365] = 1669;
        nArray2[2366] = 619;
        nArray2[2367] = 1632;
        nArray2[2368] = 1630;
        nArray2[2369] = 1628;
        nArray2[2370] = 1773;
        nArray2[2371] = 1378;
        nArray2[2372] = 1363;
        nArray2[2373] = 1361;
        nArray2[2374] = 1333;
        nArray2[2375] = 1328;
        nArray2[2376] = 1336;
        nArray2[2377] = 1286;
        nArray2[2378] = 1281;
        nArray2[2379] = 1278;
        nArray2[2380] = 248;
        nArray2[2381] = 1292;
        nArray2[2382] = 1289;
        nArray2[2383] = 2111;
        nArray2[2384] = 1218;
        nArray2[2385] = 1216;
        nArray2[2386] = 1210;
        nArray2[2387] = 197;
        nArray2[2388] = 1206;
        nArray2[2389] = 193;
        nArray2[2390] = 1228;
        nArray2[2391] = 1225;
        nArray2[2392] = 1221;
        nArray2[2393] = 1236;
        nArray2[2394] = 2073;
        nArray2[2395] = 2071;
        nArray2[2396] = 1151;
        nArray2[2397] = 1150;
        nArray2[2398] = 1148;
        nArray2[2399] = 1146;
        nArray2[2400] = 152;
        nArray2[2401] = 1143;
        nArray2[2402] = 149;
        nArray2[2403] = 1140;
        nArray2[2404] = 145;
        nArray2[2405] = 1161;
        nArray2[2406] = 1159;
        nArray2[2407] = 1156;
        nArray2[2408] = 1153;
        nArray2[2409] = 158;
        nArray2[2410] = 1169;
        nArray2[2411] = 1166;
        nArray2[2412] = 2017;
        nArray2[2413] = 2016;
        nArray2[2414] = 2014;
        nArray2[2415] = 2019;
        nArray2[2416] = 1582;
        nArray2[2417] = 510;
        nArray2[2418] = 1556;
        nArray2[2419] = 1553;
        nArray2[2420] = 452;
        nArray2[2421] = 448;
        nArray2[2422] = 1506;
        nArray2[2423] = 1500;
        nArray2[2424] = 394;
        nArray2[2425] = 391;
        nArray2[2426] = 387;
        nArray2[2427] = 1443;
        nArray2[2428] = 1441;
        nArray2[2429] = 1439;
        nArray2[2430] = 1436;
        nArray2[2431] = 1450;
        nArray2[2432] = 2207;
        nArray2[2433] = 765;
        nArray2[2434] = 716;
        nArray2[2435] = 713;
        nArray2[2436] = 1709;
        nArray2[2437] = 662;
        nArray2[2438] = 660;
        nArray2[2439] = 657;
        nArray2[2440] = 1673;
        nArray2[2441] = 1671;
        nArray2[2442] = 916;
        nArray2[2443] = 914;
        nArray2[2444] = 879;
        nArray2[2445] = 878;
        nArray2[2446] = 877;
        nArray2[2447] = 882;
        nArray2[2448] = 1135;
        nArray2[2449] = 1134;
        nArray2[2450] = 1121;
        nArray2[2451] = 1120;
        nArray2[2452] = 1118;
        nArray2[2453] = 1123;
        nArray2[2454] = 1097;
        nArray2[2455] = 1096;
        nArray2[2456] = 1094;
        nArray2[2457] = 1092;
        nArray2[2458] = 103;
        nArray2[2459] = 1101;
        nArray2[2460] = 1099;
        nArray2[2461] = 1979;
        nArray2[2462] = 1059;
        nArray2[2463] = 1058;
        nArray2[2464] = 1056;
        nArray2[2465] = 1054;
        nArray2[2466] = 77;
        nArray2[2467] = 1051;
        nArray2[2468] = 74;
        nArray2[2469] = 1066;
        nArray2[2470] = 1064;
        nArray2[2471] = 1061;
        nArray2[2472] = 1071;
        nArray2[2473] = 1964;
        nArray2[2474] = 1963;
        nArray2[2475] = 1007;
        nArray2[2476] = 1006;
        nArray2[2477] = 1004;
        nArray2[2478] = 1002;
        nArray2[2479] = 999;
        nArray2[2480] = 41;
        nArray2[2481] = 996;
        nArray2[2482] = 37;
        nArray2[2483] = 1017;
        nArray2[2484] = 1015;
        nArray2[2485] = 1012;
        nArray2[2486] = 1009;
        nArray2[2487] = 52;
        nArray2[2488] = 1025;
        nArray2[2489] = 1022;
        nArray2[2490] = 1936;
        nArray2[2491] = 1935;
        nArray2[2492] = 1933;
        nArray2[2493] = 1938;
        nArray2[2494] = 942;
        nArray2[2495] = 940;
        nArray2[2496] = 938;
        nArray2[2497] = 935;
        nArray2[2498] = 932;
        nArray2[2499] = 5;
        nArray2[2500] = 2;
        nArray2[2501] = 955;
        nArray2[2502] = 953;
        nArray2[2503] = 950;
        nArray2[2504] = 947;
        nArray2[2505] = 18;
        nArray2[2506] = 943;
        nArray2[2507] = 15;
        nArray2[2508] = 965;
        nArray2[2509] = 962;
        nArray2[2510] = 958;
        nArray2[2511] = 1895;
        nArray2[2512] = 1894;
        nArray2[2513] = 1892;
        nArray2[2514] = 1890;
        nArray2[2515] = 973;
        nArray2[2516] = 1899;
        nArray2[2517] = 1897;
        nArray2[2518] = 1379;
        nArray2[2519] = 325;
        nArray2[2520] = 1364;
        nArray2[2521] = 1362;
        nArray2[2522] = 288;
        nArray2[2523] = 285;
        nArray2[2524] = 1334;
        nArray2[2525] = 1332;
        nArray2[2526] = 1330;
        nArray2[2527] = 241;
        nArray2[2528] = 238;
        nArray2[2529] = 234;
        nArray2[2530] = 1287;
        nArray2[2531] = 1285;
        nArray2[2532] = 1283;
        nArray2[2533] = 1280;
        nArray2[2534] = 1294;
        nArray2[2535] = 2112;
        nArray2[2536] = 188;
        nArray2[2537] = 185;
        nArray2[2538] = 181;
        nArray2[2539] = 178;
        nArray2[2540] = 2028;
        nArray2[2541] = 1219;
        nArray2[2542] = 1217;
        nArray2[2543] = 1215;
        nArray2[2544] = 1212;
        nArray2[2545] = 200;
        nArray2[2546] = 1209;
        nArray2[2547] = 1227;
        nArray2[2548] = 2074;
        nArray2[2549] = 2072;
        nArray2[2550] = 583;
        nArray2[2551] = 553;
        nArray2[2552] = 551;
        nArray2[2553] = 1583;
        nArray2[2554] = 505;
        nArray2[2555] = 503;
        nArray2[2556] = 500;
        nArray2[2557] = 513;
        nArray2[2558] = 1557;
        nArray2[2559] = 1555;
        nArray2[2560] = 444;
        nArray2[2561] = 442;
        nArray2[2562] = 439;
        nArray2[2563] = 436;
        nArray2[2564] = 2213;
        nArray2[2565] = 455;
        nArray2[2566] = 451;
        nArray2[2567] = 1507;
        nArray2[2568] = 1505;
        nArray2[2569] = 1502;
        nArray2[2570] = 796;
        nArray2[2571] = 763;
        nArray2[2572] = 762;
        nArray2[2573] = 760;
        nArray2[2574] = 767;
        nArray2[2575] = 711;
        nArray2[2576] = 710;
        nArray2[2577] = 708;
        nArray2[2578] = 706;
        nArray2[2579] = 2377;
        nArray2[2580] = 718;
        nArray2[2581] = 715;
        nArray2[2582] = 1710;
        nArray2[2583] = 2544;
        nArray2[2584] = 917;
        nArray2[2585] = 915;
        nArray2[2586] = 2681;
        nArray2[2587] = 1627;
        nArray2[2588] = 1597;
        nArray2[2589] = 1595;
        nArray2[2590] = 2325;
        nArray2[2591] = 1769;
        nArray2[2592] = 1749;
        nArray2[2593] = 1747;
        nArray2[2594] = 1499;
        nArray2[2595] = 1438;
        nArray2[2596] = 1435;
        nArray2[2597] = 2204;
        nArray2[2598] = 1390;
        nArray2[2599] = 1388;
        nArray2[2600] = 1385;
        nArray2[2601] = 1395;
        nArray2[2602] = 2169;
        nArray2[2603] = 2167;
        nArray2[2604] = 1704;
        nArray2[2605] = 1665;
        nArray2[2606] = 1662;
        nArray2[2607] = 1625;
        nArray2[2608] = 1623;
        nArray2[2609] = 1620;
        nArray2[2610] = 1770;
        nArray2[2611] = 1329;
        nArray2[2612] = 1282;
        nArray2[2613] = 1279;
        nArray2[2614] = 2109;
        nArray2[2615] = 1214;
        nArray2[2616] = 1207;
        nArray2[2617] = 1222;
        nArray2[2618] = 2068;
        nArray2[2619] = 2065;
        nArray2[2620] = 1149;
        nArray2[2621] = 1147;
        nArray2[2622] = 1144;
        nArray2[2623] = 1141;
        nArray2[2624] = 146;
        nArray2[2625] = 1157;
        nArray2[2626] = 1154;
        nArray2[2627] = 2013;
        nArray2[2628] = 2011;
        nArray2[2629] = 2008;
        nArray2[2630] = 2015;
        nArray2[2631] = 1579;
        nArray2[2632] = 1549;
        nArray2[2633] = 1546;
        nArray2[2634] = 1495;
        nArray2[2635] = 1487;
        nArray2[2636] = 1433;
        nArray2[2637] = 1431;
        nArray2[2638] = 1428;
        nArray2[2639] = 1425;
        nArray2[2640] = 388;
        nArray2[2641] = 1440;
        nArray2[2642] = 2205;
        nArray2[2643] = 1705;
        nArray2[2644] = 658;
        nArray2[2645] = 1667;
        nArray2[2646] = 1664;
        nArray2[2647] = 1119;
        nArray2[2648] = 1095;
        nArray2[2649] = 1093;
        nArray2[2650] = 1978;
        nArray2[2651] = 1057;
        nArray2[2652] = 1055;
        nArray2[2653] = 1052;
        nArray2[2654] = 1062;
        nArray2[2655] = 1962;
        nArray2[2656] = 1960;
        nArray2[2657] = 1005;
        nArray2[2658] = 1003;
        nArray2[2659] = 1000;
        nArray2[2660] = 997;
        nArray2[2661] = 38;
        nArray2[2662] = 1013;
        nArray2[2663] = 1010;
        nArray2[2664] = 1932;
        nArray2[2665] = 1930;
        nArray2[2666] = 1927;
        nArray2[2667] = 1934;
        nArray2[2668] = 941;
        nArray2[2669] = 939;
        nArray2[2670] = 936;
        nArray2[2671] = 933;
        nArray2[2672] = 6;
        nArray2[2673] = 930;
        nArray2[2674] = 3;
        nArray2[2675] = 951;
        nArray2[2676] = 948;
        nArray2[2677] = 944;
        nArray2[2678] = 1889;
        nArray2[2679] = 1887;
        nArray2[2680] = 1884;
        nArray2[2681] = 1881;
        nArray2[2682] = 959;
        nArray2[2683] = 1893;
        nArray2[2684] = 1891;
        nArray2[2685] = 35;
        nArray2[2686] = 1377;
        nArray2[2687] = 1360;
        nArray2[2688] = 1358;
        nArray2[2689] = 1327;
        nArray2[2690] = 1325;
        nArray2[2691] = 1322;
        nArray2[2692] = 1331;
        nArray2[2693] = 1277;
        nArray2[2694] = 1275;
        nArray2[2695] = 1272;
        nArray2[2696] = 1269;
        nArray2[2697] = 235;
        nArray2[2698] = 1284;
        nArray2[2699] = 2110;
        nArray2[2700] = 1205;
        nArray2[2701] = 1204;
        nArray2[2702] = 1201;
        nArray2[2703] = 1198;
        nArray2[2704] = 182;
        nArray2[2705] = 1195;
        nArray2[2706] = 179;
        nArray2[2707] = 1213;
        nArray2[2708] = 2070;
        nArray2[2709] = 2067;
        nArray2[2710] = 1580;
        nArray2[2711] = 501;
        nArray2[2712] = 1551;
        nArray2[2713] = 1548;
        nArray2[2714] = 440;
        nArray2[2715] = 437;
        nArray2[2716] = 1497;
        nArray2[2717] = 1494;
        nArray2[2718] = 1490;
        nArray2[2719] = 1503;
        nArray2[2720] = 761;
        nArray2[2721] = 709;
        nArray2[2722] = 707;
        nArray2[2723] = 1706;
        nArray2[2724] = 913;
        nArray2[2725] = 912;
        nArray2[2726] = 2198;
        nArray2[2727] = 1386;
        nArray2[2728] = 2164;
        nArray2[2729] = 2161;
        nArray2[2730] = 1621;
        nArray2[2731] = 1766;
        nArray2[2732] = 2103;
        nArray2[2733] = 1208;
        nArray2[2734] = 2058;
        nArray2[2735] = 2054;
        nArray2[2736] = 1145;
        nArray2[2737] = 1142;
        nArray2[2738] = 2005;
        nArray2[2739] = 2002;
        nArray2[2740] = 1999;
        nArray2[2741] = 2009;
        nArray2[2742] = 1488;
        nArray2[2743] = 1429;
        nArray2[2744] = 1426;
        nArray2[2745] = 2200;
        nArray2[2746] = 1698;
        nArray2[2747] = 1659;
        nArray2[2748] = 1656;
        nArray2[2749] = 1975;
        nArray2[2750] = 1053;
        nArray2[2751] = 1957;
        nArray2[2752] = 1954;
        nArray2[2753] = 1001;
        nArray2[2754] = 998;
        nArray2[2755] = 1924;
        nArray2[2756] = 1921;
        nArray2[2757] = 1918;
        nArray2[2758] = 1928;
        nArray2[2759] = 937;
        nArray2[2760] = 934;
        nArray2[2761] = 931;
        nArray2[2762] = 1879;
        nArray2[2763] = 1876;
        nArray2[2764] = 1873;
        nArray2[2765] = 1870;
        nArray2[2766] = 945;
        nArray2[2767] = 1885;
        nArray2[2768] = 1882;
        nArray2[2769] = 1323;
        nArray2[2770] = 1273;
        nArray2[2771] = 1270;
        nArray2[2772] = 2105;
        nArray2[2773] = 1202;
        nArray2[2774] = 1199;
        nArray2[2775] = 1196;
        nArray2[2776] = 1211;
        nArray2[2777] = 2061;
        nArray2[2778] = 2057;
        nArray2[2779] = 1576;
        nArray2[2780] = 1543;
        nArray2[2781] = 1540;
        nArray2[2782] = 1484;
        nArray2[2783] = 1481;
        nArray2[2784] = 1478;
        nArray2[2785] = 1491;
        nArray2[2786] = 1700;
        CODEWORD_TABLE = nArray2;
    }
}

