/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.decoder;

import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.qrcode.decoder.DataMask;
import com.dcloud.zxing2.qrcode.decoder.FormatInformation;
import com.dcloud.zxing2.qrcode.decoder.Version;

final class BitMatrixParser {
    private final BitMatrix bitMatrix;
    private Version parsedVersion;
    private FormatInformation parsedFormatInfo;
    private boolean mirror;

    BitMatrixParser(BitMatrix bitMatrix) throws FormatException {
        int n5 = bitMatrix.getHeight();
        if (n5 >= 21 && (n5 & 3) == 1) {
            this.bitMatrix = bitMatrix;
            return;
        }
        throw FormatException.getFormatInstance();
    }

    private int copyBit(int n5, int n6, int n7) {
        if (this.mirror ? this.bitMatrix.get(n6, n5) : this.bitMatrix.get(n5, n6)) {
            return n7 << 1 | 1;
        }
        return n7 << 1;
    }

    FormatInformation readFormatInformation() throws FormatException {
        FormatInformation formatInformation;
        int n5;
        FormatInformation formatInformation2 = this.parsedFormatInfo;
        if (formatInformation2 != null) {
            return formatInformation2;
        }
        int n6 = 0;
        for (n5 = 0; n5 < 6; ++n5) {
            n6 = this.copyBit(n5, 8, n6);
        }
        BitMatrixParser bitMatrixParser = this;
        n6 = bitMatrixParser.copyBit(7, 8, n6);
        n6 = bitMatrixParser.copyBit(8, 8, n6);
        n6 = bitMatrixParser.copyBit(8, 7, n6);
        for (n5 = 5; n5 >= 0; --n5) {
            n6 = this.copyBit(8, n5, n6);
        }
        n5 = this.bitMatrix.getHeight();
        int n7 = 0;
        int n8 = n5 - 7;
        for (int i5 = n5 - 1; i5 >= n8; --i5) {
            n7 = this.copyBit(8, i5, n7);
        }
        for (n8 = n5 - 8; n8 < n5; ++n8) {
            n7 = this.copyBit(n8, 8, n7);
        }
        this.parsedFormatInfo = formatInformation = FormatInformation.decodeFormatInformation(n6, n7);
        if (formatInformation != null) {
            return formatInformation;
        }
        throw FormatException.getFormatInstance();
    }

    Version readVersion() throws FormatException {
        int n5;
        int n6;
        Version version = this.parsedVersion;
        if (version != null) {
            return version;
        }
        int n7 = this.bitMatrix.getHeight();
        int n8 = (n7 - 17) / 4;
        if (n8 <= 6) {
            return Version.getVersionForNumber(n8);
        }
        n8 = 0;
        int n9 = n7 - 11;
        for (n6 = 5; n6 >= 0; --n6) {
            for (n5 = n7 - 9; n5 >= n9; --n5) {
                n8 = this.copyBit(n5, n6, n8);
            }
        }
        Version version2 = Version.decodeVersionInformation(n8);
        if (version2 != null && version2.getDimensionForVersion() == n7) {
            this.parsedVersion = version2;
            return version2;
        }
        int n10 = 0;
        for (n6 = 5; n6 >= 0; --n6) {
            for (n5 = n7 - 9; n5 >= n9; --n5) {
                n10 = this.copyBit(n6, n5, n10);
            }
        }
        Version version3 = Version.decodeVersionInformation(n10);
        if (version3 != null && version3.getDimensionForVersion() == n7) {
            this.parsedVersion = version3;
            return version3;
        }
        throw FormatException.getFormatInstance();
    }

    byte[] readCodewords() throws FormatException {
        int n5;
        BitMatrixParser bitMatrixParser = this;
        Object object = bitMatrixParser.readFormatInformation();
        Version version = bitMatrixParser.readVersion();
        object = DataMask.forReference(((FormatInformation)object).getDataMask());
        int n6 = bitMatrixParser.bitMatrix.getHeight();
        Version version2 = version;
        ((DataMask)object).unmaskBitMatrix(this.bitMatrix, n6);
        object = version2.buildFunctionPattern();
        boolean bl = true;
        byte[] byArray = new byte[version2.getTotalCodewords()];
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (int i5 = n5 = n6 - 1; i5 > 0; i5 -= 2) {
            if (i5 == 6) {
                --i5;
            }
            for (int i6 = 0; i6 < n6; ++i6) {
                int n10 = bl ? n5 - i6 : i6;
                for (int i7 = 0; i7 < 2; ++i7) {
                    int n11 = i5 - i7;
                    if (((BitMatrix)object).get(n11, n10)) continue;
                    int n12 = n8;
                    n8 = n9 + 1;
                    n9 = n12 << 1;
                    if (this.bitMatrix.get(n11, n10)) {
                        n9 |= 1;
                    }
                    if (n8 == 8) {
                        n8 = n7 + 1;
                        byArray[n7] = (byte)n9;
                        n7 = 0;
                        n9 = 0;
                        int n13 = n8;
                        n8 = n9;
                        n9 = n7;
                        n7 = n13;
                        continue;
                    }
                    int n14 = n8;
                    n8 = n9;
                    n9 = n14;
                }
            }
            bl ^= true;
        }
        if (n7 == version.getTotalCodewords()) {
            return byArray;
        }
        throw FormatException.getFormatInstance();
    }

    void remask() {
        FormatInformation formatInformation = this.parsedFormatInfo;
        if (formatInformation == null) {
            return;
        }
        BitMatrixParser bitMatrixParser = this;
        int n5 = bitMatrixParser.bitMatrix.getHeight();
        DataMask.forReference(formatInformation.getDataMask()).unmaskBitMatrix(bitMatrixParser.bitMatrix, n5);
    }

    void setMirror(boolean bl) {
        BitMatrixParser bitMatrixParser = this;
        bitMatrixParser.parsedVersion = null;
        bitMatrixParser.parsedFormatInfo = null;
        bitMatrixParser.mirror = bl;
    }

    void mirror() {
        int n5 = 0;
        while (n5 < this.bitMatrix.getWidth()) {
            int n6;
            for (int i5 = n6 = n5 + 1; i5 < this.bitMatrix.getHeight(); ++i5) {
                if (this.bitMatrix.get(n5, i5) == this.bitMatrix.get(i5, n5)) continue;
                BitMatrixParser bitMatrixParser = this;
                bitMatrixParser.bitMatrix.flip(i5, n5);
                bitMatrixParser.bitMatrix.flip(n5, i5);
            }
            n5 = n6;
        }
    }
}

