/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.MediaType;
import dc.squareup.okhttp3.RequestBody;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public final class FormBody
extends RequestBody {
    private static final MediaType CONTENT_TYPE = MediaType.get("application/x-www-form-urlencoded");
    private final List<String> encodedNames;
    private final List<String> encodedValues;

    FormBody(List<String> list, List<String> list2) {
        this.encodedNames = Util.immutableList(list);
        this.encodedValues = Util.immutableList(list2);
    }

    private long writeOrCountBytes(@Nullable BufferedSink bufferedSink, boolean bl) {
        long l5 = 0L;
        if (bl) {
            Buffer buffer;
            bufferedSink = buffer;
            buffer = new Buffer();
        } else {
            bufferedSink = bufferedSink.buffer();
        }
        int n5 = this.encodedNames.size();
        for (int i5 = 0; i5 < n5; ++i5) {
            if (i5 > 0) {
                ((Buffer)bufferedSink).writeByte(38);
            }
            BufferedSink bufferedSink2 = bufferedSink;
            ((Buffer)bufferedSink2).writeUtf8(this.encodedNames.get(i5));
            ((Buffer)bufferedSink2).writeByte(61);
            ((Buffer)bufferedSink).writeUtf8(this.encodedValues.get(i5));
        }
        if (bl) {
            long l6 = ((Buffer)bufferedSink).size();
            ((Buffer)bufferedSink).clear();
            return l6;
        }
        return l5;
    }

    public int size() {
        return this.encodedNames.size();
    }

    public String encodedName(int n5) {
        return this.encodedNames.get(n5);
    }

    public String name(int n5) {
        return HttpUrl.percentDecode(this.encodedName(n5), true);
    }

    public String encodedValue(int n5) {
        return this.encodedValues.get(n5);
    }

    public String value(int n5) {
        return HttpUrl.percentDecode(this.encodedValue(n5), true);
    }

    @Override
    public MediaType contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public long contentLength() {
        return this.writeOrCountBytes(null, true);
    }

    @Override
    public void writeTo(BufferedSink bufferedSink) throws IOException {
        this.writeOrCountBytes(bufferedSink, false);
    }

    public static final class Builder {
        private final List<String> names;
        private final List<String> values;
        private final Charset charset;

        public Builder() {
            this(null);
        }

        public Builder(Charset charset) {
            ArrayList arrayList;
            ArrayList arrayList2;
            Object object = arrayList2;
            arrayList2 = new ArrayList();
            v1.names = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.values = object;
            v1.charset = charset;
        }

        public Builder add(String object, String string2) {
            if (object != null) {
                if (string2 != null) {
                    Builder builder = charset;
                    String string3 = object;
                    object = ((Builder)((Object)charset)).charset;
                    builder.names.add(HttpUrl.canonicalize(string3, " \"':;<=>@[]^`{}|/\\?#&!$(),~", false, false, true, true, (Charset)object));
                    Charset charset = ((Builder)((Object)charset)).charset;
                    builder.values.add(HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#&!$(),~", false, false, true, true, charset));
                    return builder;
                }
                throw new NullPointerException("value == null");
            }
            throw new NullPointerException("name == null");
        }

        public Builder addEncoded(String object, String string2) {
            if (object != null) {
                if (string2 != null) {
                    Builder builder = charset;
                    String string3 = object;
                    object = ((Builder)((Object)charset)).charset;
                    builder.names.add(HttpUrl.canonicalize(string3, " \"':;<=>@[]^`{}|/\\?#&!$(),~", true, false, true, true, (Charset)object));
                    Charset charset = ((Builder)((Object)charset)).charset;
                    builder.values.add(HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#&!$(),~", true, false, true, true, charset));
                    return builder;
                }
                throw new NullPointerException("value == null");
            }
            throw new NullPointerException("name == null");
        }

        public FormBody build() {
            Builder builder = list;
            List<String> list = builder.names;
            return new FormBody(list, builder.values);
        }
    }
}

