/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.connection;

import dc.squareup.okhttp3.Address;
import dc.squareup.okhttp3.Call;
import dc.squareup.okhttp3.EventListener;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.Route;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.connection.RouteDatabase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

public final class RouteSelector {
    private final Address address;
    private final RouteDatabase routeDatabase;
    private final Call call;
    private final EventListener eventListener;
    private List<Proxy> proxies;
    private int nextProxyIndex;
    private List<InetSocketAddress> inetSocketAddresses;
    private final List<Route> postponedRoutes;

    public RouteSelector(Address address, RouteDatabase routeDatabase, Call call, EventListener eventListener) {
        ArrayList arrayList;
        RouteSelector routeSelector = object;
        Address address2 = address;
        Object object = Collections.EMPTY_LIST;
        v2.proxies = object;
        v2.inetSocketAddresses = object;
        object = arrayList;
        arrayList = new ArrayList();
        v2.postponedRoutes = object;
        v2.address = address;
        v2.routeDatabase = routeDatabase;
        v2.call = call;
        v2.eventListener = eventListener;
        object = address2.url();
        routeSelector.resetNextProxy((HttpUrl)object, address2.proxy());
    }

    private void resetNextProxy(HttpUrl list, Proxy proxy) {
        if (proxy != null) {
            this.proxies = Collections.singletonList(proxy);
        } else {
            list = this.address.proxySelector().select(((HttpUrl)((Object)list)).uri());
            list = list != null && !list.isEmpty() ? Util.immutableList(list) : Util.immutableList(Proxy.NO_PROXY);
            this.proxies = list;
        }
        this.nextProxyIndex = 0;
    }

    private boolean hasNextProxy() {
        return this.nextProxyIndex < this.proxies.size();
    }

    private Proxy nextProxy() throws IOException {
        if (this.hasNextProxy()) {
            int n5 = this.nextProxyIndex;
            this.nextProxyIndex = n5 + 1;
            Proxy proxy = this.proxies.get(n5);
            this.resetNextInetSocketAddress(proxy);
            return proxy;
        }
        throw new SocketException("No route to " + this.address.url().host() + "; exhausted proxy configurations: " + this.proxies);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resetNextInetSocketAddress(Proxy list) throws IOException {
        int n5;
        Object object;
        this.inetSocketAddresses = new ArrayList<InetSocketAddress>();
        if (((Proxy)((Object)list)).type() != Proxy.Type.DIRECT && ((Proxy)((Object)list)).type() != Proxy.Type.SOCKS) {
            object = ((Proxy)((Object)list)).address();
            if (!(object instanceof InetSocketAddress)) throw new IllegalArgumentException("Proxy.address() is not an InetSocketAddress: " + object.getClass());
            InetSocketAddress inetSocketAddress = (InetSocketAddress)object;
            object = RouteSelector.getHostString(inetSocketAddress);
            n5 = inetSocketAddress.getPort();
        } else {
            RouteSelector routeSelector = this;
            object = routeSelector.address.url().host();
            n5 = routeSelector.address.url().port();
        }
        if (n5 < 1 || n5 > 65535) throw new SocketException("No route to " + (String)object + ":" + n5 + "; port is out of range");
        if (((Proxy)((Object)list)).type() == Proxy.Type.SOCKS) {
            this.inetSocketAddresses.add(InetSocketAddress.createUnresolved((String)object, n5));
            return;
        }
        RouteSelector routeSelector = this;
        routeSelector.eventListener.dnsStart(this.call, (String)object);
        list = routeSelector.address.dns().lookup((String)object);
        if (list.isEmpty()) throw new UnknownHostException(this.address.dns() + " returned no addresses for " + (String)object);
        this.eventListener.dnsEnd(this.call, (String)object, list);
        int n6 = list.size();
        for (int i5 = 0; i5 < n6; ++i5) {
            InetAddress inetAddress = list.get(i5);
            this.inetSocketAddresses.add(new InetSocketAddress(inetAddress, n5));
        }
    }

    static String getHostString(InetSocketAddress inetSocketAddress) {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            return inetSocketAddress.getHostName();
        }
        return inetAddress.getHostAddress();
    }

    public boolean hasNext() {
        return this.hasNextProxy() || !this.postponedRoutes.isEmpty();
        {
        }
    }

    public Selection next() throws IOException {
        if (this.hasNext()) {
            ArrayList<Route> arrayList;
            ArrayList<Route> arrayList2 = arrayList;
            arrayList = new ArrayList<Route>();
            while (this.hasNextProxy()) {
                RouteSelector routeSelector = this;
                Proxy proxy = routeSelector.nextProxy();
                int n5 = routeSelector.inetSocketAddresses.size();
                for (int i5 = 0; i5 < n5; ++i5) {
                    Route route;
                    Route route2 = route;
                    route = new Route(this.address, proxy, this.inetSocketAddresses.get(i5));
                    if (this.routeDatabase.shouldPostpone(route2)) {
                        this.postponedRoutes.add(route2);
                        continue;
                    }
                    arrayList2.add(route2);
                }
                if (arrayList2.isEmpty()) continue;
            }
            if (arrayList2.isEmpty()) {
                arrayList2.addAll(this.postponedRoutes);
                this.postponedRoutes.clear();
            }
            return new Selection(arrayList2);
        }
        throw new NoSuchElementException();
    }

    public void connectFailed(Route route, IOException iOException) {
        if (route.proxy().type() != Proxy.Type.DIRECT && this.address.proxySelector() != null) {
            this.address.proxySelector().connectFailed(this.address.url().uri(), route.proxy().address(), iOException);
        }
        this.routeDatabase.failed(route);
    }

    public static final class Selection {
        private final List<Route> routes;
        private int nextRouteIndex = 0;

        Selection(List<Route> list) {
            this.routes = list;
        }

        public boolean hasNext() {
            return this.nextRouteIndex < this.routes.size();
        }

        public Route next() {
            if (this.hasNext()) {
                int n5 = this.nextRouteIndex;
                this.nextRouteIndex = n5 + 1;
                return this.routes.get(n5);
            }
            throw new NoSuchElementException();
        }

        public List<Route> getAll() {
            return new ArrayList<Route>(this.routes);
        }
    }
}

