/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http2.ErrorCode;
import dc.squareup.okhttp3.internal.http2.Header;
import dc.squareup.okhttp3.internal.http2.Http2Connection;
import dc.squareup.okhttp3.internal.http2.StreamResetException;
import dc.squareup.okio.AsyncTimeout;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public final class Http2Stream {
    static final /* synthetic */ boolean $assertionsDisabled;
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    final int id;
    final Http2Connection connection;
    private final Deque<Headers> headersQueue;
    private Header.Listener headersListener;
    private boolean hasResponseHeaders;
    private final FramingSource source;
    final FramingSink sink;
    final StreamTimeout readTimeout;
    final StreamTimeout writeTimeout;
    ErrorCode errorCode;

    Http2Stream(int n5, Http2Connection closeable, boolean bl, boolean bl2, @Nullable Headers headers) {
        StreamTimeout streamTimeout;
        StreamTimeout streamTimeout2;
        ArrayDeque<Headers> arrayDeque;
        ArrayDeque<Headers> arrayDeque2 = arrayDeque;
        arrayDeque = new ArrayDeque<Headers>();
        this.headersQueue = arrayDeque2;
        StreamTimeout streamTimeout3 = streamTimeout2;
        streamTimeout2 = new StreamTimeout();
        this.readTimeout = streamTimeout3;
        streamTimeout3 = streamTimeout;
        streamTimeout = new StreamTimeout();
        this.writeTimeout = streamTimeout3;
        this.errorCode = null;
        if (closeable != null) {
            FramingSink framingSink;
            FramingSource framingSource;
            Http2Stream http2Stream = this;
            this.id = n5;
            this.connection = closeable;
            http2Stream.bytesLeftInWriteWindow = closeable.peerSettings.getInitialWindowSize();
            FramingSource framingSource2 = framingSource;
            http2Stream.source = new FramingSource(closeable.okHttpSettings.getInitialWindowSize());
            Closeable closeable2 = closeable = framingSink;
            this.sink = closeable2;
            framingSource2.finished = bl2;
            framingSink.finished = bl;
            if (headers != null) {
                arrayDeque2.add(headers);
            }
            if (this.isLocallyInitiated() && headers != null) {
                throw new IllegalStateException("locally-initiated streams shouldn't have headers yet");
            }
            if (!this.isLocallyInitiated()) {
                if (headers != null) {
                    return;
                }
                throw new IllegalStateException("remotely-initiated streams should have headers");
            }
            return;
        }
        throw new NullPointerException("connection == null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean closeInternal(ErrorCode errorCode) {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            try {
                if (http2Stream.errorCode != null) {
                    // ** MonitorExit[this] (shouldn't be in output)
                    return false;
                }
                if (this.source.finished && this.sink.finished) {
                    // ** MonitorExit[this] (shouldn't be in output)
                    return false;
                }
                Http2Stream http2Stream2 = this;
                http2Stream2.errorCode = errorCode;
                http2Stream2.notifyAll();
                // ** MonitorExit[v1] (shouldn't be in output)
                http2Stream2.connection.removeStream(this.id);
            }
            catch (Throwable throwable) {}
            return true;
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable;
        }
    }

    static {
        $assertionsDisabled = Http2Stream.class.desiredAssertionStatus() ^ true;
    }

    public int getId() {
        return this.id;
    }

    public synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        Closeable closeable = this.source;
        if (closeable.finished || closeable.closed) {
            closeable = this.sink;
            if ((((FramingSink)closeable).finished || ((FramingSink)closeable).closed) && this.hasResponseHeaders) {
                return false;
            }
        }
        return true;
    }

    public boolean isLocallyInitiated() {
        boolean bl = (this.id & 1) == 1;
        return this.connection.client == bl;
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Headers takeHeaders() throws IOException {
        Throwable throwable2;
        block4: {
            this.readTimeout.enter();
            try {
                while (this.headersQueue.isEmpty() && this.errorCode == null) {
                    this.waitForIo();
                }
            }
            catch (Throwable throwable2) {
                break block4;
            }
            Http2Stream http2Stream = this;
            http2Stream.readTimeout.exitAndThrowIfTimedOut();
            if (!http2Stream.headersQueue.isEmpty()) {
                return this.headersQueue.removeFirst();
            }
            throw new StreamResetException(this.errorCode);
        }
        this.readTimeout.exitAndThrowIfTimedOut();
        throw throwable2;
    }

    public synchronized ErrorCode getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void writeHeaders(List<Header> list, boolean bl) throws IOException {
        if (!$assertionsDisabled) {
            if (Thread.holdsLock(this)) throw new AssertionError();
        }
        if (list == null) throw new NullPointerException("headers == null");
        boolean bl2 = bl;
        bl = false;
        boolean bl22 = false;
        // MONITORENTER : this
        this.hasResponseHeaders = true;
        if (!bl2) {
            this.sink.finished = true;
            bl22 = true;
            bl = true;
        }
        if (!bl22) {
            Http2Stream http2Stream = this;
            Http2Connection http2Connection = http2Stream.connection;
            // MONITORENTER : http2Connection
            bl22 = http2Stream.connection.bytesLeftInWriteWindow == 0L;
            // MONITOREXIT : http2Connection
        }
        this.connection.writeSynReply(this.id, bl, list);
        if (!bl22) return;
        this.connection.flush();
    }

    public Timeout readTimeout() {
        return this.readTimeout;
    }

    public Timeout writeTimeout() {
        return this.writeTimeout;
    }

    public Source getSource() {
        return this.source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sink getSink() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            try {
                if (!http2Stream.hasResponseHeaders && !this.isLocallyInitiated()) {
                    throw new IllegalStateException("reply before requesting the sink");
                }
                Http2Stream http2Stream2 = this;
                // ** MonitorExit[v1] (shouldn't be in output)
                return http2Stream2.sink;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    public void close(ErrorCode errorCode) throws IOException {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynReset(this.id, errorCode);
    }

    public void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveHeaders(List<Header> list) {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            http2Stream.hasResponseHeaders = true;
            http2Stream.headersQueue.add(Util.toHeaders(list));
            boolean bl = http2Stream.isOpen();
            Http2Stream http2Stream2 = this;
            http2Stream2.notifyAll();
            // ** MonitorExit[v3] (shouldn't be in output)
            if (!bl) {
                this.connection.removeStream(this.id);
                return;
            }
            return;
        }
    }

    void receiveData(BufferedSource bufferedSource, int n5) throws IOException {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.source.receive(bufferedSource, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveFin() {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            http2Stream.source.finished = true;
            boolean bl = http2Stream.isOpen();
            Http2Stream http2Stream2 = this;
            http2Stream2.notifyAll();
            // ** MonitorExit[v2] (shouldn't be in output)
            if (!bl) {
                this.connection.removeStream(this.id);
                return;
            }
            return;
        }
    }

    synchronized void receiveRstStream(ErrorCode errorCode) {
        if (this.errorCode == null) {
            this.errorCode = errorCode;
            this.notifyAll();
            return;
        }
    }

    public synchronized void setHeadersListener(Header.Listener listener) {
        this.headersListener = listener;
        if (!this.headersQueue.isEmpty() && listener != null) {
            this.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void cancelStreamIfNecessary() throws IOException {
        boolean bl;
        block9: {
            block8: {
                if (!$assertionsDisabled) {
                    if (Thread.holdsLock(this)) throw new AssertionError();
                }
                Http2Stream http2Stream = this;
                // MONITORENTER : http2Stream
                Closeable closeable = http2Stream.source;
                if (closeable.finished || !closeable.closed) break block8;
                closeable = this.sink;
                if (!((FramingSink)closeable).finished && !((FramingSink)closeable).closed) break block8;
                bl = true;
                break block9;
            }
            bl = false;
        }
        Http2Stream http2Stream = this;
        boolean bl2 = http2Stream.isOpen();
        // MONITOREXIT : http2Stream
        if (bl) {
            this.close(ErrorCode.CANCEL);
            return;
        }
        if (bl2) return;
        this.connection.removeStream(this.id);
    }

    void addBytesToWriteWindow(long l5) {
        this.bytesLeftInWriteWindow += l5;
        if (l5 > 0L) {
            this.notifyAll();
            return;
        }
    }

    void checkOutNotClosed() throws IOException {
        FramingSink framingSink = this.sink;
        if (!framingSink.closed) {
            if (!framingSink.finished) {
                if (this.errorCode == null) {
                    return;
                }
                throw new StreamResetException(this.errorCode);
            }
            throw new IOException("stream finished");
        }
        throw new IOException("stream closed");
    }

    void waitForIo() throws InterruptedIOException {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    class StreamTimeout
    extends AsyncTimeout {
        StreamTimeout() {
        }

        @Override
        protected void timedOut() {
            StreamTimeout streamTimeout = this;
            streamTimeout.Http2Stream.this.closeLater(ErrorCode.CANCEL);
            streamTimeout.Http2Stream.this.connection.sendDegradedPingLater();
        }

        @Override
        protected IOException newTimeoutException(IOException iOException) {
            SocketTimeoutException socketTimeoutException;
            SocketTimeoutException socketTimeoutException2 = socketTimeoutException;
            socketTimeoutException = new SocketTimeoutException("timeout");
            if (iOException != null) {
                SocketTimeoutException socketTimeoutException3 = socketTimeoutException2;
                socketTimeoutException3.initCause(iOException);
                return socketTimeoutException3;
            }
            return socketTimeoutException2;
        }

        public void exitAndThrowIfTimedOut() throws IOException {
            if (!this.exit()) {
                return;
            }
            throw this.newTimeoutException(null);
        }
    }

    private final class FramingSource
    implements Source {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final Buffer receiveBuffer;
        private final Buffer readBuffer;
        private final long maxByteCount;
        boolean closed;
        boolean finished;

        FramingSource(long l5) {
            Buffer buffer;
            Buffer buffer2;
            Source source = buffer2;
            buffer2 = new Buffer();
            v1.receiveBuffer = source;
            source = buffer;
            buffer = new Buffer();
            v1.readBuffer = source;
            v1.maxByteCount = l5;
        }

        private void updateConnectionFlowControl(long l5) {
            if (!$assertionsDisabled && Thread.holdsLock(Http2Stream.this)) {
                throw new AssertionError();
            }
            Http2Stream.this.connection.updateConnectionFlowControl(l5);
        }

        static {
            $assertionsDisabled = Http2Stream.class.desiredAssertionStatus() ^ true;
        }

        /*
         * Exception decompiling
         */
        @Override
        public long read(Buffer var1_1, long var2_2) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [8 : 120->127)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void receive(BufferedSource bufferedSource, long l5) throws IOException {
            if (!$assertionsDisabled) {
                if (Thread.holdsLock(Http2Stream.this)) throw new AssertionError();
            }
            while (l5 > 0L) {
                long l6;
                block13: {
                    boolean bl;
                    block12: {
                        FramingSource framingSource = this;
                        Http2Stream http2Stream = framingSource.Http2Stream.this;
                        // MONITORENTER : http2Stream
                        bl = framingSource.finished;
                        // MONITOREXIT : http2Stream
                        if (!(l5 + framingSource.readBuffer.size() > this.maxByteCount)) break block12;
                        bufferedSource.skip(l5);
                        Http2Stream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                        return;
                    }
                    if (bl) {
                        bufferedSource.skip(l5);
                        return;
                    }
                    l6 = bufferedSource.read(this.receiveBuffer, l5);
                    if (l6 == -1L) throw new EOFException();
                    FramingSource framingSource = this;
                    l5 -= l6;
                    l6 = 0L;
                    Http2Stream http2Stream = framingSource.Http2Stream.this;
                    // MONITORENTER : http2Stream
                    if (framingSource.closed) {
                        FramingSource framingSource2 = this;
                        l6 = framingSource2.receiveBuffer.size();
                        framingSource2.receiveBuffer.clear();
                        break block13;
                    }
                    boolean bl2 = this.readBuffer.size() == 0L;
                    this.readBuffer.writeAll(this.receiveBuffer);
                    if (!bl2) break block13;
                    Http2Stream.this.notifyAll();
                }
                // MONITOREXIT : http2Stream
                if (l6 <= 0L) continue;
                this.updateConnectionFlowControl(l6);
            }
            return;
            catch (Throwable throwable) {
                // MONITOREXIT : http2Stream
                throw throwable;
            }
        }

        @Override
        public Timeout timeout() {
            return Http2Stream.this.readTimeout;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            long l5;
            Header.Listener listener;
            ArrayList arrayList;
            block7: {
                ArrayList arrayList2;
                FramingSource framingSource = this;
                arrayList = null;
                listener = null;
                Http2Stream http2Stream = framingSource.Http2Stream.this;
                // MONITORENTER : http2Stream
                framingSource.closed = true;
                l5 = framingSource.readBuffer.size();
                framingSource.readBuffer.clear();
                if (framingSource.Http2Stream.this.headersQueue.isEmpty() || Http2Stream.this.headersListener == null) break block7;
                FramingSource framingSource2 = this;
                FramingSource framingSource3 = framingSource2;
                FramingSource framingSource4 = framingSource2;
                arrayList = arrayList2;
                arrayList2 = new ArrayList(Http2Stream.this.headersQueue);
                framingSource3.Http2Stream.this.headersQueue.clear();
                listener = framingSource4.Http2Stream.this.headersListener;
            }
            Http2Stream.this.notifyAll();
            // MONITOREXIT : http2Stream
            if (l5 > 0L) {
                this.updateConnectionFlowControl(l5);
            }
            Http2Stream.this.cancelStreamIfNecessary();
            if (listener == null) return;
            int n5 = 0;
            int n6 = arrayList.size();
            while (n5 < n6) {
                Object e5 = arrayList.get(n5);
                ++n5;
                listener.onHeaders((Headers)e5);
            }
        }
    }

    final class FramingSink
    implements Sink {
        private static final long EMIT_BUFFER_SIZE = 16384L;
        static final /* synthetic */ boolean $assertionsDisabled;
        private final Buffer sendBuffer;
        boolean closed;
        boolean finished;

        FramingSink() {
            Buffer buffer;
            Sink sink = buffer;
            buffer = new Buffer();
            v1.sendBuffer = sink;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void emitFrame(boolean bl) throws IOException {
            FramingSink framingSink = this;
            Http2Stream http2Stream = framingSink.Http2Stream.this;
            synchronized (http2Stream) {
                Throwable throwable4;
                Throwable throwable22;
                block14: {
                    Throwable throwable32;
                    block15: {
                        boolean bl2;
                        int n5;
                        Object object;
                        long l5;
                        FramingSink framingSink2;
                        boolean bl3;
                        Http2Stream http2Stream2;
                        framingSink.Http2Stream.this.writeTimeout.enter();
                        try {
                            while (true) {
                                http2Stream2 = Http2Stream.this;
                                if (http2Stream2.bytesLeftInWriteWindow <= 0L && !this.finished && !this.closed && http2Stream2.errorCode == null) {
                                    http2Stream2.waitForIo();
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable throwable22) {
                            break block14;
                        }
                        try {
                            bl3 = bl;
                            framingSink2 = this;
                            Http2Stream http2Stream3 = http2Stream;
                            FramingSink framingSink3 = this;
                            http2Stream2.writeTimeout.exitAndThrowIfTimedOut();
                            framingSink3.Http2Stream.this.checkOutNotClosed();
                            l5 = Math.min(framingSink3.Http2Stream.this.bytesLeftInWriteWindow, this.sendBuffer.size());
                            object = framingSink3.Http2Stream.this;
                        }
                        catch (Throwable throwable4) {}
                        long l6 = ((Http2Stream)object).bytesLeftInWriteWindow;
                        ((Http2Stream)object).bytesLeftInWriteWindow = l6 - l5;
                        // ** MonitorExit[v4] (shouldn't be in output)
                        ((Http2Stream)object).writeTimeout.enter();
                        try {
                            Http2Stream http2Stream4 = framingSink2.Http2Stream.this;
                            object = http2Stream4.connection;
                            n5 = http2Stream4.id;
                            bl2 = bl3 && l5 == this.sendBuffer.size();
                        }
                        catch (Throwable throwable32) {
                            break block15;
                        }
                        ((Http2Connection)object).writeData(n5, bl2, this.sendBuffer, l5);
                        Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
                        return;
                    }
                    Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
                    throw throwable32;
                }
                Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
                throw throwable22;
                throw throwable4;
            }
        }

        static {
            $assertionsDisabled = Http2Stream.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public void write(Buffer buffer, long l5) throws IOException {
            if (!$assertionsDisabled && Thread.holdsLock(Http2Stream.this)) {
                throw new AssertionError();
            }
            this.sendBuffer.write(buffer, l5);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitFrame(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void flush() throws IOException {
            if (!$assertionsDisabled && Thread.holdsLock(Http2Stream.this)) {
                throw new AssertionError();
            }
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                Http2Stream.this.checkOutNotClosed();
            }
            while (this.sendBuffer.size() > 0L) {
                FramingSink framingSink = this;
                framingSink.emitFrame(false);
                framingSink.Http2Stream.this.connection.flush();
            }
            return;
        }

        @Override
        public Timeout timeout() {
            return Http2Stream.this.writeTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            if (!$assertionsDisabled) {
                if (Thread.holdsLock(Http2Stream.this)) throw new AssertionError();
            }
            FramingSink framingSink = this;
            Http2Stream http2Stream = framingSink.Http2Stream.this;
            // MONITORENTER : http2Stream
            if (framingSink.closed) {
                // MONITOREXIT : http2Stream
                return;
            }
            if (!Http2Stream.this.sink.finished) {
                if (this.sendBuffer.size() > 0L) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(true);
                    }
                } else {
                    http2Stream = Http2Stream.this;
                    http2Stream.connection.writeData(http2Stream.id, true, null, 0L);
                }
            }
            FramingSink framingSink2 = this;
            http2Stream = framingSink2.Http2Stream.this;
            // MONITORENTER : http2Stream
            this.closed = true;
            // MONITOREXIT : http2Stream
            framingSink2.Http2Stream.this.connection.flush();
            framingSink2.Http2Stream.this.cancelStreamIfNecessary();
        }
    }
}

