/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import java.util.Arrays;

public final class Settings {
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    static final int HEADER_TABLE_SIZE = 1;
    static final int ENABLE_PUSH = 2;
    static final int MAX_CONCURRENT_STREAMS = 4;
    static final int MAX_FRAME_SIZE = 5;
    static final int MAX_HEADER_LIST_SIZE = 6;
    static final int INITIAL_WINDOW_SIZE = 7;
    static final int COUNT = 10;
    private int set;
    private final int[] values = new int[10];

    void clear() {
        this.set = 0;
        Arrays.fill(this.values, 0);
    }

    Settings set(int n5, int n6) {
        if (n5 >= 0) {
            int[] nArray = this.values;
            if (n5 < this.values.length) {
                int n7 = 1 << n5;
                this.set |= n7;
                nArray[n5] = n6;
                return this;
            }
        }
        return this;
    }

    boolean isSet(int n5) {
        int n6 = 1 << n5;
        return (this.set & n6) != 0;
    }

    int get(int n5) {
        return this.values[n5];
    }

    int size() {
        return Integer.bitCount(this.set);
    }

    int getHeaderTableSize() {
        if ((this.set & 2) != 0) {
            return this.values[1];
        }
        return -1;
    }

    boolean getEnablePush(boolean bl) {
        return ((this.set & 4) != 0 ? this.values[2] : (bl ? 1 : 0)) == 1;
    }

    int getMaxConcurrentStreams(int n5) {
        if ((this.set & 0x10) != 0) {
            return this.values[4];
        }
        return n5;
    }

    int getMaxFrameSize(int n5) {
        if ((this.set & 0x20) != 0) {
            return this.values[5];
        }
        return n5;
    }

    int getMaxHeaderListSize(int n5) {
        if ((this.set & 0x40) != 0) {
            return this.values[6];
        }
        return n5;
    }

    int getInitialWindowSize() {
        if ((this.set & 0x80) != 0) {
            return this.values[7];
        }
        return 65535;
    }

    void merge(Settings settings) {
        for (int i5 = 0; i5 < 10; ++i5) {
            if (!settings.isSet(i5)) continue;
            this.set(i5, settings.get(i5));
        }
    }
}

