/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.Segment;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.IOException;

final class PeekSource
implements Source {
    private final BufferedSource upstream;
    private final Buffer buffer;
    private Segment expectedSegment;
    private int expectedPos;
    private boolean closed;
    private long pos;

    PeekSource(BufferedSource object) {
        this.upstream = object;
        this.buffer = object.buffer();
        this.expectedSegment = object = this.buffer.head;
        int n5 = object != null ? ((Segment)object).pos : -1;
        this.expectedPos = n5;
    }

    @Override
    public long read(Buffer buffer, long l5) throws IOException {
        if (l5 >= 0L) {
            if (!this.closed) {
                Segment segment = this.expectedSegment;
                if (segment != null && (segment != (segment = this.buffer.head) || this.expectedPos != segment.pos)) {
                    throw new IllegalStateException("Peek source is invalid because upstream source was used");
                }
                if (l5 == 0L) {
                    return 0L;
                }
                if (!this.upstream.request(this.pos + 1L)) {
                    return -1L;
                }
                if (this.expectedSegment == null && (segment = this.buffer.head) != null) {
                    this.expectedSegment = segment;
                    this.expectedPos = segment.pos;
                }
                l5 = Math.min(l5, this.buffer.size - this.pos);
                PeekSource peekSource = this;
                peekSource.buffer.copyTo(buffer, this.pos, l5);
                peekSource.pos += l5;
                return l5;
            }
            throw new IllegalStateException("closed");
        }
        throw new IllegalArgumentException("byteCount < 0: " + l5);
    }

    @Override
    public Timeout timeout() {
        return this.upstream.timeout();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

