/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.adapter.ui;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import io.dcloud.base.R;
import io.dcloud.common.adapter.ui.AdaFrameItem;
import io.dcloud.common.adapter.ui.AdaWebview;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.adapter.util.ViewOptions;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;

public class PullRefreshView
extends View {
    public static final String TAG = "PullRefreshView";
    public static final byte TYPE_PULL_UP_REFRESH = 0;
    public static final byte TYPE_PULL_DOWN_REFRESH = 1;
    static int MAX_FRAME_COUNT = 9;
    static int HEIGHT = 25;
    static final byte STATE_NO_REFRESH = 0;
    static final byte STATE_ON_MOVE_ING = 1;
    static final byte STATE_ON_OVER = 2;
    static final byte STATE_ON_REFRESH_ING = 3;
    static final byte FLAG_NO_THING = -1;
    static final byte FLAG_STARTED = 0;
    static final byte FLAG_MOVEED = 1;
    static final int color_tr = 0xFF00F0;
    byte mType;
    String mContent_down;
    String mContent_over;
    String mContent_refresh;
    String mShowContent;
    String mSecInfo;
    private Rect src;
    private RectF dst;
    Bitmap mIcon;
    float mFontScale;
    int changeStateHeight;
    int maxPullHeight;
    float startX;
    float startY;
    AdaFrameItem mParent;
    AdaWebview mWebview;
    private float mWebviewScale;
    int sScreenWidth;
    int sScreenHeight;
    Paint paint;
    int index;
    private int contentLeft;
    private int contentTop;
    private int contentWidth;
    byte mState;
    boolean touch_started;
    boolean mCaptureTouchEnd;
    byte mFlag;
    int icon_x;
    int icon_y;
    int fontSize;
    int mScrollHeight;
    byte SCROLL_STATE_MIN;
    byte SCROLL_STATE_MAX;
    byte SCROLL_STATE_MIDDLE;
    byte mScrollState;
    boolean mEnableScrollMinHeight;
    boolean mEnableScrollMaxHeight;
    float lastScrollY;
    boolean mRefreshState;
    Timer mUpdateProgressBar;

    public PullRefreshView(AdaFrameItem adaFrameItem, AdaWebview adaWebview) {
        Paint paint;
        AdaWebview adaWebview2 = adaWebview;
        super(adaFrameItem.getContext());
        this.mType = 1;
        this.mShowContent = null;
        this.mSecInfo = null;
        this.mIcon = null;
        this.mFontScale = 1.2f;
        this.changeStateHeight = 100;
        this.maxPullHeight = 100;
        Paint paint2 = paint;
        paint = new Paint();
        this.paint = paint2;
        this.index = 0;
        this.contentLeft = 0;
        this.contentTop = 0;
        this.contentWidth = 0;
        this.mState = 0;
        this.touch_started = false;
        this.mCaptureTouchEnd = false;
        this.mFlag = 0;
        this.mScrollHeight = 0;
        this.SCROLL_STATE_MIN = 0;
        this.SCROLL_STATE_MAX = 1;
        this.SCROLL_STATE_MIDDLE = (byte)2;
        this.mScrollState = 0;
        this.mEnableScrollMinHeight = true;
        this.mEnableScrollMaxHeight = true;
        this.mRefreshState = false;
        this.mUpdateProgressBar = null;
        this.mParent = adaFrameItem;
        this.mWebview = adaWebview;
        this.mContent_down = this.getResources().getString(R.string.dcloud_drop_down_refresh1);
        this.mContent_over = this.getResources().getString(R.string.dcloud_drop_down_refresh2);
        this.mContent_refresh = this.getResources().getString(R.string.dcloud_drop_down_refresh3);
        this.sScreenWidth = adaWebview2.obtainApp().getInt(0);
        this.sScreenHeight = adaWebview2.obtainApp().getInt(1);
        this.mWebviewScale = adaWebview2.getScale();
        this.init(null);
        this.paint.setAntiAlias(true);
    }

    private boolean updateScrollState(byte by) {
        boolean bl = false;
        this.mScrollState = by;
        if (by == this.SCROLL_STATE_MAX) {
            PullRefreshView pullRefreshView = this;
            pullRefreshView.mScrollHeight = pullRefreshView.maxPullHeight;
            if (pullRefreshView.mEnableScrollMaxHeight) {
                bl = true;
                this.mEnableScrollMaxHeight = false;
            }
            this.mEnableScrollMinHeight = true;
            return bl;
        }
        if (by == this.SCROLL_STATE_MIN) {
            this.mEnableScrollMaxHeight = true;
            this.mScrollHeight = 0;
            if (this.mEnableScrollMinHeight) {
                this.mEnableScrollMinHeight = false;
                return true;
            }
        } else if (by == this.SCROLL_STATE_MIDDLE) {
            PullRefreshView pullRefreshView = this;
            pullRefreshView.mEnableScrollMinHeight = true;
            pullRefreshView.mEnableScrollMaxHeight = true;
            return true;
        }
        return bl;
    }

    private void stopUpdateScreenTimer() {
        Timer timer = this.mUpdateProgressBar;
        if (timer != null) {
            timer.cancel();
            this.mUpdateProgressBar = null;
            return;
        }
    }

    private void startUpdateScreenTimer() {
        TimerTask timerTask;
        Timer timer;
        this.stopUpdateScreenTimer();
        Object object = timer;
        ((Timer)object)();
        this.mUpdateProgressBar = object;
        object = timerTask;
        timerTask = new TimerTask(){

            @Override
            public void run() {
                PullRefreshView.this.updateScreen();
            }
        };
        timer.schedule((TimerTask)object, 0L, 100L);
    }

    static void smoothScrollTo(final ViewGroup viewGroup, final View view, final int n5, final int n6, int n7) {
        TimerTask timerTask;
        Timer timer;
        final Timer timer2 = timer;
        timer2();
        TimerTask timerTask2 = timerTask;
        timerTask = new TimerTask(){
            View child;
            ViewGroup parent;
            final int TIME;
            int toX;
            int toY;
            int fromX;
            int fromY;
            int timesCount;
            int flagTimes;
            int vX;
            int vY;
            {
                this.child = view2;
                this.parent = viewGroup2;
                this.TIME = 500;
                this.toX = n52;
                this.toY = n62;
                this.fromX = viewGroup2.getScrollX();
                this.fromY = this.parent.getScrollY();
                this.timesCount = 10;
                this.flagTimes = 1;
                this.vX = Math.abs(this.toX - this.fromX) / this.timesCount;
                this.vY = Math.abs(this.toY - this.fromY) / this.timesCount;
                if (this.vY >= 5) {
                    this.vY = 5;
                    this.timesCount = Math.abs(this.toY - this.fromY) / this.vY;
                }
                this.vX = Math.abs(this.toX - this.fromX) / this.timesCount;
            }

            @Override
            public void run() {
                2 v02 = this;
                int n52 = v02.fromX + this.vX;
                int n62 = v02.fromY + this.vY;
                if (v02.flagTimes == this.timesCount) {
                    2 v12 = this;
                    n52 = v12.toX;
                    n62 = v12.toY;
                }
                2 v22 = this;
                PullRefreshView.scrollToByMessage((View)v22.parent, n52, n62);
                if (v22.flagTimes == this.timesCount) {
                    if (this.child != null) {
                        this.parent.post(new Runnable(){

                            @Override
                            public void run() {
                                Runnable runnable = runnable.this;
                                runnable.parent.removeView(runnable.child);
                            }
                        });
                    }
                    timer2.cancel();
                }
                this.fromX = n52;
                this.fromY = n62;
                ++this.flagTimes;
            }
        };
        long l5 = n7;
        timer.schedule(timerTask2, 0L, l5);
    }

    private static void scrollToByMessage(final View view, final int n5, final int n6) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                3 v02 = this;
                int n52 = v02.n5;
                view.scrollTo(n52, v02.n6);
            }
        };
        view.post(runnable2);
    }

    protected void onDraw(Canvas canvas) {
        if (pullRefreshView3.mState != 0) {
            PullRefreshView pullRefreshView = pullRefreshView3;
            canvas.drawColor(-1907998);
            pullRefreshView.paint.setColor(-16777216);
            pullRefreshView.paint.setTextSize((float)pullRefreshView3.fontSize);
            String string2 = pullRefreshView.mShowContent;
            float f5 = pullRefreshView.contentLeft;
            float f6 = pullRefreshView.contentTop;
            Paint paint = pullRefreshView.paint;
            canvas.drawText(string2, f5, f6, paint);
            string2 = pullRefreshView3.mIcon;
            if (string2 != null) {
                Canvas canvas2 = canvas;
                PullRefreshView pullRefreshView2 = pullRefreshView3;
                PullRefreshView pullRefreshView3 = pullRefreshView2.src;
                canvas = pullRefreshView2.dst;
                Paint paint2 = pullRefreshView2.paint;
                canvas2.drawBitmap((Bitmap)string2, (Rect)pullRefreshView3, (RectF)canvas, paint2);
                return;
            }
        }
    }

    public void updateScreen() {
        if (++this.index >= MAX_FRAME_COUNT) {
            this.index = 0;
        }
        PullRefreshView pullRefreshView = this;
        int n5 = HEIGHT;
        int n6 = this.index;
        int n7 = n5 * n6;
        int n8 = n5 * (n6 + 1);
        pullRefreshView.src.set(n7, 0, n8, n5);
        pullRefreshView.postInvalidate();
    }

    public void init(String string2) {
        int n5;
        BitmapFactory.Options options;
        string2 = options;
        new BitmapFactory.Options().inScaled = false;
        string2 = BitmapFactory.decodeStream((InputStream)PlatformUtil.getResInputStream("res/dcloud_prograss_snow1.png"), null, (BitmapFactory.Options)string2);
        this.mIcon = string2;
        HEIGHT = n5 = string2.getHeight();
        int n6 = this.sScreenWidth;
        this.contentLeft = (int)((float)n6 * 0.43f);
        this.icon_x = (int)((float)n6 * 0.41f) - n5;
        int n7 = n5 = HEIGHT;
        this.src = new Rect(0, 0, n7, n7);
        int n8 = HEIGHT;
        float f5 = n8;
        float f6 = n8;
        this.dst = new RectF(0.0f, 150.0f, f5, f6);
        MAX_FRAME_COUNT = string2.getWidth() / HEIGHT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseJsonOption(JSONObject jSONObject) {
        int n5;
        try {
            if (!jSONObject.isNull("height")) {
                int n6;
                this.changeStateHeight = n6 = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject, "height"), this.mWebview.mFrameView.mViewOptions.height, this.changeStateHeight, this.mWebviewScale);
                this.maxPullHeight = n6;
            }
            if (!jSONObject.isNull("range")) {
                this.maxPullHeight = PdrUtil.convertToScreenInt(jSONObject.getString("range"), this.mWebview.mFrameView.mViewOptions.height, this.changeStateHeight, this.mWebviewScale);
            }
            if (!jSONObject.isNull("contentdown")) {
                this.changeStringInfo(JSONUtil.getString(jSONObject.getJSONObject("contentdown"), "caption"));
            }
            if (!jSONObject.isNull("contentover")) {
                this.mContent_over = JSONUtil.getString(jSONObject.getJSONObject("contentover"), "caption");
            }
            if (!jSONObject.isNull("contentrefresh")) {
                this.mContent_refresh = JSONUtil.getString(jSONObject.getJSONObject("contentrefresh"), "caption");
            }
            n5 = Math.max(this.maxPullHeight - this.changeStateHeight, 0);
        }
        catch (JSONException jSONException) {}
        int n7 = n5;
        Paint.FontMetricsInt fontMetricsInt = DeviceInfo.sPaint.getFontMetricsInt();
        int n8 = this.changeStateHeight;
        int n9 = fontMetricsInt.bottom - fontMetricsInt.top;
        this.contentTop = n7 + (n8 >> 1) + (n9 >> 1);
        n7 = HEIGHT;
        int n10 = n5 + (n8 - n7 >> 1);
        this.icon_y = n10;
        RectF rectF = this.dst;
        int n11 = n10;
        int n12 = n7;
        int n13 = this.icon_x;
        float f5 = n13;
        float f6 = n10;
        float f7 = n13 + n7;
        float f8 = n11 + n12;
        rectF.set(f5, f6, f7, f8);
        Logger.d(TAG, "height=" + this.changeStateHeight + ";range=" + this.maxPullHeight + ";contentdown=" + this.mShowContent);
        return;
        jSONException.printStackTrace();
    }

    public void changeStringInfo(String string2) {
        this.mShowContent = string2;
        this.fontSize = (int)(DeviceInfo.DEFAULT_FONT_SIZE * DeviceInfo.sDensity * this.mFontScale);
        this.paint.setAntiAlias(true);
        int n5 = string2.length();
        float[] fArray = new float[n5];
        this.paint.getTextWidths(string2, fArray);
        float f5 = 0.0f;
        for (int i5 = 0; i5 < n5; ++i5) {
            f5 += fArray[i5];
        }
        this.contentWidth = (int)f5;
    }

    void setColorByParentChild(View view) {
        int n5 = 2;
        for (int i5 = 0; i5 != n5; ++i5) {
            view = (View)view.getParent();
            view.setBackgroundColor(0xFF00F0);
        }
    }

    void onPullDown_start(float f5, float f6) {
        if (!this.touch_started) {
            byte by;
            Logger.d(TAG, "onPullDown_start");
            this.startX = f5;
            this.startY = f6;
            this.lastScrollY = f6;
            if (this.getParent() == null) {
                AbsoluteLayout.LayoutParams layoutParams;
                AbsoluteLayout.LayoutParams layoutParams2 = layoutParams;
                PullRefreshView pullRefreshView = this;
                int n5 = pullRefreshView.maxPullHeight;
                ViewOptions viewOptions = pullRefreshView.mWebview.mViewOptions;
                int n6 = viewOptions.left;
                int n7 = viewOptions.top - n5;
                layoutParams = new AbsoluteLayout.LayoutParams(-1, n5, n6, n7);
                ((ViewGroup)this.mParent.obtainMainView()).addView((View)this, 0, (ViewGroup.LayoutParams)layoutParams2);
            }
            if ((by = this.mState) == 0) {
                PullRefreshView pullRefreshView = this;
                pullRefreshView.mState = 1;
                pullRefreshView.mFlag = 0;
            } else if (by == 3) {
                this.mFlag = 0;
            }
            this.touch_started = true;
            return;
        }
    }

    boolean onMove(float f5, float f6) {
        int n5 = (int)((f6 - this.lastScrollY) * (float)this.maxPullHeight / (float)this.mWebview.mFrameView.mViewOptions.height);
        if (Math.abs(n5) < 1) {
            if (this.mScrollHeight > 0) {
                return true;
            }
            float f7 = n5;
            if ((f7 > 0.5f || f7 < -0.5f) && this.mFlag == 0) {
                this.mFlag = 1;
            }
            return false;
        }
        int n6 = this.mScrollHeight + n5;
        this.mScrollHeight = n6;
        n6 = n6 >= this.maxPullHeight ? (int)(this.updateScrollState(this.SCROLL_STATE_MAX) ? 1 : 0) : (n6 <= 0 ? (int)(this.updateScrollState(this.SCROLL_STATE_MIN) ? 1 : 0) : (int)(this.updateScrollState(this.SCROLL_STATE_MIDDLE) ? 1 : 0));
        byte by = this.mState;
        if (by != 3) {
            if (by == 1 && this.mScrollHeight >= this.changeStateHeight) {
                this.mState = (byte)2;
                this.changeStringInfo(this.mContent_over);
            } else if (by == 2 && this.mScrollHeight < this.changeStateHeight) {
                this.mState = 1;
                this.changeStringInfo(this.mContent_down);
            }
        }
        if (n6 != 0) {
            if (this.mFlag == 0) {
                this.mFlag = 1;
                Logger.d(TAG, "onMove; mFlag=FLAG_MOVEED");
                this.startUpdateScreenTimer();
            }
            this.mParent.obtainMainView().scrollBy(0, -n5);
            this.lastScrollY = f6;
            return n6 != 0;
        }
        return n6 != 0;
    }

    void onExecuting() {
        PullRefreshView pullRefreshView = this;
        Logger.d(TAG, "onExecuting");
        pullRefreshView.mState = (byte)3;
        pullRefreshView.mRefreshState = true;
        pullRefreshView.mFlag = (byte)-1;
        Logger.d(TAG, "onExecuting; mFlag = FLAG_NO_THING");
        pullRefreshView.changeStringInfo(pullRefreshView.mContent_refresh);
        pullRefreshView.mScrollHeight = pullRefreshView.changeStateHeight;
        int n5 = -this.changeStateHeight;
        PullRefreshView.smoothScrollTo((ViewGroup)pullRefreshView.mParent.obtainMainView(), null, 0, n5, 1);
    }

    void onPullDown_end() {
        if (this.mScrollHeight <= this.changeStateHeight) {
            PullRefreshView pullRefreshView = this;
            pullRefreshView.mState = 0;
            pullRefreshView.mScrollHeight = 0;
            pullRefreshView.mFlag = (byte)-1;
            Logger.d(TAG, "onPullDown_end; mFlag = FLAG_NO_THING");
            pullRefreshView.changeStringInfo(pullRefreshView.mContent_down);
            Timer timer = pullRefreshView.mUpdateProgressBar;
            if (timer != null) {
                timer.cancel();
            }
            PullRefreshView pullRefreshView2 = this;
            pullRefreshView2.mParent.obtainMainView().scrollTo(0, 0);
            pullRefreshView2.stopUpdateScreenTimer();
        } else {
            this.smoothScrollToStateHeight(true);
        }
        this.mRefreshState = false;
    }

    void smoothScrollToStateHeight(boolean bl) {
        if (bl) {
            PullRefreshView pullRefreshView = this;
            pullRefreshView.mScrollHeight = pullRefreshView.changeStateHeight;
            int n5 = -this.changeStateHeight;
            PullRefreshView.smoothScrollTo((ViewGroup)pullRefreshView.mParent.obtainMainView(), null, 0, n5, 1);
            return;
        }
        if (this.mScrollHeight > this.changeStateHeight) {
            this.smoothScrollToStateHeight(true);
            return;
        }
        this.mRefreshState = false;
    }
}

