/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.audio.aac;

import android.media.MediaCodec;
import android.media.MediaFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class AacEncode {
    private static AacEncode mInstance;
    private MediaCodec mediaCodec;
    ByteBuffer[] inputBuffers = null;
    ByteBuffer[] outputBuffers = null;
    MediaCodec.BufferInfo bufferInfo;
    long presentationTimeUs = 0L;
    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private int mSampleRate;
    private int mChannelCount;
    private HashMap<Integer, Integer> freqidxs = new HashMap();

    public AacEncode(int n5, int n6) {
        MediaFormat mediaFormat;
        try {
            ((AacEncode)object).mediaCodec = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        AacEncode aacEncode = object;
        ((AacEncode)object).mSampleRate = n5;
        aacEncode.mChannelCount = n6;
        aacEncode.initFreqidxs();
        int[] nArray = new int[3];
        Object object = nArray;
        nArray[0] = 64000;
        nArray[1] = 96000;
        nArray[2] = 128000;
        MediaFormat mediaFormat2 = mediaFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)n5, (int)n6);
        mediaFormat2.setString("mime", "audio/mp4a-latm");
        mediaFormat2.setInteger("aac-profile", 2);
        mediaFormat.setInteger("bitrate", (int)object[1]);
        mediaFormat.setInteger("max-input-size", 0x100000);
        aacEncode.mediaCodec.configure(mediaFormat, null, null, 1);
        aacEncode.mediaCodec.start();
        aacEncode.inputBuffers = aacEncode.mediaCodec.getInputBuffers();
        aacEncode.outputBuffers = aacEncode.mediaCodec.getOutputBuffers();
        aacEncode.bufferInfo = new MediaCodec.BufferInfo();
    }

    private void addADTStoPacket(byte[] byArray, int n5) {
        AacEncode aacEncode = this;
        int n6 = aacEncode.freqidxs.get(this.mSampleRate);
        int n7 = aacEncode.mChannelCount;
        byArray[0] = -1;
        byArray[1] = -7;
        byArray[2] = (byte)(64 + (n6 << 2) + (n7 >> 2));
        byArray[3] = (byte)(((n7 & 3) << 6) + (n5 >> 11));
        byArray[4] = (byte)((n5 & 0x7FF) >> 3);
        byArray[5] = (byte)(((n5 & 7) << 5) + 31);
        byArray[6] = -4;
    }

    private long computePresentationTime(long l5) {
        return l5 * 92160000L / (long)this.mSampleRate;
    }

    public static AacEncode getAacEncode(int n5, int n6) {
        if (mInstance == null) {
            mInstance = new AacEncode(n5, n6);
        }
        return mInstance;
    }

    public static AacEncode getAacEncode() {
        return mInstance;
    }

    public void initFreqidxs() {
        AacEncode aacEncode = this;
        aacEncode.freqidxs.put(96000, 0);
        aacEncode.freqidxs.put(88200, 1);
        aacEncode.freqidxs.put(64000, 2);
        aacEncode.freqidxs.put(48000, 3);
        aacEncode.freqidxs.put(44100, 4);
        aacEncode.freqidxs.put(32000, 5);
        aacEncode.freqidxs.put(24000, 6);
        aacEncode.freqidxs.put(22050, 7);
        aacEncode.freqidxs.put(16000, 8);
        aacEncode.freqidxs.put(12000, 9);
        aacEncode.freqidxs.put(11025, 10);
        aacEncode.freqidxs.put(8000, 11);
        aacEncode.freqidxs.put(7350, 12);
    }

    public void close() {
        try {
            AacEncode aacEncode = this;
            aacEncode.mediaCodec.stop();
            aacEncode.mediaCodec.release();
            aacEncode.outputStream.flush();
            aacEncode.outputStream.close();
            mInstance = null;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public byte[] offerEncoder(byte[] byArray) throws Exception {
        int n5 = this.mediaCodec.dequeueInputBuffer(-1L);
        if (n5 >= 0) {
            long l5;
            ByteBuffer byteBuffer = this.inputBuffers[n5];
            byteBuffer.clear();
            byteBuffer.put(byArray);
            byteBuffer.limit(byArray.length);
            long l6 = this.presentationTimeUs;
            l6 = this.computePresentationTime(l6);
            this.mediaCodec.queueInputBuffer(n5, 0, byArray.length, l6, 0);
            this.presentationTimeUs = l5 = this.presentationTimeUs + 1L;
        }
        int n6 = this.mediaCodec.dequeueOutputBuffer(this.bufferInfo, 0L);
        while (n6 >= 0) {
            Object object = this.bufferInfo;
            int n7 = object.size;
            int n8 = n7 + 7;
            ByteBuffer byteBuffer = this.outputBuffers[n6];
            byteBuffer.position(object.offset);
            byteBuffer.limit(this.bufferInfo.offset + n7);
            byte[] byArray2 = new byte[n8];
            object = byArray2;
            this.addADTStoPacket((byte[])object, n8);
            byteBuffer.get(byArray2, 7, n7);
            byteBuffer.position(this.bufferInfo.offset);
            this.outputStream.write((byte[])object);
            this.mediaCodec.releaseOutputBuffer(n6, false);
            n6 = this.mediaCodec.dequeueOutputBuffer(this.bufferInfo, 0L);
        }
        byte[] byArray3 = this.outputStream.toByteArray();
        this.outputStream.flush();
        this.outputStream.reset();
        return byArray3;
    }
}

