/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.nativeObj.photoview.subscaleview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.nativeObj.photoview.subscaleview.ImageSource;
import io.dcloud.feature.nativeObj.photoview.subscaleview.ImageViewState;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.CompatDecoderFactory;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.DecoderFactory;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.ImageDecoder;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.ImageRegionDecoder;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.SkiaImageDecoder;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.SkiaImageRegionDecoder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import pl.droidsonroids.gif.GifImageView;

public class SubsamplingScaleImageView
extends GifImageView {
    private static final String TAG = "SubsamplingScaleImageView";
    public static final int ORIENTATION_USE_EXIF = -1;
    public static final int ORIENTATION_0 = 0;
    public static final int ORIENTATION_90 = 90;
    public static final int ORIENTATION_180 = 180;
    public static final int ORIENTATION_270 = 270;
    private static final List<Integer> VALID_ORIENTATIONS;
    public static final int ZOOM_FOCUS_FIXED = 1;
    public static final int ZOOM_FOCUS_CENTER = 2;
    public static final int ZOOM_FOCUS_CENTER_IMMEDIATE = 3;
    private static final List<Integer> VALID_ZOOM_STYLES;
    public static final int EASE_OUT_QUAD = 1;
    public static final int EASE_IN_OUT_QUAD = 2;
    private static final List<Integer> VALID_EASING_STYLES;
    public static final int PAN_LIMIT_INSIDE = 1;
    public static final int PAN_LIMIT_OUTSIDE = 2;
    public static final int PAN_LIMIT_CENTER = 3;
    private static final List<Integer> VALID_PAN_LIMITS;
    public static final int SCALE_TYPE_CENTER_INSIDE = 1;
    public static final int SCALE_TYPE_CENTER_CROP = 2;
    public static final int SCALE_TYPE_CUSTOM = 3;
    public static final int SCALE_TYPE_START = 4;
    private static final List<Integer> VALID_SCALE_TYPES;
    public static final int ORIGIN_ANIM = 1;
    public static final int ORIGIN_TOUCH = 2;
    public static final int ORIGIN_FLING = 3;
    public static final int ORIGIN_DOUBLE_TAP_ZOOM = 4;
    public static final int TILE_SIZE_AUTO = Integer.MAX_VALUE;
    private static final int MESSAGE_LONG_CLICK = 1;
    private static Bitmap.Config preferredBitmapConfig;
    private Bitmap bitmap;
    private boolean bitmapIsPreview;
    private boolean bitmapIsCached;
    private Uri uri;
    private int fullImageSampleSize;
    private Map<Integer, List<Tile>> tileMap;
    private boolean debug;
    private int orientation;
    private float maxScale;
    private float minScale;
    private int minimumTileDpi;
    private int panLimit;
    private int minimumScaleType;
    private int maxTileWidth;
    private int maxTileHeight;
    private Executor executor;
    private boolean eagerLoadingEnabled;
    private boolean panEnabled;
    private boolean zoomEnabled;
    private boolean quickScaleEnabled;
    private float doubleTapZoomScale;
    private int doubleTapZoomStyle;
    private int doubleTapZoomDuration;
    private float scale;
    private float scaleStart;
    private PointF vTranslate;
    private PointF vTranslateStart;
    private PointF vTranslateBefore;
    private Float pendingScale;
    private PointF sPendingCenter;
    private PointF sRequestedCenter;
    private int sWidth;
    private int sHeight;
    private int sOrientation;
    private Rect sRegion;
    private Rect pRegion;
    private boolean isZooming;
    private boolean isPanning;
    private boolean isQuickScaling;
    private int maxTouchCount;
    private GestureDetector detector;
    private GestureDetector singleDetector;
    private ImageRegionDecoder decoder;
    private final ReadWriteLock decoderLock;
    private DecoderFactory<? extends ImageDecoder> bitmapDecoderFactory;
    private DecoderFactory<? extends ImageRegionDecoder> regionDecoderFactory;
    private PointF vCenterStart;
    private float vDistStart;
    private final float quickScaleThreshold;
    private float quickScaleLastDistance;
    private boolean quickScaleMoved;
    private PointF quickScaleVLastPoint;
    private PointF quickScaleSCenter;
    private PointF quickScaleVStart;
    private Anim anim;
    private boolean readySent;
    private boolean imageLoadedSent;
    private OnImageEventListener onImageEventListener;
    private OnStateChangedListener onStateChangedListener;
    private View.OnLongClickListener onLongClickListener;
    private final Handler handler;
    private Paint bitmapPaint;
    private Paint debugTextPaint;
    private Paint debugLinePaint;
    private Paint tileBgPaint;
    private ScaleAndTranslate satTemp;
    private Matrix matrix;
    private RectF sRect;
    private final float[] srcArray;
    private final float[] dstArray;
    private final float density;
    private TilesInited inited;

    public SubsamplingScaleImageView(Context context, AttributeSet object) {
        Handler handler;
        CompatDecoderFactory<SkiaImageRegionDecoder> compatDecoderFactory;
        CompatDecoderFactory<SkiaImageDecoder> compatDecoderFactory2;
        ReentrantReadWriteLock reentrantReadWriteLock;
        Context context2 = context;
        super(context, object);
        this.orientation = 0;
        this.maxScale = 2.0f;
        this.minScale = this.minScale();
        this.minimumTileDpi = -1;
        this.panLimit = 1;
        this.minimumScaleType = 3;
        this.maxTileWidth = Integer.MAX_VALUE;
        this.maxTileHeight = Integer.MAX_VALUE;
        this.executor = AsyncTask.THREAD_POOL_EXECUTOR;
        this.eagerLoadingEnabled = true;
        this.panEnabled = true;
        this.zoomEnabled = true;
        this.quickScaleEnabled = true;
        this.doubleTapZoomScale = 1.0f;
        this.doubleTapZoomStyle = 1;
        this.doubleTapZoomDuration = 200;
        object = reentrantReadWriteLock;
        reentrantReadWriteLock = new ReentrantReadWriteLock(true);
        this.decoderLock = object;
        object = compatDecoderFactory2;
        compatDecoderFactory2 = new CompatDecoderFactory<SkiaImageDecoder>(SkiaImageDecoder.class);
        this.bitmapDecoderFactory = object;
        object = compatDecoderFactory;
        compatDecoderFactory = new CompatDecoderFactory<SkiaImageRegionDecoder>(SkiaImageRegionDecoder.class);
        this.regionDecoderFactory = object;
        this.srcArray = new float[8];
        this.dstArray = new float[8];
        this.density = this.getResources().getDisplayMetrics().density;
        this.setMinimumDpi(160);
        this.setDoubleTapZoomDpi(160);
        this.setMinimumTileDpi(320);
        this.setGestureDetector(context);
        context = handler;
        handler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message message) {
                if (message.what == 1 && SubsamplingScaleImageView.this.onLongClickListener != null) {
                    1 v02 = this;
                    SubsamplingScaleImageView.access$102(v02.SubsamplingScaleImageView.this, 0);
                    SubsamplingScaleImageView subsamplingScaleImageView = v02.SubsamplingScaleImageView.this;
                    SubsamplingScaleImageView.super.setOnLongClickListener(subsamplingScaleImageView.onLongClickListener);
                    v02.SubsamplingScaleImageView.this.performLongClick();
                    SubsamplingScaleImageView.super.setOnLongClickListener(null);
                }
                return true;
            }
        });
        this.handler = context;
        context = context2.getResources().getDisplayMetrics();
        this.quickScaleThreshold = TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)context);
    }

    public SubsamplingScaleImageView(Context context) {
        this(context, null);
    }

    public static Bitmap.Config getPreferredBitmapConfig() {
        return preferredBitmapConfig;
    }

    public static void setPreferredBitmapConfig(Bitmap.Config config) {
        preferredBitmapConfig = config;
    }

    private void reset(boolean bl) {
        Object object;
        block11: {
            object = new Object[]{};
            this.debug("reset newImage=" + bl, (Object[])object);
            this.scale = 0.0f;
            this.scaleStart = 0.0f;
            this.vTranslate = null;
            this.vTranslateStart = null;
            this.vTranslateBefore = null;
            this.pendingScale = Float.valueOf(0.0f);
            this.sPendingCenter = null;
            this.sRequestedCenter = null;
            this.isZooming = false;
            this.isPanning = false;
            this.isQuickScaling = false;
            this.maxTouchCount = 0;
            this.fullImageSampleSize = 0;
            this.vCenterStart = null;
            this.vDistStart = 0.0f;
            this.quickScaleLastDistance = 0.0f;
            this.quickScaleMoved = false;
            this.quickScaleSCenter = null;
            this.quickScaleVLastPoint = null;
            this.quickScaleVStart = null;
            this.anim = null;
            this.satTemp = null;
            this.matrix = null;
            this.sRect = null;
            if (bl) {
                Throwable throwable2;
                block10: {
                    block9: {
                        this.uri = null;
                        this.decoderLock.writeLock().lock();
                        try {
                            object = this.decoder;
                            if (object == null) break block9;
                        }
                        catch (Throwable throwable2) {
                            break block10;
                        }
                        object.recycle();
                        this.decoder = null;
                    }
                    this.decoderLock.writeLock().unlock();
                    object = this.bitmap;
                    if (object != null && !this.bitmapIsCached) {
                        object.recycle();
                    }
                    if (this.bitmap != null && this.bitmapIsCached && (object = this.onImageEventListener) != null) {
                        object.onPreviewReleased();
                    }
                    this.sWidth = 0;
                    this.sHeight = 0;
                    this.sOrientation = 0;
                    this.sRegion = null;
                    this.pRegion = null;
                    this.readySent = false;
                    this.imageLoadedSent = false;
                    this.bitmap = null;
                    this.bitmapIsPreview = false;
                    this.bitmapIsCached = false;
                    break block11;
                }
                this.decoderLock.writeLock().unlock();
                throw throwable2;
            }
        }
        if ((object = this.tileMap) != null) {
            object = object.entrySet().iterator();
            while (object.hasNext()) {
                for (Tile tile : (List)((Map.Entry)object.next()).getValue()) {
                    Tile.access$402(tile, false);
                    if (tile.bitmap == null) continue;
                    Tile tile2 = tile;
                    tile2.bitmap.recycle();
                    Tile.access$502(tile2, null);
                }
            }
            this.tileMap = null;
        }
        this.setGestureDetector(this.getContext());
    }

    private void setGestureDetector(final Context context) {
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener;
        GestureDetector gestureDetector;
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener2;
        GestureDetector gestureDetector2;
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        GestureDetector gestureDetector3 = gestureDetector2;
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener3 = simpleOnGestureListener2;
        simpleOnGestureListener2 = new GestureDetector.SimpleOnGestureListener(){

            public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f5, float f6) {
                if (SubsamplingScaleImageView.this.panEnabled && SubsamplingScaleImageView.this.readySent && SubsamplingScaleImageView.this.vTranslate != null && motionEvent != null && motionEvent2 != null && (Math.abs(motionEvent.getX() - motionEvent2.getX()) > 50.0f || Math.abs(motionEvent.getY() - motionEvent2.getY()) > 50.0f) && (Math.abs(f5) > 500.0f || Math.abs(f6) > 500.0f) && !SubsamplingScaleImageView.this.isZooming) {
                    PointF pointF;
                    2 v02 = this;
                    motionEvent = pointF;
                    pointF = new PointF(((SubsamplingScaleImageView)SubsamplingScaleImageView.this).vTranslate.x + f5 * 0.25f, ((SubsamplingScaleImageView)SubsamplingScaleImageView.this).vTranslate.y + f6 * 0.25f);
                    float f7 = ((float)(v02.SubsamplingScaleImageView.this.getWidth() / 2) - motionEvent.x) / SubsamplingScaleImageView.this.scale;
                    float f8 = ((float)(v02.SubsamplingScaleImageView.this.getHeight() / 2) - motionEvent.y) / SubsamplingScaleImageView.this.scale;
                    new AnimationBuilder(SubsamplingScaleImageView.this, new PointF(f7, f8)).withEasing(1).withPanLimited(false).withOrigin(3).start();
                    return true;
                }
                return super.onFling(motionEvent, motionEvent2, f5, f6);
            }

            public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
                SubsamplingScaleImageView.this.performClick();
                return true;
            }

            public boolean onDoubleTap(MotionEvent motionEvent) {
                if (this_.SubsamplingScaleImageView.this.zoomEnabled && this_.SubsamplingScaleImageView.this.readySent && this_.SubsamplingScaleImageView.this.vTranslate != null) {
                    PointF pointF;
                    PointF pointF2;
                    this_.SubsamplingScaleImageView.this.setGestureDetector(this_.context);
                    if (this_.SubsamplingScaleImageView.this.quickScaleEnabled) {
                        MotionEvent motionEvent2 = motionEvent;
                        float f5 = motionEvent2.getX();
                        SubsamplingScaleImageView.access$1702(this_.SubsamplingScaleImageView.this, new PointF(f5, motionEvent2.getY()));
                        SubsamplingScaleImageView.access$1802(this_.SubsamplingScaleImageView.this, new PointF(((SubsamplingScaleImageView)this_.SubsamplingScaleImageView.this).vTranslate.x, ((SubsamplingScaleImageView)this_.SubsamplingScaleImageView.this).vTranslate.y));
                        SubsamplingScaleImageView subsamplingScaleImageView = this_.SubsamplingScaleImageView.this;
                        SubsamplingScaleImageView.access$1902(subsamplingScaleImageView, subsamplingScaleImageView.scale);
                        SubsamplingScaleImageView.access$2002(this_.SubsamplingScaleImageView.this, true);
                        SubsamplingScaleImageView.access$902(this_.SubsamplingScaleImageView.this, true);
                        SubsamplingScaleImageView.access$2102(this_.SubsamplingScaleImageView.this, -1.0f);
                        SubsamplingScaleImageView subsamplingScaleImageView2 = this_.SubsamplingScaleImageView.this;
                        SubsamplingScaleImageView.access$2202(subsamplingScaleImageView2, subsamplingScaleImageView2.viewToSourceCoord(subsamplingScaleImageView2.vCenterStart));
                        MotionEvent motionEvent3 = motionEvent;
                        float f6 = motionEvent3.getX();
                        SubsamplingScaleImageView.access$2302(this_.SubsamplingScaleImageView.this, new PointF(f6, motionEvent3.getY()));
                        SubsamplingScaleImageView.access$2402(this_.SubsamplingScaleImageView.this, new PointF(((SubsamplingScaleImageView)this_.SubsamplingScaleImageView.this).quickScaleSCenter.x, ((SubsamplingScaleImageView)this_.SubsamplingScaleImageView.this).quickScaleSCenter.y));
                        SubsamplingScaleImageView.access$2502(this_.SubsamplingScaleImageView.this, false);
                        return false;
                    }
                    SubsamplingScaleImageView subsamplingScaleImageView = this_.SubsamplingScaleImageView.this;
                    2 this_ = pointF2;
                    MotionEvent motionEvent4 = motionEvent;
                    float f7 = motionEvent4.getX();
                    pointF2 = new PointF(f7, motionEvent4.getY());
                    this_ = subsamplingScaleImageView.viewToSourceCoord((PointF)this_);
                    PointF pointF3 = pointF;
                    MotionEvent motionEvent5 = motionEvent;
                    float f8 = motionEvent5.getX();
                    pointF = new PointF(f8, motionEvent5.getY());
                    subsamplingScaleImageView.doubleTapZoom((PointF)this_, pointF3);
                    return true;
                }
                return super.onDoubleTapEvent(motionEvent);
            }
        };
        gestureDetector2 = new GestureDetector(context, (GestureDetector.OnGestureListener)simpleOnGestureListener3);
        subsamplingScaleImageView.detector = gestureDetector3;
        gestureDetector3 = gestureDetector;
        simpleOnGestureListener3 = simpleOnGestureListener;
        simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
                SubsamplingScaleImageView.this.performClick();
                return true;
            }

            public void onLongPress(MotionEvent motionEvent) {
                SubsamplingScaleImageView.this.performLongClick();
            }
        };
        gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)simpleOnGestureListener3);
        subsamplingScaleImageView.singleDetector = gestureDetector3;
    }

    private boolean onTouchEventInternal(@NonNull MotionEvent motionEvent) {
        int n5;
        block38: {
            int n6;
            block39: {
                block41: {
                    block43: {
                        block44: {
                            PointF pointF;
                            block42: {
                                float f5;
                                block40: {
                                    n5 = motionEvent.getPointerCount();
                                    n6 = motionEvent.getAction();
                                    if (n6 == 0) break block38;
                                    if (n6 == 1) break block39;
                                    if (n6 == 2) break block40;
                                    if (n6 == 5) break block38;
                                    if (n6 == 6) break block39;
                                    if (n6 == 261) break block38;
                                    if (n6 == 262) break block39;
                                    break block41;
                                }
                                if (this.maxTouchCount <= 0) break block41;
                                if (n5 < 2) break block42;
                                float f6 = motionEvent.getX(1);
                                float f7 = motionEvent.getY(0);
                                float f8 = motionEvent.getY(1);
                                f6 = this.distance(motionEvent.getX(0), f6, f7, f8);
                                f7 = (motionEvent.getX(0) + motionEvent.getX(1)) / 2.0f;
                                float f9 = (motionEvent.getY(0) + motionEvent.getY(1)) / 2.0f;
                                if (!this.zoomEnabled) break block41;
                                PointF pointF2 = this.vCenterStart;
                                f8 = pointF2.x;
                                float f10 = pointF2.y;
                                if (!(this.distance(f8, f7, f10, f9) > 5.0f) && !(Math.abs(f6 - this.vDistStart) > 5.0f) && !this.isPanning) break block41;
                                this.isZooming = true;
                                this.isPanning = true;
                                double d6 = this.scale;
                                this.scale = Math.min(this.maxScale, f6 / this.vDistStart * this.scaleStart);
                                if (f5 <= this.minScale()) {
                                    this.vDistStart = f6;
                                    this.scaleStart = this.minScale();
                                    this.vCenterStart.set(f7, f9);
                                    this.vTranslateStart.set(this.vTranslate);
                                } else if (this.panEnabled) {
                                    PointF pointF3 = this.vCenterStart;
                                    PointF pointF4 = this.vTranslateStart;
                                    float f11 = pointF3.x - pointF4.x;
                                    float f12 = this.scale;
                                    float f13 = this.scaleStart;
                                    f11 *= f12 / f13;
                                    f13 = (pointF3.y - pointF4.y) * (f12 / f13);
                                    PointF pointF5 = this.vTranslate;
                                    pointF5.x = f7 - f11;
                                    this.vTranslate.y = f9 - f13;
                                    if (d6 * (double)this.sHeight() < (double)this.getHeight() && this.scale * (float)this.sHeight() >= (float)this.getHeight() || d6 * (double)this.sWidth() < (double)this.getWidth() && this.scale * (float)this.sWidth() >= (float)this.getWidth()) {
                                        this.fitToBounds(true);
                                        this.vCenterStart.set(f7, f9);
                                        this.vTranslateStart.set(this.vTranslate);
                                        this.scaleStart = this.scale;
                                        this.vDistStart = f6;
                                    }
                                } else if (this.sRequestedCenter != null) {
                                    this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * this.sRequestedCenter.x;
                                    this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * this.sRequestedCenter.y;
                                } else {
                                    this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * (float)(this.sWidth() / 2);
                                    this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * (float)(this.sHeight() / 2);
                                }
                                this.fitToBounds(true);
                                this.refreshRequiredTiles(this.eagerLoadingEnabled);
                                break block43;
                            }
                            if (!this.isQuickScaling) break block44;
                            float f14 = Math.abs(this.quickScaleVStart.y - motionEvent.getY()) * 2.0f + this.quickScaleThreshold;
                            if (this.quickScaleLastDistance == -1.0f) {
                                this.quickScaleLastDistance = f14;
                            }
                            PointF pointF6 = this.quickScaleVLastPoint;
                            boolean bl = motionEvent.getY() > pointF.y;
                            pointF6.set(0.0f, motionEvent.getY());
                            float f15 = Math.abs(1.0f - f14 / this.quickScaleLastDistance) * 0.5f;
                            if (f15 > 0.03f || this.quickScaleMoved) {
                                this.quickScaleMoved = true;
                                float f16 = 1.0f;
                                if (this.quickScaleLastDistance > 0.0f) {
                                    f16 = bl ? (f15 += 1.0f) : (f15 = 1.0f - f15);
                                }
                                double d7 = this.scale;
                                this.scale = f15 = Math.max(this.minScale(), Math.min(this.maxScale, this.scale * f16));
                                if (this.panEnabled) {
                                    PointF pointF7 = this.vCenterStart;
                                    f16 = pointF7.x;
                                    PointF pointF8 = this.vTranslateStart;
                                    float f17 = f16 - pointF8.x;
                                    float f18 = pointF7.y;
                                    float f19 = f15;
                                    float f20 = f15;
                                    f15 = this.scaleStart;
                                    float f21 = f17 * (f20 / f15);
                                    f15 = (f18 - pointF8.y) * (f19 / f15);
                                    PointF pointF9 = this.vTranslate;
                                    pointF9.x = f16 - f21;
                                    this.vTranslate.y = f18 - f15;
                                    if (d7 * (double)this.sHeight() < (double)this.getHeight() && this.scale * (float)this.sHeight() >= (float)this.getHeight() || d7 * (double)this.sWidth() < (double)this.getWidth() && this.scale * (float)this.sWidth() >= (float)this.getWidth()) {
                                        this.fitToBounds(true);
                                        this.vCenterStart.set(this.sourceToViewCoord(this.quickScaleSCenter));
                                        this.vTranslateStart.set(this.vTranslate);
                                        this.scaleStart = this.scale;
                                        f14 = 0.0f;
                                    }
                                } else if (this.sRequestedCenter != null) {
                                    this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * this.sRequestedCenter.x;
                                    this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * this.sRequestedCenter.y;
                                } else {
                                    this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * (float)(this.sWidth() / 2);
                                    this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * (float)(this.sHeight() / 2);
                                }
                            }
                            this.quickScaleLastDistance = f14;
                            this.fitToBounds(true);
                            this.refreshRequiredTiles(this.eagerLoadingEnabled);
                            break block43;
                        }
                        if (this.isZooming) break block41;
                        float f22 = Math.abs(motionEvent.getX() - this.vCenterStart.x);
                        float f23 = Math.abs(motionEvent.getY() - this.vCenterStart.y);
                        float f24 = this.density * 5.0f;
                        if (!(f22 > f24) && !(f23 > f24) && !this.isPanning) break block41;
                        this.vTranslate.x = this.vTranslateStart.x + (motionEvent.getX() - this.vCenterStart.x);
                        this.vTranslate.y = this.vTranslateStart.y + (motionEvent.getY() - this.vCenterStart.y);
                        motionEvent = this.vTranslate;
                        float f25 = motionEvent.x;
                        float f26 = motionEvent.y;
                        this.fitToBounds(true);
                        PointF pointF = this.vTranslate;
                        boolean bl = f25 != pointF.x;
                        float f27 = pointF.y;
                        boolean bl2 = f26 != f27;
                        boolean bl3 = bl && f22 > f23 && !this.isPanning;
                        boolean bl4 = bl2 && f23 > f22 && !this.isPanning;
                        boolean bl5 = f26 == f27 && f23 > f24 * 3.0f;
                        if (!(bl3 || bl4 || bl && bl2 && !bl5 && !this.isPanning)) {
                            this.isPanning = true;
                        } else if (f22 > f24 || f23 > f24) {
                            this.maxTouchCount = 0;
                            this.handler.removeMessages(1);
                            this.requestDisallowInterceptTouchEvent(false);
                        }
                        if (!this.panEnabled) {
                            PointF pointF10 = this.vTranslate;
                            PointF pointF11 = this.vTranslateStart;
                            pointF10.x = pointF11.x;
                            pointF10.y = pointF11.y;
                            this.requestDisallowInterceptTouchEvent(false);
                        }
                        this.refreshRequiredTiles(this.eagerLoadingEnabled);
                    }
                    this.handler.removeMessages(1);
                    this.invalidate();
                    return true;
                }
                return false;
            }
            this.handler.removeMessages(1);
            if (this.isQuickScaling) {
                this.isQuickScaling = false;
                if (!this.quickScaleMoved) {
                    PointF pointF = this.vCenterStart;
                    this.doubleTapZoom(this.quickScaleSCenter, pointF);
                }
            }
            if (this.maxTouchCount > 0) {
                boolean bl = this.isZooming;
                n6 = bl ? 1 : 0;
                if (bl || this.isPanning) {
                    if (n6 != 0 && n5 == 2) {
                        this.isPanning = true;
                        PointF pointF = this.vTranslate;
                        float f28 = pointF.x;
                        this.vTranslateStart.set(f28, pointF.y);
                        if (motionEvent.getActionIndex() == 1) {
                            this.vCenterStart.set(motionEvent.getX(0), motionEvent.getY(0));
                        } else {
                            this.vCenterStart.set(motionEvent.getX(1), motionEvent.getY(1));
                        }
                    }
                    if (n5 < 3) {
                        this.isZooming = false;
                    }
                    if (n5 < 2) {
                        this.isPanning = false;
                        this.maxTouchCount = 0;
                    }
                    this.refreshRequiredTiles(true);
                    return true;
                }
            }
            if (n5 == 1) {
                this.isZooming = false;
                this.isPanning = false;
                this.maxTouchCount = 0;
            }
            return true;
        }
        this.anim = null;
        this.requestDisallowInterceptTouchEvent(true);
        this.maxTouchCount = Math.max(this.maxTouchCount, n5);
        if (n5 >= 2) {
            if (this.zoomEnabled) {
                float f29 = motionEvent.getX(1);
                float f30 = motionEvent.getY(0);
                float f31 = motionEvent.getY(1);
                this.scaleStart = this.scale;
                this.vDistStart = this.distance(motionEvent.getX(0), f29, f30, f31);
                PointF pointF = this.vTranslate;
                f29 = pointF.x;
                this.vTranslateStart.set(f29, pointF.y);
                this.vCenterStart.set((motionEvent.getX(0) + motionEvent.getX(1)) / 2.0f, (motionEvent.getY(0) + motionEvent.getY(1)) / 2.0f);
            } else {
                this.maxTouchCount = 0;
            }
            this.handler.removeMessages(1);
        } else if (!this.isQuickScaling) {
            PointF pointF = this.vTranslate;
            float f32 = pointF.x;
            this.vTranslateStart.set(f32, pointF.y);
            this.vCenterStart.set(motionEvent.getX(), motionEvent.getY());
            this.handler.sendEmptyMessageDelayed(1, 600L);
        }
        return true;
    }

    private void requestDisallowInterceptTouchEvent(boolean bl) {
        if ((this = this.getParent()) != null) {
            this.requestDisallowInterceptTouchEvent(bl);
            return;
        }
    }

    private void doubleTapZoom(PointF pointF, PointF pointF2) {
        if (!this.panEnabled) {
            PointF pointF3 = this.sRequestedCenter;
            if (pointF3 != null) {
                pointF.x = pointF3.x;
                pointF.y = pointF3.y;
            } else {
                pointF.x = this.sWidth() / 2;
                pointF.y = this.sHeight() / 2;
            }
        }
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        float f5 = subsamplingScaleImageView.scale;
        float f6 = Math.min(subsamplingScaleImageView.maxScale, this.doubleTapZoomScale);
        boolean bl = (double)f5 <= (double)f6 * 0.9 || f5 == this.minScale;
        if (!bl) {
            f6 = this.minScale();
        }
        int n5 = this.doubleTapZoomStyle;
        if (n5 == 3) {
            this.setScaleAndCenter(f6, pointF);
        } else if (n5 != 2 && bl && this.panEnabled) {
            if (n5 == 1) {
                new AnimationBuilder(this, f6, pointF, pointF2).withInterruptible(false).withDuration(this.doubleTapZoomDuration).withOrigin(4).start();
            }
        } else {
            new AnimationBuilder(this, f6, pointF).withInterruptible(false).withDuration(this.doubleTapZoomDuration).withOrigin(4).start();
        }
        this.invalidate();
    }

    private void setMatrixArray(float[] fArray, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        float[] fArray2 = fArray;
        float[] fArray3 = fArray;
        fArray2[0] = f5;
        fArray3[1] = f6;
        fArray2[2] = f7;
        fArray3[3] = f8;
        fArray2[4] = f9;
        fArray3[5] = f10;
        fArray2[6] = f11;
        fArray3[7] = f12;
    }

    private boolean isBaseLayerReady() {
        if (this.bitmap != null && !this.bitmapIsPreview) {
            return true;
        }
        Map<Integer, List<Tile>> map = this.tileMap;
        if (map != null) {
            boolean bl = true;
            for (Map.Entry<Integer, List<Tile>> entry : map.entrySet()) {
                if (entry.getKey() != this.fullImageSampleSize) continue;
                entry = entry.getValue().iterator();
                while (entry.hasNext()) {
                    Tile tile = (Tile)entry.next();
                    if (!tile.loading && tile.bitmap != null) continue;
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private boolean checkReady() {
        boolean bl = onImageEventListener.getWidth() > 0 && onImageEventListener.getHeight() > 0 && ((SubsamplingScaleImageView)((Object)onImageEventListener)).sWidth > 0 && ((SubsamplingScaleImageView)((Object)onImageEventListener)).sHeight > 0 && (((SubsamplingScaleImageView)((Object)onImageEventListener)).bitmap != null || ((SubsamplingScaleImageView)((Object)onImageEventListener)).isBaseLayerReady());
        if (!((SubsamplingScaleImageView)((Object)onImageEventListener)).readySent && bl) {
            SubsamplingScaleImageView subsamplingScaleImageView = onImageEventListener;
            subsamplingScaleImageView.preDraw();
            subsamplingScaleImageView.readySent = true;
            subsamplingScaleImageView.onReady();
            OnImageEventListener onImageEventListener = subsamplingScaleImageView.onImageEventListener;
            if (onImageEventListener != null) {
                onImageEventListener.onReady();
                return bl;
            }
        }
        return bl;
    }

    private boolean checkImageLoaded() {
        SubsamplingScaleImageView subsamplingScaleImageView = onImageEventListener;
        boolean bl = subsamplingScaleImageView.isBaseLayerReady();
        if (!subsamplingScaleImageView.imageLoadedSent && bl) {
            SubsamplingScaleImageView subsamplingScaleImageView2 = onImageEventListener;
            subsamplingScaleImageView2.preDraw();
            subsamplingScaleImageView2.imageLoadedSent = true;
            subsamplingScaleImageView2.onImageLoaded();
            OnImageEventListener onImageEventListener = subsamplingScaleImageView2.onImageEventListener;
            if (onImageEventListener != null) {
                onImageEventListener.onImageLoaded();
                return bl;
            }
        }
        return bl;
    }

    private void createPaints() {
        if (this.bitmapPaint == null) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            this.bitmapPaint = new Paint();
            this.bitmapPaint.setAntiAlias(true);
            subsamplingScaleImageView.bitmapPaint.setFilterBitmap(true);
            subsamplingScaleImageView.bitmapPaint.setDither(true);
        }
        if ((this.debugTextPaint == null || this.debugLinePaint == null) && this.debug) {
            Paint paint;
            Paint paint2;
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            Paint paint3 = paint2 = paint;
            paint3();
            this.debugTextPaint = paint3;
            paint.setTextSize((float)this.px(12));
            subsamplingScaleImageView.debugTextPaint.setColor(-65281);
            subsamplingScaleImageView.debugTextPaint.setStyle(Paint.Style.FILL);
            this.debugLinePaint = new Paint();
            this.debugLinePaint.setColor(-65281);
            subsamplingScaleImageView.debugLinePaint.setStyle(Paint.Style.STROKE);
            subsamplingScaleImageView.debugLinePaint.setStrokeWidth((float)this.px(1));
            return;
        }
    }

    private synchronized void initialiseBaseLayer(@NonNull Point object) {
        int n5;
        PointF pointF;
        ScaleAndTranslate scaleAndTranslate;
        Point point = object;
        Object object2 = point.x;
        Object object3 = point.y;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object2;
        objectArray[1] = object3;
        this.debug("initialiseBaseLayer maxTileDimensions=%dx%d", objectArray2);
        object2 = scaleAndTranslate;
        object3 = pointF;
        pointF = new PointF(0.0f, 0.0f);
        scaleAndTranslate = new ScaleAndTranslate(0.0f, (PointF)object3);
        this.satTemp = object2;
        this.fitToBounds(true, (ScaleAndTranslate)object2);
        this.fullImageSampleSize = n5 = this.calculateInSampleSize(this.satTemp.scale);
        if (n5 > 1) {
            this.fullImageSampleSize = n5 / 2;
        }
        if (this.fullImageSampleSize == 1 && this.sRegion == null && this.sWidth() < object.x && this.sHeight() < object.y) {
            BitmapLoadTask bitmapLoadTask;
            this.decoder.recycle();
            this.decoder = null;
            object = bitmapLoadTask;
            DecoderFactory<? extends ImageDecoder> decoderFactory = this.bitmapDecoderFactory;
            object3 = this.uri;
            bitmapLoadTask = new BitmapLoadTask(this, this.getContext(), decoderFactory, (Uri)object3, false);
            this.execute((AsyncTask<Void, Void, ?>)object);
            return;
        }
        this.initialiseTileMap((Point)object);
        for (Tile tile : this.tileMap.get(this.fullImageSampleSize)) {
            TileLoadTask tileLoadTask;
            object3 = tileLoadTask;
            tileLoadTask = new TileLoadTask(this, this.decoder, tile);
            this.execute((AsyncTask<Void, Void, ?>)object3);
        }
        this.refreshRequiredTiles(true);
    }

    private void refreshRequiredTiles(boolean bl) {
        if (this.decoder != null && this.tileMap != null) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            int n5 = Math.min(subsamplingScaleImageView.fullImageSampleSize, subsamplingScaleImageView2.calculateInSampleSize(subsamplingScaleImageView2.scale));
            Iterator<Map.Entry<Integer, List<Tile>>> iterator = subsamplingScaleImageView.tileMap.entrySet().iterator();
            while (iterator.hasNext()) {
                for (Tile tile : iterator.next().getValue()) {
                    if (tile.sampleSize < n5 || tile.sampleSize > n5 && tile.sampleSize != this.fullImageSampleSize) {
                        Tile tile2 = tile;
                        Tile.access$402(tile2, false);
                        if (tile2.bitmap != null) {
                            Tile tile3 = tile;
                            tile3.bitmap.recycle();
                            Tile.access$502(tile3, null);
                        }
                    }
                    if (tile.sampleSize == n5) {
                        if (this.tileVisible(tile)) {
                            TileLoadTask tileLoadTask;
                            Tile tile4 = tile;
                            Tile.access$402(tile4, true);
                            if (tile4.loading || tile.bitmap != null || !bl) continue;
                            TileLoadTask tileLoadTask2 = tileLoadTask;
                            tileLoadTask = new TileLoadTask(this, this.decoder, tile);
                            this.execute(tileLoadTask2);
                            continue;
                        }
                        if (tile.sampleSize == this.fullImageSampleSize) continue;
                        Tile tile5 = tile;
                        Tile.access$402(tile5, false);
                        if (tile5.bitmap == null) continue;
                        Tile tile6 = tile;
                        tile6.bitmap.recycle();
                        Tile.access$502(tile6, null);
                        continue;
                    }
                    if (tile.sampleSize != this.fullImageSampleSize) continue;
                    Tile.access$402(tile, true);
                }
            }
        }
    }

    private boolean tileVisible(Tile tile) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        float f5 = subsamplingScaleImageView.viewToSourceX(subsamplingScaleImageView.getWidth());
        float f6 = subsamplingScaleImageView.viewToSourceY(0.0f);
        float f7 = subsamplingScaleImageView.viewToSourceY(subsamplingScaleImageView.getHeight());
        return !(this.viewToSourceX(0.0f) > (float)((Tile)tile).sRect.right || (float)((Tile)tile).sRect.left > f5 || f6 > (float)((Tile)tile).sRect.bottom || (float)((Tile)tile).sRect.top > f7);
    }

    private void preDraw() {
        if (this.getWidth() != 0 && this.getHeight() != 0 && this.sWidth > 0 && this.sHeight > 0) {
            Float f5;
            if (this.sPendingCenter != null && (f5 = this.pendingScale) != null) {
                this.scale = f5.floatValue();
                if (this.vTranslate == null) {
                    PointF pointF;
                    f5 = pointF;
                    pointF = new PointF();
                    this.vTranslate = f5;
                }
                this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * this.sPendingCenter.x;
                this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * this.sPendingCenter.y;
                this.sPendingCenter = null;
                this.pendingScale = null;
                this.fitToBounds(true);
                this.refreshRequiredTiles(true);
            }
            this.fitToBounds(false);
            return;
        }
    }

    private int calculateInSampleSize(float f5) {
        if (this.minimumTileDpi > 0) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            DisplayMetrics displayMetrics = subsamplingScaleImageView.getResources().getDisplayMetrics();
            float f6 = (displayMetrics.xdpi + displayMetrics.ydpi) / 2.0f;
            f5 = (float)subsamplingScaleImageView.minimumTileDpi / f6 * f5;
        }
        int n5 = (int)((float)this.sWidth() * f5);
        int n6 = (int)((float)this.sHeight() * f5);
        int n7 = 1;
        if (n5 != 0 && n6 != 0) {
            if (this.sHeight() > n6 || this.sWidth() > n5) {
                int n8;
                n6 = Math.round((float)this.sHeight() / (float)n6);
                n7 = n6 < (n8 = Math.round((float)this.sWidth() / (float)n5)) ? n6 : n8;
            }
            int n9 = 1;
            while ((n6 = n9 * 2) < n7) {
                n9 = n6;
            }
            return n9;
        }
        return 32;
    }

    private void fitToBounds(boolean bl, ScaleAndTranslate scaleAndTranslate) {
        float f5;
        float f6;
        if (this.panLimit == 2 && this.isReady()) {
            bl = false;
        }
        ScaleAndTranslate scaleAndTranslate2 = scaleAndTranslate;
        PointF pointF = scaleAndTranslate2.vTranslate;
        float f7 = this.limitedScale(scaleAndTranslate2.scale);
        float f8 = f7 * (float)this.sWidth();
        float f9 = f7 * (float)this.sHeight();
        if (this.panLimit == 3 && this.isReady()) {
            PointF pointF2 = pointF;
            pointF2.x = Math.max(pointF2.x, (float)(this.getWidth() / 2) - f8);
            pointF2.y = Math.max(pointF2.y, (float)(this.getHeight() / 2) - f9);
        } else if (bl) {
            PointF pointF3 = pointF;
            pointF3.x = Math.max(pointF3.x, (float)this.getWidth() - f8);
            pointF3.y = Math.max(pointF3.y, (float)this.getHeight() - f9);
        } else {
            PointF pointF4 = pointF;
            pointF4.x = Math.max(pointF4.x, -f8);
            pointF4.y = Math.max(pointF4.y, -f9);
        }
        float f10 = this.getPaddingLeft() <= 0 && this.getPaddingRight() <= 0 ? 0.5f : (float)this.getPaddingLeft() / (float)(this.getPaddingLeft() + this.getPaddingRight());
        float f11 = this.getPaddingTop() <= 0 && this.getPaddingBottom() <= 0 ? 0.5f : (float)this.getPaddingTop() / (float)(this.getPaddingTop() + this.getPaddingBottom());
        if (this.panLimit == 3 && this.isReady()) {
            f6 = Math.max(0, this.getWidth() / 2);
            f5 = Math.max(0, this.getHeight() / 2);
        } else if (bl) {
            f6 = Math.max(0.0f, ((float)this.getWidth() - f8) * f10);
            f5 = Math.max(0.0f, ((float)this.getHeight() - f9) * f11);
        } else {
            f6 = Math.max(0, this.getWidth());
            f5 = Math.max(0, this.getHeight());
        }
        PointF pointF5 = pointF;
        pointF5.x = Math.min(pointF5.x, f6);
        pointF5.y = Math.min(pointF5.y, f5);
        ScaleAndTranslate.access$4702(scaleAndTranslate, f7);
    }

    private void fitToBounds(boolean bl) {
        Object object;
        boolean bl2 = false;
        if (this.vTranslate == null) {
            PointF pointF;
            bl2 = true;
            object = pointF;
            pointF = new PointF(0.0f, 0.0f);
            this.vTranslate = object;
        }
        if (this.satTemp == null) {
            PointF pointF;
            ScaleAndTranslate scaleAndTranslate;
            object = scaleAndTranslate;
            PointF pointF2 = pointF;
            pointF = new PointF(0.0f, 0.0f);
            scaleAndTranslate = new ScaleAndTranslate(0.0f, pointF2);
            this.satTemp = object;
        }
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        SubsamplingScaleImageView subsamplingScaleImageView2 = this;
        ScaleAndTranslate.access$4702(subsamplingScaleImageView2.satTemp, this.scale);
        subsamplingScaleImageView2.satTemp.vTranslate.set(this.vTranslate);
        subsamplingScaleImageView.fitToBounds(bl, subsamplingScaleImageView2.satTemp);
        subsamplingScaleImageView.scale = subsamplingScaleImageView.satTemp.scale;
        subsamplingScaleImageView.vTranslate.set(this.satTemp.vTranslate);
        if (bl2 && this.minimumScaleType != 4) {
            SubsamplingScaleImageView subsamplingScaleImageView3 = this;
            float f5 = subsamplingScaleImageView3.sWidth() / 2;
            float f6 = subsamplingScaleImageView3.sHeight() / 2;
            float f7 = subsamplingScaleImageView3.scale;
            this.vTranslate.set(subsamplingScaleImageView3.vTranslateForSCenter(f5, f6, f7));
            return;
        }
    }

    private void initialiseTileMap(Point point) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        Point point2 = point;
        Integer n5 = point2.x;
        Integer n6 = point2.y;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n5;
        objectArray[1] = n6;
        subsamplingScaleImageView.debug("initialiseTileMap maxTileDimensions=%dx%d", objectArray2);
        subsamplingScaleImageView.tileMap = new LinkedHashMap<Integer, List<Tile>>();
        int n7 = subsamplingScaleImageView.fullImageSampleSize;
        int n8 = 1;
        int n9 = 1;
        block0: while (true) {
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            int n10 = subsamplingScaleImageView2.sWidth() / n8;
            int n11 = subsamplingScaleImageView2.sHeight() / n9;
            int n12 = n10 / n7;
            int n13 = n11 / n7;
            while (true) {
                if (!(n12 + n8 + 1 > point.x || (double)n12 > (double)this.getWidth() * 1.25 && n7 < this.fullImageSampleSize)) {
                    while (true) {
                        if (!(n13 + n9 + 1 > point.y || (double)n13 > (double)this.getHeight() * 1.25 && n7 < this.fullImageSampleSize)) {
                            ArrayList<Tile> arrayList;
                            ArrayList<Tile> arrayList2 = arrayList;
                            arrayList = new ArrayList<Tile>(n8 * n9);
                            for (n13 = 0; n13 < n8; ++n13) {
                                for (int i5 = 0; i5 < n9; ++i5) {
                                    Rect rect;
                                    Tile tile;
                                    Tile tile2 = tile;
                                    tile2();
                                    Tile.access$4302(tile, n7);
                                    boolean bl = n7 == this.fullImageSampleSize;
                                    Tile.access$402(tile2, bl);
                                    int n14 = n13 * n10;
                                    int n15 = i5 * n11;
                                    int n16 = n13 == n8 - 1 ? this.sWidth() : (n13 + 1) * n10;
                                    int n17 = i5 == n9 - 1 ? this.sHeight() : (i5 + 1) * n11;
                                    Tile tile3 = tile2;
                                    Rect rect2 = rect;
                                    rect2(n14, n15, n16, n17);
                                    Tile.access$4102(tile3, rect2);
                                    Tile.access$4202(tile3, new Rect(0, 0, 0, 0));
                                    Tile.access$5002(tile3, new Rect(tile2.sRect));
                                    arrayList2.add(tile3);
                                }
                            }
                            this.tileMap.put(n7, arrayList2);
                            if (n7 == 1) {
                                return;
                            }
                            n7 /= 2;
                            continue block0;
                        }
                        n11 = this.sHeight() / ++n9;
                        n13 = n11 / n7;
                    }
                }
                n10 = this.sWidth() / ++n8;
                n12 = n10 / n7;
            }
            break;
        }
    }

    private synchronized void onTilesInited(ImageRegionDecoder imageRegionDecoder, int n5, int n6, int n7) {
        int n8;
        int n9;
        Integer n10 = n5;
        Integer n11 = n6;
        Integer n12 = this.orientation;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n10;
        objectArray[1] = n11;
        objectArray[2] = n12;
        this.debug("onTilesInited sWidth=%d, sHeight=%d, sOrientation=%d", objectArray2);
        int n13 = this.sWidth;
        if (n13 > 0 && (n9 = this.sHeight) > 0 && (n13 != n5 || n9 != n6)) {
            this.reset(false);
            Object object = this.bitmap;
            if (object != null) {
                if (!this.bitmapIsCached) {
                    object.recycle();
                }
                this.bitmap = null;
                object = this.onImageEventListener;
                if (object != null && this.bitmapIsCached) {
                    object.onPreviewReleased();
                }
                this.bitmapIsPreview = false;
                this.bitmapIsCached = false;
            }
        }
        this.decoder = imageRegionDecoder;
        this.sWidth = n5;
        this.sHeight = n6;
        this.sOrientation = n7;
        this.checkReady();
        if (!this.checkImageLoaded() && (n8 = this.maxTileWidth) > 0 && n8 != Integer.MAX_VALUE && (n8 = this.maxTileHeight) > 0 && n8 != Integer.MAX_VALUE && this.getWidth() > 0 && this.getHeight() > 0) {
            Point point;
            Point point2 = point;
            point = new Point(this.maxTileWidth, this.maxTileHeight);
            this.initialiseBaseLayer(point2);
        }
        this.invalidate();
        this.requestLayout();
        this.resetAllScale(n5, n6);
    }

    private void resetAllScale(int n5, int n6) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        float f5 = (float)subsamplingScaleImageView.getWidth() / (float)n5;
        this.setMinScale(f5);
        float f6 = f5 + 4.0f;
        this.setMaxScale(f6);
        subsamplingScaleImageView.setDoubleTapZoomScale(f6 * 0.9f);
        if (n5 <= subsamplingScaleImageView.getWidth() && n6 <= n5) {
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            float f7 = n6;
            subsamplingScaleImageView2.setDoubleTapZoomScale((float)subsamplingScaleImageView2.getHeight() / f7);
            subsamplingScaleImageView2.setMaxScale((float)subsamplingScaleImageView2.getHeight() / f7 / 0.7f);
            return;
        }
    }

    private synchronized void onTileLoaded() {
        Object object;
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        subsamplingScaleImageView.debug("onTileLoaded", new Object[0]);
        subsamplingScaleImageView.checkReady();
        subsamplingScaleImageView.checkImageLoaded();
        if (subsamplingScaleImageView.isBaseLayerReady() && (object = this.bitmap) != null) {
            if (!this.bitmapIsCached) {
                object.recycle();
            }
            this.bitmap = null;
            object = this.onImageEventListener;
            if (object != null && this.bitmapIsCached) {
                object.onPreviewReleased();
            }
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            subsamplingScaleImageView2.bitmapIsPreview = false;
            subsamplingScaleImageView2.bitmapIsCached = false;
        }
        this.invalidate();
    }

    private synchronized void onPreviewLoaded(Bitmap bitmap) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        subsamplingScaleImageView.debug("onPreviewLoaded", new Object[0]);
        if (subsamplingScaleImageView.bitmap == null && !this.imageLoadedSent) {
            Rect rect = this.pRegion;
            if (rect != null) {
                Rect rect2 = rect;
                int n5 = rect2.left;
                int n6 = rect2.top;
                int n7 = rect2.width();
                int n8 = n5;
                n5 = this.pRegion.height();
                this.bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)n8, (int)n6, (int)n7, (int)n5);
            } else {
                this.bitmap = bitmap;
            }
            this.bitmapIsPreview = true;
            if (this.checkReady()) {
                SubsamplingScaleImageView subsamplingScaleImageView2 = this;
                subsamplingScaleImageView2.invalidate();
                subsamplingScaleImageView2.requestLayout();
                return;
            }
            return;
        }
        bitmap.recycle();
    }

    private synchronized void onImageLoaded(Bitmap bitmap, int n5, boolean bl) {
        int n6;
        Object object;
        Object[] objectArray = new Object[]{};
        this.debug("onImageLoaded", objectArray);
        int n7 = this.sWidth;
        if (n7 > 0 && this.sHeight > 0 && (n7 != bitmap.getWidth() || this.sHeight != bitmap.getHeight())) {
            this.reset(false);
        }
        if ((object = this.bitmap) != null && !this.bitmapIsCached) {
            object.recycle();
        }
        if (this.bitmap != null && this.bitmapIsCached && (object = this.onImageEventListener) != null) {
            object.onPreviewReleased();
        }
        Bitmap bitmap2 = bitmap;
        this.bitmapIsPreview = false;
        this.bitmapIsCached = bl;
        this.bitmap = bitmap;
        this.sWidth = bitmap2.getWidth();
        this.sHeight = n6 = bitmap2.getHeight();
        this.sOrientation = n5;
        this.resetAllScale(this.sWidth, n6);
        n6 = this.checkImageLoaded() ? 1 : 0;
        if (!this.checkReady() && n6 == 0) {
            return;
        }
        this.invalidate();
        this.requestLayout();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AnyThread
    private int getExifOrientation(Context context, String string2) {
        Throwable throwable222222;
        block17: {
            int n5 = 0;
            if (string2.startsWith("content")) {
                block16: {
                    Context context2 = context;
                    context = null;
                    String[] stringArray = new String[1];
                    String[] stringArray2 = stringArray;
                    stringArray[0] = "orientation";
                    context = context2.getContentResolver().query(Uri.parse((String)string2), stringArray2, null, null, null);
                    if (context == null) break block16;
                    if (!context.moveToFirst()) break block16;
                    int n6 = context.getInt(0);
                    if (VALID_ORIENTATIONS.contains(n6) && n6 != -1) {
                        n5 = n6;
                        break block16;
                    }
                    Log.w((String)TAG, (String)("Unsupported orientation: " + n6));
                }
                if (context == null) return n5;
            } else {
                Context context3;
                int n7;
                if (!string2.startsWith("file:///")) return n5;
                if (string2.startsWith("file:///android_asset/")) return n5;
                try {
                    int n8 = new ExifInterface(string2.substring(7)).getAttributeInt("Orientation", 1);
                    if (n8 == 1) return 0;
                    if (n8 == 0) {
                        return 0;
                    }
                    if (n8 == 6) {
                        return 90;
                    }
                    if (n8 == 3) {
                        return 180;
                    }
                    if (n8 == 8) {
                        return 270;
                    }
                    n7 = n5;
                    Log.w((String)TAG, (String)("Unsupported EXIF orientation: " + n8));
                }
                catch (Exception exception) {}
                return n7;
                Log.w((String)TAG, (String)"Could not get EXIF orientation of image");
                return n5;
                catch (Throwable throwable222222) {
                    break block17;
                }
                catch (Exception exception) {}
                {
                    context3 = context;
                    Log.w((String)TAG, (String)"Could not get orientation of image from media store");
                }
                if (context3 == null) return n5;
            }
            context.close();
            return n5;
        }
        if (context == null) throw throwable222222;
        context.close();
        throw throwable222222;
    }

    private void execute(AsyncTask<Void, Void, ?> asyncTask) {
        asyncTask.executeOnExecutor(this.executor, (Object[])new Void[0]);
    }

    private void restoreState(ImageViewState imageViewState) {
        if (imageViewState != null && VALID_ORIENTATIONS.contains(imageViewState.getOrientation())) {
            this.sPendingCenter = imageViewState.getCenter();
            this.invalidate();
            return;
        }
    }

    @NonNull
    private Point getMaxBitmapDimensions(Canvas canvas) {
        return new Point(Math.min(canvas.getMaximumBitmapWidth(), this.maxTileWidth), Math.min(canvas.getMaximumBitmapHeight(), this.maxTileHeight));
    }

    private int sWidth() {
        int n5 = this.getRequiredRotation();
        if (n5 != 90 && n5 != 270) {
            return this.sWidth;
        }
        return this.sHeight;
    }

    private int sHeight() {
        int n5 = this.getRequiredRotation();
        if (n5 != 90 && n5 != 270) {
            return this.sHeight;
        }
        return this.sWidth;
    }

    @AnyThread
    private void fileSRect(Rect rect, Rect rect2) {
        if (this.getRequiredRotation() == 0) {
            rect2.set(rect);
            return;
        }
        if (this.getRequiredRotation() == 90) {
            int n5 = rect.top;
            int n6 = this.sHeight;
            int n7 = n5;
            Rect rect3 = rect;
            n5 = n6 - rect.right;
            int n8 = rect3.bottom;
            rect2.set(n7, n5, n8, n6 -= rect3.left);
            return;
        }
        if (this.getRequiredRotation() == 180) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            int n9 = subsamplingScaleImageView.sWidth;
            int n10 = n9 - rect.right;
            int n11 = subsamplingScaleImageView.sHeight;
            int n12 = n10;
            int n13 = n9;
            n9 = n11 - rect.bottom;
            int n14 = n13 - rect.left;
            n10 = n11 - rect.top;
            rect2.set(n12, n9, n14, n10);
            return;
        }
        int n15 = this.sWidth;
        int n16 = n15;
        Rect rect4 = rect;
        int n17 = rect4.left;
        int n18 = n15 - rect4.top;
        int n19 = rect.right;
        rect2.set(n16 -= rect.bottom, n17, n18, n19);
    }

    @AnyThread
    private int getRequiredRotation() {
        int n5 = this.orientation;
        if (n5 == -1) {
            return this.sOrientation;
        }
        return n5;
    }

    private float distance(float f5, float f6, float f7, float f8) {
        float f9;
        float f10 = f5 - f6;
        float f11 = f9 = f7 - f8;
        return (float)Math.sqrt(f10 * f10 + f11 * f11);
    }

    private float viewToSourceX(float f5) {
        PointF pointF = this.vTranslate;
        if (pointF == null) {
            return Float.NaN;
        }
        return (f5 - pointF.x) / this.scale;
    }

    private float viewToSourceY(float f5) {
        PointF pointF = this.vTranslate;
        if (pointF == null) {
            return Float.NaN;
        }
        return (f5 - pointF.y) / this.scale;
    }

    private float sourceToViewX(float f5) {
        PointF pointF = this.vTranslate;
        if (pointF == null) {
            return Float.NaN;
        }
        return f5 * this.scale + pointF.x;
    }

    private float sourceToViewY(float f5) {
        PointF pointF = this.vTranslate;
        if (pointF == null) {
            return Float.NaN;
        }
        return f5 * this.scale + pointF.y;
    }

    private void sourceToViewRect(@NonNull Rect rect, @NonNull Rect rect2) {
        int n5 = (int)this.sourceToViewX(rect.left);
        int n6 = (int)this.sourceToViewY(rect.top);
        int n7 = (int)this.sourceToViewX(rect.right);
        int n8 = (int)this.sourceToViewY(rect.bottom);
        rect2.set(n5, n6, n7, n8);
    }

    @NonNull
    private PointF vTranslateForSCenter(float f5, float f6, float f7) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        int n5 = subsamplingScaleImageView.getPaddingLeft() + (this.getWidth() - this.getPaddingRight() - this.getPaddingLeft()) / 2;
        int n6 = subsamplingScaleImageView.getPaddingTop() + (this.getHeight() - this.getPaddingBottom() - this.getPaddingTop()) / 2;
        if (subsamplingScaleImageView.satTemp == null) {
            PointF pointF;
            ScaleAndTranslate scaleAndTranslate;
            ScaleAndTranslate scaleAndTranslate2 = scaleAndTranslate;
            PointF pointF2 = pointF;
            pointF = new PointF(0.0f, 0.0f);
            scaleAndTranslate = new ScaleAndTranslate(0.0f, pointF2);
            this.satTemp = scaleAndTranslate2;
        }
        SubsamplingScaleImageView subsamplingScaleImageView2 = this;
        ScaleAndTranslate.access$4702(subsamplingScaleImageView2.satTemp, f7);
        subsamplingScaleImageView2.satTemp.vTranslate.set((float)n5 - f5 * f7, (float)n6 - f6 * f7);
        subsamplingScaleImageView2.fitToBounds(true, subsamplingScaleImageView2.satTemp);
        return subsamplingScaleImageView2.satTemp.vTranslate;
    }

    @NonNull
    private PointF limitedSCenter(float f5, float f6, float f7, @NonNull PointF pointF) {
        PointF pointF2 = pointF;
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        PointF pointF3 = subsamplingScaleImageView.vTranslateForSCenter(f5, f6, f7);
        int n5 = this.getPaddingTop() + (this.getHeight() - this.getPaddingBottom() - this.getPaddingTop()) / 2;
        pointF2.set(((float)(subsamplingScaleImageView.getPaddingLeft() + (this.getWidth() - this.getPaddingRight() - this.getPaddingLeft()) / 2) - pointF3.x) / f7, ((float)n5 - pointF3.y) / f7);
        return pointF2;
    }

    private float minScale() {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        int n5 = subsamplingScaleImageView.getPaddingBottom() + this.getPaddingTop();
        int n6 = subsamplingScaleImageView.getPaddingLeft() + this.getPaddingRight();
        int n7 = subsamplingScaleImageView.minimumScaleType;
        if (n7 != 2 && n7 != 4) {
            if (n7 == 3) {
                float f5;
                float f6 = this.minScale;
                if (f5 > 0.0f) {
                    return f6;
                }
            }
            return Math.min((float)(this.getWidth() - n6) / (float)this.sWidth(), (float)(this.getHeight() - n5) / (float)this.sHeight());
        }
        return Math.max((float)(this.getWidth() - n6) / (float)this.sWidth(), (float)(this.getHeight() - n5) / (float)this.sHeight());
    }

    private float limitedScale(float f5) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        float f6 = Math.max(subsamplingScaleImageView.minScale(), f5);
        return Math.min(subsamplingScaleImageView.maxScale, f6);
    }

    private float ease(int n5, long l5, float f5, float f6, long l6) {
        if (n5 != 1) {
            if (n5 == 2) {
                return this.easeInOutQuad(l5, f5, f6, l6);
            }
            throw new IllegalStateException("Unexpected easing type: " + n5);
        }
        return this.easeOutQuad(l5, f5, f6, l6);
    }

    private float easeOutQuad(long l5, float f5, float f6, long l6) {
        float f7 = (float)l5 / (float)l6;
        return -f6 * f7 * (f7 - 2.0f) + f5;
    }

    private float easeInOutQuad(long l5, float f5, float f6, long l6) {
        float f7;
        float f8 = (float)l5 / ((float)l6 / 2.0f);
        if (f7 < 1.0f) {
            return f6 / 2.0f * f8 * f8 + f5;
        }
        float f9 = f8 -= 1.0f;
        return -f6 / 2.0f * (f9 * (f9 - 2.0f) - 1.0f) + f5;
    }

    @AnyThread
    private void debug(String string2, Object ... objectArray) {
        if (this.debug) {
            Log.d((String)TAG, (String)StringUtil.format(string2, objectArray));
            return;
        }
    }

    private int px(int n5) {
        return (int)(this.density * (float)n5);
    }

    private void sendStateChanged(float f5, PointF pointF, int n5) {
        float f6;
        OnStateChangedListener onStateChangedListener = this.onStateChangedListener;
        if (onStateChangedListener != null && (f6 = this.scale) != f5) {
            onStateChangedListener.onScaleChanged(f6, n5);
        }
        if (this.onStateChangedListener != null && !this.vTranslate.equals((Object)pointF)) {
            this.onStateChangedListener.onCenterChanged(this.getCenter(), n5);
            return;
        }
    }

    static /* synthetic */ int access$102(SubsamplingScaleImageView subsamplingScaleImageView, int n5) {
        subsamplingScaleImageView.maxTouchCount = n5;
        return n5;
    }

    static /* synthetic */ PointF access$1702(SubsamplingScaleImageView subsamplingScaleImageView, PointF pointF) {
        subsamplingScaleImageView.vCenterStart = pointF;
        return pointF;
    }

    static /* synthetic */ PointF access$1802(SubsamplingScaleImageView subsamplingScaleImageView, PointF pointF) {
        subsamplingScaleImageView.vTranslateStart = pointF;
        return pointF;
    }

    static /* synthetic */ float access$1902(SubsamplingScaleImageView subsamplingScaleImageView, float f5) {
        subsamplingScaleImageView.scaleStart = f5;
        return f5;
    }

    static /* synthetic */ boolean access$2002(SubsamplingScaleImageView subsamplingScaleImageView, boolean bl) {
        subsamplingScaleImageView.isQuickScaling = bl;
        return bl;
    }

    static /* synthetic */ boolean access$902(SubsamplingScaleImageView subsamplingScaleImageView, boolean bl) {
        subsamplingScaleImageView.isZooming = bl;
        return bl;
    }

    static /* synthetic */ float access$2102(SubsamplingScaleImageView subsamplingScaleImageView, float f5) {
        subsamplingScaleImageView.quickScaleLastDistance = f5;
        return f5;
    }

    static /* synthetic */ PointF access$2202(SubsamplingScaleImageView subsamplingScaleImageView, PointF pointF) {
        subsamplingScaleImageView.quickScaleSCenter = pointF;
        return pointF;
    }

    static /* synthetic */ PointF access$2302(SubsamplingScaleImageView subsamplingScaleImageView, PointF pointF) {
        subsamplingScaleImageView.quickScaleVStart = pointF;
        return pointF;
    }

    static /* synthetic */ PointF access$2402(SubsamplingScaleImageView subsamplingScaleImageView, PointF pointF) {
        subsamplingScaleImageView.quickScaleVLastPoint = pointF;
        return pointF;
    }

    static /* synthetic */ boolean access$2502(SubsamplingScaleImageView subsamplingScaleImageView, boolean bl) {
        subsamplingScaleImageView.quickScaleMoved = bl;
        return bl;
    }

    static /* synthetic */ Anim access$6402(SubsamplingScaleImageView subsamplingScaleImageView, Anim anim2) {
        subsamplingScaleImageView.anim = anim2;
        return anim2;
    }

    static {
        Integer n5 = 0;
        Integer n6 = 90;
        Integer n7 = 180;
        Integer n8 = 270;
        Integer n9 = -1;
        VALID_ORIENTATIONS = Arrays.asList(n5, n6, n7, n8, n9);
        n5 = 1;
        n6 = 2;
        n7 = 3;
        VALID_ZOOM_STYLES = Arrays.asList(n5, n6, n7);
        n5 = 2;
        n6 = 1;
        VALID_EASING_STYLES = Arrays.asList(n5, n6);
        n5 = 1;
        n6 = 2;
        n7 = 3;
        VALID_PAN_LIMITS = Arrays.asList(n5, n6, n7);
        n5 = 2;
        n6 = 1;
        n7 = 3;
        n8 = 4;
        VALID_SCALE_TYPES = Arrays.asList(n5, n6, n7, n8);
    }

    public final void setOrientation(int n5) {
        if (VALID_ORIENTATIONS.contains(n5)) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            subsamplingScaleImageView.orientation = n5;
            subsamplingScaleImageView.reset(false);
            subsamplingScaleImageView.invalidate();
            subsamplingScaleImageView.requestLayout();
            return;
        }
        throw new IllegalArgumentException("Invalid orientation: " + n5);
    }

    public final void setImage(@NonNull ImageSource object) {
        PointF pointF;
        ImageViewState imageViewState;
        ImageSource imageSource = object;
        object = imageViewState;
        PointF pointF2 = pointF;
        pointF = new PointF((float)this.getWidth() / 2.0f, 0.0f);
        imageViewState = new ImageViewState(0.0f, pointF2, 0);
        this.setImage(imageSource, null, (ImageViewState)object);
    }

    public final void setImage(@NonNull ImageSource imageSource, ImageViewState imageViewState) {
        this.setImage(imageSource, null, imageViewState);
    }

    public final void setImage(@NonNull ImageSource imageSource, ImageSource imageSource2) {
        this.setImage(imageSource, imageSource2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setImage(@NonNull ImageSource object, ImageSource object2, ImageViewState imageViewState) {
        TilesInitTask tilesInitTask;
        if (object == null) throw new NullPointerException("imageSource must not be null");
        this.reset(true);
        if (imageViewState != null) {
            this.restoreState(imageViewState);
        }
        if (object2 != null) {
            if (((ImageSource)object).getBitmap() != null) throw new IllegalArgumentException("Preview image cannot be used when a bitmap is provided for the main image");
            if (((ImageSource)object).getSWidth() <= 0 || ((ImageSource)object).getSHeight() <= 0) throw new IllegalArgumentException("Preview image cannot be used unless dimensions are provided for the main image");
            Object object3 = object2;
            this.sWidth = ((ImageSource)object).getSWidth();
            this.sHeight = ((ImageSource)object).getSHeight();
            this.pRegion = ((ImageSource)object3).getSRegion();
            if (((ImageSource)object3).getBitmap() != null) {
                Object object4 = object2;
                this.bitmapIsCached = ((ImageSource)object4).isCached();
                this.onPreviewLoaded(((ImageSource)object4).getBitmap());
            } else {
                BitmapLoadTask bitmapLoadTask;
                imageViewState = ((ImageSource)object2).getUri();
                if (imageViewState == null && ((ImageSource)object2).getResource() != null) {
                    imageViewState = Uri.parse((String)("android.resource://" + this.getContext().getPackageName() + "/" + ((ImageSource)object2).getResource()));
                }
                object2 = bitmapLoadTask;
                DecoderFactory<? extends ImageDecoder> decoderFactory = this.bitmapDecoderFactory;
                bitmapLoadTask = new BitmapLoadTask(this, this.getContext(), decoderFactory, (Uri)imageViewState, true);
                this.execute((AsyncTask<Void, Void, ?>)object2);
            }
        }
        if (((ImageSource)object).getBitmap() != null && ((ImageSource)object).getSRegion() != null) {
            this.onImageLoaded(Bitmap.createBitmap((Bitmap)((ImageSource)object).getBitmap(), (int)((ImageSource)object).getSRegion().left, (int)((ImageSource)object).getSRegion().top, (int)((ImageSource)object).getSRegion().width(), (int)((ImageSource)object).getSRegion().height()), 0, false);
            return;
        }
        if (((ImageSource)object).getBitmap() != null) {
            boolean bl = ((ImageSource)object).isCached();
            this.onImageLoaded(((ImageSource)object).getBitmap(), 0, bl);
            return;
        }
        this.sRegion = ((ImageSource)object).getSRegion();
        this.uri = ((ImageSource)object).getUri();
        if (this.uri == null && ((ImageSource)object).getResource() != null) {
            this.uri = Uri.parse((String)("android.resource://" + this.getContext().getPackageName() + "/" + ((ImageSource)object).getResource()));
        }
        if (!((ImageSource)object).getTile() && this.sRegion == null) {
            BitmapLoadTask bitmapLoadTask;
            object = bitmapLoadTask;
            object2 = this.bitmapDecoderFactory;
            imageViewState = this.uri;
            bitmapLoadTask = new BitmapLoadTask(this, this.getContext(), (DecoderFactory<? extends ImageDecoder>)object2, (Uri)imageViewState, false);
            this.execute((AsyncTask<Void, Void, ?>)object);
            return;
        }
        object = tilesInitTask;
        object2 = this.regionDecoderFactory;
        imageViewState = this.uri;
        tilesInitTask = new TilesInitTask(this, this.getContext(), (DecoderFactory<? extends ImageRegionDecoder>)object2, (Uri)imageViewState);
        this.execute((AsyncTask<Void, Void, ?>)object);
    }

    protected void onSizeChanged(int n5, int n6, int n7, int n8) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        Integer n9 = n7;
        Integer n10 = n8;
        Integer n11 = n5;
        Integer n12 = n6;
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n9;
        objectArray[1] = n10;
        objectArray[2] = n11;
        objectArray[3] = n12;
        subsamplingScaleImageView.debug("onSizeChanged %dx%d -> %dx%d", objectArray2);
        n9 = subsamplingScaleImageView.getCenter();
        if (subsamplingScaleImageView.readySent && n9 != null) {
            this.anim = null;
            this.pendingScale = Float.valueOf(this.scale);
            this.sPendingCenter = n9;
            return;
        }
    }

    protected void onMeasure(int n5, int n6) {
        int n7 = View.MeasureSpec.getMode((int)n5);
        int n8 = n6;
        int n9 = n5;
        n5 = View.MeasureSpec.getMode((int)n6);
        n6 = View.MeasureSpec.getSize((int)n9);
        int n10 = View.MeasureSpec.getSize((int)n8);
        boolean bl = n7 != 0x40000000;
        n5 = n5 != 0x40000000 ? 1 : 0;
        if (this.sWidth > 0 && this.sHeight > 0) {
            if (bl && n5 != 0) {
                SubsamplingScaleImageView subsamplingScaleImageView = this;
                n6 = subsamplingScaleImageView.sWidth();
                n10 = subsamplingScaleImageView.sHeight();
            } else if (n5 != 0) {
                n10 = (int)((double)this.sHeight() / (double)this.sWidth() * (double)n6);
            } else if (bl) {
                n6 = (int)((double)this.sWidth() / (double)this.sHeight() * (double)n10);
            }
        }
        int n11 = Math.max(n6, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(n11, Math.max(n10, this.getSuggestedMinimumHeight()));
    }

    public boolean onTouchEvent(@NonNull MotionEvent motionEvent) {
        Anim anim2 = subsamplingScaleImageView.anim;
        if (anim2 != null && !anim2.interruptible) {
            subsamplingScaleImageView.requestDisallowInterceptTouchEvent(true);
            return true;
        }
        anim2 = subsamplingScaleImageView.anim;
        if (anim2 != null && anim2.listener != null) {
            try {
                subsamplingScaleImageView.anim.listener.onInterruptedByUser();
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"Error thrown by animation listener", (Throwable)exception);
            }
        }
        subsamplingScaleImageView.anim = null;
        if (subsamplingScaleImageView.vTranslate == null) {
            SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView.singleDetector;
            if (subsamplingScaleImageView != null) {
                subsamplingScaleImageView.onTouchEvent(motionEvent);
            }
            return true;
        }
        if (!subsamplingScaleImageView.isQuickScaling && ((anim2 = subsamplingScaleImageView.detector) == null || anim2.onTouchEvent(motionEvent))) {
            subsamplingScaleImageView.isZooming = false;
            subsamplingScaleImageView.isPanning = false;
            subsamplingScaleImageView.maxTouchCount = 0;
            return true;
        }
        if (subsamplingScaleImageView.vTranslateStart == null) {
            PointF pointF;
            anim2 = pointF;
            pointF = new PointF(0.0f, 0.0f);
            subsamplingScaleImageView.vTranslateStart = anim2;
        }
        if (subsamplingScaleImageView.vTranslateBefore == null) {
            PointF pointF;
            anim2 = pointF;
            pointF = new PointF(0.0f, 0.0f);
            subsamplingScaleImageView.vTranslateBefore = anim2;
        }
        if (subsamplingScaleImageView.vCenterStart == null) {
            PointF pointF;
            anim2 = pointF;
            pointF = new PointF(0.0f, 0.0f);
            subsamplingScaleImageView.vCenterStart = anim2;
        }
        float f5 = subsamplingScaleImageView.scale;
        subsamplingScaleImageView.vTranslateBefore.set(subsamplingScaleImageView.vTranslate);
        boolean bl = subsamplingScaleImageView.onTouchEventInternal(motionEvent);
        PointF pointF = subsamplingScaleImageView.vTranslateBefore;
        subsamplingScaleImageView.sendStateChanged(f5, pointF, 2);
        return bl || super.onTouchEvent(motionEvent);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.createPaints();
        if (this.sWidth != 0 && this.sHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
            if (this.tileMap == null && this.decoder != null) {
                this.initialiseBaseLayer(this.getMaxBitmapDimensions(canvas));
            }
            if (this.checkReady()) {
                float f5;
                this.preDraw();
                Anim anim2 = this.anim;
                if (anim2 != null && anim2.vFocusStart != null) {
                    float f6 = this.scale;
                    if (this.vTranslateBefore == null) {
                        PointF pointF;
                        PointF pointF2 = pointF;
                        pointF = new PointF(0.0f, 0.0f);
                        this.vTranslateBefore = pointF2;
                    }
                    this.vTranslateBefore.set(this.vTranslate);
                    long l5 = System.currentTimeMillis() - this.anim.time;
                    boolean bl = l5 > this.anim.duration;
                    l5 = Math.min(l5, this.anim.duration);
                    f5 = this.anim.scaleStart;
                    float f7 = this.anim.scaleEnd - this.anim.scaleStart;
                    long l6 = this.anim.duration;
                    this.scale = this.ease(this.anim.easing, l5, f5, f7, l6);
                    f5 = ((Anim)this.anim).vFocusStart.x;
                    f7 = ((Anim)this.anim).vFocusEnd.x - ((Anim)this.anim).vFocusStart.x;
                    l6 = this.anim.duration;
                    f5 = this.ease(this.anim.easing, l5, f5, f7, l6);
                    f7 = ((Anim)this.anim).vFocusStart.y;
                    float f8 = ((Anim)this.anim).vFocusEnd.y - ((Anim)this.anim).vFocusStart.y;
                    long l7 = this.anim.duration;
                    float f9 = this.ease(this.anim.easing, l5, f7, f8, l7);
                    this.vTranslate.x -= this.sourceToViewX(((Anim)this.anim).sCenterEnd.x) - f5;
                    this.vTranslate.y -= this.sourceToViewY(((Anim)this.anim).sCenterEnd.y) - f9;
                    boolean bl2 = bl || this.anim.scaleStart == this.anim.scaleEnd;
                    this.fitToBounds(bl2);
                    PointF pointF = this.vTranslateBefore;
                    int n5 = this.anim.origin;
                    this.sendStateChanged(f6, pointF, n5);
                    this.refreshRequiredTiles(bl);
                    if (bl) {
                        if (this.anim.listener != null) {
                            try {
                                this.anim.listener.onComplete();
                            }
                            catch (Exception exception) {
                                Log.w((String)TAG, (String)"Error thrown by animation listener", (Throwable)exception);
                            }
                        }
                        this.anim = null;
                    }
                    this.invalidate();
                }
                if (this.tileMap != null && this.isBaseLayerReady()) {
                    int n6 = Math.min(this.fullImageSampleSize, this.calculateInSampleSize(this.scale));
                    boolean bl = false;
                    for (Map.Entry<Integer, List<Tile>> entry : this.tileMap.entrySet()) {
                        if (entry.getKey() != n6) continue;
                        entry = entry.getValue().iterator();
                        while (entry.hasNext()) {
                            Tile tile = (Tile)entry.next();
                            if (!tile.visible || !tile.loading && tile.bitmap != null) continue;
                            bl = true;
                        }
                    }
                    for (Map.Entry<Integer, List<Tile>> entry : this.tileMap.entrySet()) {
                        if (entry.getKey() != n6 && !bl) continue;
                        entry = entry.getValue().iterator();
                        while (entry.hasNext()) {
                            Tile tile = (Tile)entry.next();
                            Rect rect = tile.vRect;
                            this.sourceToViewRect(tile.sRect, rect);
                            if (!tile.loading && tile.bitmap != null) {
                                float f10;
                                float f11;
                                float f12;
                                float f13;
                                if (this.tileBgPaint != null) {
                                    canvas.drawRect(tile.vRect, this.tileBgPaint);
                                }
                                if (this.matrix == null) {
                                    Matrix matrix;
                                    rect = matrix;
                                    matrix = new Matrix();
                                    this.matrix = rect;
                                }
                                this.matrix.reset();
                                float f14 = tile.bitmap.getWidth();
                                float f15 = tile.bitmap.getWidth();
                                float f16 = tile.bitmap.getHeight();
                                float f17 = tile.bitmap.getHeight();
                                this.setMatrixArray(this.srcArray, 0.0f, 0.0f, f14, 0.0f, f15, f16, 0.0f, f17);
                                if (this.getRequiredRotation() == 0) {
                                    f14 = ((Tile)tile).vRect.left;
                                    f15 = ((Tile)tile).vRect.top;
                                    f16 = ((Tile)tile).vRect.right;
                                    f17 = ((Tile)tile).vRect.top;
                                    f13 = ((Tile)tile).vRect.right;
                                    f12 = ((Tile)tile).vRect.bottom;
                                    f11 = ((Tile)tile).vRect.left;
                                    f10 = ((Tile)tile).vRect.bottom;
                                    this.setMatrixArray(this.dstArray, f14, f15, f16, f17, f13, f12, f11, f10);
                                } else if (this.getRequiredRotation() == 90) {
                                    f14 = ((Tile)tile).vRect.right;
                                    f15 = ((Tile)tile).vRect.top;
                                    f16 = ((Tile)tile).vRect.right;
                                    f17 = ((Tile)tile).vRect.bottom;
                                    f13 = ((Tile)tile).vRect.left;
                                    f12 = ((Tile)tile).vRect.bottom;
                                    f11 = ((Tile)tile).vRect.left;
                                    f10 = ((Tile)tile).vRect.top;
                                    this.setMatrixArray(this.dstArray, f14, f15, f16, f17, f13, f12, f11, f10);
                                } else if (this.getRequiredRotation() == 180) {
                                    f14 = ((Tile)tile).vRect.right;
                                    f15 = ((Tile)tile).vRect.bottom;
                                    f16 = ((Tile)tile).vRect.left;
                                    f17 = ((Tile)tile).vRect.bottom;
                                    f13 = ((Tile)tile).vRect.left;
                                    f12 = ((Tile)tile).vRect.top;
                                    f11 = ((Tile)tile).vRect.right;
                                    f10 = ((Tile)tile).vRect.top;
                                    this.setMatrixArray(this.dstArray, f14, f15, f16, f17, f13, f12, f11, f10);
                                } else if (this.getRequiredRotation() == 270) {
                                    f14 = ((Tile)tile).vRect.left;
                                    f15 = ((Tile)tile).vRect.bottom;
                                    f16 = ((Tile)tile).vRect.left;
                                    f17 = ((Tile)tile).vRect.top;
                                    f13 = ((Tile)tile).vRect.right;
                                    f12 = ((Tile)tile).vRect.top;
                                    f11 = ((Tile)tile).vRect.right;
                                    f10 = ((Tile)tile).vRect.bottom;
                                    this.setMatrixArray(this.dstArray, f14, f15, f16, f17, f13, f12, f11, f10);
                                }
                                this.matrix.setPolyToPoly(this.srcArray, 0, this.dstArray, 0, 4);
                                canvas.drawBitmap(tile.bitmap, this.matrix, this.bitmapPaint);
                                if (this.debug) {
                                    canvas.drawRect(tile.vRect, this.debugLinePaint);
                                }
                            } else if (tile.loading && this.debug) {
                                float f18 = ((Tile)tile).vRect.top + this.px(35);
                                Paint paint = this.debugTextPaint;
                                canvas.drawText("LOADING", (float)(((Tile)tile).vRect.left + this.px(5)), f18, paint);
                            }
                            if (!tile.visible || !this.debug) continue;
                            canvas.drawText("ISS " + tile.sampleSize + " RECT " + ((Tile)tile).sRect.top + "," + ((Tile)tile).sRect.left + "," + ((Tile)tile).sRect.bottom + "," + ((Tile)tile).sRect.right, (float)(((Tile)tile).vRect.left + this.px(5)), (float)(((Tile)tile).vRect.top + this.px(15)), this.debugTextPaint);
                        }
                    }
                } else {
                    anim2 = this.bitmap;
                    if (anim2 != null) {
                        float f19;
                        float f20 = this.scale;
                        if (this.bitmapIsPreview) {
                            f20 *= (float)this.sWidth / (float)anim2.getWidth();
                            f19 = this.scale * ((float)this.sHeight / (float)this.bitmap.getHeight());
                        } else {
                            f19 = f20;
                        }
                        if (this.matrix == null) {
                            Matrix matrix;
                            Matrix matrix2 = matrix;
                            matrix = new Matrix();
                            this.matrix = matrix2;
                        }
                        this.matrix.reset();
                        this.matrix.postScale(f20, f19);
                        this.matrix.postRotate((float)this.getRequiredRotation());
                        PointF pointF = this.vTranslate;
                        f19 = pointF.x;
                        this.matrix.postTranslate(f19, pointF.y);
                        if (this.getRequiredRotation() == 180) {
                            float f21 = this.scale;
                            f19 = f21 * (float)this.sWidth;
                            this.matrix.postTranslate(f19, f21 * (float)this.sHeight);
                        } else if (this.getRequiredRotation() == 90) {
                            this.matrix.postTranslate(this.scale * (float)this.sHeight, 0.0f);
                        } else if (this.getRequiredRotation() == 270) {
                            this.matrix.postTranslate(0.0f, this.scale * (float)this.sWidth);
                        }
                        if (this.tileBgPaint != null) {
                            if (this.sRect == null) {
                                RectF rectF;
                                RectF rectF2 = rectF;
                                rectF = new RectF();
                                this.sRect = rectF2;
                            }
                            RectF rectF = this.sRect;
                            f20 = 0.0f;
                            float f22 = 0.0f;
                            float f23 = this.bitmapIsPreview ? (float)this.bitmap.getWidth() : (float)this.sWidth;
                            f5 = this.bitmapIsPreview ? (float)this.bitmap.getHeight() : (float)this.sHeight;
                            rectF.set(f20, f22, f23, f5);
                            this.matrix.mapRect(this.sRect);
                            canvas.drawRect(this.sRect, this.tileBgPaint);
                        }
                        Bitmap bitmap = this.bitmap;
                        Paint paint = this.bitmapPaint;
                        canvas.drawBitmap(bitmap, this.matrix, paint);
                    }
                }
                if (this.debug) {
                    Canvas canvas2 = canvas;
                    Object object = Locale.ENGLISH;
                    PointF pointF = Float.valueOf(this.scale);
                    Object[] objectArray = new Object[1];
                    Object object2 = objectArray;
                    objectArray[0] = pointF;
                    StringBuilder stringBuilder = new StringBuilder().append("Scale: ").append(String.format((Locale)object, "%.2f", object2)).append(" (");
                    pointF = Float.valueOf(this.minScale());
                    Object[] objectArray2 = new Object[1];
                    object2 = objectArray2;
                    objectArray2[0] = pointF;
                    StringBuilder stringBuilder2 = stringBuilder.append(String.format((Locale)object, "%.2f", object2)).append(" - ");
                    pointF = Float.valueOf(this.maxScale);
                    Object[] objectArray3 = new Object[1];
                    object2 = objectArray3;
                    objectArray3[0] = pointF;
                    canvas2.drawText(stringBuilder2.append(String.format((Locale)object, "%.2f", object2)).append(")").toString(), (float)this.px(5), (float)this.px(15), this.debugTextPaint);
                    pointF = Float.valueOf(this.vTranslate.x);
                    Object[] objectArray4 = new Object[1];
                    object2 = objectArray4;
                    objectArray4[0] = pointF;
                    StringBuilder stringBuilder3 = new StringBuilder().append("Translate: ").append(String.format((Locale)object, "%.2f", object2)).append(":");
                    pointF = Float.valueOf(this.vTranslate.y);
                    Object[] objectArray5 = new Object[1];
                    object2 = objectArray5;
                    objectArray5[0] = pointF;
                    canvas2.drawText(stringBuilder3.append(String.format((Locale)object, "%.2f", object2)).toString(), (float)this.px(5), (float)this.px(30), this.debugTextPaint);
                    pointF = this.getCenter();
                    object2 = Float.valueOf(pointF.x);
                    Object[] objectArray6 = new Object[1];
                    Object[] objectArray7 = objectArray6;
                    objectArray6[0] = object2;
                    StringBuilder stringBuilder4 = new StringBuilder().append("Source center: ").append(String.format((Locale)object, "%.2f", objectArray7)).append(":");
                    Locale locale = object;
                    object = Float.valueOf(pointF.y);
                    PointF pointF3 = new Object[1];
                    pointF = pointF3;
                    pointF3[0] = object;
                    canvas2.drawText(stringBuilder4.append(String.format(locale, "%.2f", (Object[])pointF)).toString(), (float)this.px(5), (float)this.px(45), this.debugTextPaint);
                    object = this.anim;
                    if (object != null) {
                        Canvas canvas3 = canvas;
                        object = this.sourceToViewCoord(((Anim)object).sCenterStart);
                        pointF = this.sourceToViewCoord(this.anim.sCenterEndRequested);
                        PointF pointF4 = this.sourceToViewCoord(this.anim.sCenterEnd);
                        PointF pointF5 = pointF;
                        Object object3 = object;
                        float f24 = ((PointF)object3).x;
                        canvas.drawCircle(f24, ((PointF)object3).y, (float)this.px(10), this.debugLinePaint);
                        this.debugLinePaint.setColor(-65536);
                        f24 = pointF5.x;
                        canvas.drawCircle(f24, pointF5.y, (float)this.px(20), this.debugLinePaint);
                        this.debugLinePaint.setColor(-16776961);
                        f24 = pointF4.x;
                        canvas3.drawCircle(f24, pointF4.y, (float)this.px(25), this.debugLinePaint);
                        this.debugLinePaint.setColor(-16711681);
                        canvas3.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)this.px(30), this.debugLinePaint);
                    }
                    if (this.vCenterStart != null) {
                        this.debugLinePaint.setColor(-65536);
                        PointF pointF6 = this.vCenterStart;
                        float f25 = pointF6.x;
                        float f26 = pointF6.y;
                        Paint paint = this.debugLinePaint;
                        canvas.drawCircle(f25, f26, (float)this.px(20), paint);
                    }
                    if (this.quickScaleSCenter != null) {
                        this.debugLinePaint.setColor(-16776961);
                        canvas.drawCircle(this.sourceToViewX(this.quickScaleSCenter.x), this.sourceToViewY(this.quickScaleSCenter.y), (float)this.px(35), this.debugLinePaint);
                    }
                    if (this.quickScaleVStart != null && this.isQuickScaling) {
                        this.debugLinePaint.setColor(-16711681);
                        PointF pointF7 = this.quickScaleVStart;
                        float f27 = pointF7.x;
                        float f28 = pointF7.y;
                        Paint paint = this.debugLinePaint;
                        canvas.drawCircle(f27, f28, (float)this.px(30), paint);
                    }
                    this.debugLinePaint.setColor(-65281);
                }
            }
        }
    }

    public void setOnTileInited(TilesInited tilesInited) {
        this.inited = tilesInited;
    }

    public void setMaxTileSize(int n5) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        subsamplingScaleImageView.maxTileWidth = n5;
        subsamplingScaleImageView.maxTileHeight = n5;
    }

    public void setMaxTileSize(int n5, int n6) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        subsamplingScaleImageView.maxTileWidth = n5;
        subsamplingScaleImageView.maxTileHeight = n6;
    }

    public void recycle() {
        this.reset(true);
        this.bitmapPaint = null;
        this.debugTextPaint = null;
        this.debugLinePaint = null;
        this.tileBgPaint = null;
    }

    public void viewToFileRect(Rect rect, Rect rect2) {
        if (this.vTranslate != null && this.readySent) {
            Rect rect3 = rect2;
            Rect rect4 = rect2;
            int n5 = (int)this.viewToSourceX(rect.left);
            int n6 = (int)this.viewToSourceY(rect.top);
            int n7 = (int)this.viewToSourceX(rect.right);
            int n8 = (int)this.viewToSourceY(rect.bottom);
            rect4.set(n5, n6, n7, n8);
            this.fileSRect(rect4, rect2);
            n5 = Math.max(0, rect3.left);
            n6 = rect3.top;
            int n9 = n5;
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            int n10 = Math.max(0, n6);
            n5 = Math.min(subsamplingScaleImageView.sWidth, rect2.right);
            n6 = Math.min(subsamplingScaleImageView.sHeight, rect2.bottom);
            rect3.set(n9, n10, n5, n6);
            Rect rect5 = this.sRegion;
            if (rect5 != null) {
                Rect rect6 = rect5;
                int n11 = rect6.left;
                rect2.offset(n11, rect6.top);
                return;
            }
        }
    }

    public void visibleFileRect(Rect rect) {
        if (this.vTranslate != null && this.readySent) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            int n5 = subsamplingScaleImageView.getWidth();
            int n6 = subsamplingScaleImageView.getHeight();
            rect.set(0, 0, n5, n6);
            Rect rect2 = rect;
            this.viewToFileRect(rect2, rect2);
            return;
        }
    }

    @Nullable
    public final PointF viewToSourceCoord(PointF pointF) {
        PointF pointF2;
        PointF pointF3 = pointF;
        float f5 = pointF3.x;
        float f6 = pointF3.y;
        PointF pointF4 = pointF2;
        pointF2 = new PointF();
        return this.viewToSourceCoord(f5, f6, pointF4);
    }

    @Nullable
    public final PointF viewToSourceCoord(float f5, float f6) {
        PointF pointF;
        SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
        SubsamplingScaleImageView subsamplingScaleImageView2 = pointF;
        pointF = new PointF();
        return subsamplingScaleImageView.viewToSourceCoord(f5, f6, (PointF)subsamplingScaleImageView2);
    }

    @Nullable
    public final PointF viewToSourceCoord(PointF pointF, @NonNull PointF pointF2) {
        PointF pointF3 = pointF;
        float f5 = pointF3.x;
        return this.viewToSourceCoord(f5, pointF3.y, pointF2);
    }

    @Nullable
    public final PointF viewToSourceCoord(float f5, float f6, @NonNull PointF pointF) {
        if (this.vTranslate == null) {
            return null;
        }
        PointF pointF2 = pointF;
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        float f7 = subsamplingScaleImageView.viewToSourceX(f5);
        pointF2.set(f7, subsamplingScaleImageView.viewToSourceY(f6));
        return pointF2;
    }

    @Nullable
    public final PointF sourceToViewCoord(PointF pointF) {
        PointF pointF2;
        PointF pointF3 = pointF;
        float f5 = pointF3.x;
        float f6 = pointF3.y;
        PointF pointF4 = pointF2;
        pointF2 = new PointF();
        return this.sourceToViewCoord(f5, f6, pointF4);
    }

    @Nullable
    public final PointF sourceToViewCoord(float f5, float f6) {
        PointF pointF;
        SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
        SubsamplingScaleImageView subsamplingScaleImageView2 = pointF;
        pointF = new PointF();
        return subsamplingScaleImageView.sourceToViewCoord(f5, f6, (PointF)subsamplingScaleImageView2);
    }

    @Nullable
    public final PointF sourceToViewCoord(PointF pointF, @NonNull PointF pointF2) {
        PointF pointF3 = pointF;
        float f5 = pointF3.x;
        return this.sourceToViewCoord(f5, pointF3.y, pointF2);
    }

    @Nullable
    public final PointF sourceToViewCoord(float f5, float f6, @NonNull PointF pointF) {
        if (this.vTranslate == null) {
            return null;
        }
        PointF pointF2 = pointF;
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        float f7 = subsamplingScaleImageView.sourceToViewX(f5);
        pointF2.set(f7, subsamplingScaleImageView.sourceToViewY(f6));
        return pointF2;
    }

    public final void setRegionDecoderClass(@NonNull Class<? extends ImageRegionDecoder> clazz) {
        if (clazz != null) {
            CompatDecoderFactory<? extends ImageRegionDecoder> compatDecoderFactory;
            SubsamplingScaleImageView subsamplingScaleImageView = object;
            Object object = compatDecoderFactory;
            compatDecoderFactory = new CompatDecoderFactory<ImageRegionDecoder>(clazz);
            subsamplingScaleImageView.regionDecoderFactory = object;
            return;
        }
        throw new IllegalArgumentException("Decoder class cannot be set to null");
    }

    public final void setRegionDecoderFactory(@NonNull DecoderFactory<? extends ImageRegionDecoder> decoderFactory) {
        if (decoderFactory != null) {
            this.regionDecoderFactory = decoderFactory;
            return;
        }
        throw new IllegalArgumentException("Decoder factory cannot be set to null");
    }

    public final void setBitmapDecoderClass(@NonNull Class<? extends ImageDecoder> clazz) {
        if (clazz != null) {
            CompatDecoderFactory<? extends ImageDecoder> compatDecoderFactory;
            SubsamplingScaleImageView subsamplingScaleImageView = object;
            Object object = compatDecoderFactory;
            compatDecoderFactory = new CompatDecoderFactory<ImageDecoder>(clazz);
            subsamplingScaleImageView.bitmapDecoderFactory = object;
            return;
        }
        throw new IllegalArgumentException("Decoder class cannot be set to null");
    }

    public final void setBitmapDecoderFactory(@NonNull DecoderFactory<? extends ImageDecoder> decoderFactory) {
        if (decoderFactory != null) {
            this.bitmapDecoderFactory = decoderFactory;
            return;
        }
        throw new IllegalArgumentException("Decoder factory cannot be set to null");
    }

    public final void getPanRemaining(RectF rectF) {
        if (!this.isReady()) {
            return;
        }
        float f5 = this.scale * (float)this.sWidth();
        float f6 = this.scale * (float)this.sHeight();
        int n5 = this.panLimit;
        if (n5 == 3) {
            RectF rectF2 = rectF;
            rectF2.top = Math.max(0.0f, -(this.vTranslate.y - (float)(this.getHeight() / 2)));
            rectF2.left = Math.max(0.0f, -(this.vTranslate.x - (float)(this.getWidth() / 2)));
            rectF2.bottom = Math.max(0.0f, this.vTranslate.y - ((float)(this.getHeight() / 2) - f6));
            rectF2.right = Math.max(0.0f, this.vTranslate.x - ((float)(this.getWidth() / 2) - f5));
            return;
        }
        if (n5 == 2) {
            RectF rectF3 = rectF;
            rectF3.top = Math.max(0.0f, -(this.vTranslate.y - (float)this.getHeight()));
            rectF3.left = Math.max(0.0f, -(this.vTranslate.x - (float)this.getWidth()));
            rectF3.bottom = Math.max(0.0f, this.vTranslate.y + f6);
            rectF3.right = Math.max(0.0f, this.vTranslate.x + f5);
            return;
        }
        RectF rectF4 = rectF;
        rectF4.top = Math.max(0.0f, -this.vTranslate.y);
        rectF4.left = Math.max(0.0f, -this.vTranslate.x);
        rectF.bottom = Math.max(0.0f, f6 + this.vTranslate.y - (float)this.getHeight());
        rectF.right = Math.max(0.0f, f5 + this.vTranslate.x - (float)this.getWidth());
    }

    public final void setPanLimit(int n5) {
        if (VALID_PAN_LIMITS.contains(n5)) {
            this.panLimit = n5;
            if (this.isReady()) {
                SubsamplingScaleImageView subsamplingScaleImageView = this;
                subsamplingScaleImageView.fitToBounds(true);
                subsamplingScaleImageView.invalidate();
                return;
            }
            return;
        }
        throw new IllegalArgumentException("Invalid pan limit: " + n5);
    }

    public final void setMinimumScaleType(int n5) {
        if (VALID_SCALE_TYPES.contains(n5)) {
            this.minimumScaleType = n5;
            if (this.isReady()) {
                SubsamplingScaleImageView subsamplingScaleImageView = this;
                subsamplingScaleImageView.fitToBounds(true);
                subsamplingScaleImageView.invalidate();
                return;
            }
            return;
        }
        throw new IllegalArgumentException("Invalid scale type: " + n5);
    }

    public final void setMaxScale(float f5) {
        this.maxScale = f5;
    }

    public final void setMinScale(float f5) {
        this.minScale = f5;
    }

    public final void setMinimumDpi(int n5) {
        SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
        SubsamplingScaleImageView subsamplingScaleImageView2 = subsamplingScaleImageView.getResources().getDisplayMetrics();
        subsamplingScaleImageView.setMaxScale((((DisplayMetrics)subsamplingScaleImageView2).xdpi + ((DisplayMetrics)subsamplingScaleImageView2).ydpi) / 2.0f / (float)n5);
    }

    public final void setMaximumDpi(int n5) {
        SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
        SubsamplingScaleImageView subsamplingScaleImageView2 = subsamplingScaleImageView.getResources().getDisplayMetrics();
        subsamplingScaleImageView.setMinScale((((DisplayMetrics)subsamplingScaleImageView2).xdpi + ((DisplayMetrics)subsamplingScaleImageView2).ydpi) / 2.0f / (float)n5);
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public final float getMinScale() {
        return this.minScale();
    }

    public void setMinimumTileDpi(int n5) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        DisplayMetrics displayMetrics = subsamplingScaleImageView.getResources().getDisplayMetrics();
        subsamplingScaleImageView.minimumTileDpi = (int)Math.min((displayMetrics.xdpi + displayMetrics.ydpi) / 2.0f, (float)n5);
        if (subsamplingScaleImageView.isReady()) {
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            subsamplingScaleImageView2.reset(false);
            subsamplingScaleImageView2.invalidate();
            return;
        }
    }

    @Nullable
    public final PointF getCenter() {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        int n5 = subsamplingScaleImageView.getWidth() / 2;
        float f5 = n5;
        return subsamplingScaleImageView.viewToSourceCoord(f5, subsamplingScaleImageView.getHeight() / 2);
    }

    public final float getScale() {
        return this.scale;
    }

    public final void setScaleAndCenter(float f5, @Nullable PointF pointF) {
        this.anim = null;
        this.pendingScale = Float.valueOf(f5);
        this.sPendingCenter = pointF;
        this.sRequestedCenter = pointF;
        this.invalidate();
    }

    public final void resetScaleAndCenter() {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        subsamplingScaleImageView.anim = null;
        subsamplingScaleImageView.pendingScale = Float.valueOf(subsamplingScaleImageView.limitedScale(0.0f));
        if (subsamplingScaleImageView.isReady()) {
            this.sPendingCenter = new PointF((float)(this.sWidth() / 2), (float)(this.sHeight() / 2));
        } else {
            PointF pointF;
            PointF pointF2 = pointF;
            pointF = new PointF(0.0f, 0.0f);
            this.sPendingCenter = pointF2;
        }
        this.invalidate();
    }

    public final boolean isReady() {
        return this.readySent;
    }

    protected void onReady() {
    }

    public final boolean isImageLoaded() {
        return this.imageLoadedSent;
    }

    protected void onImageLoaded() {
    }

    public final int getSWidth() {
        return this.sWidth;
    }

    public final int getSHeight() {
        return this.sHeight;
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final int getAppliedOrientation() {
        return this.getRequiredRotation();
    }

    @Nullable
    public final ImageViewState getState() {
        if (this.vTranslate != null && this.sWidth > 0 && this.sHeight > 0) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            float f5 = subsamplingScaleImageView.getScale();
            PointF pointF = subsamplingScaleImageView.getCenter();
            int n5 = subsamplingScaleImageView.getOrientation();
            return new ImageViewState(f5, pointF, n5);
        }
        return null;
    }

    public final boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    public final void setZoomEnabled(boolean bl) {
        this.zoomEnabled = bl;
    }

    public final boolean isQuickScaleEnabled() {
        return this.quickScaleEnabled;
    }

    public final void setQuickScaleEnabled(boolean bl) {
        this.quickScaleEnabled = bl;
    }

    public final boolean isPanEnabled() {
        return this.panEnabled;
    }

    public final void setPanEnabled(boolean bl) {
        PointF pointF;
        this.panEnabled = bl;
        if (!bl && (pointF = this.vTranslate) != null) {
            pointF.x = (float)(this.getWidth() / 2) - this.scale * (float)(this.sWidth() / 2);
            this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * (float)(this.sHeight() / 2);
            if (this.isReady()) {
                SubsamplingScaleImageView subsamplingScaleImageView = this;
                subsamplingScaleImageView.refreshRequiredTiles(true);
                subsamplingScaleImageView.invalidate();
                return;
            }
        }
    }

    public final void setTileBackgroundColor(int n5) {
        if (Color.alpha((int)n5) == 0) {
            this.tileBgPaint = null;
        } else {
            this.tileBgPaint = new Paint();
            this.tileBgPaint.setStyle(Paint.Style.FILL);
            this.tileBgPaint.setColor(n5);
        }
        this.invalidate();
    }

    public final void setDoubleTapZoomScale(float f5) {
        this.doubleTapZoomScale = f5;
    }

    public final void setDoubleTapZoomDpi(int n5) {
        SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
        SubsamplingScaleImageView subsamplingScaleImageView2 = subsamplingScaleImageView.getResources().getDisplayMetrics();
        subsamplingScaleImageView.setDoubleTapZoomScale((((DisplayMetrics)subsamplingScaleImageView2).xdpi + ((DisplayMetrics)subsamplingScaleImageView2).ydpi) / 2.0f / (float)n5);
    }

    public final void setDoubleTapZoomStyle(int n5) {
        if (VALID_ZOOM_STYLES.contains(n5)) {
            this.doubleTapZoomStyle = n5;
            return;
        }
        throw new IllegalArgumentException("Invalid zoom style: " + n5);
    }

    public final void setDoubleTapZoomDuration(int n5) {
        this.doubleTapZoomDuration = Math.max(0, n5);
    }

    public void setExecutor(@NonNull Executor executor) {
        if (executor != null) {
            this.executor = executor;
            return;
        }
        throw new NullPointerException("Executor must not be null");
    }

    public void setEagerLoadingEnabled(boolean bl) {
        this.eagerLoadingEnabled = bl;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean hasImage() {
        return this.uri != null || this.bitmap != null;
        {
        }
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        super.setOnLongClickListener(onLongClickListener);
        this.onLongClickListener = onLongClickListener;
    }

    public void setOnImageEventListener(OnImageEventListener onImageEventListener) {
        this.onImageEventListener = onImageEventListener;
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.onStateChangedListener = onStateChangedListener;
    }

    @Nullable
    public AnimationBuilder animateCenter(PointF pointF) {
        if (!this.isReady()) {
            return null;
        }
        return new AnimationBuilder(this, pointF);
    }

    @Nullable
    public AnimationBuilder animateScale(float f5) {
        if (!this.isReady()) {
            return null;
        }
        return new AnimationBuilder(this, f5);
    }

    @Nullable
    public AnimationBuilder animateScaleAndCenter(float f5, PointF pointF) {
        if (!this.isReady()) {
            return null;
        }
        return new AnimationBuilder(this, f5, pointF);
    }

    private static class ScaleAndTranslate {
        private float scale;
        private final PointF vTranslate;

        private ScaleAndTranslate(float f5, PointF pointF) {
            this.scale = f5;
            this.vTranslate = pointF;
        }

        static /* synthetic */ float access$4702(ScaleAndTranslate scaleAndTranslate, float f5) {
            scaleAndTranslate.scale = f5;
            return f5;
        }
    }

    private static class Anim {
        private float scaleStart;
        private float scaleEnd;
        private PointF sCenterStart;
        private PointF sCenterEnd;
        private PointF sCenterEndRequested;
        private PointF vFocusStart;
        private PointF vFocusEnd;
        private long duration = 500L;
        private boolean interruptible = true;
        private int easing = 2;
        private int origin = 1;
        private long time = System.currentTimeMillis();
        private OnAnimationEventListener listener;

        private Anim() {
        }

        static /* synthetic */ float access$3502(Anim anim2, float f5) {
            anim2.scaleStart = f5;
            return f5;
        }

        static /* synthetic */ float access$3602(Anim anim2, float f5) {
            anim2.scaleEnd = f5;
            return f5;
        }

        static /* synthetic */ long access$3202(Anim anim2, long l5) {
            anim2.time = l5;
            return l5;
        }

        static /* synthetic */ PointF access$4502(Anim anim2, PointF pointF) {
            anim2.sCenterEndRequested = pointF;
            return pointF;
        }

        static /* synthetic */ PointF access$4402(Anim anim2, PointF pointF) {
            anim2.sCenterStart = pointF;
            return pointF;
        }

        static /* synthetic */ PointF access$3802(Anim anim2, PointF pointF) {
            anim2.sCenterEnd = pointF;
            return pointF;
        }

        static /* synthetic */ PointF access$3102(Anim anim2, PointF pointF) {
            anim2.vFocusStart = pointF;
            return pointF;
        }

        static /* synthetic */ PointF access$3702(Anim anim2, PointF pointF) {
            anim2.vFocusEnd = pointF;
            return pointF;
        }

        static /* synthetic */ long access$3302(Anim anim2, long l5) {
            anim2.duration = l5;
            return l5;
        }

        static /* synthetic */ boolean access$2702(Anim anim2, boolean bl) {
            anim2.interruptible = bl;
            return bl;
        }

        static /* synthetic */ int access$3402(Anim anim2, int n5) {
            anim2.easing = n5;
            return n5;
        }

        static /* synthetic */ int access$3902(Anim anim2, int n5) {
            anim2.origin = n5;
            return n5;
        }

        static /* synthetic */ OnAnimationEventListener access$2802(Anim anim2, OnAnimationEventListener onAnimationEventListener) {
            anim2.listener = onAnimationEventListener;
            return onAnimationEventListener;
        }
    }

    public static interface OnImageEventListener {
        public void onReady();

        public void onImageLoaded();

        public void onPreviewLoadError(Exception var1);

        public void onImageLoadError(Exception var1);

        public void onTileLoadError(Exception var1);

        public void onPreviewReleased();
    }

    private static class BitmapLoadTask
    extends AsyncTask<Void, Void, Integer> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<Context> contextRef;
        private final WeakReference<DecoderFactory<? extends ImageDecoder>> decoderFactoryRef;
        private final Uri source;
        private final boolean preview;
        private Bitmap bitmap;
        private Exception exception;

        BitmapLoadTask(SubsamplingScaleImageView subsamplingScaleImageView, Context context, DecoderFactory<? extends ImageDecoder> decoderFactory, Uri uri, boolean bl) {
            WeakReference<DecoderFactory<? extends ImageDecoder>> weakReference;
            WeakReference<Context> weakReference2;
            WeakReference<SubsamplingScaleImageView> weakReference3;
            Object object = weakReference3;
            weakReference3 = new WeakReference<SubsamplingScaleImageView>(subsamplingScaleImageView);
            v1.viewRef = object;
            object = weakReference2;
            weakReference2 = new WeakReference<Context>(context);
            v1.contextRef = object;
            object = weakReference;
            weakReference = new WeakReference<DecoderFactory<? extends ImageDecoder>>(decoderFactory);
            v1.decoderFactoryRef = object;
            v1.source = uri;
            v1.preview = bl;
        }

        protected Integer doInBackground(Void ... object) {
            block7: {
                Exception exception2;
                block9: {
                    BitmapLoadTask bitmapLoadTask = this;
                    BitmapLoadTask bitmapLoadTask2 = bitmapLoadTask;
                    object = bitmapLoadTask.source.toString();
                    Context context = (Context)bitmapLoadTask2.contextRef.get();
                    BitmapLoadTask bitmapLoadTask3 = this;
                    BitmapLoadTask bitmapLoadTask4 = bitmapLoadTask3;
                    DecoderFactory decoderFactory = (DecoderFactory)bitmapLoadTask3.decoderFactoryRef.get();
                    SubsamplingScaleImageView subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)bitmapLoadTask4.viewRef.get());
                    if (context == null || decoderFactory == null || subsamplingScaleImageView == null) break block7;
                    try {
                        subsamplingScaleImageView.debug("BitmapLoadTask.doInBackground", new Object[0]);
                        this.bitmap = ((ImageDecoder)decoderFactory.make()).decode(context, this.source);
                        return subsamplingScaleImageView.getExifOrientation(context, (String)object);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                    }
                    catch (Exception exception2) {
                        break block9;
                    }
                    Log.e((String)TAG, (String)"Failed to load bitmap - OutOfMemoryError", (Throwable)outOfMemoryError);
                    this.exception = new RuntimeException(outOfMemoryError);
                    break block7;
                }
                Log.e((String)TAG, (String)"Failed to load bitmap", (Throwable)exception2);
                this.exception = exception2;
            }
            return null;
        }

        protected void onPostExecute(Integer n5) {
            SubsamplingScaleImageView subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)this.viewRef.get());
            if (subsamplingScaleImageView != null) {
                Bitmap bitmap = this.bitmap;
                if (bitmap != null && n5 != null) {
                    if (this.preview) {
                        subsamplingScaleImageView.onPreviewLoaded(bitmap);
                        return;
                    }
                    subsamplingScaleImageView.onImageLoaded(bitmap, n5, false);
                    return;
                }
                if (this.exception != null && subsamplingScaleImageView.onImageEventListener != null) {
                    if (this.preview) {
                        subsamplingScaleImageView.onImageEventListener.onPreviewLoadError(this.exception);
                        return;
                    }
                    subsamplingScaleImageView.onImageEventListener.onImageLoadError(this.exception);
                    return;
                }
            }
        }
    }

    private static class TilesInitTask
    extends AsyncTask<Void, Void, int[]> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<Context> contextRef;
        private final WeakReference<DecoderFactory<? extends ImageRegionDecoder>> decoderFactoryRef;
        private final Uri source;
        private ImageRegionDecoder decoder;
        private Exception exception;

        TilesInitTask(SubsamplingScaleImageView subsamplingScaleImageView, Context context, DecoderFactory<? extends ImageRegionDecoder> decoderFactory, Uri uri) {
            WeakReference<DecoderFactory<? extends ImageRegionDecoder>> weakReference;
            WeakReference<Context> weakReference2;
            WeakReference<SubsamplingScaleImageView> weakReference3;
            Object object = weakReference3;
            weakReference3 = new WeakReference<SubsamplingScaleImageView>(subsamplingScaleImageView);
            v1.viewRef = object;
            object = weakReference2;
            weakReference2 = new WeakReference<Context>(context);
            v1.contextRef = object;
            object = weakReference;
            weakReference = new WeakReference<DecoderFactory<? extends ImageRegionDecoder>>(decoderFactory);
            v1.decoderFactoryRef = object;
            v1.source = uri;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected int[] doInBackground(Void ... object) {
            block6: {
                Exception exception2;
                block5: {
                    Object object2;
                    Context context;
                    SubsamplingScaleImageView subsamplingScaleImageView;
                    SubsamplingScaleImageView subsamplingScaleImageView2;
                    SubsamplingScaleImageView subsamplingScaleImageView3;
                    Context context2;
                    try {
                        TilesInitTask tilesInitTask = this;
                        object = tilesInitTask.source.toString();
                        context2 = (Context)tilesInitTask.contextRef.get();
                    }
                    catch (Exception exception2) {
                        break block5;
                    }
                    {
                        TilesInitTask tilesInitTask = this;
                        DecoderFactory decoderFactory = (DecoderFactory)tilesInitTask.decoderFactoryRef.get();
                        subsamplingScaleImageView3 = (SubsamplingScaleImageView)((Object)tilesInitTask.viewRef.get());
                        if (context2 == null || decoderFactory == null || subsamplingScaleImageView3 == null) break block6;
                        SubsamplingScaleImageView subsamplingScaleImageView4 = subsamplingScaleImageView3;
                        subsamplingScaleImageView2 = subsamplingScaleImageView4;
                        subsamplingScaleImageView = subsamplingScaleImageView4;
                        context = context2;
                        object2 = object;
                        subsamplingScaleImageView3.debug("TilesInitTask.doInBackground", new Object[0]);
                        object = (ImageRegionDecoder)decoderFactory.make();
                    }
                    this.decoder = object;
                    Point point = object.init(context2, this.source);
                    int n5 = point.x;
                    int n6 = point.y;
                    int n7 = subsamplingScaleImageView2.getExifOrientation(context, (String)object2);
                    if (subsamplingScaleImageView.sRegion != null) {
                        SubsamplingScaleImageView subsamplingScaleImageView5 = subsamplingScaleImageView3;
                        ((SubsamplingScaleImageView)subsamplingScaleImageView5).sRegion.left = Math.max(0, ((SubsamplingScaleImageView)subsamplingScaleImageView3).sRegion.left);
                        ((SubsamplingScaleImageView)subsamplingScaleImageView5).sRegion.top = Math.max(0, ((SubsamplingScaleImageView)subsamplingScaleImageView3).sRegion.top);
                        ((SubsamplingScaleImageView)subsamplingScaleImageView5).sRegion.right = Math.min(n5, ((SubsamplingScaleImageView)subsamplingScaleImageView3).sRegion.right);
                        ((SubsamplingScaleImageView)subsamplingScaleImageView5).sRegion.bottom = Math.min(n6, ((SubsamplingScaleImageView)subsamplingScaleImageView3).sRegion.bottom);
                        n5 = subsamplingScaleImageView5.sRegion.width();
                        n6 = subsamplingScaleImageView5.sRegion.height();
                    }
                    return new int[]{n5, n6, n7};
                }
                Log.e((String)TAG, (String)"Failed to initialise bitmap decoder", (Throwable)exception2);
                this.exception = exception2;
            }
            return null;
        }

        protected void onPostExecute(int[] nArray) {
            SubsamplingScaleImageView subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)this.viewRef.get());
            if (subsamplingScaleImageView != null) {
                ImageRegionDecoder imageRegionDecoder = this.decoder;
                if (imageRegionDecoder != null && nArray != null && nArray.length == 3) {
                    int n5 = nArray[0];
                    int n6 = nArray[1];
                    int n7 = nArray[2];
                    subsamplingScaleImageView.onTilesInited(imageRegionDecoder, n5, n6, n7);
                    return;
                }
                if (this.exception != null && subsamplingScaleImageView.onImageEventListener != null) {
                    subsamplingScaleImageView.onImageEventListener.onImageLoadError(this.exception);
                    return;
                }
            }
        }
    }

    private static class Tile {
        private Rect sRect;
        private int sampleSize;
        private Bitmap bitmap;
        private boolean loading;
        private boolean visible;
        private Rect vRect;
        private Rect fileSRect;

        private Tile() {
        }

        static /* synthetic */ boolean access$402(Tile tile, boolean bl) {
            tile.visible = bl;
            return bl;
        }

        static /* synthetic */ Bitmap access$502(Tile tile, Bitmap bitmap) {
            tile.bitmap = bitmap;
            return bitmap;
        }

        static /* synthetic */ int access$4302(Tile tile, int n5) {
            tile.sampleSize = n5;
            return n5;
        }

        static /* synthetic */ Rect access$4102(Tile tile, Rect rect) {
            tile.sRect = rect;
            return rect;
        }

        static /* synthetic */ Rect access$4202(Tile tile, Rect rect) {
            tile.vRect = rect;
            return rect;
        }

        static /* synthetic */ Rect access$5002(Tile tile, Rect rect) {
            tile.fileSRect = rect;
            return rect;
        }

        static /* synthetic */ boolean access$4002(Tile tile, boolean bl) {
            tile.loading = bl;
            return bl;
        }
    }

    public static interface OnAnimationEventListener {
        public void onComplete();

        public void onInterruptedByUser();

        public void onInterruptedByNewAnim();
    }

    public final class AnimationBuilder {
        private final float targetScale;
        private final PointF targetSCenter;
        private final PointF vFocus;
        private long duration;
        private int easing;
        private int origin;
        private boolean interruptible;
        private boolean panLimited;
        private OnAnimationEventListener listener;
        final /* synthetic */ SubsamplingScaleImageView this$0;

        private AnimationBuilder(SubsamplingScaleImageView subsamplingScaleImageView, PointF pointF) {
            AnimationBuilder animationBuilder = this;
            this.this$0 = subsamplingScaleImageView;
            this.duration = 500L;
            this.easing = 2;
            this.origin = 1;
            this.interruptible = true;
            this.panLimited = true;
            this.targetScale = subsamplingScaleImageView.scale;
            animationBuilder.targetSCenter = pointF;
            animationBuilder.vFocus = null;
        }

        private AnimationBuilder(SubsamplingScaleImageView subsamplingScaleImageView, float f5) {
            AnimationBuilder animationBuilder = this;
            this.this$0 = subsamplingScaleImageView;
            this.duration = 500L;
            this.easing = 2;
            this.origin = 1;
            this.interruptible = true;
            this.panLimited = true;
            this.targetScale = f5;
            animationBuilder.targetSCenter = subsamplingScaleImageView.getCenter();
            animationBuilder.vFocus = null;
        }

        private AnimationBuilder(SubsamplingScaleImageView subsamplingScaleImageView, float f5, PointF pointF) {
            this.this$0 = subsamplingScaleImageView;
            this.duration = 500L;
            this.easing = 2;
            this.origin = 1;
            this.interruptible = true;
            this.panLimited = true;
            this.targetScale = f5;
            this.targetSCenter = pointF;
            this.vFocus = null;
        }

        private AnimationBuilder(SubsamplingScaleImageView subsamplingScaleImageView, float f5, PointF pointF, PointF pointF2) {
            this.this$0 = subsamplingScaleImageView;
            this.duration = 500L;
            this.easing = 2;
            this.origin = 1;
            this.interruptible = true;
            this.panLimited = true;
            this.targetScale = f5;
            this.targetSCenter = pointF;
            this.vFocus = pointF2;
        }

        @NonNull
        private AnimationBuilder withPanLimited(boolean bl) {
            this.panLimited = bl;
            return this;
        }

        @NonNull
        private AnimationBuilder withOrigin(int n5) {
            this.origin = n5;
            return this;
        }

        @NonNull
        public AnimationBuilder withDuration(long l5) {
            this.duration = l5;
            return this;
        }

        @NonNull
        public AnimationBuilder withInterruptible(boolean bl) {
            this.interruptible = bl;
            return this;
        }

        @NonNull
        public AnimationBuilder withEasing(int n5) {
            if (VALID_EASING_STYLES.contains(n5)) {
                this.easing = n5;
                return this;
            }
            throw new IllegalArgumentException("Unknown easing type: " + n5);
        }

        @NonNull
        public AnimationBuilder withOnAnimationEventListener(OnAnimationEventListener onAnimationEventListener) {
            this.listener = onAnimationEventListener;
            return this;
        }

        public void start() {
            Object object;
            if (this.this$0.anim != null && this.this$0.anim.listener != null) {
                try {
                    this.this$0.anim.listener.onInterruptedByNewAnim();
                }
                catch (Exception exception) {
                    Log.w((String)TAG, (String)"Error thrown by animation listener", (Throwable)exception);
                }
            }
            int n5 = this.this$0.getPaddingLeft() + (this.this$0.getWidth() - this.this$0.getPaddingRight() - this.this$0.getPaddingLeft()) / 2;
            int n6 = this.this$0.getPaddingTop() + (this.this$0.getHeight() - this.this$0.getPaddingBottom() - this.this$0.getPaddingTop()) / 2;
            float f5 = this.this$0.limitedScale(this.targetScale);
            if (this.panLimited) {
                PointF pointF;
                PointF pointF2 = this.targetSCenter;
                float f6 = pointF2.x;
                float f7 = pointF2.y;
                object = pointF;
                pointF = new PointF();
                object = this.this$0.limitedSCenter(f6, f7, f5, object);
            } else {
                object = this.targetSCenter;
            }
            SubsamplingScaleImageView.access$6402(this.this$0, new Anim());
            Anim.access$3502(this.this$0.anim, this.this$0.scale);
            Anim.access$3602(this.this$0.anim, f5);
            Anim.access$3202(this.this$0.anim, System.currentTimeMillis());
            Anim.access$4502(this.this$0.anim, object);
            Anim.access$4402(this.this$0.anim, this.this$0.getCenter());
            Anim.access$3802(this.this$0.anim, object);
            Anim.access$3102(this.this$0.anim, this.this$0.sourceToViewCoord((PointF)object));
            float f8 = n5;
            Anim.access$3702(this.this$0.anim, new PointF(f8, (float)n6));
            Anim.access$3302(this.this$0.anim, this.duration);
            Anim.access$2702(this.this$0.anim, this.interruptible);
            Anim.access$3402(this.this$0.anim, this.easing);
            Anim.access$3902(this.this$0.anim, this.origin);
            Anim.access$3202(this.this$0.anim, System.currentTimeMillis());
            Anim.access$2802(this.this$0.anim, this.listener);
            PointF pointF = this.vFocus;
            if (pointF != null) {
                ScaleAndTranslate scaleAndTranslate;
                float f9 = pointF.x - f5 * ((Anim)((SubsamplingScaleImageView)this.this$0).anim).sCenterStart.x;
                float f10 = this.vFocus.y - f5 * ((Anim)((SubsamplingScaleImageView)this.this$0).anim).sCenterStart.y;
                object = scaleAndTranslate;
                scaleAndTranslate = new ScaleAndTranslate(f5, new PointF(f9, f10));
                this.this$0.fitToBounds(true, (ScaleAndTranslate)object);
                Anim.access$3702(this.this$0.anim, new PointF(this.vFocus.x + (((ScaleAndTranslate)object).vTranslate.x - f9), this.vFocus.y + (((ScaleAndTranslate)object).vTranslate.y - f10)));
            }
            this.this$0.invalidate();
        }
    }

    private static class TileLoadTask
    extends AsyncTask<Void, Void, Bitmap> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<ImageRegionDecoder> decoderRef;
        private final WeakReference<Tile> tileRef;
        private Exception exception;

        TileLoadTask(SubsamplingScaleImageView subsamplingScaleImageView, ImageRegionDecoder imageRegionDecoder, Tile tile) {
            WeakReference<Tile> weakReference;
            WeakReference<ImageRegionDecoder> weakReference2;
            WeakReference<SubsamplingScaleImageView> weakReference3;
            Object object = weakReference3;
            weakReference3 = new WeakReference<SubsamplingScaleImageView>(subsamplingScaleImageView);
            v1.viewRef = object;
            object = weakReference2;
            weakReference2 = new WeakReference<ImageRegionDecoder>(imageRegionDecoder);
            v1.decoderRef = object;
            object = weakReference;
            weakReference = new WeakReference<Tile>(tile);
            v1.tileRef = object;
            Tile.access$4002(tile, true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Bitmap doInBackground(Void ... object) {
            Exception exception2;
            block14: {
                OutOfMemoryError outOfMemoryError2;
                block13: {
                    Tile tile;
                    block11: {
                        Throwable throwable2;
                        block15: {
                            block12: {
                                Bitmap bitmap;
                                TileLoadTask tileLoadTask = this;
                                object = (SubsamplingScaleImageView)((Object)tileLoadTask.viewRef.get());
                                ImageRegionDecoder imageRegionDecoder = (ImageRegionDecoder)tileLoadTask.decoderRef.get();
                                tile = (Tile)this.tileRef.get();
                                if (imageRegionDecoder == null || tile == null || object == null || !imageRegionDecoder.isReady() || !tile.visible) break block11;
                                ImageRegionDecoder imageRegionDecoder2 = imageRegionDecoder;
                                Object object2 = object;
                                Object object3 = object;
                                Object object4 = "TileLoadTask.doInBackground, tile.sRect=%s, tile.sampleSize=%d";
                                Rect rect = tile.sRect;
                                String string2 = object4;
                                object4 = tile.sampleSize;
                                Object[] objectArray = new Object[2];
                                Object[] objectArray2 = objectArray;
                                objectArray[0] = rect;
                                objectArray[1] = object4;
                                ((SubsamplingScaleImageView)((Object)object2)).debug(string2, objectArray2);
                                ((SubsamplingScaleImageView)((Object)object3)).decoderLock.readLock().lock();
                                try {
                                    if (!imageRegionDecoder2.isReady()) break block12;
                                    Tile tile2 = tile;
                                    object4 = tile2.sRect;
                                    ((SubsamplingScaleImageView)((Object)object)).fileSRect((Rect)object4, tile2.fileSRect);
                                    if (((SubsamplingScaleImageView)((Object)object)).sRegion != null) {
                                        tile.fileSRect.offset(((SubsamplingScaleImageView)((Object)object)).sRegion.left, ((SubsamplingScaleImageView)((Object)object)).sRegion.top);
                                    }
                                    ImageRegionDecoder imageRegionDecoder3 = imageRegionDecoder;
                                    Tile tile3 = tile;
                                    imageRegionDecoder = tile3.fileSRect;
                                    bitmap = imageRegionDecoder3.decodeRegion((Rect)imageRegionDecoder, tile3.sampleSize);
                                }
                                catch (Throwable throwable2) {}
                                ((SubsamplingScaleImageView)((Object)object)).decoderLock.readLock().unlock();
                                return bitmap;
                            }
                            Object object5 = object;
                            Tile.access$4002(tile, false);
                            break block15;
                            try {
                                ((SubsamplingScaleImageView)((Object)object5)).decoderLock.readLock().unlock();
                                return null;
                            }
                            catch (OutOfMemoryError outOfMemoryError2) {
                                break block13;
                            }
                            catch (Exception exception2) {
                                break block14;
                            }
                        }
                        ((SubsamplingScaleImageView)((Object)object)).decoderLock.readLock().unlock();
                        throw throwable2;
                    }
                    if (tile == null) return null;
                    Tile.access$4002(tile, false);
                    return null;
                }
                Log.e((String)TAG, (String)"Failed to decode tile - OutOfMemoryError", (Throwable)outOfMemoryError2);
                this.exception = new RuntimeException(outOfMemoryError2);
                return null;
            }
            Log.e((String)TAG, (String)"Failed to decode tile", (Throwable)exception2);
            this.exception = exception2;
            return null;
        }

        protected void onPostExecute(Bitmap bitmap) {
            SubsamplingScaleImageView subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)this.viewRef.get());
            Tile tile = (Tile)this.tileRef.get();
            if (subsamplingScaleImageView != null && tile != null) {
                if (bitmap != null) {
                    Tile tile2 = tile;
                    Tile.access$502(tile2, bitmap);
                    Tile.access$4002(tile2, false);
                    subsamplingScaleImageView.onTileLoaded();
                    return;
                }
                if (this.exception != null && subsamplingScaleImageView.onImageEventListener != null) {
                    subsamplingScaleImageView.onImageEventListener.onTileLoadError(this.exception);
                    return;
                }
            }
        }
    }

    public static interface TilesInited {
        public void onTileInited();
    }

    public static interface OnStateChangedListener {
        public void onScaleChanged(float var1, int var2);

        public void onCenterChanged(PointF var1, int var2);
    }

    public static class DefaultOnStateChangedListener
    implements OnStateChangedListener {
        @Override
        public void onCenterChanged(PointF pointF, int n5) {
        }

        @Override
        public void onScaleChanged(float f5, int n5) {
        }
    }

    public static class DefaultOnImageEventListener
    implements OnImageEventListener {
        @Override
        public void onReady() {
        }

        @Override
        public void onImageLoaded() {
        }

        @Override
        public void onPreviewLoadError(Exception exception) {
        }

        @Override
        public void onImageLoadError(Exception exception) {
        }

        @Override
        public void onTileLoadError(Exception exception) {
        }

        @Override
        public void onPreviewReleased() {
        }
    }

    public static class DefaultOnAnimationEventListener
    implements OnAnimationEventListener {
        @Override
        public void onComplete() {
        }

        @Override
        public void onInterruptedByUser() {
        }

        @Override
        public void onInterruptedByNewAnim() {
        }
    }
}

