/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.util.Arrays;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.contextanalysis.EUCJPContextAnalysis;
import org.mozilla.universalchardet.prober.distributionanalysis.EUCJPDistributionAnalysis;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.EUCJPSMModel;
import org.mozilla.universalchardet.prober.statemachine.SMModel;

public class EUCJPProber
extends CharsetProber {
    private static final SMModel smModel = new EUCJPSMModel();
    private CodingStateMachine codingSM;
    private CharsetProber.ProbingState state;
    private EUCJPContextAnalysis contextAnalyzer;
    private EUCJPDistributionAnalysis distributionAnalyzer;
    private byte[] lastChar;

    public EUCJPProber() {
        EUCJPProber eUCJPProber = this;
        eUCJPProber.codingSM = new CodingStateMachine(smModel);
        eUCJPProber.contextAnalyzer = new EUCJPContextAnalysis();
        eUCJPProber.distributionAnalyzer = new EUCJPDistributionAnalysis();
        eUCJPProber.lastChar = new byte[2];
        eUCJPProber.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_EUC_JP;
    }

    @Override
    public float getConfidence() {
        return Math.max(this.contextAnalyzer.getConfidence(), this.distributionAnalyzer.getConfidence());
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n5, int n6) {
        n6 = n5 + n6;
        for (int i5 = n5; i5 < n6; ++i5) {
            int n7 = this.codingSM.nextState(byArray[i5]);
            if (n7 == 1) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            if (n7 == 2) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (n7 != 0) continue;
            n7 = this.codingSM.getCurrentCharLen();
            if (i5 == n5) {
                EUCJPProber eUCJPProber = this;
                byte[] byArray2 = eUCJPProber.lastChar;
                eUCJPProber.lastChar[1] = byArray[n5];
                eUCJPProber.contextAnalyzer.handleOneChar(byArray2, 0, n7);
                eUCJPProber.distributionAnalyzer.handleOneChar(this.lastChar, 0, n7);
                continue;
            }
            EUCJPProber eUCJPProber = this;
            int n8 = i5 - 1;
            eUCJPProber.contextAnalyzer.handleOneChar(byArray, n8, n7);
            eUCJPProber.distributionAnalyzer.handleOneChar(byArray, n8, n7);
        }
        EUCJPProber eUCJPProber = this;
        eUCJPProber.lastChar[0] = byArray[n6 - 1];
        if (eUCJPProber.state == CharsetProber.ProbingState.DETECTING && this.contextAnalyzer.gotEnoughData() && this.getConfidence() > 0.95f) {
            this.state = CharsetProber.ProbingState.FOUND_IT;
        }
        return this.state;
    }

    @Override
    public void reset() {
        EUCJPProber eUCJPProber = this;
        eUCJPProber.codingSM.reset();
        eUCJPProber.state = CharsetProber.ProbingState.DETECTING;
        eUCJPProber.contextAnalyzer.reset();
        eUCJPProber.distributionAnalyzer.reset();
        Arrays.fill(eUCJPProber.lastChar, (byte)0);
    }

    @Override
    public void setOption() {
    }
}

