/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.nineoldandroids.animation;

import android.view.animation.Interpolator;
import io.dcloud.nineoldandroids.animation.Animator;
import io.dcloud.nineoldandroids.animation.AnimatorListenerAdapter;
import io.dcloud.nineoldandroids.animation.ObjectAnimator;
import io.dcloud.nineoldandroids.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public final class AnimatorSet
extends Animator {
    private ArrayList<Animator> mPlayingSet = new ArrayList();
    private HashMap<Animator, Node> mNodeMap = new HashMap();
    private ArrayList<Node> mNodes = new ArrayList();
    private ArrayList<Node> mSortedNodes = new ArrayList();
    private boolean mNeedsSort = true;
    private AnimatorSetListener mSetListener = null;
    boolean mTerminated = false;
    private boolean mStarted = false;
    private long mStartDelay = 0L;
    private ValueAnimator mDelayAnim = null;
    private long mDuration = -1L;

    public void playTogether(Animator ... items) {
        if (items != null) {
            this.mNeedsSort = true;
            Builder builder = this.play(items[0]);
            int i = 1;
            while (i < items.length) {
                builder.with(items[i]);
                ++i;
            }
        }
    }

    public void playTogether(Collection<Animator> items) {
        if (items != null && items.size() > 0) {
            this.mNeedsSort = true;
            Builder builder = null;
            for (Animator anim : items) {
                if (builder == null) {
                    builder = this.play(anim);
                    continue;
                }
                builder.with(anim);
            }
        }
    }

    public void playSequentially(Animator ... items) {
        if (items != null) {
            this.mNeedsSort = true;
            if (items.length == 1) {
                this.play(items[0]);
            } else {
                int i = 0;
                while (i < items.length - 1) {
                    this.play(items[i]).before(items[i + 1]);
                    ++i;
                }
            }
        }
    }

    public void playSequentially(List<Animator> items) {
        if (items != null && items.size() > 0) {
            this.mNeedsSort = true;
            if (items.size() == 1) {
                this.play(items.get(0));
            } else {
                int i = 0;
                while (i < items.size() - 1) {
                    this.play(items.get(i)).before(items.get(i + 1));
                    ++i;
                }
            }
        }
    }

    public ArrayList<Animator> getChildAnimations() {
        ArrayList<Animator> childList = new ArrayList<Animator>();
        for (Node node : this.mNodes) {
            childList.add(node.animation);
        }
        return childList;
    }

    @Override
    public void setTarget(Object target) {
        for (Node node : this.mNodes) {
            Animator animation = node.animation;
            if (animation instanceof AnimatorSet) {
                ((AnimatorSet)animation).setTarget(target);
                continue;
            }
            if (!(animation instanceof ObjectAnimator)) continue;
            ((ObjectAnimator)animation).setTarget(target);
        }
    }

    @Override
    public void setInterpolator(Interpolator interpolator) {
        for (Node node : this.mNodes) {
            node.animation.setInterpolator(interpolator);
        }
    }

    public Builder play(Animator anim) {
        if (anim != null) {
            this.mNeedsSort = true;
            return new Builder(anim);
        }
        return null;
    }

    @Override
    public void cancel() {
        this.mTerminated = true;
        if (this.isStarted()) {
            ArrayList tmpListeners = null;
            if (this.mListeners != null) {
                tmpListeners = (ArrayList)this.mListeners.clone();
                for (Animator.AnimatorListener listener : tmpListeners) {
                    listener.onAnimationCancel(this);
                }
            }
            if (this.mDelayAnim != null && this.mDelayAnim.isRunning()) {
                this.mDelayAnim.cancel();
            } else if (this.mSortedNodes.size() > 0) {
                for (Node node : this.mSortedNodes) {
                    node.animation.cancel();
                }
            }
            if (tmpListeners != null) {
                for (Animator.AnimatorListener listener : tmpListeners) {
                    listener.onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    @Override
    public void end() {
        this.mTerminated = true;
        if (this.isStarted()) {
            if (this.mSortedNodes.size() != this.mNodes.size()) {
                this.sortNodes();
                for (Node node : this.mSortedNodes) {
                    if (this.mSetListener == null) {
                        this.mSetListener = new AnimatorSetListener(this);
                    }
                    node.animation.addListener(this.mSetListener);
                }
            }
            if (this.mDelayAnim != null) {
                this.mDelayAnim.cancel();
            }
            if (this.mSortedNodes.size() > 0) {
                for (Node node : this.mSortedNodes) {
                    node.animation.end();
                }
            }
            if (this.mListeners != null) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                for (Animator.AnimatorListener listener : tmpListeners) {
                    listener.onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    @Override
    public boolean isRunning() {
        for (Node node : this.mNodes) {
            if (!node.animation.isRunning()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public void setStartDelay(long startDelay) {
        this.mStartDelay = startDelay;
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public AnimatorSet setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration must be a value of zero or greater");
        }
        for (Node node : this.mNodes) {
            node.animation.setDuration(duration);
        }
        this.mDuration = duration;
        return this;
    }

    @Override
    public void setupStartValues() {
        for (Node node : this.mNodes) {
            node.animation.setupStartValues();
        }
    }

    @Override
    public void setupEndValues() {
        for (Node node : this.mNodes) {
            node.animation.setupEndValues();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        void var3_6;
        this.mTerminated = false;
        this.mStarted = true;
        this.sortNodes();
        int numSortedNodes = this.mSortedNodes.size();
        int i = 0;
        while (i < numSortedNodes) {
            Node node = this.mSortedNodes.get(i);
            ArrayList<Animator.AnimatorListener> oldListeners = node.animation.getListeners();
            if (oldListeners != null && oldListeners.size() > 0) {
                ArrayList<Animator.AnimatorListener> clonedListeners = new ArrayList<Animator.AnimatorListener>(oldListeners);
                for (Animator.AnimatorListener listener : clonedListeners) {
                    if (!(listener instanceof DependencyListener) && !(listener instanceof AnimatorSetListener)) continue;
                    node.animation.removeListener(listener);
                }
            }
            ++i;
        }
        final ArrayList<Object> nodesToStart = new ArrayList<Object>();
        boolean bl = false;
        while (var3_6 < numSortedNodes) {
            Node node = this.mSortedNodes.get((int)var3_6);
            if (this.mSetListener == null) {
                this.mSetListener = new AnimatorSetListener(this);
            }
            if (node.dependencies == null || node.dependencies.size() == 0) {
                nodesToStart.add(node);
            } else {
                int numDependencies = node.dependencies.size();
                int j = 0;
                while (j < numDependencies) {
                    Dependency dependency = node.dependencies.get(j);
                    dependency.node.animation.addListener(new DependencyListener(this, node, dependency.rule));
                    ++j;
                }
                node.tmpDependencies = (ArrayList)node.dependencies.clone();
            }
            node.animation.addListener(this.mSetListener);
            ++var3_6;
        }
        if (this.mStartDelay <= 0L) {
            for (Node node : nodesToStart) {
                node.animation.start();
                this.mPlayingSet.add(node.animation);
            }
        } else {
            this.mDelayAnim = ValueAnimator.ofFloat(0.0f, 1.0f);
            this.mDelayAnim.setDuration(this.mStartDelay);
            this.mDelayAnim.addListener(new AnimatorListenerAdapter(){
                boolean canceled = false;

                @Override
                public void onAnimationCancel(Animator anim) {
                    this.canceled = true;
                }

                @Override
                public void onAnimationEnd(Animator anim) {
                    if (!this.canceled) {
                        int numNodes = nodesToStart.size();
                        int i = 0;
                        while (i < numNodes) {
                            Node node = (Node)nodesToStart.get(i);
                            node.animation.start();
                            AnimatorSet.this.mPlayingSet.add(node.animation);
                            ++i;
                        }
                    }
                }
            });
            this.mDelayAnim.start();
        }
        if (this.mListeners != null) {
            ArrayList arrayList = (ArrayList)this.mListeners.clone();
            int numListeners = arrayList.size();
            int i3 = 0;
            while (i3 < numListeners) {
                ((Animator.AnimatorListener)arrayList.get(i3)).onAnimationStart(this);
                ++i3;
            }
        }
        if (this.mNodes.size() == 0 && this.mStartDelay == 0L) {
            this.mStarted = false;
            if (this.mListeners != null) {
                ArrayList arrayList = (ArrayList)this.mListeners.clone();
                int numListeners = arrayList.size();
                int i4 = 0;
                while (i4 < numListeners) {
                    ((Animator.AnimatorListener)arrayList.get(i4)).onAnimationEnd(this);
                    ++i4;
                }
            }
        }
    }

    @Override
    public AnimatorSet clone() {
        Node nodeClone;
        AnimatorSet anim = (AnimatorSet)super.clone();
        anim.mNeedsSort = true;
        anim.mTerminated = false;
        anim.mStarted = false;
        anim.mPlayingSet = new ArrayList();
        anim.mNodeMap = new HashMap();
        anim.mNodes = new ArrayList();
        anim.mSortedNodes = new ArrayList();
        HashMap<Node, Node> nodeCloneMap = new HashMap<Node, Node>();
        for (Node node : this.mNodes) {
            nodeClone = node.clone();
            nodeCloneMap.put(node, nodeClone);
            anim.mNodes.add(nodeClone);
            anim.mNodeMap.put(nodeClone.animation, nodeClone);
            nodeClone.dependencies = null;
            nodeClone.tmpDependencies = null;
            nodeClone.nodeDependents = null;
            nodeClone.nodeDependencies = null;
            ArrayList<Animator.AnimatorListener> cloneListeners = nodeClone.animation.getListeners();
            if (cloneListeners == null) continue;
            ArrayList<Animator.AnimatorListener> listenersToRemove = null;
            for (Animator.AnimatorListener listener : cloneListeners) {
                if (!(listener instanceof AnimatorSetListener)) continue;
                if (listenersToRemove == null) {
                    listenersToRemove = new ArrayList<Animator.AnimatorListener>();
                }
                listenersToRemove.add(listener);
            }
            if (listenersToRemove == null) continue;
            for (Animator.AnimatorListener listener : listenersToRemove) {
                cloneListeners.remove(listener);
            }
        }
        for (Node node : this.mNodes) {
            nodeClone = (Node)nodeCloneMap.get(node);
            if (node.dependencies == null) continue;
            for (Dependency dependency : node.dependencies) {
                Node clonedDependencyNode = (Node)nodeCloneMap.get(dependency.node);
                Dependency cloneDependency = new Dependency(clonedDependencyNode, dependency.rule);
                nodeClone.addDependency(cloneDependency);
            }
        }
        return anim;
    }

    private void sortNodes() {
        if (this.mNeedsSort) {
            this.mSortedNodes.clear();
            ArrayList<Node> roots = new ArrayList<Node>();
            int numNodes = this.mNodes.size();
            int i = 0;
            while (i < numNodes) {
                Node node = this.mNodes.get(i);
                if (node.dependencies == null || node.dependencies.size() == 0) {
                    roots.add(node);
                }
                ++i;
            }
            ArrayList<Node> tmpRoots = new ArrayList<Node>();
            while (roots.size() > 0) {
                int numRoots = roots.size();
                int i2 = 0;
                while (i2 < numRoots) {
                    Node root = (Node)roots.get(i2);
                    this.mSortedNodes.add(root);
                    if (root.nodeDependents != null) {
                        int numDependents = root.nodeDependents.size();
                        int j = 0;
                        while (j < numDependents) {
                            Node node = root.nodeDependents.get(j);
                            node.nodeDependencies.remove(root);
                            if (node.nodeDependencies.size() == 0) {
                                tmpRoots.add(node);
                            }
                            ++j;
                        }
                    }
                    ++i2;
                }
                roots.clear();
                roots.addAll(tmpRoots);
                tmpRoots.clear();
            }
            this.mNeedsSort = false;
            if (this.mSortedNodes.size() != this.mNodes.size()) {
                throw new IllegalStateException("Circular dependencies cannot exist in AnimatorSet");
            }
        } else {
            int numNodes = this.mNodes.size();
            int i = 0;
            while (i < numNodes) {
                Node node = this.mNodes.get(i);
                if (node.dependencies != null && node.dependencies.size() > 0) {
                    int numDependencies = node.dependencies.size();
                    int j = 0;
                    while (j < numDependencies) {
                        Dependency dependency = node.dependencies.get(j);
                        if (node.nodeDependencies == null) {
                            node.nodeDependencies = new ArrayList();
                        }
                        if (!node.nodeDependencies.contains(dependency.node)) {
                            node.nodeDependencies.add(dependency.node);
                        }
                        ++j;
                    }
                }
                node.done = false;
                ++i;
            }
        }
    }

    private class AnimatorSetListener
    implements Animator.AnimatorListener {
        private AnimatorSet mAnimatorSet;

        AnimatorSetListener(AnimatorSet animatorSet2) {
            this.mAnimatorSet = animatorSet2;
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            if (!AnimatorSet.this.mTerminated && AnimatorSet.this.mPlayingSet.size() == 0 && AnimatorSet.this.mListeners != null) {
                int numListeners = AnimatorSet.this.mListeners.size();
                int i = 0;
                while (i < numListeners) {
                    ((Animator.AnimatorListener)AnimatorSet.this.mListeners.get(i)).onAnimationCancel(this.mAnimatorSet);
                    ++i;
                }
            }
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            animation.removeListener(this);
            AnimatorSet.this.mPlayingSet.remove(animation);
            Node animNode = (Node)this.mAnimatorSet.mNodeMap.get(animation);
            animNode.done = true;
            if (!AnimatorSet.this.mTerminated) {
                ArrayList sortedNodes = this.mAnimatorSet.mSortedNodes;
                boolean allDone = true;
                int numSortedNodes = sortedNodes.size();
                int i = 0;
                while (i < numSortedNodes) {
                    if (!((Node)sortedNodes.get((int)i)).done) {
                        allDone = false;
                        break;
                    }
                    ++i;
                }
                if (allDone) {
                    if (AnimatorSet.this.mListeners != null) {
                        ArrayList tmpListeners = (ArrayList)AnimatorSet.this.mListeners.clone();
                        int numListeners = tmpListeners.size();
                        int i2 = 0;
                        while (i2 < numListeners) {
                            ((Animator.AnimatorListener)tmpListeners.get(i2)).onAnimationEnd(this.mAnimatorSet);
                            ++i2;
                        }
                    }
                    this.mAnimatorSet.mStarted = false;
                }
            }
        }

        @Override
        public void onAnimationRepeat(Animator animation) {
        }

        @Override
        public void onAnimationStart(Animator animation) {
        }
    }

    public class Builder {
        private Node mCurrentNode;

        Builder(Animator anim) {
            this.mCurrentNode = (Node)AnimatorSet.this.mNodeMap.get(anim);
            if (this.mCurrentNode == null) {
                this.mCurrentNode = new Node(anim);
                AnimatorSet.this.mNodeMap.put(anim, this.mCurrentNode);
                AnimatorSet.this.mNodes.add(this.mCurrentNode);
            }
        }

        public Builder with(Animator anim) {
            Node node = (Node)AnimatorSet.this.mNodeMap.get(anim);
            if (node == null) {
                node = new Node(anim);
                AnimatorSet.this.mNodeMap.put(anim, node);
                AnimatorSet.this.mNodes.add(node);
            }
            Dependency dependency = new Dependency(this.mCurrentNode, 0);
            node.addDependency(dependency);
            return this;
        }

        public Builder before(Animator anim) {
            Node node = (Node)AnimatorSet.this.mNodeMap.get(anim);
            if (node == null) {
                node = new Node(anim);
                AnimatorSet.this.mNodeMap.put(anim, node);
                AnimatorSet.this.mNodes.add(node);
            }
            Dependency dependency = new Dependency(this.mCurrentNode, 1);
            node.addDependency(dependency);
            return this;
        }

        public Builder after(Animator anim) {
            Node node = (Node)AnimatorSet.this.mNodeMap.get(anim);
            if (node == null) {
                node = new Node(anim);
                AnimatorSet.this.mNodeMap.put(anim, node);
                AnimatorSet.this.mNodes.add(node);
            }
            Dependency dependency = new Dependency(node, 1);
            this.mCurrentNode.addDependency(dependency);
            return this;
        }

        public Builder after(long delay) {
            ValueAnimator anim = ValueAnimator.ofFloat(0.0f, 1.0f);
            anim.setDuration(delay);
            this.after(anim);
            return this;
        }
    }

    private static class Dependency {
        static final int WITH = 0;
        static final int AFTER = 1;
        public Node node;
        public int rule;

        public Dependency(Node node, int rule) {
            this.node = node;
            this.rule = rule;
        }
    }

    private static class DependencyListener
    implements Animator.AnimatorListener {
        private AnimatorSet mAnimatorSet;
        private Node mNode;
        private int mRule;

        public DependencyListener(AnimatorSet animatorSet, Node node, int rule) {
            this.mAnimatorSet = animatorSet;
            this.mNode = node;
            this.mRule = rule;
        }

        @Override
        public void onAnimationCancel(Animator animation) {
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            if (this.mRule == 1) {
                this.startIfReady(animation);
            }
        }

        @Override
        public void onAnimationRepeat(Animator animation) {
        }

        @Override
        public void onAnimationStart(Animator animation) {
            if (this.mRule == 0) {
                this.startIfReady(animation);
            }
        }

        private void startIfReady(Animator dependencyAnimation) {
            if (this.mAnimatorSet.mTerminated) {
                return;
            }
            Dependency dependencyToRemove = null;
            int numDependencies = this.mNode.tmpDependencies.size();
            int i = 0;
            while (i < numDependencies) {
                Dependency dependency = this.mNode.tmpDependencies.get(i);
                if (dependency.rule == this.mRule && dependency.node.animation == dependencyAnimation) {
                    dependencyToRemove = dependency;
                    dependencyAnimation.removeListener(this);
                    break;
                }
                ++i;
            }
            this.mNode.tmpDependencies.remove(dependencyToRemove);
            if (this.mNode.tmpDependencies.size() == 0) {
                this.mNode.animation.start();
                this.mAnimatorSet.mPlayingSet.add(this.mNode.animation);
            }
        }
    }

    private static class Node
    implements Cloneable {
        public Animator animation;
        public ArrayList<Dependency> dependencies = null;
        public ArrayList<Dependency> tmpDependencies = null;
        public ArrayList<Node> nodeDependencies = null;
        public ArrayList<Node> nodeDependents = null;
        public boolean done = false;

        public Node(Animator animation) {
            this.animation = animation;
        }

        public void addDependency(Dependency dependency) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList();
                this.nodeDependencies = new ArrayList();
            }
            this.dependencies.add(dependency);
            if (!this.nodeDependencies.contains(dependency.node)) {
                this.nodeDependencies.add(dependency.node);
            }
            Node dependencyNode = dependency.node;
            if (dependencyNode.nodeDependents == null) {
                dependencyNode.nodeDependents = new ArrayList();
            }
            dependencyNode.nodeDependents.add(this);
        }

        public Node clone() {
            try {
                Node node = (Node)super.clone();
                node.animation = this.animation.clone();
                return node;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }
}

