/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.decoding;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.BinaryBitmap;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.MultiFormatReader;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ReaderException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPointCallback;
import com.dcloud.zxing2.common.GlobalHistogramBinarizer;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.barcode2.BarcodeProxy;
import io.dcloud.feature.barcode2.camera.CameraManager;
import io.dcloud.feature.barcode2.camera.PlanarYUVLuminanceSource;
import io.dcloud.feature.barcode2.decoding.BitmapLuminanceSource;
import io.dcloud.feature.barcode2.decoding.CaptureActivityHandler;
import io.dcloud.feature.barcode2.decoding.DecodeFormatManager;
import io.dcloud.feature.barcode2.decoding.IBarHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

final class DecodeHandler
extends Handler {
    private static final String TAG = "DecodeHandler";
    private static boolean mIsVerticalScreen = true;
    private final IBarHandler activity;
    private final MultiFormatReader multiFormatReader;

    DecodeHandler(IBarHandler iBarHandler, Hashtable<DecodeHintType, Object> hashtable) {
        MultiFormatReader multiFormatReader;
        MultiFormatReader multiFormatReader2 = multiFormatReader;
        multiFormatReader2(this);
        this.multiFormatReader = multiFormatReader2;
        multiFormatReader.setHints(hashtable);
        this.activity = iBarHandler;
    }

    private void handleNeedZoom() {
        DecodeHandler decodeHandler = CameraManager.get().getCameraHandler().getParameters();
        int n5 = decodeHandler.getZoom();
        int n6 = (int)((double)decodeHandler.getMaxZoom() * 0.6);
        int n7 = (int)((double)n6 * 0.2);
        if (n5 < n6) {
            n5 += n7;
        }
        if (n5 <= n6) {
            n6 = n5;
        }
        decodeHandler.setZoom(n6);
        CameraManager.get().getCameraHandler().setParameters((Camera.Parameters)decodeHandler);
    }

    private void decode(byte[] object, int n5, int n6) {
        PlanarYUVLuminanceSource planarYUVLuminanceSource;
        Result result;
        block20: {
            FileOutputStream fileOutputStream;
            File file;
            YuvImage yuvImage;
            BinaryBitmap binaryBitmap;
            block18: {
                block19: {
                    BinaryBitmap binaryBitmap2;
                    DecodeHandler decodeHandler = decodeHandler;
                    result = null;
                    planarYUVLuminanceSource = CameraManager.get().buildLuminanceSource((byte[])object, n5, n6);
                    binaryBitmap = binaryBitmap2;
                    binaryBitmap2 = new BinaryBitmap(new GlobalHistogramBinarizer(planarYUVLuminanceSource));
                    try {
                        result = decodeHandler.multiFormatReader.decodeWithState(binaryBitmap);
                        decodeHandler.multiFormatReader.reset();
                        break block18;
                    }
                    catch (Throwable throwable) {
                    }
                    catch (ReaderException readerException) {
                        break block19;
                    }
                    decodeHandler.multiFormatReader.reset();
                    throw throwable;
                }
                decodeHandler.multiFormatReader.reset();
            }
            if (!BarcodeProxy.save) break block20;
            binaryBitmap = CameraManager.get().getCameraHandler().getParameters();
            Camera.Size size = binaryBitmap.getPreviewSize();
            YuvImage yuvImage2 = yuvImage;
            Object object2 = object;
            Camera.Size size2 = size;
            Camera.Size size3 = size2;
            Camera.Size size4 = size2;
            int n7 = binaryBitmap.getPreviewFormat();
            int n8 = size3.width;
            int n9 = size4.height;
            yuvImage = new YuvImage(object2, n7, n8, n9, null);
            File file2 = file;
            file = new File("/sdcard/1/" + System.currentTimeMillis() + "--" + size.width + "*" + size.height + ".jpg");
            FileOutputStream fileOutputStream2 = fileOutputStream;
            fileOutputStream = new FileOutputStream(file2);
            YuvImage yuvImage3 = yuvImage2;
            int n10 = 0;
            int n11 = 0;
            int n12 = yuvImage3.getWidth();
            n9 = yuvImage3.getHeight();
            try {
                yuvImage.compressToJpeg(new Rect(n10, n11, n12, n9), 90, (OutputStream)fileOutputStream2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            Bitmap bitmap = planarYUVLuminanceSource.renderCroppedGreyscaleBitmap(true);
            object = bitmap;
            binaryBitmap = CameraManager.get().getFramingRectInPreview();
            PdrUtil.saveBitmapToFile(bitmap, "/sdcard/1/" + System.currentTimeMillis() + "--" + ((Rect)binaryBitmap).left + "*" + ((Rect)binaryBitmap).top + ".png");
            BarcodeProxy.save = false;
            PdrUtil.alert((Activity)BarcodeProxy.context, "\u6210\u529f left=" + ((Rect)binaryBitmap).left + "top:" + ((Rect)binaryBitmap).top, (Bitmap)object);
        }
        if (result != null) {
            Bundle bundle;
            DecodeHandler decodeHandler = Message.obtain((Handler)decodeHandler.activity.getHandler(), (int)1002, (Object)result);
            object = bundle;
            bundle = new Bundle();
            planarYUVLuminanceSource = planarYUVLuminanceSource.renderCroppedGreyscaleBitmap(true);
            if (!mIsVerticalScreen) {
                Matrix matrix;
                PlanarYUVLuminanceSource planarYUVLuminanceSource2 = planarYUVLuminanceSource;
                planarYUVLuminanceSource = matrix;
                new Matrix().postRotate(-90.0f);
                int n13 = planarYUVLuminanceSource2.getWidth();
                Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)planarYUVLuminanceSource2, (int)n13, (int)planarYUVLuminanceSource2.getHeight(), (boolean)true);
                n13 = bitmap.getWidth();
                int n14 = bitmap.getHeight();
                planarYUVLuminanceSource = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n13, (int)n14, (Matrix)planarYUVLuminanceSource, (boolean)true);
            }
            DecodeHandler decodeHandler2 = decodeHandler;
            object.putParcelable("barcode_bitmap", (Parcelable)planarYUVLuminanceSource);
            decodeHandler2.setData((Bundle)object);
            decodeHandler2.sendToTarget();
        } else {
            Message.obtain((Handler)decodeHandler.activity.getHandler(), (int)1001).sendToTarget();
        }
    }

    public static Result decode(Bitmap bitmap, ResultPointCallback resultPointCallback, boolean bl) {
        Vector<BarcodeFormat> vector;
        Hashtable<DecodeHintType, Object> hashtable;
        MultiFormatReader multiFormatReader;
        MultiFormatReader multiFormatReader2 = multiFormatReader;
        multiFormatReader = new MultiFormatReader(null);
        Hashtable<DecodeHintType, Object> hashtable2 = hashtable;
        hashtable = new Hashtable<DecodeHintType, Object>(4);
        Serializable serializable = vector;
        if (new Vector<BarcodeFormat>().isEmpty()) {
            Vector<BarcodeFormat> vector2;
            serializable = vector2;
            new Vector<BarcodeFormat>().addAll(DecodeFormatManager.ONE_D_FORMATS);
            serializable.addAll(DecodeFormatManager.QR_CODE_FORMATS);
            serializable.addAll(DecodeFormatManager.DATA_MATRIX_FORMATS);
        }
        Hashtable<DecodeHintType, Object> hashtable3 = hashtable2;
        hashtable3.put(DecodeHintType.POSSIBLE_FORMATS, serializable);
        serializable = Boolean.TRUE;
        hashtable3.put(DecodeHintType.TRY_HARDER, serializable);
        if (resultPointCallback != null) {
            hashtable2.put(DecodeHintType.NEED_RESULT_POINT_CALLBACK, resultPointCallback);
        }
        if (bl) {
            hashtable2.put(DecodeHintType.autoDecodeCharset, serializable);
        }
        MultiFormatReader multiFormatReader3 = multiFormatReader2;
        multiFormatReader3.setHints(hashtable2);
        resultPointCallback = null;
        try {
            return multiFormatReader3.decodeWithState(new BinaryBitmap(new GlobalHistogramBinarizer(new BitmapLuminanceSource(bitmap))));
        }
        catch (NotFoundException notFoundException) {
            notFoundException.printStackTrace();
            return resultPointCallback;
        }
    }

    public static Result decode(Bitmap bitmap, boolean bl) {
        return DecodeHandler.decode(bitmap, null, bl);
    }

    public void handleMessage(Message message) {
        block8: {
            block7: {
                int n5 = message.what;
                if (n5 == 1010) break block7;
                switch (n5) {
                    default: {
                        break block8;
                    }
                    case 1006: {
                        DecodeHandler decodeHandler = object;
                        Message message2 = message;
                        mIsVerticalScreen = false;
                        Object object = (byte[])message2.obj;
                        int n6 = message2.arg1;
                        n5 = message2.arg2;
                        decodeHandler.decode((byte[])object, n6, n5);
                        return;
                    }
                    case 1005: {
                        DecodeHandler decodeHandler = object;
                        Message message3 = message;
                        mIsVerticalScreen = true;
                        Object object = (byte[])message3.obj;
                        int n7 = message3.arg1;
                        n5 = message3.arg2;
                        decodeHandler.decode((byte[])object, n7, n5);
                        return;
                    }
                    case 1004: {
                        DecodeHandler decodeHandler = object;
                        Message message4 = message;
                        Object object = (byte[])message4.obj;
                        int n8 = message4.arg1;
                        n5 = message4.arg2;
                        decodeHandler.decode((byte[])object, n8, n5);
                        return;
                    }
                    case 1003: {
                        Looper.myLooper().quit();
                        return;
                    }
                }
            }
            if (CaptureActivityHandler.isAutoZoom) {
                object.handleNeedZoom();
                return;
            }
        }
    }
}

