/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.tls;

import javax.security.auth.x500.X500Principal;

final class DistinguishedNameParser {
    private final String dn;
    private final int length;
    private int pos;
    private int beg;
    private int end;
    private int cur;
    private char[] chars;

    DistinguishedNameParser(X500Principal x500Principal) {
        DistinguishedNameParser distinguishedNameParser = string2;
        String string2 = x500Principal.getName("RFC2253");
        distinguishedNameParser.dn = string2;
        distinguishedNameParser.length = string2.length();
    }

    private String nextAT() {
        char c6;
        int n5;
        int n6;
        while ((n6 = this.pos) < (n5 = this.length) && this.chars[n6] == ' ') {
            this.pos = n6 + 1;
        }
        if (n6 == n5) {
            return null;
        }
        this.beg = n6;
        this.pos = n6 + 1;
        while ((n6 = this.pos) < (n5 = this.length) && (c6 = this.chars[n6]) != '=' && c6 != ' ') {
            this.pos = n6 + 1;
        }
        if (n6 < n5) {
            this.end = n6;
            if (this.chars[n6] == ' ') {
                while ((n6 = this.pos) < (n5 = this.length) && (c6 = this.chars[n6]) != '=' && c6 == ' ') {
                    this.pos = n6 + 1;
                }
                if (this.chars[n6] != '=' || n6 == n5) {
                    throw new IllegalStateException("Unexpected end of DN: " + this.dn);
                }
            }
            ++this.pos;
            while ((n6 = this.pos) < this.length && this.chars[n6] == ' ') {
                this.pos = n6 + 1;
            }
            n6 = this.end;
            n5 = this.beg;
            if (n6 - n5 > 4) {
                char c7;
                char[] cArray = this.chars;
                if (!(this.chars[n5 + 3] != '.' || (c7 = cArray[n5]) != 'O' && c7 != 'o' || cArray[n5 + 1] != 'I' && cArray[n5 + 1] != 'i' || cArray[n5 + 2] != 'D' && cArray[n5 + 2] != 'd')) {
                    this.beg = n5 + 4;
                }
            }
            char[] cArray = this.chars;
            int n7 = this.beg;
            n5 = n6 - n7;
            return new String(cArray, n7, n5);
        }
        throw new IllegalStateException("Unexpected end of DN: " + this.dn);
    }

    private String quotedAV() {
        int n5;
        this.pos = n5 = this.pos + 1;
        this.beg = n5;
        this.end = n5;
        while ((n5 = ++this.pos) != this.length) {
            char[] cArray = this.chars;
            char c6 = this.chars[n5];
            if (c6 == '\"') {
                this.pos = n5 + 1;
                while ((n5 = this.pos) < this.length && this.chars[n5] == ' ') {
                    this.pos = n5 + 1;
                }
                int n6 = this.beg;
                return new String(this.chars, n6, this.end - n6);
            }
            cArray[this.end] = c6 == '\\' ? this.getEscaped() : c6;
            ++this.end;
        }
        throw new IllegalStateException("Unexpected end of DN: " + this.dn);
    }

    private String hexAV() {
        int n5 = this.pos;
        if (n5 + 4 < this.length) {
            int n6;
            int n7;
            block7: {
                this.beg = n5;
                this.pos = n5 + 1;
                while ((n5 = this.pos) != this.length) {
                    char[] cArray = this.chars;
                    n7 = this.chars[n5];
                    if (n7 == 43 || n7 == 44 || n7 == 59) break;
                    if (n7 == 32) {
                        this.end = n5;
                        this.pos = n5 + 1;
                        while ((n5 = this.pos) < this.length && this.chars[n5] == ' ') {
                            this.pos = n5 + 1;
                        }
                        break block7;
                    }
                    if (n7 >= 65 && n7 <= 70) {
                        cArray[n5] = (char)(n7 + 32);
                    }
                    this.pos = n5 + 1;
                }
                this.end = n5;
            }
            if ((n6 = this.end - (n5 = this.beg)) >= 5 && (n6 & 1) != 0) {
                n7 = n6 / 2;
                byte[] byArray = new byte[n7];
                ++n5;
                for (int i5 = 0; i5 < n7; ++i5) {
                    byArray[i5] = (byte)this.getByte(n5);
                    n5 += 2;
                }
                return new String(this.chars, this.beg, n6);
            }
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        throw new IllegalStateException("Unexpected end of DN: " + this.dn);
    }

    private String escapedAV() {
        int n5;
        this.beg = n5 = this.pos;
        this.end = n5;
        while (true) {
            int n6;
            if ((n5 = this.pos++) >= this.length) {
                int n7 = this.beg;
                return new String(this.chars, n7, this.end - n7);
            }
            char[] cArray = this.chars;
            char c6 = this.chars[n5];
            if (c6 != ' ') {
                if (c6 != ';') {
                    if (c6 != '\\') {
                        if (c6 != '+' && c6 != ',') {
                            int n8 = this.end;
                            this.end = n8 + 1;
                            cArray[n8] = c6;
                            this.pos = n5 + 1;
                            continue;
                        }
                    } else {
                        cArray[this.end++] = this.getEscaped();
                        continue;
                    }
                }
                n5 = this.beg;
                return new String(cArray, n5, this.end - n5);
            }
            this.cur = n6 = this.end;
            this.pos = n5 + 1;
            this.end = n6 + 1;
            cArray[n6] = 32;
            while ((n5 = this.pos) < (n6 = this.length)) {
                char[] cArray2 = this.chars;
                if (this.chars[n5] != ' ') break;
                n6 = this.end;
                this.end = n6 + 1;
                cArray2[n6] = 32;
                this.pos = n5 + 1;
            }
            if (n5 == n6 || (n5 = this.chars[n5]) == 44 || n5 == 43 || n5 == 59) break;
        }
        int n9 = this.beg;
        return new String(this.chars, n9, this.cur - n9);
    }

    private char getEscaped() {
        char c6 = this.pos + 1;
        this.pos = c6;
        if (c6 != this.length) {
            c6 = this.chars[c6];
            switch (c6) {
                default: {
                    return this.getUTF8();
                }
                case ' ': 
                case '\"': 
                case '#': 
                case '%': 
                case '*': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': 
                case '_': 
            }
            return c6;
        }
        throw new IllegalStateException("Unexpected end of DN: " + this.dn);
    }

    private char getUTF8() {
        DistinguishedNameParser distinguishedNameParser = this;
        int n5 = distinguishedNameParser.getByte(distinguishedNameParser.pos);
        ++this.pos;
        if (n5 < 128) {
            return (char)n5;
        }
        if (n5 >= 192 && n5 <= 247) {
            int n6;
            if (n5 <= 223) {
                int n7 = n5;
                n5 = 1;
                n6 = n7 & 0x1F;
            } else if (n5 <= 239) {
                int n8 = n5;
                n5 = 2;
                n6 = n8 & 0xF;
            } else {
                int n9 = n5;
                n5 = 3;
                n6 = n9 & 7;
            }
            for (int i5 = 0; i5 < n5; ++i5) {
                int n10;
                int n11 = this.pos;
                this.pos = n10 = n11 + 1;
                if (n10 != this.length && this.chars[n10] == '\\') {
                    this.pos = n11 += 2;
                    n11 = this.getByte(n11);
                    ++this.pos;
                    if ((n11 & 0xC0) != 128) {
                        return '?';
                    }
                    n6 = (n6 << 6) + (n11 & 0x3F);
                    continue;
                }
                return '?';
            }
            return (char)n6;
        }
        return '?';
    }

    private int getByte(int n5) {
        block2: {
            block6: {
                block10: {
                    int n6;
                    block8: {
                        int n7;
                        block9: {
                            block7: {
                                char[] cArray;
                                block4: {
                                    block5: {
                                        block3: {
                                            n7 = n5 + 1;
                                            if (n7 >= this.length) break block2;
                                            cArray = this.chars;
                                            if ((n5 = this.chars[n5]) < 48 || n5 > 57) break block3;
                                            n5 -= 48;
                                            break block4;
                                        }
                                        if (n5 < 97 || n5 > 102) break block5;
                                        n5 -= 87;
                                        break block4;
                                    }
                                    if (n5 < 65 || n5 > 70) break block6;
                                    n5 -= 55;
                                }
                                n7 = cArray[n7];
                                if (n7 < 48 || n7 > 57) break block7;
                                n6 = n7 - 48;
                                break block8;
                            }
                            if (n7 < 97 || n7 > 102) break block9;
                            n6 = n7 - 87;
                            break block8;
                        }
                        if (n7 < 65 || n7 > 70) break block10;
                        n6 = n7 - 55;
                    }
                    return (n5 << 4) + n6;
                }
                throw new IllegalStateException("Malformed DN: " + this.dn);
            }
            throw new IllegalStateException("Malformed DN: " + this.dn);
        }
        throw new IllegalStateException("Malformed DN: " + this.dn);
    }

    public String findMostSpecific(String string2) {
        DistinguishedNameParser distinguishedNameParser = this;
        distinguishedNameParser.pos = 0;
        distinguishedNameParser.beg = 0;
        distinguishedNameParser.end = 0;
        distinguishedNameParser.cur = 0;
        distinguishedNameParser.chars = distinguishedNameParser.dn.toCharArray();
        String string3 = distinguishedNameParser.nextAT();
        if (string3 == null) {
            return null;
        }
        do {
            String string4 = "";
            int n5 = this.pos;
            if (n5 == this.length) {
                return null;
            }
            if ((n5 = this.chars[n5]) != 34) {
                if (n5 != 35) {
                    if (n5 != 43 && n5 != 44 && n5 != 59) {
                        string4 = this.escapedAV();
                    }
                } else {
                    string4 = this.hexAV();
                }
            } else {
                string4 = this.quotedAV();
            }
            if (string2.equalsIgnoreCase(string3)) {
                return string4;
            }
            int n6 = this.pos;
            if (n6 >= this.length) {
                return null;
            }
            char c6 = this.chars[n6];
            if (c6 != ',' && c6 != ';' && c6 != '+') {
                throw new IllegalStateException("Malformed DN: " + this.dn);
            }
            this.pos = n6 + 1;
        } while ((string3 = this.nextAT()) != null);
        throw new IllegalStateException("Malformed DN: " + this.dn);
    }
}

