/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.nativeObj.photoview;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.nostra13.dcloudimageloader.core.DisplayImageOptions;
import com.nostra13.dcloudimageloader.core.assist.ImageScaleType;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.util.EventDispatchManager;
import io.dcloud.common.util.FileUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.RuningAcitvityUtil;
import io.dcloud.feature.nativeObj.BannerLayout;
import io.dcloud.feature.nativeObj.data.NativeImageDataItem;
import io.dcloud.feature.nativeObj.photoview.LongClickEventManager;
import io.dcloud.feature.nativeObj.photoview.subscaleview.BitmapUtil;
import io.dcloud.feature.nativeObj.photoview.subscaleview.ImageSource;
import io.dcloud.feature.nativeObj.photoview.subscaleview.SubsamplingScaleImageView;
import io.src.dcloud.adapter.DCloudBaseActivity;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class PhotoActivity
extends DCloudBaseActivity {
    public static String IMAGE_URLS_KEY = "image_urls";
    public static String IMAGE_CURRENT_INDEX_KEY = "image_current_index";
    public static String IMAGE_LOOP_KEY = "image_loop";
    public static String IMAGE_PHOTO_KEY = "image_photo";
    public static String IMAGE_PHOTO_TOP = "image_photo_top";
    public static String IMAGE_URLLIST_KEY = "image_urlList";
    public static String IMAGE_INDICATOR_KEY = "image_indicator";
    public static String IMAGE_BG_KEY = "image_backgroud_color";
    ArrayList<NativeImageDataItem> mImageUrls;
    private String[] localImageUrls;
    private ArrayList originalImageUrls;
    int mCurrentItmeIndex = 0;
    private DisplayImageOptions mDefOps;
    public String mIndicatorType = "default";
    public boolean isBack = false;
    private String callbackId;
    private BannerLayout photoLayout;

    private DisplayImageOptions getIconDisplayOptions() {
        ColorDrawable colorDrawable;
        PhotoActivity photoActivity = colorDrawable;
        colorDrawable = new ColorDrawable(0);
        return new DisplayImageOptions.Builder().cacheOnDisc(true).cacheInMemory(true).imageScaleType(ImageScaleType.NONE).bitmapConfig(Bitmap.Config.ARGB_8888).showImageOnLoading((Drawable)photoActivity).build();
    }

    private void fullScreen(Activity activity) {
        int n5 = Build.VERSION.SDK_INT;
        if (n5 >= 19) {
            Window window = activity.getWindow();
            if (n5 >= 21) {
                Window window2 = window;
                window2.getDecorView().setSystemUiVisibility(1792);
                window2.addFlags(Integer.MIN_VALUE);
                window2.setStatusBarColor(0);
                window2.setNavigationBarColor(0);
                return;
            }
            Window window3 = window;
            WindowManager.LayoutParams layoutParams = window3.getAttributes();
            layoutParams.flags |= 0x4000000;
            window3.setAttributes(layoutParams);
            return;
        }
    }

    @Override
    public void onCreate(Bundle object) {
        ViewGroup.LayoutParams layoutParams;
        RelativeLayout relativeLayout;
        super.onCreate((Bundle)object);
        RuningAcitvityUtil.putRuningActivity((Activity)this);
        this.mDefOps = this.getIconDisplayOptions();
        object = this.getIntent();
        this.mImageUrls = object.hasExtra(IMAGE_URLLIST_KEY) ? this.listToNativeDataItems(object.getStringArrayListExtra(IMAGE_URLLIST_KEY)) : object.getParcelableArrayListExtra(IMAGE_URLS_KEY);
        if (this.mImageUrls == null) {
            this.onBackPressed();
            return;
        }
        this.mCurrentItmeIndex = object.getIntExtra(IMAGE_CURRENT_INDEX_KEY, this.mCurrentItmeIndex);
        if (this.mCurrentItmeIndex > this.mImageUrls.size()) {
            this.mCurrentItmeIndex = 0;
        }
        if (object.hasExtra("preview_callback")) {
            this.callbackId = object.getStringExtra("preview_callback");
        }
        if (object.hasExtra("original_image_urlArray")) {
            this.originalImageUrls = object.getStringArrayListExtra("original_image_urlArray");
        }
        if (object.hasExtra("screen_orientation")) {
            this.setRequestedOrientation(object.getIntExtra("screen_orientation", 2));
        }
        Bundle bundle = object;
        boolean bl = bundle.getBooleanExtra(IMAGE_LOOP_KEY, false);
        boolean bl2 = bundle.getBooleanExtra(IMAGE_PHOTO_KEY, false);
        if (bundle.hasExtra(IMAGE_INDICATOR_KEY)) {
            this.mIndicatorType = object.getStringExtra(IMAGE_INDICATOR_KEY);
        }
        RelativeLayout relativeLayout2 = relativeLayout;
        relativeLayout2((Context)this.that);
        relativeLayout.setBackgroundColor(object.getIntExtra(IMAGE_BG_KEY, -16777216));
        relativeLayout.postDelayed(new Runnable(){

            @Override
            public void run() {
                PhotoActivity.this.isBack = true;
            }
        }, 1000L);
        if (this.mImageUrls.size() > 0) {
            RelativeLayout.LayoutParams layoutParams2;
            BannerLayout bannerLayout;
            this.localImageUrls = new String[bl && this.mImageUrls.size() == 2 ? this.mImageUrls.size() + 2 : this.mImageUrls.size()];
            object = bannerLayout;
            this.photoLayout = object;
            new BannerLayout((Context)this.that, bl, bl2).setImageLoader(new BannerLayout.ImageLoader(){

                @Override
                public void displayImage(Context context, final String string2, final View view, final int n5) {
                    View view2 = view;
                    Object object = view2.getTag();
                    view2.setTag(null);
                    if (string2.startsWith("file://")) {
                        string2 = string2.replace("file://", "");
                    }
                    if (!(PdrUtil.isDeviceRootDir(string2) || PdrUtil.isNetPath(string2) || PdrUtil.isBase64ImagePath(string2))) {
                        string2 = string2.startsWith("assets://") ? string2.replace("assets://", "file:///android_asset/") : (string2.startsWith("/") ? "file:///android_asset" + string2 : "file:///android_asset/" + string2);
                    }
                    if (!FileUtil.checkPrivatePath(context, string2) && (context = FileUtil.getImageFileUri(context, string2)) != null) {
                        string2 = context.toString();
                    }
                    Glide.with((FragmentActivity)PhotoActivity.this).download((Object)string2).into((Target)new SimpleTarget<File>(){
                        private SubsamplingScaleImageView subImageview;
                        private ProgressBar bar;

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void onResourceReady(@NonNull File file, @Nullable Transition<? super File> object) {
                            block9: {
                                block7: {
                                    block8: {
                                        block4: {
                                            ImageSource imageSource;
                                            block6: {
                                                block5: {
                                                    object = view;
                                                    if (!(object instanceof RelativeLayout)) break block7;
                                                    try {
                                                        if (this.typeOf(file, "gif")) break block4;
                                                        if (!this.typeOf(file, "bmp")) break block5;
                                                        imageSource = BitmapUtil.needRatationWithExif(file) ? ImageSource.bitmap(BitmapUtil.getRotatedBitmapFromFile(file)) : ImageSource.bitmap(BitmapFactory.decodeFile((String)file.getAbsolutePath()));
                                                        break block6;
                                                    }
                                                    catch (Exception exception) {
                                                    }
                                                }
                                                imageSource = BitmapUtil.needRatationWithExif(file) ? ImageSource.bitmap(BitmapUtil.getRotatedBitmapFromFile(file)) : ImageSource.uri(file.getAbsolutePath());
                                            }
                                            object = imageSource;
                                            this.subImageview.setImage((ImageSource)object);
                                            break block8;
                                        }
                                        1 v22 = this;
                                        v22.subImageview.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                                        v22.subImageview.setImageURI(Uri.fromFile((File)file));
                                    }
                                    this.bar.setVisibility(8);
                                    break block9;
                                }
                                ((ImageView)object).setImageURI(Uri.fromFile((File)file));
                            }
                            if (PdrUtil.isNetPath(string2) && PhotoActivity.this.localImageUrls != null && n5 < PhotoActivity.this.localImageUrls.length) {
                                int n52 = n5;
                                ((PhotoActivity)PhotoActivity.this).localImageUrls[n52] = file.getAbsolutePath();
                            }
                        }

                        public void onLoadStarted(@Nullable Drawable drawable2) {
                            drawable2 = view;
                            if (drawable2 instanceof RelativeLayout) {
                                try {
                                    this.subImageview = (SubsamplingScaleImageView)((RelativeLayout)drawable2).getChildAt(0);
                                    this.bar = (ProgressBar)((RelativeLayout)view).getChildAt(1);
                                    return;
                                }
                                catch (Exception exception) {}
                            }
                        }

                        public boolean typeOf(File file, String string22) {
                            BitmapFactory.Options options;
                            1 this_ = options;
                            this_();
                            ((BitmapFactory.Options)this_).inJustDecodeBounds = true;
                            BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)this_);
                            return options.outMimeType.toLowerCase(Locale.ENGLISH).contains(string22);
                        }
                    });
                    view.setTag(object);
                }
            });
            object = this.mIndicatorType;
            this.photoLayout.setIndicatorContainerData(null, 20, 10, 18, (String)object);
            this.photoLayout.setScrollDuration(500);
            this.photoLayout.setViewUrls(this.mImageUrls, this.mCurrentItmeIndex);
            if (this.mImageUrls.size() == 2 && bl && this.photoLayout.getPager() != null) {
                this.photoLayout.getPager().setOffscreenPageLimit(2);
            }
            this.photoLayout.setOnBannerItemClickListener(new BannerLayout.OnBannerItemClickListener(){

                @Override
                public void onItemClick(int n5) {
                    PhotoActivity photoActivity = photoActivity.PhotoActivity.this;
                    if (photoActivity.isBack) {
                        photoActivity.onBackPressed();
                        return;
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onItemLongClick(int n5) {
                    JSONObject jSONObject;
                    block5: {
                        JSONObject jSONObject2;
                        jSONObject = jSONObject2;
                        try {
                            new JSONObject().put("index", n5);
                        }
                        catch (JSONException jSONException) {}
                        if (PhotoActivity.this.originalImageUrls == null || PhotoActivity.this.originalImageUrls.get(n5) == null) break block5;
                        jSONObject.put("url", PhotoActivity.this.originalImageUrls.get(n5));
                    }
                    if (PhotoActivity.this.localImageUrls[n5] != null) {
                        jSONObject.put("path", (Object)PhotoActivity.this.localImageUrls[n5]);
                    }
                    LongClickEventManager.getInstance().fireEvent(jSONObject);
                }
            });
            object = layoutParams2;
            layoutParams2 = new RelativeLayout.LayoutParams(-1, -1);
            relativeLayout2.addView((View)this.photoLayout, (ViewGroup.LayoutParams)object);
        }
        object = layoutParams;
        layoutParams = new ViewGroup.LayoutParams(-1, -1);
        this.setContentView((View)relativeLayout2, (ViewGroup.LayoutParams)object);
        PhotoActivity photoActivity = this;
        photoActivity.fullScreen((Activity)photoActivity);
    }

    public void onBackPressed() {
        Integer n5 = 4;
        if (EventDispatchManager.getInstance().dispatchEvent(ISysEventListener.SysEventType.onKeyUp, new Object[]{n5, null})) {
            return;
        }
        if (this.callbackId != null) {
            LongClickEventManager.getInstance().removeOnLongClickListener(this.callbackId);
        }
        PhotoActivity photoActivity = this;
        RuningAcitvityUtil.removeRuningActivity(photoActivity.getComponentName().getClassName());
        photoActivity.finish();
        photoActivity.overridePendingTransition(0x10A0000, 0x10A0001);
    }

    public ArrayList<NativeImageDataItem> listToNativeDataItems(ArrayList<String> arrayList) {
        ArrayList arrayList2;
        if (arrayList == null) {
            return null;
        }
        ArrayList arrayList3 = arrayList2;
        arrayList2 = new ArrayList();
        int n5 = arrayList.size();
        for (int i5 = 0; i5 < n5; ++i5) {
            String string2 = arrayList.get(i5);
            String string3 = string2;
            NativeImageDataItem nativeImageDataItem = new NativeImageDataItem();
            nativeImageDataItem.setUrl(string3);
            arrayList3.add(nativeImageDataItem);
        }
        return arrayList3;
    }
}

