/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.widget;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CapsuleLayout
extends LinearLayout {
    public static final int STYLE_LIGHT = 1;
    public static final int STYLE_DARK = 2;
    public Paint mPaint;
    public float mAngle;
    public int mStrokeColor;
    public int mStrokeWidth;
    public int mBackgroundColor;
    CapsuleDrawable mDrawable;
    private List<View> mIntervals;
    private int mSelectColor;
    private int mStyle = 1;
    public boolean isDiy = false;

    public CapsuleLayout(@NonNull Context context, float f5) {
        super(context);
        this.mAngle = f5;
        this.mIntervals = new ArrayList<View>();
        this.setRoundColor(Color.parseColor((String)"#ffffffff"), Color.parseColor((String)"#ffe5e5e5"), 1);
        this.mSelectColor = Color.parseColor((String)"#CBCCCD");
    }

    private void updateBackground() {
        if (this.mDrawable == null) {
            CapsuleDrawable capsuleDrawable;
            CapsuleDrawable capsuleDrawable2 = capsuleDrawable;
            this.mDrawable = new CapsuleDrawable();
            if (Build.VERSION.SDK_INT < 16) {
                this.setBackgroundDrawable((Drawable)capsuleDrawable2);
            } else {
                this.setBackground((Drawable)capsuleDrawable2);
            }
        }
        CapsuleLayout capsuleLayout = this;
        capsuleLayout.mDrawable.setCornerRadius(this.mAngle);
        CapsuleLayout capsuleLayout2 = this;
        int n5 = capsuleLayout2.mStrokeWidth;
        capsuleLayout.mDrawable.setStroke(n5, capsuleLayout2.mStrokeColor);
        capsuleLayout.mDrawable.setColor(this.mBackgroundColor);
        capsuleLayout.mDrawable.invalidateSelf();
    }

    private void initButtonBackground(View view, ButtonType buttonType) {
        CapsuleDrawable capsuleDrawable;
        CapsuleDrawable capsuleDrawable2;
        StateListDrawable stateListDrawable;
        StateListDrawable stateListDrawable2 = stateListDrawable;
        stateListDrawable = new StateListDrawable();
        CapsuleDrawable capsuleDrawable3 = capsuleDrawable2;
        capsuleDrawable2 = new CapsuleDrawable();
        CapsuleDrawable capsuleDrawable4 = capsuleDrawable;
        capsuleDrawable = new CapsuleDrawable();
        float[] fArray = new float[]{};
        int n5 = 1.$SwitchMap$com$dcloud$android$widget$CapsuleLayout$ButtonType[buttonType.ordinal()];
        if (n5 != 1) {
            if (n5 != 2) {
                if (n5 == 3) {
                    float[] fArray2 = new float[8];
                    fArray = fArray2;
                    fArray2[0] = 0.0f;
                    fArray2[1] = 0.0f;
                    fArray2[2] = 0.0f;
                    fArray2[3] = 0.0f;
                    fArray2[4] = 0.0f;
                    fArray2[5] = 0.0f;
                    fArray2[6] = 0.0f;
                    fArray2[7] = 0.0f;
                }
            } else {
                float f5;
                float[] fArray3 = new float[8];
                fArray = fArray3;
                fArray[0] = 0.0f;
                fArray[1] = 0.0f;
                fArray3[2] = f5 = this.mAngle;
                fArray3[3] = f5;
                fArray3[4] = f5;
                fArray3[5] = f5;
                fArray3[6] = 0.0f;
                fArray3[7] = 0.0f;
                capsuleDrawable4.setStroke(this.mStrokeWidth, 0);
            }
        } else {
            float f6;
            float[] fArray4 = new float[8];
            fArray = fArray4;
            fArray4[0] = f6 = this.mAngle;
            fArray4[1] = f6;
            fArray4[2] = 0.0f;
            fArray4[3] = 0.0f;
            fArray4[4] = 0.0f;
            fArray4[5] = 0.0f;
            fArray4[6] = f6;
            fArray4[7] = f6;
            capsuleDrawable4.setStroke(this.mStrokeWidth, 0);
        }
        StateListDrawable stateListDrawable3 = stateListDrawable2;
        CapsuleDrawable capsuleDrawable5 = capsuleDrawable3;
        capsuleDrawable4.setCornerRadii(fArray);
        capsuleDrawable5.setCornerRadii(fArray);
        capsuleDrawable5.setColor(0);
        capsuleDrawable4.setColor(this.mSelectColor);
        stateListDrawable3.addState(new int[]{16842919, 16842910}, (Drawable)capsuleDrawable4);
        stateListDrawable3.addState(new int[]{16842910, 16842908}, (Drawable)capsuleDrawable4);
        stateListDrawable3.addState(new int[]{16842910}, (Drawable)capsuleDrawable3);
        stateListDrawable3.addState(new int[]{16842908}, (Drawable)capsuleDrawable4);
        stateListDrawable3.addState(new int[]{16842909}, (Drawable)capsuleDrawable4);
        stateListDrawable3.addState(new int[0], (Drawable)capsuleDrawable3);
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable((Drawable)stateListDrawable2);
            return;
        }
        view.setBackground((Drawable)stateListDrawable2);
    }

    private void updateIntervalColor() {
        Iterator<View> iterator = this.mIntervals.iterator();
        while (iterator.hasNext()) {
            iterator.next().setBackgroundColor(this.mStrokeColor);
        }
    }

    public void setBackgroundColor(int n5) {
        this.mBackgroundColor = n5;
        this.updateBackground();
    }

    public void setBackground(Drawable drawable) {
        if (drawable instanceof CapsuleDrawable) {
            super.setBackground(drawable);
            return;
        }
    }

    public void setBackgroundResource(int n5) {
    }

    public void setRoundColor(int n5, int n6, int n7) {
        this.mBackgroundColor = n5;
        this.mStrokeColor = n6;
        this.mStrokeWidth = n7;
        this.updateBackground();
    }

    public void setRoundColor(int n5) {
        this.mStrokeColor = n5;
        this.updateBackground();
    }

    public void setButtonSelectColor(View view, ButtonType buttonType, int n5) {
        if (view != null && view.getParent() != null) {
            this.mSelectColor = n5;
            this.initButtonBackground((View)view.getParent(), buttonType);
            return;
        }
    }

    public void setAngle(float f5) {
        this.mAngle = f5;
        this.updateBackground();
    }

    public int checkColorToStyle(int n5) {
        if (this.isDiy) {
            return 1;
        }
        int n6 = n5 >> 16 & 0xFF;
        int n7 = n5;
        n5 = n7 >> 8 & 0xFF;
        int n8 = n7 & 0xFF;
        if (n6 > 235 && n5 > 235 && n8 > 235) {
            if (this.mStyle == 2) {
                CapsuleLayout capsuleLayout = this;
                capsuleLayout.mStyle = 1;
                capsuleLayout.setRoundColor(Color.parseColor((String)"#ffffffff"), Color.parseColor((String)"#ffe5e5e5"), 1);
                capsuleLayout.updateIntervalColor();
            }
        } else if (this.mStyle == 1) {
            CapsuleLayout capsuleLayout = this;
            capsuleLayout.mStyle = 2;
            capsuleLayout.setRoundColor(Color.parseColor((String)"#1a000000"), Color.parseColor((String)"#4de5e5e5"), 1);
            capsuleLayout.updateIntervalColor();
        }
        return this.mStyle;
    }

    public void addIntervalView(float f5) {
        LinearLayout.LayoutParams layoutParams;
        View view;
        CapsuleLayout capsuleLayout = this;
        View view2 = view;
        view2(this.getContext());
        view.setBackgroundColor(this.mStrokeColor);
        LinearLayout.LayoutParams layoutParams2 = layoutParams;
        int n5 = this.mStrokeWidth;
        layoutParams = new LinearLayout.LayoutParams(n5, (int)(f5 * 18.0f));
        capsuleLayout.addView(view, (ViewGroup.LayoutParams)layoutParams2);
        capsuleLayout.mIntervals.add(view2);
    }

    public void addButtonView(View view, LinearLayout.LayoutParams layoutParams, ButtonType buttonType, View.OnClickListener onClickListener) {
        LinearLayout linearLayout;
        LinearLayout linearLayout2;
        LinearLayout.LayoutParams layoutParams2;
        LinearLayout.LayoutParams layoutParams3 = layoutParams2;
        new LinearLayout.LayoutParams((int)-1, (int)-1).weight = 1.0f;
        new LinearLayout.LayoutParams((int)-1, (int)-1).gravity = 17;
        LinearLayout linearLayout3 = linearLayout2 = linearLayout;
        linearLayout2(this.getContext());
        linearLayout3.addView(view, (ViewGroup.LayoutParams)layoutParams);
        this.addView((View)linearLayout3, (ViewGroup.LayoutParams)layoutParams3);
        linearLayout.setOnClickListener(onClickListener);
        this.initButtonBackground((View)linearLayout, buttonType);
    }

    public void removeAllViews() {
        CapsuleLayout capsuleLayout = this;
        super.removeAllViews();
        capsuleLayout.mIntervals.clear();
    }

    private class CapsuleDrawable
    extends GradientDrawable {
        private CapsuleDrawable() {
        }
    }

    public static enum ButtonType {
        LIFT,
        MIDDLE,
        RIGHT;

    }
}

