/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder;

import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.pdf417.decoder.BarcodeMetadata;
import com.dcloud.zxing2.pdf417.decoder.BarcodeValue;
import com.dcloud.zxing2.pdf417.decoder.BoundingBox;
import com.dcloud.zxing2.pdf417.decoder.Codeword;
import com.dcloud.zxing2.pdf417.decoder.DetectionResultColumn;

final class DetectionResultRowIndicatorColumn
extends DetectionResultColumn {
    private final boolean isLeft;

    DetectionResultRowIndicatorColumn(BoundingBox boundingBox, boolean bl) {
        super(boundingBox);
        this.isLeft = bl;
    }

    private void removeIncorrectCodewords(Codeword[] codewordArray, BarcodeMetadata barcodeMetadata) {
        for (int i5 = 0; i5 < codewordArray.length; ++i5) {
            Codeword codeword = codewordArray[i5];
            if (codeword == null) continue;
            Codeword codeword2 = codeword;
            int n5 = codeword2.getValue() % 30;
            int n6 = codeword2.getRowNumber();
            if (n6 > barcodeMetadata.getRowCount()) {
                codewordArray[i5] = null;
                continue;
            }
            if (!this.isLeft) {
                n6 += 2;
            }
            if ((n6 %= 3) != 0) {
                if (n6 != 1) {
                    if (n6 != 2 || n5 + 1 == barcodeMetadata.getColumnCount()) continue;
                    codewordArray[i5] = null;
                    continue;
                }
                if (n5 / 3 == barcodeMetadata.getErrorCorrectionLevel() && n5 % 3 == barcodeMetadata.getRowCountLowerPart()) continue;
                codewordArray[i5] = null;
                continue;
            }
            if (n5 * 3 + 1 == barcodeMetadata.getRowCountUpperPart()) continue;
            codewordArray[i5] = null;
        }
    }

    void setRowNumbers() {
        for (Codeword codeword : this.getCodewords()) {
            if (codeword == null) continue;
            codeword.setRowNumberAsRowIndicatorColumn();
        }
    }

    int adjustCompleteIndicatorColumnRowNumbers(BarcodeMetadata barcodeMetadata) {
        int n5;
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn = this;
        Codeword[] codewordArray = detectionResultRowIndicatorColumn.getCodewords();
        detectionResultRowIndicatorColumn.setRowNumbers();
        detectionResultRowIndicatorColumn.removeIncorrectCodewords(codewordArray, barcodeMetadata);
        Object object = detectionResultRowIndicatorColumn.getBoundingBox();
        ResultPoint resultPoint = detectionResultRowIndicatorColumn.isLeft ? ((BoundingBox)object).getTopLeft() : ((BoundingBox)object).getTopRight();
        object = this.isLeft ? ((BoundingBox)object).getBottomLeft() : ((BoundingBox)object).getBottomRight();
        int n6 = this.imageRowToCodewordIndex((int)((ResultPoint)object).getY());
        float f5 = (float)(n6 - n5) / (float)barcodeMetadata.getRowCount();
        int n7 = -1;
        int n8 = 1;
        int n9 = 0;
        for (n5 = this.imageRowToCodewordIndex((int)resultPoint.getY()); n5 < n6; ++n5) {
            Codeword codeword = codewordArray[n5];
            if (codeword == null) continue;
            int n10 = codeword.getRowNumber() - n7;
            if (n10 == 0) {
                ++n9;
                continue;
            }
            if (n10 == 1) {
                n7 = Math.max(n8, n9);
                n8 = 1;
                int n11 = n9 = codeword.getRowNumber();
                int n12 = n8;
                n8 = n7;
                n9 = n12;
                n7 = n11;
                continue;
            }
            if (n10 >= 0 && codeword.getRowNumber() < barcodeMetadata.getRowCount() && n10 <= n5) {
                if (n8 > 2) {
                    n10 = (n8 - 2) * n10;
                }
                boolean bl = n10 >= n5;
                for (int i5 = 1; i5 <= n10 && !bl; ++i5) {
                    bl = codewordArray[n5 - i5] != null;
                }
                if (bl) {
                    codewordArray[n5] = null;
                    continue;
                }
                n7 = codeword.getRowNumber();
                n9 = 1;
                continue;
            }
            codewordArray[n5] = null;
        }
        return (int)((double)f5 + 0.5);
    }

    int[] getRowHeights() throws FormatException {
        Object object = this.getBarcodeMetadata();
        if (object == null) {
            return null;
        }
        this.adjustIncompleteIndicatorColumnRowNumbers((BarcodeMetadata)object);
        int n5 = ((BarcodeMetadata)object).getRowCount();
        object = new int[n5];
        for (Codeword codeword : this.getCodewords()) {
            int n6;
            if (codeword == null || (n6 = codeword.getRowNumber()) >= n5) continue;
            object[n6] = object[n6] + true;
        }
        return object;
    }

    int adjustIncompleteIndicatorColumnRowNumbers(BarcodeMetadata barcodeMetadata) {
        int n5;
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn = this;
        Object object = detectionResultRowIndicatorColumn.getBoundingBox();
        ResultPoint resultPoint = detectionResultRowIndicatorColumn.isLeft ? ((BoundingBox)object).getTopLeft() : ((BoundingBox)object).getTopRight();
        object = this.isLeft ? ((BoundingBox)object).getBottomLeft() : ((BoundingBox)object).getBottomRight();
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2 = this;
        int n6 = detectionResultRowIndicatorColumn2.imageRowToCodewordIndex((int)((ResultPoint)object).getY());
        float f5 = (float)(n6 - n5) / (float)barcodeMetadata.getRowCount();
        Codeword[] codewordArray = detectionResultRowIndicatorColumn2.getCodewords();
        int n7 = -1;
        int n8 = 1;
        int n9 = 0;
        for (n5 = this.imageRowToCodewordIndex((int)resultPoint.getY()); n5 < n6; ++n5) {
            Codeword codeword = codewordArray[n5];
            if (codeword == null) continue;
            Codeword codeword2 = codeword;
            codeword2.setRowNumberAsRowIndicatorColumn();
            int n10 = codeword2.getRowNumber() - n7;
            if (n10 == 0) {
                ++n9;
                continue;
            }
            if (n10 == 1) {
                n7 = Math.max(n8, n9);
                n8 = 1;
                int n11 = n9 = codeword.getRowNumber();
                int n12 = n8;
                n8 = n7;
                n9 = n12;
                n7 = n11;
                continue;
            }
            if (codeword.getRowNumber() >= barcodeMetadata.getRowCount()) {
                codewordArray[n5] = null;
                continue;
            }
            n7 = codeword.getRowNumber();
            n9 = 1;
        }
        return (int)((double)f5 + 0.5);
    }

    BarcodeMetadata getBarcodeMetadata() {
        BarcodeValue barcodeValue;
        BarcodeValue barcodeValue2;
        BarcodeValue barcodeValue3;
        BarcodeValue barcodeValue4;
        Codeword[] codewordArray = this.getCodewords();
        BarcodeValue barcodeValue5 = barcodeValue4;
        barcodeValue4 = new BarcodeValue();
        BarcodeValue barcodeValue6 = barcodeValue3;
        barcodeValue3 = new BarcodeValue();
        BarcodeValue barcodeValue7 = barcodeValue2;
        barcodeValue2 = new BarcodeValue();
        BarcodeValue barcodeValue8 = barcodeValue;
        barcodeValue = new BarcodeValue();
        int n5 = codewordArray.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            Codeword codeword = codewordArray[i5];
            if (codeword == null) continue;
            Codeword codeword2 = codeword;
            codeword2.setRowNumberAsRowIndicatorColumn();
            int n6 = codeword2.getValue() % 30;
            int n7 = codeword2.getRowNumber();
            if (!this.isLeft) {
                n7 += 2;
            }
            if ((n7 %= 3) != 0) {
                if (n7 != 1) {
                    if (n7 != 2) continue;
                    barcodeValue5.setValue(n6 + 1);
                    continue;
                }
                barcodeValue8.setValue(n6 / 3);
                barcodeValue7.setValue(n6 % 3);
                continue;
            }
            barcodeValue6.setValue(n6 * 3 + 1);
        }
        if (barcodeValue5.getValue().length != 0 && barcodeValue6.getValue().length != 0 && barcodeValue7.getValue().length != 0 && barcodeValue8.getValue().length != 0 && barcodeValue5.getValue()[0] >= 1 && barcodeValue6.getValue()[0] + barcodeValue7.getValue()[0] >= 3 && barcodeValue6.getValue()[0] + barcodeValue7.getValue()[0] <= 90) {
            BarcodeMetadata barcodeMetadata;
            BarcodeMetadata barcodeMetadata2;
            BarcodeMetadata barcodeMetadata3 = barcodeMetadata2 = barcodeMetadata;
            int n8 = barcodeValue6.getValue()[0];
            int n9 = barcodeValue7.getValue()[0];
            int n10 = barcodeValue8.getValue()[0];
            barcodeMetadata3(barcodeValue5.getValue()[0], n8, n9, n10);
            this.removeIncorrectCodewords(codewordArray, barcodeMetadata3);
            return barcodeMetadata;
        }
        return null;
    }

    boolean isLeft() {
        return this.isLeft;
    }

    @Override
    public String toString() {
        return "IsLeft: " + this.isLeft + '\n' + super.toString();
    }
}

