/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.performance;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXConfigAdapter;
import org.json.JSONObject;

public class WhiteScreenUtils {
    public static boolean doWhiteScreenCheck() {
        IWXConfigAdapter iWXConfigAdapter = WXSDKManager.getInstance().getWxConfigAdapter();
        if (iWXConfigAdapter == null) {
            return false;
        }
        double d = Math.random() * 100.0;
        double d2 = 100.0;
        try {
            d2 = Double.valueOf(iWXConfigAdapter.getConfig("wxapm", "new_ws_sampling", "100"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d < d2;
    }

    public static boolean isWhiteScreen(WXSDKInstance wXSDKInstance) {
        if (wXSDKInstance == null) {
            return false;
        }
        View view = wXSDKInstance.getContainerView();
        if (!(view instanceof ViewGroup)) {
            return false;
        }
        if (WhiteScreenUtils.isInWhiteList(wXSDKInstance)) {
            return false;
        }
        return WhiteScreenUtils.hasLeafViewOrSizeIgnore(view, 3) ^ true;
    }

    private static boolean isInWhiteList(WXSDKInstance wXSDKInstance) {
        Object object = WXSDKManager.getInstance().getWxConfigAdapter();
        if (object == null) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)(object = object.getConfig("wxapm", "ws_white_list", null)))) {
            return false;
        }
        object = object.split(";");
        int n = ((String[])object).length;
        for (int i = 0; i < n; ++i) {
            String string2;
            WXSDKInstance wXSDKInstance2;
            try {
                wXSDKInstance2 = wXSDKInstance;
                string2 = object[i];
            }
            catch (Exception exception) {}
            if (wXSDKInstance2.getBundleUrl() == null) continue;
            if (!wXSDKInstance.getBundleUrl().contains(string2)) continue;
            return true;
            exception.printStackTrace();
            break;
        }
        return false;
    }

    private static boolean hasLeafViewOrSizeIgnore(View view, int n) {
        if (!(view instanceof ViewGroup)) {
            return true;
        }
        if (n > 0) {
            if (view.getHeight() >= 10 && view.getWidth() >= 10) {
                --n;
            } else {
                return true;
            }
        }
        view = (ViewGroup)view;
        for (int i = 0; i < view.getChildCount(); ++i) {
            if (!WhiteScreenUtils.hasLeafViewOrSizeIgnore(view.getChildAt(i), n)) continue;
            return true;
        }
        return false;
    }

    public static String takeViewTreeSnapShot(WXSDKInstance wXSDKInstance) {
        if (wXSDKInstance == null) {
            return "nullInstance";
        }
        if ((wXSDKInstance = WhiteScreenUtils.geViewDetailTreeMsg(wXSDKInstance.getContainerView())) != null) {
            return wXSDKInstance.toString();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JSONObject geViewDetailTreeMsg(View view) {
        JSONObject jSONObject;
        block12: {
            Exception exception2;
            block11: {
                Object object;
                JSONObject jSONObject2;
                if (view == null) {
                    return null;
                }
                jSONObject = jSONObject2;
                jSONObject();
                try {
                    object = "width";
                    jSONObject.put((String)object, view.getWidth());
                }
                catch (Exception exception2) {}
                object = "height";
                jSONObject2.put((String)object, view.getHeight());
                int[] nArray = new int[2];
                object = nArray;
                Object object2 = object;
                Object object3 = object;
                object3[0] = -1;
                object3[1] = -1;
                view.getLocationOnScreen((int[])object3);
                object = "x";
                jSONObject.put((String)object, (int)object2[0]);
                object = "y";
                jSONObject2.put((String)object, nArray[1]);
                if (!(view instanceof ViewGroup)) break block11;
                View view2 = view;
                jSONObject.put("type", (Object)view.getClass().getSimpleName());
                view = (ViewGroup)view2;
                break block12;
            }
            JSONObject jSONObject3 = jSONObject;
            JSONObject jSONObject4 = jSONObject3;
            jSONObject3.put("type", (Object)view.getClass().getSimpleName());
            return jSONObject4;
            exception2.printStackTrace();
            return jSONObject;
        }
        for (int i = 0; i < view.getChildCount(); ++i) {
            String string2 = "child_" + i;
            jSONObject.put(string2, (Object)WhiteScreenUtils.geViewDetailTreeMsg(view.getChildAt(i)));
        }
        return jSONObject;
    }
}

