/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.common;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.tools.LogDetail;
import com.taobao.weex.utils.tools.TimeCalculator;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class WXThread
extends HandlerThread {
    private Handler mHandler;

    public static Runnable secure(Runnable runnable) {
        return WXThread.secure(runnable, null, null);
    }

    public static Runnable secure(Runnable runnable, WXSDKInstance wXSDKInstance, String string2) {
        if (runnable != null) {
            if (runnable instanceof SafeRunnable) {
                return runnable;
            }
            return new SafeRunnable(runnable, wXSDKInstance, string2);
        }
        return runnable;
    }

    public static Handler.Callback secure(Handler.Callback callback) {
        if (callback != null) {
            if (callback instanceof SafeCallback) {
                return callback;
            }
            return new SafeCallback(callback);
        }
        return callback;
    }

    public WXThread(String string2) {
        WXThread wXThread = this;
        super(string2);
        ((Thread)((Object)wXThread)).start();
        wXThread.mHandler = new Handler(this.getLooper());
    }

    public WXThread(String string2, Handler.Callback callback) {
        Handler handler;
        WXThread wXThread = wXThread2;
        super(string2);
        ((Thread)((Object)wXThread)).start();
        string2 = handler;
        WXThread wXThread2 = wXThread2.getLooper();
        handler = new Handler((Looper)wXThread2, WXThread.secure(callback));
        wXThread.mHandler = string2;
    }

    public WXThread(String string2, int n, Handler.Callback callback) {
        Handler handler;
        WXThread wXThread = wXThread2;
        super(string2, n);
        ((Thread)((Object)wXThread)).start();
        string2 = handler;
        WXThread wXThread2 = wXThread2.getLooper();
        handler = new Handler((Looper)wXThread2, WXThread.secure(callback));
        wXThread.mHandler = string2;
    }

    public WXThread(String string2, int n) {
        WXThread wXThread = this;
        super(string2, n);
        ((Thread)((Object)wXThread)).start();
        wXThread.mHandler = new Handler(this.getLooper());
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public boolean isWXThreadAlive() {
        return this.mHandler != null && this.getLooper() != null && ((Thread)((Object)this)).isAlive();
    }

    public boolean quit() {
        Handler handler = this.mHandler;
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
        }
        return super.quit();
    }

    static class SafeRunnable
    implements Runnable {
        static final String TAG = "SafeRunnable";
        private LogDetail mTimelineLog = null;
        private WeakReference<WXSDKInstance> mInstance;
        final Runnable mTask;

        SafeRunnable(Runnable runnable) {
            this(runnable, null);
        }

        SafeRunnable(Runnable runnable, String string2) {
            this(runnable, null, string2);
        }

        SafeRunnable(Runnable object, WXSDKInstance wXSDKInstance, String string2) {
            this.mTask = object;
            if (string2 != null) {
                LogDetail logDetail;
                Object object2 = object = logDetail;
                ((LogDetail)object2)();
                this.mTimelineLog = object2;
                ((LogDetail)object).info.platform = "Android";
                logDetail.name(string2);
                this.mInstance = new WeakReference<WXSDKInstance>(wXSDKInstance);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object;
            block8: {
                try {
                    if (this.mTask == null) break block8;
                    object = this.mTimelineLog;
                    if (object != null) {
                        ((LogDetail)object).taskStart();
                    }
                    SafeRunnable safeRunnable = this;
                    safeRunnable.mTask.run();
                    object = safeRunnable.mTimelineLog;
                    if (object != null) {
                        ((LogDetail)object).taskEnd();
                    }
                    break block8;
                }
                catch (Throwable throwable) {}
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.e(TAG, "SafeRunnable run throw expection:" + throwable.getMessage());
                    throw throwable;
                }
                WXLogUtils.w(TAG, throwable);
            }
            if (this.mTimelineLog != null && (object = this.mInstance) != null && (object = (WXSDKInstance)((Reference)object).get()) != null && (object = ((WXSDKInstance)object).mTimeCalculator) != null) {
                ((TimeCalculator)object).addLog(this.mTimelineLog);
            }
        }
    }

    static class SafeCallback
    implements Handler.Callback {
        static final String TAG = "SafeCallback";
        final Handler.Callback mCallback;

        SafeCallback(Handler.Callback callback) {
            this.mCallback = callback;
        }

        public boolean handleMessage(Message message) {
            boolean bl;
            block4: {
                bl = false;
                Handler.Callback callback = this.mCallback;
                return (boolean)callback;
                try {
                    return callback.handleMessage(message);
                }
                catch (Throwable throwable) {}
                finally {
                    if (callback == null) break block4;
                }
            }
            return bl;
        }
    }
}

