/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.downloader.core.task;

import android.os.Process;
import android.text.TextUtils;
import com.dcloud.android.downloader.core.DownloadResponse;
import com.dcloud.android.downloader.domain.DownloadInfo;
import com.dcloud.android.downloader.exception.DownloadException;
import io.dcloud.common.adapter.util.DCloudTrustManager;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;

public class GetFileInfoTask
implements Runnable {
    private final DownloadResponse downloadResponse;
    private final DownloadInfo downloadInfo;
    private final OnGetFileInfoListener onGetFileInfoListener;

    public GetFileInfoTask(DownloadResponse downloadResponse, DownloadInfo downloadInfo, OnGetFileInfoListener onGetFileInfoListener) {
        this.downloadResponse = downloadResponse;
        this.downloadInfo = downloadInfo;
        this.onGetFileInfoListener = onGetFileInfoListener;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeConnection() throws DownloadException {
        block11: {
            block12: {
                try {
                    var1_5 = (HttpURLConnection)new URL(this.downloadInfo.getDownloadUrl()).openConnection();
                }
                catch (Throwable v0) {
                    throw v0;
                }
                catch (Exception var0_1) {
                    throw new DownloadException(5, "Unknown error", var0_1);
                }
                catch (IOException var0_2) {
                    throw new DownloadException(5, "IO error", var0_2);
                }
                catch (ProtocolException var0_3) {
                    throw new DownloadException(4, "Protocol error", var0_3);
                }
                catch (MalformedURLException var0_4) {
                    throw new DownloadException(2, "Bad url.", var0_4);
                }
                {
                    if (!(var1_5 instanceof HttpsURLConnection)) break block11;
                    var2_6 = DCloudTrustManager.getSSLSocketFactory();
                    if (var2_6 == null) break block12;
                }
                ((HttpsURLConnection)var1_5).setSSLSocketFactory(var2_6);
            }
            ((HttpsURLConnection)var1_5).setHostnameVerifier((HostnameVerifier)DCloudTrustManager.getHostnameVerifier(false));
        }
        v1 = var1_5;
        v1.setConnectTimeout(10000);
        v1.setReadTimeout(10000);
        v1.setRequestMethod("GET");
        v1.setRequestProperty("Range", "bytes=0-");
        v1.setInstanceFollowRedirects(false);
        var2_7 = v1.getResponseCode();
        if (var2_7 != 200) ** GOTO lbl31
        {
            this.parseHttpResponse(var1_5, false);
            return;
lbl31:
            // 1 sources

            if (var2_7 == 206) {
                this.parseHttpResponse(var1_5, true);
                return;
            }
            if (var2_7 == 302 || 301 == var2_7) ** GOTO lbl36
        }
        {
            throw new DownloadException(3, "UnSupported response code:" + var2_7);
lbl36:
            // 1 sources

            v2 = this;
            this = var1_5.getHeaderField("Location");
            v2.downloadInfo.setLocation(this);
            v2.executeConnection();
            return;
        }
    }

    private void parseHttpResponse(HttpURLConnection httpURLConnection, boolean bl) throws DownloadException {
        String string2 = httpURLConnection.getHeaderField("Content-Length");
        long l5 = !(TextUtils.isEmpty((CharSequence)string2) || string2.equals("0") || string2.equals("-1")) ? Long.parseLong(string2) : (long)httpURLConnection.getContentLength();
        if (l5 > 0L) {
            GetFileInfoTask getFileInfoTask = this;
            getFileInfoTask.checkIfPause();
            getFileInfoTask.onGetFileInfoListener.onSuccess(l5, bl);
            return;
        }
        throw new DownloadException(6, "length <= 0");
    }

    private void checkIfPause() {
        if (!this.downloadInfo.isPause()) {
            return;
        }
        throw new DownloadException(7);
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        try {
            this.executeConnection();
            return;
        }
        catch (Exception exception) {
            this.downloadResponse.handleException(new DownloadException(9, (Throwable)exception));
        }
        catch (DownloadException downloadException) {
            this.downloadResponse.handleException(downloadException);
        }
    }

    public static interface OnGetFileInfoListener {
        public void onSuccess(long var1, boolean var3);

        public void onFailed(DownloadException var1);
    }
}

