/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.encoder;

import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.common.CharacterSetECI;
import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonEncoder;
import com.dcloud.zxing2.qrcode.decoder.ErrorCorrectionLevel;
import com.dcloud.zxing2.qrcode.decoder.Mode;
import com.dcloud.zxing2.qrcode.decoder.Version;
import com.dcloud.zxing2.qrcode.encoder.BlockPair;
import com.dcloud.zxing2.qrcode.encoder.ByteMatrix;
import com.dcloud.zxing2.qrcode.encoder.MaskUtil;
import com.dcloud.zxing2.qrcode.encoder.MatrixUtil;
import com.dcloud.zxing2.qrcode.encoder.QRCode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;

public final class Encoder {
    private static final int[] ALPHANUMERIC_TABLE;
    static final String DEFAULT_BYTE_MODE_ENCODING = "ISO-8859-1";

    private Encoder() {
    }

    private static int calculateMaskPenalty(ByteMatrix byteMatrix) {
        return MaskUtil.applyMaskPenaltyRule1(byteMatrix) + MaskUtil.applyMaskPenaltyRule2(byteMatrix) + MaskUtil.applyMaskPenaltyRule3(byteMatrix) + MaskUtil.applyMaskPenaltyRule4(byteMatrix);
    }

    public static QRCode encode(String string2, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
        return Encoder.encode(string2, errorCorrectionLevel, null);
    }

    public static QRCode encode(String object, ErrorCorrectionLevel object2, Map<EncodeHintType, ?> object3) throws WriterException {
        ByteMatrix byteMatrix;
        QRCode qRCode;
        BitArray bitArray;
        BitArray bitArray2;
        Object object4;
        BitArray bitArray3;
        Object object5;
        Object object6 = DEFAULT_BYTE_MODE_ENCODING;
        if (object3 != null && object3.containsKey(object5 = EncodeHintType.CHARACTER_SET)) {
            object6 = object3.get(object5).toString();
        }
        object3 = Encoder.chooseMode((String)object, (String)object6);
        object5 = bitArray3;
        bitArray3 = new BitArray();
        Object object7 = Mode.BYTE;
        if (object3 == object7 && !DEFAULT_BYTE_MODE_ENCODING.equals(object6) && (object4 = CharacterSetECI.getCharacterSetECIByName((String)object6)) != null) {
            Encoder.appendECI((CharacterSetECI)((Object)object4), (BitArray)object5);
        }
        Mode mode = object7;
        Object object8 = object5;
        Object object9 = object3;
        Encoder.appendModeInfo((Mode)((Object)object9), (BitArray)object5);
        object7 = bitArray2;
        bitArray2 = new BitArray();
        Encoder.appendBytes((String)object, (Mode)((Object)object9), (BitArray)object7, (String)object6);
        object6 = Encoder.chooseVersion(((BitArray)object8).getSize() + ((Mode)((Object)object3)).getCharacterCountBits(Version.getVersionForNumber(1)) + ((BitArray)object7).getSize(), object2);
        object6 = Encoder.chooseVersion(((BitArray)object8).getSize() + ((Mode)((Object)object3)).getCharacterCountBits((Version)object6) + ((BitArray)object7).getSize(), object2);
        object4 = bitArray;
        ((BitArray)object4)();
        bitArray.appendBitArray((BitArray)object5);
        Encoder.appendLengthInfo(object3 == mode ? ((BitArray)object7).getSizeInBytes() : ((String)object).length(), (Version)object6, (Mode)((Object)object3), (BitArray)object4);
        ((BitArray)object4).appendBitArray((BitArray)object7);
        object = ((Version)object6).getECBlocksForLevel((ErrorCorrectionLevel)((Object)object2));
        Object object10 = object6;
        int n5 = ((Version)object10).getTotalCodewords() - ((Version.ECBlocks)object).getTotalECCodewords();
        Encoder.terminateBits(n5, (BitArray)object4);
        int n6 = ((Version)object10).getTotalCodewords();
        int n7 = ((Version.ECBlocks)object).getNumBlocks();
        BitArray bitArray4 = Encoder.interleaveWithECBytes((BitArray)object4, n6, n5, n7);
        QRCode qRCode2 = qRCode;
        ErrorCorrectionLevel errorCorrectionLevel = object2;
        ErrorCorrectionLevel errorCorrectionLevel2 = object2;
        qRCode2();
        qRCode2.setECLevel((ErrorCorrectionLevel)((Object)object2));
        qRCode2.setMode((Mode)((Object)object3));
        qRCode2.setVersion((Version)object6);
        int n8 = ((Version)object6).getDimensionForVersion();
        object2 = byteMatrix;
        int n9 = n8;
        byteMatrix = new ByteMatrix(n9, n9);
        n8 = Encoder.chooseMaskPattern(bitArray4, errorCorrectionLevel2, (Version)object6, (ByteMatrix)object2);
        qRCode2.setMaskPattern(n8);
        MatrixUtil.buildMatrix(bitArray4, errorCorrectionLevel, (Version)object6, n8, (ByteMatrix)object2);
        qRCode.setMatrix((ByteMatrix)object2);
        return qRCode;
    }

    static int getAlphanumericCode(int n5) {
        int[] nArray = ALPHANUMERIC_TABLE;
        if (n5 < ALPHANUMERIC_TABLE.length) {
            return nArray[n5];
        }
        return -1;
    }

    public static Mode chooseMode(String string2) {
        return Encoder.chooseMode(string2, null);
    }

    private static Mode chooseMode(String string2, String string3) {
        if ("Shift_JIS".equals(string3) && Encoder.isOnlyDoubleByteKanji(string2)) {
            return Mode.KANJI;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i5 = 0; i5 < string2.length(); ++i5) {
            char c6 = string2.charAt(i5);
            if (c6 >= '0' && c6 <= '9') {
                bl = true;
                continue;
            }
            if (Encoder.getAlphanumericCode(c6) != -1) {
                bl2 = true;
                continue;
            }
            return Mode.BYTE;
        }
        if (bl2) {
            return Mode.ALPHANUMERIC;
        }
        if (bl) {
            return Mode.NUMERIC;
        }
        return Mode.BYTE;
    }

    private static boolean isOnlyDoubleByteKanji(String object) {
        byte[] byArray;
        try {
            byArray = ((String)object).getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        object = byArray;
        int n5 = byArray.length;
        if (n5 % 2 != 0) {
            return false;
        }
        for (int i5 = 0; i5 < n5; i5 += 2) {
            int n6 = object[i5] & 0xFF;
            if (n6 >= 129 && n6 <= 159 || n6 >= 224 && n6 <= 235) {
                continue;
            }
            return false;
        }
        return true;
    }

    private static int chooseMaskPattern(BitArray bitArray, ErrorCorrectionLevel errorCorrectionLevel, Version version, ByteMatrix byteMatrix) throws WriterException {
        int n5 = Integer.MAX_VALUE;
        int n6 = -1;
        for (int i5 = 0; i5 < 8; ++i5) {
            MatrixUtil.buildMatrix(bitArray, errorCorrectionLevel, version, i5, byteMatrix);
            int n7 = Encoder.calculateMaskPenalty(byteMatrix);
            if (n7 >= n5) continue;
            n6 = i5;
            n5 = n7;
        }
        return n6;
    }

    private static Version chooseVersion(int n5, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
        for (int i5 = 1; i5 <= 40; ++i5) {
            Version version = Version.getVersionForNumber(i5);
            if (version.getTotalCodewords() - version.getECBlocksForLevel(errorCorrectionLevel).getTotalECCodewords() < (n5 + 7) / 8) continue;
            return version;
        }
        throw new WriterException("Data too big");
    }

    static void terminateBits(int n5, BitArray bitArray) throws WriterException {
        int n6 = n5 * 8;
        if (bitArray.getSize() <= n6) {
            int n7;
            for (n7 = 0; n7 < 4 && bitArray.getSize() < n6; ++n7) {
                bitArray.appendBit(false);
            }
            n7 = bitArray.getSize() & 7;
            if (n7 > 0) {
                while (n7 < 8) {
                    bitArray.appendBit(false);
                    ++n7;
                }
            }
            n5 -= bitArray.getSizeInBytes();
            for (n7 = 0; n7 < n5; ++n7) {
                int n8 = (n7 & 1) == 0 ? 236 : 17;
                bitArray.appendBits(n8, 8);
            }
            if (bitArray.getSize() == n6) {
                return;
            }
            throw new WriterException("Bits size does not equal capacity");
        }
        throw new WriterException("data bits cannot fit in the QR Code" + bitArray.getSize() + " > " + n6);
    }

    static void getNumDataBytesAndNumECBytesForBlockID(int n5, int n6, int n7, int n8, int[] nArray, int[] nArray2) throws WriterException {
        if (n8 < n7) {
            int n9 = n5 % n7;
            int n10 = n7 - n9;
            int n11 = n5 / n7;
            n6 = n11 + 1;
            int n12 = n6 / n7;
            int n13 = n11 - n12;
            int n14 = n12 + 1;
            if (n13 == (n6 -= n14)) {
                if (n7 == n10 + n9) {
                    if (n5 == (n12 + n13) * n10 + (n14 + n6) * n9) {
                        if (n8 < n10) {
                            nArray[0] = n12;
                            nArray2[0] = n13;
                            return;
                        }
                        nArray[0] = n14;
                        nArray2[0] = n6;
                        return;
                    }
                    throw new WriterException("Total bytes mismatch");
                }
                throw new WriterException("RS blocks mismatch");
            }
            throw new WriterException("EC bytes mismatch");
        }
        throw new WriterException("Block ID too large");
    }

    static BitArray interleaveWithECBytes(BitArray bitArray, int n5, int n6, int n7) throws WriterException {
        if (bitArray.getSizeInBytes() == n6) {
            ArrayList<BlockPair> arrayList;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            ArrayList<BlockPair> arrayList2 = arrayList;
            arrayList = new ArrayList<BlockPair>(n7);
            for (int i5 = 0; i5 < n7; ++i5) {
                int[] nArray = new int[1];
                Object[] objectArray = nArray;
                int n11 = n10;
                int[] nArray2 = new int[1];
                Encoder.getNumDataBytesAndNumECBytesForBlockID(n5, n6, n7, i5, objectArray, nArray2);
                n10 = objectArray[0];
                byte[] byArray = new byte[n10];
                objectArray = byArray;
                bitArray.toBytes(n8 * 8, (byte[])objectArray, 0, n10);
                byte[] byArray2 = Encoder.generateECBytes(byArray, nArray2[0]);
                arrayList2.add(new BlockPair((byte[])objectArray, byArray2));
                n9 = Math.max(n9, n10);
                n10 = Math.max(n11, byArray2.length);
                n8 += nArray[0];
            }
            if (n6 == n8) {
                BitArray bitArray2;
                bitArray = bitArray2;
                bitArray2 = new BitArray();
                for (n6 = 0; n6 < n9; ++n6) {
                    n8 = arrayList2.size();
                    for (n7 = 0; n7 < n8; ++n7) {
                        Object e5 = arrayList2.get(n7);
                        byte[] byArray = ((BlockPair)e5).getDataBytes();
                        if (n6 >= byArray.length) continue;
                        bitArray.appendBits(byArray[n6], 8);
                    }
                }
                for (n6 = 0; n6 < n10; ++n6) {
                    n8 = arrayList2.size();
                    for (n7 = 0; n7 < n8; ++n7) {
                        Object e6 = arrayList2.get(n7);
                        byte[] byArray = ((BlockPair)e6).getErrorCorrectionBytes();
                        if (n6 >= byArray.length) continue;
                        bitArray.appendBits(byArray[n6], 8);
                    }
                }
                if (n5 == bitArray.getSizeInBytes()) {
                    return bitArray;
                }
                throw new WriterException("Interleaving error: " + n5 + " and " + bitArray.getSizeInBytes() + " differ.");
            }
            throw new WriterException("Data bytes does not match offset");
        }
        throw new WriterException("Number of bits and data bytes does not match");
    }

    static byte[] generateECBytes(byte[] byArray, int n5) {
        int n6;
        int n7 = byArray.length;
        int[] nArray = new int[n7 + n5];
        for (n6 = 0; n6 < n7; ++n6) {
            nArray[n6] = byArray[n6] & 0xFF;
        }
        new ReedSolomonEncoder(GenericGF.QR_CODE_FIELD_256).encode(nArray, n5);
        byArray = new byte[n5];
        for (n6 = 0; n6 < n5; ++n6) {
            byArray[n6] = (byte)nArray[n7 + n6];
        }
        return byArray;
    }

    static void appendModeInfo(Mode mode, BitArray bitArray) {
        bitArray.appendBits(mode.getBits(), 4);
    }

    static void appendLengthInfo(int n5, Version version, Mode mode, BitArray bitArray) throws WriterException {
        int n6 = mode.getCharacterCountBits(version);
        int n7 = 1 << n6;
        if (n5 < n7) {
            bitArray.appendBits(n5, n6);
            return;
        }
        throw new WriterException(n5 + " is bigger than " + (n7 - 1));
    }

    static void appendBytes(String string2, Mode mode, BitArray bitArray, String string3) throws WriterException {
        switch (1.$SwitchMap$com$dcloud$zxing2$qrcode$decoder$Mode[mode.ordinal()]) {
            default: {
                throw new WriterException("Invalid mode: " + (Object)((Object)mode));
            }
            case 4: {
                Encoder.appendKanjiBytes(string2, bitArray);
                return;
            }
            case 3: {
                Encoder.append8BitBytes(string2, bitArray, string3);
                return;
            }
            case 2: {
                Encoder.appendAlphanumericBytes(string2, bitArray);
                return;
            }
            case 1: 
        }
        Encoder.appendNumericBytes(string2, bitArray);
    }

    static void appendNumericBytes(CharSequence charSequence, BitArray bitArray) {
        int n5 = charSequence.length();
        int n6 = 0;
        while (n6 < n5) {
            int n7 = charSequence.charAt(n6) - 48;
            int n8 = n6 + 2;
            if (n8 < n5) {
                int n9 = n7;
                n7 = charSequence.charAt(n6 + 1) - 48;
                n8 = charSequence.charAt(n8) - 48;
                bitArray.appendBits(n9 * 100 + n7 * 10 + n8, 10);
                n6 += 3;
                continue;
            }
            if (++n6 < n5) {
                n6 = charSequence.charAt(n6) - 48;
                bitArray.appendBits(n7 * 10 + n6, 7);
                n6 = n8;
                continue;
            }
            bitArray.appendBits(n7, 4);
        }
    }

    static void appendAlphanumericBytes(CharSequence charSequence, BitArray bitArray) throws WriterException {
        int n5 = charSequence.length();
        int n6 = 0;
        while (n6 < n5) {
            int n7 = Encoder.getAlphanumericCode(charSequence.charAt(n6));
            if (n7 != -1) {
                int n8 = n6 + 1;
                if (n8 < n5) {
                    if ((n8 = Encoder.getAlphanumericCode(charSequence.charAt(n8))) != -1) {
                        bitArray.appendBits(n7 * 45 + n8, 11);
                        n6 += 2;
                        continue;
                    }
                    throw new WriterException();
                }
                bitArray.appendBits(n7, 6);
                n6 = n8;
                continue;
            }
            throw new WriterException();
        }
    }

    static void append8BitBytes(String object, BitArray bitArray, String string2) throws WriterException {
        byte[] byArray;
        try {
            byArray = ((String)object).getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException);
        }
        object = byArray;
        int n5 = byArray.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            bitArray.appendBits((int)object[i5], 8);
        }
        return;
    }

    static void appendKanjiBytes(String object, BitArray bitArray) throws WriterException {
        byte[] byArray;
        try {
            byArray = ((String)object).getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException);
        }
        object = byArray;
        int n5 = byArray.length;
        for (int i5 = 0; i5 < n5; i5 += 2) {
            int n6 = object[i5 + 1] & 0xFF;
            n6 = (object[i5] & 0xFF) << 8 | n6;
            int n7 = -1;
            if (n6 >= 33088 && n6 <= 40956) {
                n7 = n6 - 33088;
            } else if (n6 >= 57408 && n6 <= 60351) {
                n7 = n6 - 49472;
            }
            if (n7 != -1) {
                bitArray.appendBits((n7 >> 8) * 192 + (n7 & 0xFF), 13);
                continue;
            }
            throw new WriterException("Invalid byte sequence");
        }
        return;
    }

    private static void appendECI(CharacterSetECI characterSetECI, BitArray bitArray) {
        bitArray.appendBits(Mode.ECI.getBits(), 4);
        bitArray.appendBits(characterSetECI.getValue(), 8);
    }

    static {
        int[] nArray = new int[96];
        int[] nArray2 = nArray;
        nArray[0] = -1;
        nArray2[1] = -1;
        nArray2[2] = -1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[6] = -1;
        nArray2[7] = -1;
        nArray2[8] = -1;
        nArray2[9] = -1;
        nArray2[10] = -1;
        nArray2[11] = -1;
        nArray2[12] = -1;
        nArray2[13] = -1;
        nArray2[14] = -1;
        nArray2[15] = -1;
        nArray2[16] = -1;
        nArray2[17] = -1;
        nArray2[18] = -1;
        nArray2[19] = -1;
        nArray2[20] = -1;
        nArray2[21] = -1;
        nArray2[22] = -1;
        nArray2[23] = -1;
        nArray2[24] = -1;
        nArray2[25] = -1;
        nArray2[26] = -1;
        nArray2[27] = -1;
        nArray2[28] = -1;
        nArray2[29] = -1;
        nArray2[30] = -1;
        nArray2[31] = -1;
        nArray2[32] = 36;
        nArray2[33] = -1;
        nArray2[34] = -1;
        nArray2[35] = -1;
        nArray2[36] = 37;
        nArray2[37] = 38;
        nArray2[38] = -1;
        nArray2[39] = -1;
        nArray2[40] = -1;
        nArray2[41] = -1;
        nArray2[42] = 39;
        nArray2[43] = 40;
        nArray2[44] = -1;
        nArray2[45] = 41;
        nArray2[46] = 42;
        nArray2[47] = 43;
        nArray2[48] = 0;
        nArray2[49] = 1;
        nArray2[50] = 2;
        nArray2[51] = 3;
        nArray2[52] = 4;
        nArray2[53] = 5;
        nArray2[54] = 6;
        nArray2[55] = 7;
        nArray2[56] = 8;
        nArray2[57] = 9;
        nArray2[58] = 44;
        nArray2[59] = -1;
        nArray2[60] = -1;
        nArray2[61] = -1;
        nArray2[62] = -1;
        nArray2[63] = -1;
        nArray2[64] = -1;
        nArray2[65] = 10;
        nArray2[66] = 11;
        nArray2[67] = 12;
        nArray2[68] = 13;
        nArray2[69] = 14;
        nArray2[70] = 15;
        nArray2[71] = 16;
        nArray2[72] = 17;
        nArray2[73] = 18;
        nArray2[74] = 19;
        nArray2[75] = 20;
        nArray2[76] = 21;
        nArray2[77] = 22;
        nArray2[78] = 23;
        nArray2[79] = 24;
        nArray2[80] = 25;
        nArray2[81] = 26;
        nArray2[82] = 27;
        nArray2[83] = 28;
        nArray2[84] = 29;
        nArray2[85] = 30;
        nArray2[86] = 31;
        nArray2[87] = 32;
        nArray2[88] = 33;
        nArray2[89] = 34;
        nArray2[90] = 35;
        nArray2[91] = -1;
        nArray2[92] = -1;
        nArray2[93] = -1;
        nArray2[94] = -1;
        nArray2[95] = -1;
        ALPHANUMERIC_TABLE = nArray2;
    }
}

