/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.camera;

import android.graphics.Bitmap;
import com.dcloud.zxing2.LuminanceSource;

public final class PlanarYUVLuminanceSource
extends LuminanceSource {
    private final byte[] yuvData;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;
    private LuminanceSource rotateLuminanceSource = null;

    public PlanarYUVLuminanceSource(byte[] byArray, int n5, int n6, int n7, int n8, int n9, int n10) {
        super(n9, n10);
        if (n9 <= n5 && n10 <= n6) {
            PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
            planarYUVLuminanceSource.yuvData = byArray;
            planarYUVLuminanceSource.dataWidth = n5;
            planarYUVLuminanceSource.dataHeight = n6;
            planarYUVLuminanceSource.left = n7;
            planarYUVLuminanceSource.top = n8;
            return;
        }
        throw new IllegalArgumentException("Crop rectangle does not fit within image data.width=" + n9 + ";dataWidth=" + n5 + ";height=" + n10 + ";dataHeight=" + n6);
    }

    @Override
    public byte[] getRow(int n5, byte[] byArray) {
        if (n5 >= 0 && n5 < this.getHeight()) {
            int n6 = this.getWidth();
            if (byArray == null || byArray.length < n6) {
                byArray = new byte[n6];
            }
            if ((n5 = (n5 + this.top) * this.dataWidth + this.left) > 0) {
                System.arraycopy(this.yuvData, n5, byArray, 0, n6);
                return byArray;
            }
            return byArray;
        }
        throw new IllegalArgumentException("Requested row is outside the image: " + n5);
    }

    @Override
    public byte[] getMatrix() {
        int n5 = this.getWidth();
        PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
        int n6 = planarYUVLuminanceSource.getHeight();
        int n7 = planarYUVLuminanceSource.dataWidth;
        if (n5 == n7 && n6 == this.dataHeight) {
            return this.yuvData;
        }
        int n8 = n7;
        int n9 = n5 * n6;
        byte[] byArray = new byte[n9];
        n7 = this.top * n7 + this.left;
        if (n5 == n8) {
            System.arraycopy(this.yuvData, n7, byArray, 0, n9);
            return byArray;
        }
        byte[] byArray2 = this.yuvData;
        for (int i5 = 0; i5 < n6; ++i5) {
            System.arraycopy(byArray2, n7, byArray, i5 * n5, n5);
            n7 += this.dataWidth;
        }
        return byArray;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public boolean isRotateSupported() {
        return true;
    }

    @Override
    public LuminanceSource rotateCounterClockwise() {
        if (this.rotateLuminanceSource == null) {
            PlanarYUVLuminanceSource planarYUVLuminanceSource;
            PlanarYUVLuminanceSource planarYUVLuminanceSource2 = this;
            Object object = planarYUVLuminanceSource2.getMatrix();
            int n5 = planarYUVLuminanceSource2.getHeight();
            int n6 = this.getWidth();
            byte[] byArray = new byte[((byte[])object).length];
            int n7 = (n5 - 1) * n6;
            for (int i5 = 0; i5 < n5; ++i5) {
                int n8 = i5 * n6;
                for (int i6 = 0; i6 < n6; ++i6) {
                    int n9 = n8 + i6;
                    byArray[n9] = object[n7 - i6 * n6];
                }
                ++n7;
            }
            object = planarYUVLuminanceSource;
            planarYUVLuminanceSource = new PlanarYUVLuminanceSource(byArray, n6, n5, 0, 0, n6, n5);
            this.rotateLuminanceSource = object;
        }
        return this.rotateLuminanceSource;
    }

    public int getDataWidth() {
        return this.dataWidth;
    }

    public int getDataHeight() {
        return this.dataHeight;
    }

    public Bitmap renderCroppedGreyscaleBitmap() {
        return this.renderCroppedGreyscaleBitmap(false);
    }

    public Bitmap renderCroppedGreyscaleBitmap(boolean n5) {
        int n6 = n5;
        PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
        n5 = planarYUVLuminanceSource.getWidth();
        int n7 = this.getHeight();
        int[] nArray = new int[n5 * n7];
        byte[] byArray = planarYUVLuminanceSource.yuvData;
        if (n6) {
            int n8 = (this.top + n7) * this.dataWidth + this.left;
            for (int i5 = 0; i5 < n7; ++i5) {
                int n9 = i5 * n5;
                for (int i6 = 0; i6 < n5; ++i6) {
                    int n10 = n9 + i6;
                    nArray[n10] = (byArray[n8 - i6 * this.dataWidth] & 0xFF) * 65793 | 0xFF000000;
                }
                ++n8;
            }
        } else {
            int n11 = this.top * this.dataWidth + this.left;
            for (int i7 = 0; i7 < n7; ++i7) {
                int n12 = i7 * n5;
                for (int i8 = 0; i8 < n5; ++i8) {
                    int n13 = n12 + i8;
                    nArray[n13] = (byArray[n11 + i8] & 0xFF) * 65793 | 0xFF000000;
                }
                n11 += this.dataWidth;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n5, (int)n7, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(nArray, 0, n5, 0, 0, n5, n7);
        return bitmap;
    }
}

