/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model.android;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.IDrawingCache;
import master.flame.danmaku.danmaku.model.android.AndroidDisplayer;
import master.flame.danmaku.danmaku.model.android.DrawingCacheHolder;

public abstract class BaseCacheStuffer {
    protected Proxy mProxy;

    public void prepare(BaseDanmaku danmaku, boolean fromWorkerThread) {
        if (this.mProxy != null) {
            this.mProxy.prepareDrawing(danmaku, fromWorkerThread);
        }
    }

    public abstract void measure(BaseDanmaku var1, TextPaint var2, boolean var3);

    public abstract void clearCaches();

    public abstract void drawDanmaku(BaseDanmaku var1, Canvas var2, float var3, float var4, boolean var5, AndroidDisplayer.DisplayerConfig var6);

    public boolean drawCache(BaseDanmaku danmaku, Canvas canvas, float left, float top, Paint alphaPaint, TextPaint paint) {
        DrawingCacheHolder holder;
        IDrawingCache<?> cache = danmaku.getDrawingCache();
        if (cache != null && (holder = (DrawingCacheHolder)cache.get()) != null) {
            return holder.draw(canvas, left, top, alphaPaint);
        }
        return false;
    }

    public void clearCache(BaseDanmaku danmaku) {
    }

    public void setProxy(Proxy adapter) {
        this.mProxy = adapter;
    }

    public void releaseResource(BaseDanmaku danmaku) {
        if (this.mProxy != null) {
            this.mProxy.releaseResource(danmaku);
        }
    }

    public static abstract class Proxy {
        public abstract void prepareDrawing(BaseDanmaku var1, boolean var2);

        public abstract void releaseResource(BaseDanmaku var1);
    }
}

