/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.renderer.android;

import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.ICacheManager;
import master.flame.danmaku.danmaku.model.IDanmakuIterator;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.IDrawingCache;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.renderer.IRenderer;
import master.flame.danmaku.danmaku.renderer.Renderer;
import master.flame.danmaku.danmaku.renderer.android.DanmakusRetainer;

public class DanmakuRenderer
extends Renderer {
    private DanmakuTimer mStartTimer;
    private final DanmakuContext mContext;
    private DanmakusRetainer.Verifier mVerifier;
    private final DanmakusRetainer.Verifier verifier = new DanmakusRetainer.Verifier(){

        @Override
        public boolean skipLayout(BaseDanmaku danmaku, float fixedTop, int lines, boolean willHit) {
            if (danmaku.priority == 0 && ((DanmakuRenderer)DanmakuRenderer.this).mContext.mDanmakuFilters.filterSecondary(danmaku, lines, 0, DanmakuRenderer.this.mStartTimer, willHit, DanmakuRenderer.this.mContext)) {
                danmaku.setVisibility(false);
                return true;
            }
            return false;
        }
    };
    private final DanmakusRetainer mDanmakusRetainer;
    private ICacheManager mCacheManager;
    private IRenderer.OnDanmakuShownListener mOnDanmakuShownListener;

    public DanmakuRenderer(DanmakuContext config) {
        this.mContext = config;
        this.mDanmakusRetainer = new DanmakusRetainer(config.isAlignBottom());
    }

    @Override
    public void clear() {
        this.clearRetainer();
        this.mContext.mDanmakuFilters.clear();
    }

    @Override
    public void clearRetainer() {
        this.mDanmakusRetainer.clear();
    }

    @Override
    public void release() {
        this.mDanmakusRetainer.release();
        this.mContext.mDanmakuFilters.clear();
    }

    @Override
    public void setVerifierEnabled(boolean enabled) {
        this.mVerifier = enabled ? this.verifier : null;
    }

    @Override
    public void draw(IDisplayer disp, IDanmakus danmakus, long startRenderTime, IRenderer.RenderingState renderingState) {
        this.mStartTimer = renderingState.timer;
        BaseDanmaku drawItem = null;
        IDanmakuIterator itr = danmakus.iterator();
        while (itr.hasNext()) {
            drawItem = itr.next();
            if (drawItem.isTimeOut()) {
                disp.recycle(drawItem);
                continue;
            }
            if (!renderingState.isRunningDanmakus && drawItem.isOffset()) {
                itr.remove();
                continue;
            }
            if (!drawItem.hasPassedFilter()) {
                this.mContext.mDanmakuFilters.filter(drawItem, renderingState.indexInScreen, renderingState.totalSizeInScreen, renderingState.timer, false, this.mContext);
            }
            if (drawItem.getActualTime() < startRenderTime || drawItem.priority == 0 && drawItem.isFiltered()) continue;
            if (drawItem.isLate()) {
                IDrawingCache<?> cache = drawItem.getDrawingCache();
                if (this.mCacheManager == null || cache != null && cache.get() != null) break;
                this.mCacheManager.addDanmaku(drawItem);
                break;
            }
            if (drawItem.getType() == 1) {
                ++renderingState.indexInScreen;
            }
            if (!drawItem.isMeasured()) {
                drawItem.measure(disp, false);
            }
            if (!drawItem.isPrepared()) {
                drawItem.prepare(disp, false);
            }
            this.mDanmakusRetainer.fix(drawItem, disp, this.mVerifier);
            if (!drawItem.isShown() || drawItem.lines == null && drawItem.getBottom() > (float)disp.getHeight()) continue;
            int renderingType = drawItem.draw(disp);
            if (renderingType == 1) {
                ++renderingState.cacheHitCount;
            } else if (renderingType == 2) {
                ++renderingState.cacheMissCount;
                if (this.mCacheManager != null) {
                    this.mCacheManager.addDanmaku(drawItem);
                }
            }
            renderingState.addCount(drawItem.getType(), 1);
            renderingState.addTotalCount(1);
            renderingState.appendToRunningDanmakus(drawItem);
            if (this.mOnDanmakuShownListener == null || drawItem.firstShownFlag == this.mContext.mGlobalFlagValues.FIRST_SHOWN_RESET_FLAG) continue;
            drawItem.firstShownFlag = this.mContext.mGlobalFlagValues.FIRST_SHOWN_RESET_FLAG;
            this.mOnDanmakuShownListener.onDanmakuShown(drawItem);
        }
        renderingState.lastDanmaku = drawItem;
    }

    @Override
    public void setCacheManager(ICacheManager cacheManager) {
        this.mCacheManager = cacheManager;
    }

    @Override
    public void setOnDanmakuShownListener(IRenderer.OnDanmakuShownListener onDanmakuShownListener) {
        this.mOnDanmakuShownListener = onDanmakuShownListener;
    }

    @Override
    public void removeOnDanmakuShownListener() {
        this.mOnDanmakuShownListener = null;
    }

    @Override
    public void alignBottom(boolean enable) {
        if (this.mDanmakusRetainer != null) {
            this.mDanmakusRetainer.alignBottom(enable);
        }
    }
}

