/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.UPCEANReader;

public final class EAN13Reader
extends UPCEANReader {
    static final int[] FIRST_DIGIT_ENCODINGS = new int[]{0, 11, 13, 14, 19, 25, 28, 21, 22, 26};
    private final int[] decodeMiddleCounters = new int[4];

    private static void determineFirstDigit(StringBuilder stringBuilder, int n5) throws NotFoundException {
        for (int i5 = 0; i5 < 10; ++i5) {
            if (n5 != FIRST_DIGIT_ENCODINGS[i5]) continue;
            stringBuilder.insert(0, (char)(i5 + 48));
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    protected int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int n5;
        int n6;
        int[] nArray2 = ((EAN13Reader)object).decodeMiddleCounters;
        Object object = nArray2;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        ((EAN13Reader)object).decodeMiddleCounters[3] = 0;
        int n7 = bitArray.getSize();
        int n8 = nArray[1];
        int n9 = 0;
        for (n6 = 0; n6 < 6 && n8 < n7; ++n6) {
            n5 = UPCEANReader.decodeDigit(bitArray, (int[])object, n8, UPCEANReader.L_AND_G_PATTERNS);
            stringBuilder.append((char)(n5 % 10 + 48));
            int n10 = ((Object)object).length;
            for (int i5 = 0; i5 < n10; ++i5) {
                n8 += object[i5];
            }
            if (n5 < 10) continue;
            n9 |= 1 << 5 - n6;
        }
        EAN13Reader.determineFirstDigit(stringBuilder, n9);
        n8 = UPCEANReader.findGuardPattern(bitArray, n8, true, UPCEANReader.MIDDLE_PATTERN)[1];
        for (n9 = 0; n9 < 6 && n8 < n7; ++n9) {
            stringBuilder.append((char)(UPCEANReader.decodeDigit(bitArray, (int[])object, n8, UPCEANReader.L_PATTERNS) + 48));
            n6 = ((Object)object).length;
            for (n5 = 0; n5 < n6; ++n5) {
                n8 += object[n5];
            }
        }
        return n8;
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_13;
    }
}

