/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.ByteString;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public final class Options
extends AbstractList<ByteString>
implements RandomAccess {
    final ByteString[] byteStrings;
    final int[] trie;

    private Options(ByteString[] byteStringArray, int[] nArray) {
        this.byteStrings = byteStringArray;
        this.trie = nArray;
    }

    public static Options of(ByteString ... byteStringArray) {
        int n5;
        ArrayList<Integer> arrayList;
        ArrayList<ByteString> arrayList2;
        if (byteStringArray.length == 0) {
            byteStringArray = new ByteString[]{};
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = 0;
            nArray[1] = -1;
            return new Options(byteStringArray, nArray2);
        }
        ArrayList<ByteString> arrayList3 = arrayList2;
        Collections.sort(new ArrayList<ByteString>(Arrays.asList(byteStringArray)));
        Object object = arrayList;
        arrayList = new ArrayList<Integer>();
        for (n5 = 0; n5 < arrayList3.size(); ++n5) {
            object.add(-1);
        }
        for (n5 = 0; n5 < arrayList3.size(); ++n5) {
            int n6 = Collections.binarySearch(arrayList3, byteStringArray[n5]);
            object.set(n6, n5);
        }
        if (((ByteString)arrayList3.get(0)).size() != 0) {
            Buffer buffer;
            n5 = 0;
            while (n5 < arrayList3.size()) {
                ByteString byteString;
                int n7;
                ByteString byteString2 = (ByteString)arrayList3.get(n5);
                int n8 = n7 = n5 + 1;
                while (n8 < arrayList3.size() && (byteString = (ByteString)arrayList3.get(n8)).startsWith(byteString2)) {
                    if (byteString.size() != byteString2.size()) {
                        if ((Integer)object.get(n8) > (Integer)object.get(n5)) {
                            arrayList3.remove(n8);
                            object.remove(n8);
                            continue;
                        }
                        ++n8;
                        continue;
                    }
                    throw new IllegalArgumentException("duplicate option: " + byteString);
                }
                n5 = n7;
            }
            Buffer buffer2 = buffer;
            buffer2();
            int n9 = arrayList3.size();
            Options.buildTrieRecursive(0L, buffer2, 0, arrayList3, 0, n9, object);
            int n10 = Options.intCount(buffer);
            object = new int[n10];
            for (n9 = 0; n9 < n10; ++n9) {
                object[n9] = buffer2.readInt();
            }
            if (buffer2.exhausted()) {
                return new Options((ByteString[])byteStringArray.clone(), (int[])object);
            }
            throw new AssertionError();
        }
        throw new IllegalArgumentException("the empty byte string is not a supported option");
    }

    private static void buildTrieRecursive(long l5, Buffer buffer, int n5, List<ByteString> list, int n6, int n7, List<Integer> list2) {
        if (n6 < n7) {
            Buffer buffer2;
            Buffer buffer3;
            for (int i5 = n6; i5 < n7; ++i5) {
                if (list.get(i5).size() >= n5) {
                    continue;
                }
                throw new AssertionError();
            }
            ByteString byteString = list.get(n6);
            ByteString byteString2 = list.get(n7 - 1);
            int n8 = -1;
            if (n5 == byteString.size()) {
                n8 = list2.get(n6);
                byteString = list.get(++n6);
            }
            if (byteString.getByte(n5) != byteString2.getByte(n5)) {
                Buffer buffer4;
                int n9;
                int n10 = 1;
                for (n9 = n6 + 1; n9 < n7; ++n9) {
                    if (list.get(n9 - 1).getByte(n5) == list.get(n9).getByte(n5)) continue;
                    ++n10;
                }
                l5 = l5 + (long)Options.intCount(buffer) + 2L + (long)(n10 * 2);
                buffer.writeInt(n10);
                buffer.writeInt(n8);
                for (n10 = n6; n10 < n7; ++n10) {
                    n9 = list.get(n10).getByte(n5);
                    if (n10 != n6 && n9 == list.get(n10 - 1).getByte(n5)) continue;
                    buffer.writeInt(n9 & 0xFF);
                }
                Buffer buffer5 = buffer4;
                buffer4 = new Buffer();
                while (n6 < n7) {
                    block15: {
                        n9 = list.get(n6).getByte(n5);
                        for (int i6 = n8 = n6 + 1; i6 < n7; ++i6) {
                            if (n9 == list.get(i6).getByte(n5)) continue;
                            n9 = i6;
                            break block15;
                        }
                        n9 = n7;
                    }
                    if (n8 == n9 && n5 + 1 == list.get(n6).size()) {
                        buffer.writeInt(list2.get(n6));
                    } else {
                        buffer.writeInt((int)((l5 + (long)Options.intCount(buffer5)) * -1L));
                        Options.buildTrieRecursive(l5, buffer5, n5 + 1, list, n6, n9, list2);
                    }
                    n6 = n9;
                }
                l5 = buffer5.size();
                buffer.write(buffer5, l5);
                return;
            }
            int n11 = 0;
            int n12 = Math.min(byteString.size(), byteString2.size());
            for (int i7 = n5; i7 < n12 && byteString.getByte(i7) == byteString2.getByte(i7); ++i7) {
                ++n11;
            }
            l5 = l5 + (long)Options.intCount(buffer) + 2L + (long)n11 + 1L;
            buffer.writeInt(-n11);
            buffer.writeInt(n8);
            for (int i8 = n5; i8 < (n8 = n5 + n11); ++i8) {
                buffer.writeInt(byteString.getByte(i8) & 0xFF);
            }
            if (n6 + 1 == n7) {
                if (n8 == list.get(n6).size()) {
                    buffer.writeInt(list2.get(n6));
                    return;
                }
                throw new AssertionError();
            }
            Buffer buffer6 = buffer3 = buffer2;
            buffer6();
            buffer.writeInt((int)((l5 + (long)Options.intCount(buffer6)) * -1L));
            Options.buildTrieRecursive(l5, buffer3, n8, list, n6, n7, list2);
            buffer.write(buffer2, buffer2.size());
            return;
        }
        throw new AssertionError();
    }

    private static int intCount(Buffer buffer) {
        return (int)(buffer.size() / 4L);
    }

    @Override
    public ByteString get(int n5) {
        return this.byteStrings[n5];
    }

    @Override
    public final int size() {
        return this.byteStrings.length;
    }
}

