/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Proxy;
import android.os.Build;
import android.text.TextUtils;
import io.dcloud.common.util.AppRuntime;

public class NetworkTypeUtil {
    public static final int NETWORK_TYPE_UNKONWN = 0;
    public static final int NETWORK_TYPE_DISABLED = 1;
    public static final int NETWORK_TYPE_LINE = 2;
    public static final int NETWORK_TYPE_WIFI = 3;
    public static final int NETWORK_TYPE_2G = 4;
    public static final int NETWORK_TYPE_3G = 5;
    public static final int NETWORK_TYPE_4G = 6;

    public static int getNetworkType(Context context) {
        if (AppRuntime.hasPrivacyForNotShown(context)) {
            return 0;
        }
        if ((context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && context.isAvailable()) {
            if (context.getType() == 0) {
                switch (context.getSubtype()) {
                    default: {
                        return 0;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 15: 
                    case 17: {
                        return 6;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 12: {
                        return 5;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                }
                return 4;
            }
            if (context.getType() == 1) {
                return 3;
            }
            return 0;
        }
        return 1;
    }

    public static String getCurrentAPN(Context context) {
        if ((context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            if (context.getType() == 0) {
                return context.getExtraInfo();
            }
            return "";
        }
        return "";
    }

    public static boolean isWifiProxy(Context object) {
        int n5;
        if (Build.VERSION.SDK_INT >= 14) {
            object = System.getProperty("http.proxyHost");
            String string2 = System.getProperty("http.proxyPort");
            if (string2 == null) {
                string2 = "-1";
            }
            n5 = Integer.parseInt(string2);
        } else {
            Context context = object;
            object = Proxy.getHost((Context)context);
            n5 = Proxy.getPort((Context)context);
        }
        return !TextUtils.isEmpty((CharSequence)object) && n5 != -1;
    }
}

