/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.util.Arrays;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.contextanalysis.SJISContextAnalysis;
import org.mozilla.universalchardet.prober.distributionanalysis.SJISDistributionAnalysis;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.SJISSMModel;
import org.mozilla.universalchardet.prober.statemachine.SMModel;

public class SJISProber
extends CharsetProber {
    private static final SMModel smModel = new SJISSMModel();
    private CodingStateMachine codingSM;
    private CharsetProber.ProbingState state;
    private SJISContextAnalysis contextAnalyzer;
    private SJISDistributionAnalysis distributionAnalyzer;
    private byte[] lastChar;

    public SJISProber() {
        SJISProber sJISProber = this;
        sJISProber.codingSM = new CodingStateMachine(smModel);
        sJISProber.contextAnalyzer = new SJISContextAnalysis();
        sJISProber.distributionAnalyzer = new SJISDistributionAnalysis();
        sJISProber.lastChar = new byte[2];
        sJISProber.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_SHIFT_JIS;
    }

    @Override
    public float getConfidence() {
        return Math.max(this.contextAnalyzer.getConfidence(), this.distributionAnalyzer.getConfidence());
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n5, int n6) {
        n6 = n5 + n6;
        for (int i5 = n5; i5 < n6; ++i5) {
            int n7 = this.codingSM.nextState(byArray[i5]);
            if (n7 == 1) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            if (n7 == 2) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (n7 != 0) continue;
            n7 = this.codingSM.getCurrentCharLen();
            if (i5 == n5) {
                SJISProber sJISProber = this;
                byte[] byArray2 = sJISProber.lastChar;
                sJISProber.lastChar[1] = byArray[n5];
                sJISProber.contextAnalyzer.handleOneChar(byArray2, 2 - n7, n7);
                sJISProber.distributionAnalyzer.handleOneChar(this.lastChar, 0, n7);
                continue;
            }
            SJISProber sJISProber = this;
            sJISProber.contextAnalyzer.handleOneChar(byArray, i5 + 1 - n7, n7);
            sJISProber.distributionAnalyzer.handleOneChar(byArray, i5 - 1, n7);
        }
        SJISProber sJISProber = this;
        sJISProber.lastChar[0] = byArray[n6 - 1];
        if (sJISProber.state == CharsetProber.ProbingState.DETECTING && this.contextAnalyzer.gotEnoughData() && this.getConfidence() > 0.95f) {
            this.state = CharsetProber.ProbingState.FOUND_IT;
        }
        return this.state;
    }

    @Override
    public void reset() {
        SJISProber sJISProber = this;
        sJISProber.codingSM.reset();
        sJISProber.state = CharsetProber.ProbingState.DETECTING;
        sJISProber.contextAnalyzer.reset();
        sJISProber.distributionAnalyzer.reset();
        Arrays.fill(sJISProber.lastChar, (byte)0);
    }

    @Override
    public void setOption() {
    }
}

