/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.media.video.ijkplayer.media;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.MediaController;
import com.dcloud.android.annotation.NonNull;
import dc.squareup.HttpConstants;
import dc.squareup.okhttp3.internal.http.BridgeInterceptor;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.media.video.ijkplayer.media.AssetsDataSourceProvider;
import io.dcloud.media.video.ijkplayer.media.FileMediaDataSource;
import io.dcloud.media.video.ijkplayer.media.IMediaController;
import io.dcloud.media.video.ijkplayer.media.IRenderView;
import io.dcloud.media.video.ijkplayer.media.MediaPlayerCompat;
import io.dcloud.media.video.ijkplayer.media.SurfaceRenderView;
import io.dcloud.media.video.ijkplayer.media.TextureRenderView;
import io.dcloud.media.video.ijkplayer.option.EnumPlayStrategy;
import io.dcloud.media.video.ijkplayer.utils.VideoCacheUtil;
import java.io.File;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import tv.danmaku.ijk.media.player.AndroidMediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;
import tv.danmaku.ijk.media.player.TextureMediaPlayer;
import tv.danmaku.ijk.media.player.misc.IMediaDataSource;
import tv.danmaku.ijk.media.player.misc.ITrackInfo;

public class IjkVideoView
extends FrameLayout
implements MediaController.MediaPlayerControl {
    private String TAG = "TTAG";
    private Uri mUri;
    private AssetsDataSourceProvider fd;
    private Map<String, String> mHeaders;
    private int mCurrentState = 330;
    private int mTargetState = 330;
    private IRenderView.ISurfaceHolder mSurfaceHolder = null;
    private IMediaPlayer mMediaPlayer = null;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mVideoRotationDegree;
    private int mVideoTargetRotationDegree;
    private Matrix mOriginalMatrix;
    private IMediaController mMediaController;
    private IMediaPlayer.OnCompletionListener mOnCompletionListener;
    private IMediaPlayer.OnPreparedListener mOnPreparedListener;
    private int mCurrentBufferPercentage;
    private IMediaPlayer.OnErrorListener mOnErrorListener;
    private IMediaPlayer.OnInfoListener mOnInfoListener;
    private int mSeekWhenPrepared;
    private boolean mCanPause = true;
    private boolean mCanSeekBack = true;
    private boolean mCanSeekForward = true;
    private boolean mIsUsingMediaCodec = false;
    private boolean mIsUsingMediaCodecAutoRotate = false;
    private boolean mIsMediaCodecHandleResolutionChange = false;
    private boolean mIsUsingOpenSLES = false;
    private EnumPlayStrategy enumPlayStrategy = EnumPlayStrategy.DEFAULT;
    private boolean isHttpCacheOpen = false;
    private boolean mIsUsingMediaDataSource;
    private String mPixelFormat = "";
    private Context mAppContext;
    private IRenderView mRenderView;
    private int mVideoSarNum;
    private int mVideoSarDen;
    private float mVideoScale = 1.0f;
    private boolean mIsNormalScreen = true;
    private int mScreenOrWidth;
    private int mScreenOrHeight;
    private Matrix mSaveMatrix;
    private boolean isStoped = false;
    private long mPrepareStartTime = 0L;
    private long mPrepareEndTime = 0L;
    private long mSeekStartTime = 0L;
    private long mSeekEndTime = 0L;
    private ImageView coverImage;
    private String customUA = "";
    private JSONArray customAdvanceJSON = new JSONArray();
    IMediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new IMediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sarNum, int sarDen) {
            IjkVideoView.this.mVideoWidth = mp.getVideoWidth();
            IjkVideoView.this.mVideoHeight = mp.getVideoHeight();
            IjkVideoView.this.mVideoSarNum = mp.getVideoSarNum();
            IjkVideoView.this.mVideoSarDen = mp.getVideoSarDen();
            if (IjkVideoView.this.mVideoWidth != 0 && IjkVideoView.this.mVideoHeight != 0) {
                if (IjkVideoView.this.mRenderView != null) {
                    IjkVideoView.this.mRenderView.setVideoSize(IjkVideoView.this.mVideoWidth, IjkVideoView.this.mVideoHeight);
                    IjkVideoView.this.mRenderView.setVideoSampleAspectRatio(IjkVideoView.this.mVideoSarNum, IjkVideoView.this.mVideoSarDen);
                }
                IjkVideoView.this.requestLayout();
            }
        }
    };
    IMediaPlayer.OnPreparedListener mPreparedListener = new IMediaPlayer.OnPreparedListener(){

        public void onPrepared(IMediaPlayer mp) {
            IjkVideoView.this.mPrepareEndTime = System.currentTimeMillis();
            IjkVideoView.this.mCurrentState = 333;
            IjkVideoView.this._notifyMediaStatus();
            if (IjkVideoView.this.mOnPreparedListener != null) {
                IjkVideoView.this.mOnPreparedListener.onPrepared(IjkVideoView.this.mMediaPlayer);
            }
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.setEnabled(true);
            }
            IjkVideoView.this.mVideoWidth = mp.getVideoWidth();
            IjkVideoView.this.mVideoHeight = mp.getVideoHeight();
            int seekToPosition = IjkVideoView.this.mSeekWhenPrepared;
            if (seekToPosition != 0) {
                IjkVideoView.this.seekTo(seekToPosition);
            }
            if (IjkVideoView.this.mVideoWidth != 0 && IjkVideoView.this.mVideoHeight != 0) {
                if (IjkVideoView.this.mRenderView != null) {
                    IjkVideoView.this.mRenderView.setVideoSize(IjkVideoView.this.mVideoWidth, IjkVideoView.this.mVideoHeight);
                    IjkVideoView.this.mRenderView.setVideoSampleAspectRatio(IjkVideoView.this.mVideoSarNum, IjkVideoView.this.mVideoSarDen);
                    if (!IjkVideoView.this.mRenderView.shouldWaitForResize() || IjkVideoView.this.mSurfaceWidth == IjkVideoView.this.mVideoWidth && IjkVideoView.this.mSurfaceHeight == IjkVideoView.this.mVideoHeight) {
                        if (IjkVideoView.this.mTargetState == 334) {
                            IjkVideoView.this.start();
                            if (IjkVideoView.this.mMediaController != null) {
                                IjkVideoView.this.mMediaController.show();
                            }
                        } else if (!(IjkVideoView.this.isPlaying() || seekToPosition == 0 && IjkVideoView.this.getCurrentPosition() <= 0 || IjkVideoView.this.mMediaController == null)) {
                            IjkVideoView.this.mMediaController.show(0);
                        }
                    }
                }
            } else if (IjkVideoView.this.mTargetState == 334) {
                IjkVideoView.this.start();
            }
        }
    };
    private IMediaPlayer.OnCompletionListener mCompletionListener = new IMediaPlayer.OnCompletionListener(){

        public void onCompletion(IMediaPlayer mp) {
            Log.w((String)IjkVideoView.this.TAG, (String)"OnCompletionListener:");
            IjkVideoView.this.mCurrentState = 336;
            IjkVideoView.this.mTargetState = 336;
            IjkVideoView.this._notifyMediaStatus();
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.hide();
            }
            if (IjkVideoView.this.mOnCompletionListener != null) {
                IjkVideoView.this.mOnCompletionListener.onCompletion(IjkVideoView.this.mMediaPlayer);
            }
        }
    };
    private IMediaPlayer.OnInfoListener mInfoListener = new IMediaPlayer.OnInfoListener(){

        public boolean onInfo(IMediaPlayer mp, int arg1, int arg2) {
            if (IjkVideoView.this.mOnInfoListener != null) {
                IjkVideoView.this.mOnInfoListener.onInfo(mp, arg1, arg2);
            }
            switch (arg1) {
                case 700: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_VIDEO_TRACK_LAGGING:");
                    break;
                }
                case 3: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_VIDEO_RENDERING_START:");
                    break;
                }
                case 701: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_BUFFERING_START:");
                    break;
                }
                case 702: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_BUFFERING_END:");
                    break;
                }
                case 703: {
                    Log.d((String)IjkVideoView.this.TAG, (String)("MEDIA_INFO_NETWORK_BANDWIDTH: " + arg2));
                    break;
                }
                case 800: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_BAD_INTERLEAVING:");
                    break;
                }
                case 801: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_NOT_SEEKABLE:");
                    break;
                }
                case 802: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_METADATA_UPDATE:");
                    break;
                }
                case 901: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_UNSUPPORTED_SUBTITLE:");
                    break;
                }
                case 902: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_SUBTITLE_TIMED_OUT:");
                    break;
                }
                case 10001: {
                    IjkVideoView.this.mVideoRotationDegree = arg2;
                    Log.d((String)IjkVideoView.this.TAG, (String)("MEDIA_INFO_VIDEO_ROTATION_CHANGED: " + arg2));
                    if (IjkVideoView.this.mRenderView == null) break;
                    IjkVideoView.this.mRenderView.setVideoRotation(arg2);
                    break;
                }
                case 10002: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_AUDIO_RENDERING_START:");
                }
            }
            return true;
        }
    };
    private IMediaPlayer.OnErrorListener mErrorListener = new IMediaPlayer.OnErrorListener(){

        public boolean onError(IMediaPlayer mp, int framework_err, int impl_err) {
            Log.d((String)"TTAG", (String)("Error: " + framework_err + "," + impl_err));
            IjkVideoView.this.mCurrentState = 331;
            IjkVideoView.this.mTargetState = 331;
            IjkVideoView.this._notifyMediaStatus();
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.hide();
            }
            if (IjkVideoView.this.mOnErrorListener != null && IjkVideoView.this.mOnErrorListener.onError(IjkVideoView.this.mMediaPlayer, framework_err, impl_err)) {
                return true;
            }
            return true;
        }
    };
    private IMediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new IMediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(IMediaPlayer mp, int percent) {
            IjkVideoView.this.mCurrentBufferPercentage = percent;
            if (IjkVideoView.this.bufferingUpdateListener != null) {
                IjkVideoView.this.bufferingUpdateListener.onBufferingUpdate(mp, percent);
            }
        }
    };
    private IMediaPlayer.OnBufferingUpdateListener bufferingUpdateListener;
    private IMediaPlayer.OnSeekCompleteListener mSeekCompleteListener = new IMediaPlayer.OnSeekCompleteListener(){

        public void onSeekComplete(IMediaPlayer mp) {
            IjkVideoView.this.mSeekEndTime = System.currentTimeMillis();
            IjkVideoView.this.mOnInfoListener.onInfo(mp, 337, -1);
        }
    };
    IRenderView.IRenderCallback mSHCallback = new IRenderView.IRenderCallback(){

        @Override
        public void onSurfaceChanged(@NonNull IRenderView.ISurfaceHolder holder, int format, int w, int h) {
            boolean hasValidSize;
            if (holder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e((String)IjkVideoView.this.TAG, (String)"onSurfaceChanged: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceWidth = w;
            IjkVideoView.this.mSurfaceHeight = h;
            boolean isValidState = IjkVideoView.this.mTargetState == 334;
            boolean bl = hasValidSize = !IjkVideoView.this.mRenderView.shouldWaitForResize() || IjkVideoView.this.mVideoWidth == w && IjkVideoView.this.mVideoHeight == h;
            if (IjkVideoView.this.mMediaPlayer != null && isValidState && hasValidSize) {
                if (IjkVideoView.this.mSeekWhenPrepared != 0) {
                    IjkVideoView.this.seekTo(IjkVideoView.this.mSeekWhenPrepared);
                }
                IjkVideoView.this.start();
            }
        }

        @Override
        public void onSurfaceCreated(@NonNull IRenderView.ISurfaceHolder holder, int width, int height) {
            if (holder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e((String)IjkVideoView.this.TAG, (String)"onSurfaceCreated: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceHolder = holder;
            if (IjkVideoView.this.mMediaPlayer != null) {
                IjkVideoView.this.bindSurfaceHolder(IjkVideoView.this.mMediaPlayer, holder);
            } else {
                IjkVideoView.this.openVideo();
            }
        }

        @Override
        public void onSurfaceDestroyed(@NonNull IRenderView.ISurfaceHolder holder) {
            if (holder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e((String)IjkVideoView.this.TAG, (String)"onSurfaceDestroyed: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceHolder = null;
            IjkVideoView.this.releaseWithoutStop();
        }
    };
    private boolean isMediaReady = true;
    private float volume = 0.0f;
    private boolean isSetSeekTo = false;
    private static final int[] s_allAspectRatio = new int[]{0, 1, 2, 4, 5};
    private int mCurrentAspectRatio = s_allAspectRatio[0];
    public static final int RENDER_NONE = 0;
    public static final int RENDER_SURFACE_VIEW = 1;
    public static final int RENDER_TEXTURE_VIEW = 2;
    private boolean mEnableBackgroundPlay = false;

    public int getCurrentState() {
        return this.mCurrentState;
    }

    public IjkVideoView(Context context) {
        super(context);
        this.initVideoView(context);
    }

    public IjkVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initVideoView(context);
    }

    public IjkVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initVideoView(context);
    }

    @TargetApi(value=21)
    public IjkVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initVideoView(context);
    }

    private void initVideoView(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.initBackground();
        this.initRenders();
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.mCurrentState = 330;
        this.mTargetState = 330;
        this._notifyMediaStatus();
        this.coverImage = new ImageView(this.getContext());
        this.coverImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.coverImage.setBackgroundColor(-16777216);
        this.coverImage.setVisibility(8);
        this.addView((View)this.coverImage, new ViewGroup.LayoutParams(-1, -1));
    }

    public void setmIsUsingMediaCodec(boolean mIsUsingMediaCodec) {
        this.mIsUsingMediaCodec = mIsUsingMediaCodec;
    }

    public void setIsHttpCacheOpen(boolean httpCacheOpen) {
        this.isHttpCacheOpen = httpCacheOpen;
    }

    public void setFlowStrategy(EnumPlayStrategy intFlowStrategy) {
        this.enumPlayStrategy = intFlowStrategy;
    }

    public void setRenderView(IRenderView renderView) {
        View renderUIView;
        if (this.mRenderView != null) {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setDisplay(null);
            }
            renderUIView = this.mRenderView.getView();
            this.mRenderView.removeRenderCallback(this.mSHCallback);
            this.mRenderView = null;
            this.removeView(renderUIView);
        }
        if (renderView == null) {
            return;
        }
        this.mRenderView = renderView;
        renderView.setAspectRatio(this.mCurrentAspectRatio);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            renderView.setVideoSize(this.mVideoWidth, this.mVideoHeight);
        }
        if (this.mVideoSarNum > 0 && this.mVideoSarDen > 0) {
            renderView.setVideoSampleAspectRatio(this.mVideoSarNum, this.mVideoSarDen);
        }
        renderUIView = this.mRenderView.getView();
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -2, 17);
        renderUIView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.addView(renderUIView);
        this.mRenderView.addRenderCallback(this.mSHCallback);
        this.mRenderView.setVideoRotation(this.mVideoRotationDegree);
    }

    public void setVideoRotation(int degree) {
        this.mVideoTargetRotationDegree = this.mVideoRotationDegree + degree;
        this.mRenderView.setVideoRotation(this.mVideoTargetRotationDegree);
    }

    public Matrix getVideoTransform() {
        if (this.mOriginalMatrix == null) {
            this.mOriginalMatrix = this.mRenderView.getTransform();
        }
        return this.mRenderView.getTransform();
    }

    public void setVideoTransform(Matrix transform) {
        this.mRenderView.setTransform(transform);
    }

    public boolean adjustVideoView(float scale) {
        this.mVideoScale *= scale;
        int degree = (this.mVideoTargetRotationDegree + 360) % 360;
        if (this.mVideoScale == 1.0f && degree == 0) {
            return false;
        }
        this.mVideoRotationDegree = degree > 315 || degree <= 45 ? 0 : (degree > 45 && degree <= 135 ? 90 : (degree > 135 && degree <= 225 ? 180 : (degree > 225 && degree <= 315 ? 270 : 0)));
        final int deltaDegree = this.mVideoRotationDegree - this.mVideoTargetRotationDegree;
        this.mVideoTargetRotationDegree = this.mVideoRotationDegree;
        final Matrix matrix = this.getVideoTransform();
        if (this.mScreenOrWidth == 0 || this.mScreenOrHeight == 0) {
            this.mScreenOrWidth = this.mRenderView.getView().getWidth();
            this.mScreenOrHeight = this.mRenderView.getView().getHeight();
        }
        if (!this.mIsNormalScreen) {
            matrix.preScale(this.mVideoScale, this.mVideoScale);
            matrix.postTranslate((float)this.mScreenOrWidth * (1.0f - this.mVideoScale) / 2.0f, (float)this.mScreenOrHeight * (1.0f - this.mVideoScale) / 2.0f);
            this.mRenderView.setTransform(matrix);
            this.mIsNormalScreen = true;
        } else {
            float[] points = new float[2];
            matrix.mapPoints(points);
            final float deltaX = (float)this.mScreenOrWidth * (1.0f - this.mVideoScale) / 2.0f - points[0];
            final float deltaY = (float)this.mScreenOrHeight * (1.0f - this.mVideoScale) / 2.0f - points[1];
            if (this.mSaveMatrix == null) {
                this.mSaveMatrix = new Matrix();
            }
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration(300L);
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    float percent = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    IjkVideoView.this.mSaveMatrix.set(matrix);
                    IjkVideoView.this.mSaveMatrix.postTranslate(deltaX * percent, deltaY * percent);
                    IjkVideoView.this.mRenderView.setTransform(IjkVideoView.this.mSaveMatrix);
                    IjkVideoView.this.mRenderView.setVideoRotation((int)((float)IjkVideoView.this.mVideoRotationDegree - (float)deltaDegree * (1.0f - percent)));
                }
            });
            animator.start();
        }
        return true;
    }

    public void resetVideoView(boolean isForever) {
        this.mIsNormalScreen = isForever;
        this.mVideoRotationDegree = 0;
        if (isForever) {
            this.mVideoTargetRotationDegree = 0;
            this.mVideoScale = 1.0f;
        }
        this.mRenderView.setTransform(this.mOriginalMatrix);
        this.mRenderView.setVideoRotation(this.mVideoRotationDegree);
    }

    public void setRender(int render) {
        switch (render) {
            case 0: {
                this.setRenderView(null);
                break;
            }
            case 2: {
                TextureRenderView renderView = new TextureRenderView(this.getContext());
                if (this.mMediaPlayer != null) {
                    renderView.getSurfaceHolder().bindToMediaPlayer(this.mMediaPlayer);
                    renderView.setVideoSize(this.mMediaPlayer.getVideoWidth(), this.mMediaPlayer.getVideoHeight());
                    renderView.setVideoSampleAspectRatio(this.mMediaPlayer.getVideoSarNum(), this.mMediaPlayer.getVideoSarDen());
                    renderView.setAspectRatio(this.mCurrentAspectRatio);
                }
                this.setRenderView(renderView);
                break;
            }
            case 1: {
                SurfaceRenderView renderView = new SurfaceRenderView(this.getContext());
                this.setRenderView(renderView);
                break;
            }
            default: {
                Log.e((String)this.TAG, (String)String.format(Locale.US, "invalid render %d\n", render));
            }
        }
    }

    public void setCustomAdvanced(String customAdvanced) {
        if (!TextUtils.isEmpty((CharSequence)customAdvanced)) {
            try {
                JSONArray jsonArray = new JSONArray(customAdvanced);
                if (jsonArray != null) {
                    this.customAdvanceJSON = jsonArray;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void setVideoURI(Uri uri, String headerInfo) {
        this.customUA = "";
        Map<Object, Object> localCookies = new HashMap();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        HashMap<String, String> newHeader = new HashMap<String, String>();
        try {
            CookieHandler cookieHandler = CookieHandler.getDefault();
            localCookies = cookieHandler.get(URI.create(uri.toString()), headers);
            if (localCookies != null) {
                for (Map.Entry<Object, Object> perEntry : localCookies.entrySet()) {
                    String mapKey = (String)perEntry.getKey();
                    List mapVal = (List)perEntry.getValue();
                    if (!mapKey.equalsIgnoreCase("Cookie") && !mapKey.equalsIgnoreCase("Cookie2")) continue;
                    String cookieHeader = BridgeInterceptor.buildCookieHeader((List)mapVal);
                    newHeader.put(mapKey, cookieHeader);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            newHeader = new HashMap();
        }
        try {
            JSONObject headerJSON = new JSONObject(headerInfo);
            Iterator iteratorKey = headerJSON.keys();
            while (iteratorKey.hasNext()) {
                String perKey = (String)iteratorKey.next();
                String perVal = headerJSON.optString(perKey);
                if (TextUtils.isEmpty((CharSequence)perKey)) continue;
                if ("User-Agent".equalsIgnoreCase(perKey)) {
                    this.customUA = perVal;
                    continue;
                }
                newHeader.put(perKey, perVal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setVideoURI(uri, newHeader);
    }

    public void setVideoFileDescriptor(AssetsDataSourceProvider fd) {
        this.fd = fd;
        this.mSeekWhenPrepared = 0;
        this.isSetSeekTo = false;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    private void setVideoURI(Uri uri, Map<String, String> headers) {
        this.mUri = uri;
        this.mHeaders = headers;
        this.mSeekWhenPrepared = 0;
        this.isSetSeekTo = false;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    public Uri getUri() {
        return this.mUri;
    }

    public void setSpeed(float speed) {
        TextureMediaPlayer ijkMediaHost;
        IjkMediaPlayer innerMedia;
        if (this.mMediaPlayer instanceof IjkMediaPlayer) {
            IjkMediaPlayer ijkMedia = (IjkMediaPlayer)this.mMediaPlayer;
            ijkMedia.setSpeed(speed);
        } else if (this.mMediaPlayer instanceof TextureMediaPlayer && (innerMedia = (IjkMediaPlayer)(ijkMediaHost = (TextureMediaPlayer)this.mMediaPlayer).getInternalMediaPlayer()) instanceof IjkMediaPlayer) {
            IjkMediaPlayer ijkMedia = innerMedia;
            ijkMedia.setSpeed(speed);
        }
    }

    public Bitmap getScreenshot() {
        if (this.mRenderView != null) {
            return this.mRenderView.getVideoScreenshot();
        }
        return null;
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 330;
            this.mTargetState = 330;
            this._notifyMediaStatus();
            AudioManager am = (AudioManager)this.mAppContext.getSystemService("audio");
            am.abandonAudioFocus(null);
            this.isStoped = true;
            this.showCoverImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=23)
    private void openVideo() {
        if (this.mUri == null && this.fd == null || this.mSurfaceHolder == null) {
            if (this.mUri == null && this.fd == null) {
                this.mCurrentState = 331;
                this.mTargetState = 331;
                this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            }
            return;
        }
        this.release(false);
        try {
            this.mMediaPlayer = this.createPlayer(2);
            if (!this.isMediaReady) {
                this.setvolume(this.volume);
                this.isMediaReady = true;
            }
            Context context = this.getContext();
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mMediaPlayer.setOnSeekCompleteListener(this.mSeekCompleteListener);
            this.mCurrentBufferPercentage = 0;
            if (this.mUri != null) {
                String scheme = this.mUri.getScheme();
                if (Build.VERSION.SDK_INT >= 23 && this.mIsUsingMediaDataSource && (TextUtils.isEmpty((CharSequence)scheme) || scheme.equalsIgnoreCase("file"))) {
                    FileMediaDataSource dataSource = new FileMediaDataSource(new File(this.mUri.toString()));
                    this.mMediaPlayer.setDataSource((IMediaDataSource)dataSource);
                } else if (Build.VERSION.SDK_INT >= 14) {
                    this.mMediaPlayer.setDataSource(this.mAppContext, this.mUri, this.mHeaders);
                } else {
                    this.mMediaPlayer.setDataSource(this.mUri.toString());
                }
            } else if (this.fd != null) {
                this.mMediaPlayer.setDataSource((IMediaDataSource)this.fd);
            }
            this.bindSurfaceHolder(this.mMediaPlayer, this.mSurfaceHolder);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mPrepareStartTime = System.currentTimeMillis();
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 332;
            this.attachMediaController();
        }
        catch (IOException ex) {
            this.mCurrentState = 331;
            this.mTargetState = 331;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
        }
        catch (IllegalArgumentException ex) {
            this.mCurrentState = 331;
            this.mTargetState = 331;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
        }
        finally {
            this._notifyMediaStatus();
        }
    }

    public void setMediaController(IMediaController controller) {
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
        this.mMediaController = controller;
        this.attachMediaController();
    }

    private void attachMediaController() {
        if (this.mMediaPlayer != null && this.mMediaController != null) {
            this.mMediaController.setMediaPlayer(this);
            IjkVideoView anchorView = this.getParent() instanceof View ? (View)this.getParent() : this;
            this.mMediaController.setAnchorView((View)anchorView);
            this.mMediaController.setEnabled(this.isInPlaybackState());
        }
    }

    public IMediaPlayer getMediaPlayer() {
        return this.mMediaPlayer;
    }

    private void _notifyMediaStatus() {
        if (this.mOnInfoListener != null) {
            this.mOnInfoListener.onInfo(this.mMediaPlayer, this.mCurrentState, -1);
        }
    }

    private void showCoverImage() {
        if (this.mRenderView != null) {
            if (this.mCurrentAspectRatio == 1) {
                this.coverImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
            } else {
                this.coverImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
            }
            Bitmap videoShot = this.mRenderView.getVideoScreenshot();
            if (this.mVideoRotationDegree > 0) {
                videoShot = this.adjustPhotoRotation(videoShot, this.mVideoRotationDegree);
            }
            if (videoShot != null) {
                this.coverImage.setImageBitmap(videoShot);
            } else {
                this.coverImage.setBackgroundColor(-16777216);
            }
            this.coverImage.bringToFront();
            this.coverImage.setVisibility(0);
        }
    }

    private Bitmap adjustPhotoRotation(Bitmap bm, int orientationDegree) {
        if (bm != null) {
            Matrix m = new Matrix();
            m.setRotate((float)orientationDegree, (float)bm.getWidth() / 2.0f, (float)bm.getHeight() / 2.0f);
            try {
                Bitmap bm1 = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)m, (boolean)true);
                return bm1;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        return null;
    }

    public void setOnBufferingUpdateListener(IMediaPlayer.OnBufferingUpdateListener bufferingUpdateListener) {
        this.bufferingUpdateListener = bufferingUpdateListener;
    }

    public void setOnPreparedListener(IMediaPlayer.OnPreparedListener l) {
        this.mOnPreparedListener = l;
    }

    public void setOnCompletionListener(IMediaPlayer.OnCompletionListener l) {
        this.mOnCompletionListener = l;
    }

    public void setOnErrorListener(IMediaPlayer.OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    public void setOnInfoListener(IMediaPlayer.OnInfoListener l) {
        this.mOnInfoListener = l;
    }

    private void bindSurfaceHolder(IMediaPlayer mp, IRenderView.ISurfaceHolder holder) {
        if (mp == null) {
            return;
        }
        if (holder == null) {
            mp.setDisplay(null);
            return;
        }
        holder.bindToMediaPlayer(mp);
    }

    public void releaseWithoutStop() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setDisplay(null);
        }
    }

    public void release(boolean cleartargetstate) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 330;
            this._notifyMediaStatus();
            if (cleartargetstate) {
                this.mTargetState = 330;
            }
            AudioManager am = (AudioManager)this.mAppContext.getSystemService("audio");
            am.abandonAudioFocus(null);
        }
    }

    public void releaseOnWorkerThread(boolean cleartargetstate) {
        if (this.mMediaPlayer != null) {
            ThreadPool.self().addThreadTask(new Runnable(){

                @Override
                public void run() {
                    IjkVideoView.this.mMediaPlayer.reset();
                    IjkVideoView.this.mMediaPlayer.release();
                    IjkVideoView.this.mMediaPlayer = null;
                }
            });
            this.mCurrentState = 330;
            this._notifyMediaStatus();
            if (cleartargetstate) {
                this.mTargetState = 330;
            }
            AudioManager am = (AudioManager)this.mAppContext.getSystemService("audio");
            am.abandonAudioFocus(null);
        }
    }

    public void destroy() {
        this.releaseOnWorkerThread(true);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisibility();
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisibility();
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean isKeyCodeSupported;
        boolean bl = isKeyCodeSupported = keyCode != 4 && keyCode != 24 && keyCode != 25 && keyCode != 164 && keyCode != 82 && keyCode != 5 && keyCode != 6;
        if (this.isInPlaybackState() && isKeyCodeSupported && this.mMediaController != null) {
            if (keyCode == 79 || keyCode == 85) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                } else {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 126) {
                if (!this.mMediaPlayer.isPlaying()) {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 86 || keyCode == 127) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                }
                return true;
            }
            this.toggleMediaControlsVisibility();
        }
        return super.onKeyDown(keyCode, event);
    }

    private void toggleMediaControlsVisibility() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
        } else {
            this.mMediaController.show();
        }
    }

    public void start() {
        Log.e((String)"TTAG", (String)("start " + this.isInPlaybackState()));
        AudioManager am = (AudioManager)this.mAppContext.getSystemService("audio");
        am.requestAudioFocus(null, 3, 4);
        if (this.isStoped && this.mMediaPlayer == null && this.mCurrentState == 330) {
            this.isStoped = false;
            this.setRender(2);
            this.openVideo();
            this.requestLayout();
            this.invalidate();
        }
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.start();
            this.mCurrentState = 334;
            this._notifyMediaStatus();
            this.isSetSeekTo = false;
        }
        this.mTargetState = 334;
        if (this.mCurrentState == 331) {
            this.mTargetState = 331;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
        }
        this.coverImage.setVisibility(8);
    }

    public void pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 335;
            this._notifyMediaStatus();
        }
        this.mTargetState = 335;
        this.showCoverImage();
    }

    public void suspend() {
        this.release(false);
    }

    public void resume() {
        this.openVideo();
    }

    public void reload() {
        this.mCurrentState = 334;
        this.mTargetState = 334;
    }

    public int getDuration() {
        if (this.isInPlaybackState()) {
            return (int)this.mMediaPlayer.getDuration();
        }
        return -1;
    }

    public void setvolume(float volume) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setVolume(volume, volume);
        } else {
            this.isMediaReady = false;
            this.volume = volume;
        }
    }

    public int getInterruptPosition() {
        if (this.mMediaPlayer != null) {
            return (int)this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public int getCurrentPosition() {
        if (this.isInPlaybackState()) {
            if (this.mCurrentState == 336 && !this.isSetSeekTo) {
                return (int)this.mMediaPlayer.getDuration();
            }
            return (int)this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public void seekTo(int msec) {
        if (this.isInPlaybackState()) {
            this.mSeekStartTime = System.currentTimeMillis();
            this.mMediaPlayer.seekTo((long)msec);
            this.mSeekWhenPrepared = 0;
            this.isSetSeekTo = !this.isPlaying();
        } else {
            this.mSeekWhenPrepared = msec;
            this.isSetSeekTo = false;
        }
    }

    public boolean isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    private boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != 331 && this.mCurrentState != 330 && this.mCurrentState != 332;
    }

    public boolean canPause() {
        return this.mCanPause;
    }

    public boolean canSeekBackward() {
        return this.mCanSeekBack;
    }

    public boolean canSeekForward() {
        return this.mCanSeekForward;
    }

    public int getAudioSessionId() {
        return 0;
    }

    public void setAspectRatio(int aspectRatio) {
        this.mCurrentAspectRatio = aspectRatio;
        if (this.mRenderView != null) {
            this.mRenderView.setAspectRatio(this.mCurrentAspectRatio);
        }
    }

    private void initRenders() {
        this.setRender(2);
    }

    int getVideoWidth() {
        if (this.mMediaPlayer == null) {
            return 0;
        }
        return this.mMediaPlayer.getVideoWidth();
    }

    int getVideoHeight() {
        if (this.mMediaPlayer == null) {
            return 0;
        }
        return this.mMediaPlayer.getVideoHeight();
    }

    public IMediaPlayer createPlayer(int playerType) {
        Object mediaPlayer = null;
        switch (playerType) {
            case 1: {
                AndroidMediaPlayer androidMediaPlayer;
                mediaPlayer = androidMediaPlayer = new AndroidMediaPlayer();
                break;
            }
            default: {
                IjkMediaPlayer ijkMediaPlayer = null;
                if (this.mUri != null || this.fd != null) {
                    ijkMediaPlayer = new IjkMediaPlayer();
                    if (TextUtils.isEmpty((CharSequence)this.customUA)) {
                        ijkMediaPlayer.setOption(1, "user_agent", HttpConstants.getDefaultUA());
                    } else {
                        ijkMediaPlayer.setOption(1, "user_agent", this.customUA);
                    }
                    if (this.mIsUsingMediaCodec) {
                        ijkMediaPlayer.setOption(4, "mediacodec", 1L);
                        if (this.mIsUsingMediaCodecAutoRotate) {
                            ijkMediaPlayer.setOption(4, "mediacodec-auto-rotate", 1L);
                        } else {
                            ijkMediaPlayer.setOption(4, "mediacodec-auto-rotate", 0L);
                        }
                        if (this.mIsMediaCodecHandleResolutionChange) {
                            ijkMediaPlayer.setOption(4, "mediacodec-handle-resolution-change", 1L);
                        } else {
                            ijkMediaPlayer.setOption(4, "mediacodec-handle-resolution-change", 0L);
                        }
                    } else {
                        ijkMediaPlayer.setOption(4, "mediacodec", 0L);
                    }
                    if (this.mIsUsingOpenSLES) {
                        ijkMediaPlayer.setOption(4, "opensles", 1L);
                    } else {
                        ijkMediaPlayer.setOption(4, "opensles", 0L);
                    }
                    if (TextUtils.isEmpty((CharSequence)this.mPixelFormat)) {
                        ijkMediaPlayer.setOption(4, "overlay-format", 842225234L);
                    } else {
                        ijkMediaPlayer.setOption(4, "overlay-format", this.mPixelFormat);
                    }
                    ijkMediaPlayer.setOption(4, "start-on-prepared", 0L);
                    ijkMediaPlayer.setOption(1, "http-detect-range-support", 0L);
                    if (this.enumPlayStrategy == EnumPlayStrategy.PLAY_SMOOTH) {
                        ijkMediaPlayer.setOption(4, "infbuf", 1L);
                        ijkMediaPlayer.setOption(4, "max-fps", 25L);
                        ijkMediaPlayer.setOption(4, "opensles", 1L);
                        ijkMediaPlayer.setOption(4, "mediacodec-mpeg4", 1L);
                        ijkMediaPlayer.setOption(4, "mediacodec-hevc", 1L);
                    } else if (this.enumPlayStrategy == EnumPlayStrategy.M3U8_SMOOTH) {
                        ijkMediaPlayer.setOption(4, "infbuf", 1L);
                        ijkMediaPlayer.setOption(4, "max-fps", 25L);
                    } else if (this.enumPlayStrategy == EnumPlayStrategy.START_QUICK) {
                        // empty if block
                    }
                    ijkMediaPlayer.setOption(2, "skip_loop_filter", 0L);
                    ijkMediaPlayer.setOption(4, "framedrop", 1L);
                    ijkMediaPlayer.setOption(4, "soundtouch", 1L);
                    ijkMediaPlayer.setOption(1, "dns_cache_clear", 1L);
                    if (this.mUri != null && (this.mUri.toString().startsWith("rtmp://") || this.mUri.toString().startsWith("rtsp://"))) {
                        if (this.mUri.toString().startsWith("rtsp://")) {
                            ijkMediaPlayer.setOption(1, "rtsp_transport", "tcp");
                        }
                        ijkMediaPlayer.setOption(1, "flush_packets", 1L);
                        ijkMediaPlayer.setOption(4, "packet-buffering", 0L);
                        ijkMediaPlayer.setOption(4, "framedrop", 1L);
                    } else if (this.mUri != null && (this.mUri.toString().startsWith("http://") || this.mUri.toString().startsWith("https://"))) {
                        if (this.mUri.toString().endsWith(".m3u8") || this.mUri.toString().endsWith(".M3U8")) {
                            this.isHttpCacheOpen = false;
                        } else {
                            ijkMediaPlayer.setOption(4, "enable-accurate-seek", 1L);
                        }
                        if (this.isHttpCacheOpen) {
                            VideoCacheUtil.cleanCacheIfNesscessary(this.mAppContext);
                            this.mUri = VideoCacheUtil.cacheHttpUriWrap(this.mUri);
                            String cacheFilePath = VideoCacheUtil.getCacheFilePath(this.mAppContext, this.mUri);
                            String cacheMapFilePath = VideoCacheUtil.getCacheMapFilePath(this.mAppContext, this.mUri);
                            if (!TextUtils.isEmpty((CharSequence)cacheFilePath) && !TextUtils.isEmpty((CharSequence)cacheMapFilePath)) {
                                ijkMediaPlayer.setOption(1, "cache_file_path", cacheFilePath);
                                ijkMediaPlayer.setOption(1, "cache_map_path", cacheMapFilePath);
                                ijkMediaPlayer.setOption(1, "auto_save_map", 1L);
                                ijkMediaPlayer.setOption(1, "parse_cache_map", 1L);
                            }
                        }
                    }
                    try {
                        for (int i = 0; i < this.customAdvanceJSON.length(); ++i) {
                            JSONObject perJsonObject = this.customAdvanceJSON.getJSONObject(i);
                            if (perJsonObject == null) continue;
                            String keyParam = perJsonObject.getString("key");
                            String valString = perJsonObject.optString("value");
                            String typeParam = perJsonObject.getString("type");
                            int paramVal = "format".equalsIgnoreCase(typeParam) ? 1 : ("codec".equalsIgnoreCase(typeParam) ? 2 : ("sws".equalsIgnoreCase(typeParam) ? 3 : ("player".equalsIgnoreCase(typeParam) ? 4 : -10086)));
                            if (paramVal == -10086 || ijkMediaPlayer == null) continue;
                            if (IjkVideoView.isNumeric(valString)) {
                                int valueParam = Integer.parseInt(valString);
                                ijkMediaPlayer.setOption(paramVal, keyParam, (long)valueParam);
                                continue;
                            }
                            ijkMediaPlayer.setOption(paramVal, keyParam, valString);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                mediaPlayer = this.mIsUsingMediaCodec ? new TextureMediaPlayer((IMediaPlayer)ijkMediaPlayer) : ijkMediaPlayer;
            }
        }
        return mediaPlayer;
    }

    public static boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            System.out.println(str.charAt(i));
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void initBackground() {
    }

    public boolean isBackgroundPlayEnabled() {
        return this.mEnableBackgroundPlay;
    }

    public void enterBackground() {
    }

    public void stopBackgroundPlay() {
    }

    private String buildTimeMilli(long duration) {
        long total_seconds = duration / 1000L;
        long hours = total_seconds / 3600L;
        long minutes = total_seconds % 3600L / 60L;
        long seconds = total_seconds % 60L;
        if (duration <= 0L) {
            return "--:--";
        }
        if (hours >= 100L) {
            return String.format(Locale.US, "%d:%02d:%02d", hours, minutes, seconds);
        }
        if (hours > 0L) {
            return String.format(Locale.US, "%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format(Locale.US, "%02d:%02d", minutes, seconds);
    }

    public ITrackInfo[] getTrackInfo() {
        if (this.mMediaPlayer == null) {
            return null;
        }
        return this.mMediaPlayer.getTrackInfo();
    }

    public void selectTrack(int stream) {
        MediaPlayerCompat.selectTrack(this.mMediaPlayer, stream);
    }

    public void deselectTrack(int stream) {
        MediaPlayerCompat.deselectTrack(this.mMediaPlayer, stream);
    }

    public int getSelectedTrack(int trackType) {
        return MediaPlayerCompat.getSelectedTrack(this.mMediaPlayer, trackType);
    }
}

