/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model.android;

import android.annotation.SuppressLint;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextPaint;
import java.util.HashMap;
import java.util.Map;
import master.flame.danmaku.danmaku.model.AbsDisplayer;
import master.flame.danmaku.danmaku.model.AlphaValue;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.android.BaseCacheStuffer;
import master.flame.danmaku.danmaku.model.android.SimpleTextCacheStuffer;

public class AndroidDisplayer
extends AbsDisplayer<Canvas, Typeface> {
    private Camera camera = new Camera();
    private Matrix matrix = new Matrix();
    private final DisplayerConfig mDisplayConfig = new DisplayerConfig();
    private BaseCacheStuffer sStuffer = new SimpleTextCacheStuffer();
    public Canvas canvas;
    private int width;
    private int height;
    private float density = 1.0f;
    private int densityDpi = 160;
    private float scaledDensity = 1.0f;
    private int mSlopPixel = 0;
    private boolean mIsHardwareAccelerated = true;
    private int mMaximumBitmapWidth = 2048;
    private int mMaximumBitmapHeight = 2048;

    @SuppressLint(value={"NewApi"})
    private static final int getMaximumBitmapWidth(Canvas c) {
        if (Build.VERSION.SDK_INT >= 14) {
            return c.getMaximumBitmapWidth();
        }
        return c.getWidth();
    }

    @SuppressLint(value={"NewApi"})
    private static final int getMaximumBitmapHeight(Canvas c) {
        if (Build.VERSION.SDK_INT >= 14) {
            return c.getMaximumBitmapHeight();
        }
        return c.getHeight();
    }

    @Override
    public void setTypeFace(Typeface font) {
        this.mDisplayConfig.setTypeface(font);
    }

    public void setShadowRadius(float s) {
        this.mDisplayConfig.setShadowRadius(s);
    }

    public void setPaintStorkeWidth(float s) {
        this.mDisplayConfig.setStrokeWidth(s);
    }

    public void setProjectionConfig(float offsetX, float offsetY, int alpha) {
        this.mDisplayConfig.setProjectionConfig(offsetX, offsetY, alpha);
    }

    @Override
    public void setFakeBoldText(boolean fakeBoldText) {
        this.mDisplayConfig.setFakeBoldText(fakeBoldText);
    }

    @Override
    public void setTransparency(int newTransparency) {
        this.mDisplayConfig.setTransparency(newTransparency);
    }

    @Override
    public void setScaleTextSizeFactor(float factor) {
        this.mDisplayConfig.setScaleTextSizeFactor(factor);
    }

    @Override
    public void setCacheStuffer(BaseCacheStuffer cacheStuffer) {
        if (cacheStuffer != this.sStuffer) {
            this.sStuffer = cacheStuffer;
        }
    }

    @Override
    public BaseCacheStuffer getCacheStuffer() {
        return this.sStuffer;
    }

    private void update(Canvas c) {
        this.canvas = c;
        if (c != null) {
            this.width = c.getWidth();
            this.height = c.getHeight();
            if (this.mIsHardwareAccelerated) {
                this.mMaximumBitmapWidth = AndroidDisplayer.getMaximumBitmapWidth(c);
                this.mMaximumBitmapHeight = AndroidDisplayer.getMaximumBitmapHeight(c);
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public float getDensity() {
        return this.density;
    }

    @Override
    public int getDensityDpi() {
        return this.densityDpi;
    }

    @Override
    public int draw(BaseDanmaku danmaku) {
        float top = danmaku.getTop();
        float left = danmaku.getLeft();
        if (this.canvas != null) {
            Paint alphaPaint = null;
            boolean needRestore = false;
            if (danmaku.getType() == 7) {
                int alpha;
                if (danmaku.getAlpha() == AlphaValue.TRANSPARENT) {
                    return 0;
                }
                if (danmaku.rotationZ != 0.0f || danmaku.rotationY != 0.0f) {
                    this.saveCanvas(danmaku, this.canvas, left, top);
                    needRestore = true;
                }
                if ((alpha = danmaku.getAlpha()) != AlphaValue.MAX) {
                    alphaPaint = this.mDisplayConfig.ALPHA_PAINT;
                    alphaPaint.setAlpha(danmaku.getAlpha());
                }
            }
            if (alphaPaint != null && alphaPaint.getAlpha() == AlphaValue.TRANSPARENT) {
                return 0;
            }
            boolean cacheDrawn = this.sStuffer.drawCache(danmaku, this.canvas, left, top, alphaPaint, this.mDisplayConfig.PAINT);
            int result = 1;
            if (!cacheDrawn) {
                if (alphaPaint != null) {
                    this.mDisplayConfig.PAINT.setAlpha(alphaPaint.getAlpha());
                } else {
                    this.resetPaintAlpha((Paint)this.mDisplayConfig.PAINT);
                }
                this.drawDanmaku(danmaku, this.canvas, left, top, false);
                result = 2;
            }
            if (needRestore) {
                this.restoreCanvas(this.canvas);
            }
            return result;
        }
        return 0;
    }

    @Override
    public void recycle(BaseDanmaku danmaku) {
        if (this.sStuffer != null) {
            this.sStuffer.releaseResource(danmaku);
        }
    }

    private void resetPaintAlpha(Paint paint) {
        if (paint.getAlpha() != AlphaValue.MAX) {
            paint.setAlpha(AlphaValue.MAX);
        }
    }

    private void restoreCanvas(Canvas canvas) {
        canvas.restore();
    }

    private int saveCanvas(BaseDanmaku danmaku, Canvas canvas, float left, float top) {
        this.camera.save();
        this.camera.rotateY(-danmaku.rotationY);
        this.camera.rotateZ(-danmaku.rotationZ);
        this.camera.getMatrix(this.matrix);
        this.matrix.preTranslate(-left, -top);
        this.matrix.postTranslate(left, top);
        this.camera.restore();
        int count = canvas.save();
        canvas.concat(this.matrix);
        return count;
    }

    @Override
    public synchronized void drawDanmaku(BaseDanmaku danmaku, Canvas canvas, float left, float top, boolean fromWorkerThread) {
        if (this.sStuffer != null) {
            this.sStuffer.drawDanmaku(danmaku, canvas, left, top, fromWorkerThread, this.mDisplayConfig);
        }
    }

    private synchronized TextPaint getPaint(BaseDanmaku danmaku, boolean fromWorkerThread) {
        return this.mDisplayConfig.getPaint(danmaku, fromWorkerThread);
    }

    @Override
    public void prepare(BaseDanmaku danmaku, boolean fromWorkerThread) {
        if (this.sStuffer != null) {
            this.sStuffer.prepare(danmaku, fromWorkerThread);
        }
    }

    @Override
    public void measure(BaseDanmaku danmaku, boolean fromWorkerThread) {
        TextPaint paint = this.getPaint(danmaku, fromWorkerThread);
        if (this.mDisplayConfig.HAS_STROKE) {
            this.mDisplayConfig.applyPaintConfig(danmaku, (Paint)paint, true);
        }
        this.calcPaintWH(danmaku, paint, fromWorkerThread);
        if (this.mDisplayConfig.HAS_STROKE) {
            this.mDisplayConfig.applyPaintConfig(danmaku, (Paint)paint, false);
        }
    }

    private void calcPaintWH(BaseDanmaku danmaku, TextPaint paint, boolean fromWorkerThread) {
        this.sStuffer.measure(danmaku, paint, fromWorkerThread);
        this.setDanmakuPaintWidthAndHeight(danmaku, danmaku.paintWidth, danmaku.paintHeight);
    }

    private void setDanmakuPaintWidthAndHeight(BaseDanmaku danmaku, float w, float h) {
        float pw = w + (float)(2 * danmaku.padding);
        float ph = h + (float)(2 * danmaku.padding);
        if (danmaku.borderColor != 0) {
            pw += (float)(2 * 4);
            ph += (float)(2 * 4);
        }
        danmaku.paintWidth = pw + this.getStrokeWidth();
        danmaku.paintHeight = ph;
    }

    @Override
    public void clearTextHeightCache() {
        this.sStuffer.clearCaches();
        this.mDisplayConfig.clearTextHeightCache();
    }

    @Override
    public float getScaledDensity() {
        return this.scaledDensity;
    }

    @Override
    public void resetSlopPixel(float factor) {
        float d = Math.max(factor, (float)this.getWidth() / 682.0f);
        float slop = d * 25.0f;
        this.mSlopPixel = (int)slop;
        if (factor > 1.0f) {
            this.mSlopPixel = (int)(slop * factor);
        }
    }

    @Override
    public int getSlopPixel() {
        return this.mSlopPixel;
    }

    @Override
    public void setDensities(float density, int densityDpi, float scaledDensity) {
        this.density = density;
        this.densityDpi = densityDpi;
        this.scaledDensity = scaledDensity;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void setDanmakuStyle(int style, float[] values) {
        switch (style) {
            case 0: {
                this.mDisplayConfig.CONFIG_HAS_SHADOW = false;
                this.mDisplayConfig.CONFIG_HAS_STROKE = false;
                this.mDisplayConfig.CONFIG_HAS_PROJECTION = false;
                break;
            }
            case 1: {
                this.mDisplayConfig.CONFIG_HAS_SHADOW = true;
                this.mDisplayConfig.CONFIG_HAS_STROKE = false;
                this.mDisplayConfig.CONFIG_HAS_PROJECTION = false;
                this.setShadowRadius(values[0]);
                break;
            }
            case -1: 
            case 2: {
                this.mDisplayConfig.CONFIG_HAS_SHADOW = false;
                this.mDisplayConfig.CONFIG_HAS_STROKE = true;
                this.mDisplayConfig.CONFIG_HAS_PROJECTION = false;
                this.setPaintStorkeWidth(values[0]);
                break;
            }
            case 3: {
                this.mDisplayConfig.CONFIG_HAS_SHADOW = false;
                this.mDisplayConfig.CONFIG_HAS_STROKE = false;
                this.mDisplayConfig.CONFIG_HAS_PROJECTION = true;
                this.setProjectionConfig(values[0], values[1], (int)values[2]);
            }
        }
    }

    @Override
    public void setExtraData(Canvas data) {
        this.update(data);
    }

    @Override
    public Canvas getExtraData() {
        return this.canvas;
    }

    @Override
    public float getStrokeWidth() {
        return this.mDisplayConfig.getStrokeWidth();
    }

    @Override
    public void setHardwareAccelerated(boolean enable) {
        this.mIsHardwareAccelerated = enable;
    }

    @Override
    public boolean isHardwareAccelerated() {
        return this.mIsHardwareAccelerated;
    }

    @Override
    public int getMaximumCacheWidth() {
        return this.mMaximumBitmapWidth;
    }

    @Override
    public int getMaximumCacheHeight() {
        return this.mMaximumBitmapHeight;
    }

    public static class DisplayerConfig {
        private float sLastScaleTextSize;
        private final Map<Float, Float> sCachedScaleSize = new HashMap<Float, Float>(10);
        public final TextPaint PAINT;
        public final TextPaint PAINT_DUPLICATE;
        private Paint ALPHA_PAINT;
        private Paint UNDERLINE_PAINT;
        private Paint BORDER_PAINT;
        public int UNDERLINE_HEIGHT = 4;
        public static final int BORDER_WIDTH = 4;
        private float SHADOW_RADIUS = 4.0f;
        private float STROKE_WIDTH = 3.5f;
        public float sProjectionOffsetX = 1.0f;
        public float sProjectionOffsetY = 1.0f;
        private int sProjectionAlpha = 204;
        public boolean CONFIG_HAS_SHADOW;
        private boolean HAS_SHADOW = this.CONFIG_HAS_SHADOW = false;
        public boolean CONFIG_HAS_STROKE;
        private boolean HAS_STROKE = this.CONFIG_HAS_STROKE = true;
        public boolean CONFIG_HAS_PROJECTION;
        public boolean HAS_PROJECTION = this.CONFIG_HAS_PROJECTION = false;
        public boolean CONFIG_ANTI_ALIAS;
        private boolean ANTI_ALIAS = this.CONFIG_ANTI_ALIAS = true;
        private boolean isTranslucent;
        private int transparency = AlphaValue.MAX;
        private float scaleTextSize = 1.0f;
        private boolean isTextScaled = false;

        public DisplayerConfig() {
            this.PAINT = new TextPaint();
            this.PAINT.setStrokeWidth(this.STROKE_WIDTH);
            this.PAINT_DUPLICATE = new TextPaint((Paint)this.PAINT);
            this.ALPHA_PAINT = new Paint();
            this.UNDERLINE_PAINT = new Paint();
            this.UNDERLINE_PAINT.setStrokeWidth((float)this.UNDERLINE_HEIGHT);
            this.UNDERLINE_PAINT.setStyle(Paint.Style.STROKE);
            this.BORDER_PAINT = new Paint();
            this.BORDER_PAINT.setStyle(Paint.Style.STROKE);
            this.BORDER_PAINT.setStrokeWidth(4.0f);
        }

        public void setTypeface(Typeface typeface) {
            this.PAINT.setTypeface(typeface);
        }

        public void setShadowRadius(float shadowRadius) {
            this.SHADOW_RADIUS = shadowRadius;
        }

        public void setStrokeWidth(float s) {
            this.PAINT.setStrokeWidth(s);
            this.STROKE_WIDTH = s;
        }

        public void setProjectionConfig(float offsetX, float offsetY, int alpha) {
            if (this.sProjectionOffsetX != offsetX || this.sProjectionOffsetY != offsetY || this.sProjectionAlpha != alpha) {
                this.sProjectionOffsetX = offsetX > 1.0f ? offsetX : 1.0f;
                float f = this.sProjectionOffsetY = offsetY > 1.0f ? offsetY : 1.0f;
                this.sProjectionAlpha = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
            }
        }

        public void setFakeBoldText(boolean fakeBoldText) {
            this.PAINT.setFakeBoldText(fakeBoldText);
        }

        public void setTransparency(int newTransparency) {
            this.isTranslucent = newTransparency != AlphaValue.MAX;
            this.transparency = newTransparency;
        }

        public void setScaleTextSizeFactor(float factor) {
            this.isTextScaled = factor != 1.0f;
            this.scaleTextSize = factor;
        }

        private void applyTextScaleConfig(BaseDanmaku danmaku, Paint paint) {
            if (!this.isTextScaled) {
                return;
            }
            Float size = this.sCachedScaleSize.get(Float.valueOf(danmaku.textSize));
            if (size == null || this.sLastScaleTextSize != this.scaleTextSize) {
                this.sLastScaleTextSize = this.scaleTextSize;
                size = Float.valueOf(danmaku.textSize * this.scaleTextSize);
                this.sCachedScaleSize.put(Float.valueOf(danmaku.textSize), size);
            }
            paint.setTextSize(size.floatValue());
        }

        public boolean hasStroke(BaseDanmaku danmaku) {
            return (this.HAS_STROKE || this.HAS_PROJECTION) && this.STROKE_WIDTH > 0.0f && danmaku.textShadowColor != 0;
        }

        public Paint getBorderPaint(BaseDanmaku danmaku) {
            this.BORDER_PAINT.setColor(danmaku.borderColor);
            return this.BORDER_PAINT;
        }

        public Paint getUnderlinePaint(BaseDanmaku danmaku) {
            this.UNDERLINE_PAINT.setColor(danmaku.underlineColor);
            return this.UNDERLINE_PAINT;
        }

        public TextPaint getPaint(BaseDanmaku danmaku, boolean fromWorkerThread) {
            TextPaint paint;
            if (fromWorkerThread) {
                paint = this.PAINT;
            } else {
                paint = this.PAINT_DUPLICATE;
                paint.set(this.PAINT);
            }
            paint.setTextSize(danmaku.textSize);
            this.applyTextScaleConfig(danmaku, (Paint)paint);
            if (!this.HAS_SHADOW || this.SHADOW_RADIUS <= 0.0f || danmaku.textShadowColor == 0) {
                paint.clearShadowLayer();
            } else {
                paint.setShadowLayer(this.SHADOW_RADIUS, 0.0f, 0.0f, danmaku.textShadowColor);
            }
            paint.setAntiAlias(this.ANTI_ALIAS);
            return paint;
        }

        public void applyPaintConfig(BaseDanmaku danmaku, Paint paint, boolean stroke) {
            if (this.isTranslucent) {
                if (stroke) {
                    paint.setStyle(this.HAS_PROJECTION ? Paint.Style.FILL : Paint.Style.STROKE);
                    paint.setColor(danmaku.textShadowColor & 0xFFFFFF);
                    int alpha = this.HAS_PROJECTION ? (int)((float)this.sProjectionAlpha * ((float)this.transparency / (float)AlphaValue.MAX)) : this.transparency;
                    paint.setAlpha(alpha);
                } else {
                    paint.setStyle(Paint.Style.FILL);
                    paint.setColor(danmaku.textColor & 0xFFFFFF);
                    paint.setAlpha(this.transparency);
                }
            } else if (stroke) {
                paint.setStyle(this.HAS_PROJECTION ? Paint.Style.FILL : Paint.Style.STROKE);
                paint.setColor(danmaku.textShadowColor & 0xFFFFFF);
                int alpha = this.HAS_PROJECTION ? this.sProjectionAlpha : AlphaValue.MAX;
                paint.setAlpha(alpha);
            } else {
                paint.setStyle(Paint.Style.FILL);
                paint.setColor(danmaku.textColor & 0xFFFFFF);
                paint.setAlpha(AlphaValue.MAX);
            }
        }

        public void clearTextHeightCache() {
            this.sCachedScaleSize.clear();
        }

        public float getStrokeWidth() {
            if (this.HAS_SHADOW && this.HAS_STROKE) {
                return Math.max(this.SHADOW_RADIUS, this.STROKE_WIDTH);
            }
            if (this.HAS_SHADOW) {
                return this.SHADOW_RADIUS;
            }
            if (this.HAS_STROKE) {
                return this.STROKE_WIDTH;
            }
            return 0.0f;
        }

        public void definePaintParams(boolean fromWorkerThread) {
            this.HAS_STROKE = this.CONFIG_HAS_STROKE;
            this.HAS_SHADOW = this.CONFIG_HAS_SHADOW;
            this.HAS_PROJECTION = this.CONFIG_HAS_PROJECTION;
            this.ANTI_ALIAS = fromWorkerThread && this.CONFIG_ANTI_ALIAS;
        }
    }
}

