/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.v4.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import com.dcloud.android.v4.view.ViewCompat;

class CircleImageView
extends ImageView {
    private static final int KEY_SHADOW_COLOR = 0x5E000000;
    private static final int FILL_SHADOW_COLOR = 0x3D000000;
    private static final float X_OFFSET = 0.0f;
    private static final float Y_OFFSET = 1.0f;
    private static final float SHADOW_RADIUS = 2.5f;
    private static final int SHADOW_ELEVATION = 4;
    private Animation.AnimationListener mListener;
    private int mShadowRadius;
    boolean mUseElevation;

    public CircleImageView(Context context, int n5, float f5, boolean bl) {
        ShapeDrawable shapeDrawable;
        float f6;
        CircleImageView circleImageView = this;
        super(context);
        circleImageView.mUseElevation = true;
        float f7 = f6 = circleImageView.getContext().getResources().getDisplayMetrics().density;
        int n6 = (int)(f5 * f6 * 2.0f);
        int f9 = (int)(f7 * 1.0f);
        int f10 = (int)(f7 * 0.0f);
        this.mUseElevation = bl;
        circleImageView.mShadowRadius = (int)(f6 * 2.5f);
        if (circleImageView.elevationSupported()) {
            ShapeDrawable shapeDrawable2;
            shapeDrawable = shapeDrawable2;
            shapeDrawable2 = new ShapeDrawable((Shape)new OvalShape());
            ViewCompat.setElevation((View)this, f6 * 4.0f);
        } else {
            ShapeDrawable shapeDrawable3;
            OvalShadow ovalShadow;
            CircleImageView circleImageView2 = this;
            OvalShadow ovalShadow2 = ovalShadow;
            CircleImageView circleImageView3 = this;
            ovalShadow = circleImageView3.new OvalShadow(circleImageView3.mShadowRadius, n6);
            ShapeDrawable shapeDrawable4 = shapeDrawable3;
            ViewCompat.setLayerType((View)circleImageView2, 1, new ShapeDrawable((Shape)ovalShadow2).getPaint());
            float f8 = this.mShadowRadius;
            float f11 = f10;
            float f12 = f9;
            shapeDrawable4.getPaint().setShadowLayer(f8, f11, f12, 0x5E000000);
            int n7 = circleImageView2.mShadowRadius;
            circleImageView2.setPadding(n7, n7, n7, n7);
            shapeDrawable = shapeDrawable4;
        }
        ShapeDrawable shapeDrawable4 = shapeDrawable;
        shapeDrawable4.getPaint().setColor(n5);
        this.setBackgroundDrawable((Drawable)shapeDrawable4);
    }

    public CircleImageView(Context context, int n5, float f5) {
        this(context, n5, f5, true);
    }

    private boolean elevationSupported() {
        return Build.VERSION.SDK_INT >= 21 && this.mUseElevation;
    }

    static /* synthetic */ int access$002(CircleImageView circleImageView, int n5) {
        circleImageView.mShadowRadius = n5;
        return n5;
    }

    protected void onMeasure(int n5, int n6) {
        CircleImageView circleImageView = this;
        super.onMeasure(n5, n6);
        if (!circleImageView.elevationSupported()) {
            CircleImageView circleImageView2 = this;
            circleImageView2.setMeasuredDimension(circleImageView2.getMeasuredWidth() + this.mShadowRadius * 2, this.getMeasuredHeight() + this.mShadowRadius * 2);
            return;
        }
    }

    public void setAnimationListener(Animation.AnimationListener animationListener) {
        this.mListener = animationListener;
    }

    public void onAnimationStart() {
        CircleImageView circleImageView = this;
        super.onAnimationStart();
        Animation.AnimationListener animationListener = circleImageView.mListener;
        if (animationListener != null) {
            animationListener.onAnimationStart(this.getAnimation());
            return;
        }
    }

    public void onAnimationEnd() {
        CircleImageView circleImageView = this;
        super.onAnimationEnd();
        Animation.AnimationListener animationListener = circleImageView.mListener;
        if (animationListener != null) {
            animationListener.onAnimationEnd(this.getAnimation());
            return;
        }
    }

    public void setBackgroundColorRes(int n5) {
        CircleImageView circleImageView = this;
        circleImageView.setBackgroundColor(circleImageView.getContext().getResources().getColor(n5));
    }

    public void setBackgroundColor(int n5) {
        if (this.getBackground() instanceof ShapeDrawable) {
            ((ShapeDrawable)this.getBackground()).getPaint().setColor(n5);
            return;
        }
    }

    private class OvalShadow
    extends OvalShape {
        private RadialGradient mRadialGradient;
        private Paint mShadowPaint = new Paint();
        private int mCircleDiameter;

        public OvalShadow(int n5, int n6) {
            RadialGradient radialGradient;
            CircleImageView.access$002(CircleImageView.this, n5);
            this.mCircleDiameter = n6;
            RadialGradient radialGradient2 = radialGradient;
            int n7 = this.mCircleDiameter;
            float f5 = n7 / 2;
            float f6 = n7 / 2;
            float f7 = CircleImageView.this.mShadowRadius;
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = 0x3D000000;
            nArray[1] = 0;
            CircleImageView.this = Shader.TileMode.CLAMP;
            this.mRadialGradient = new RadialGradient(f5, f6, f7, nArray2, null, (Shader.TileMode)CircleImageView.this);
            this.mShadowPaint.setShader((Shader)radialGradient2);
        }

        public void draw(Canvas canvas, Paint paint) {
            Canvas canvas2 = canvas;
            OvalShadow ovalShadow = this;
            int n5 = ovalShadow.CircleImageView.this.getWidth();
            float f5 = n5 / 2;
            float f6 = ovalShadow.CircleImageView.this.getHeight() / 2;
            float f7 = ovalShadow.mCircleDiameter / 2 + CircleImageView.this.mShadowRadius;
            Paint paint2 = ovalShadow.mShadowPaint;
            canvas2.drawCircle(f5, f6, f7, paint2);
            canvas2.drawCircle(f5, f6, (float)(this.mCircleDiameter / 2), paint);
        }
    }
}

