/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.mozilla.universalchardet.UnicodeBOMInputStream;
import org.mozilla.universalchardet.UniversalDetector;

public final class ReaderFactory {
    private ReaderFactory() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static Reader createReaderFromFile(File file, Charset charset) throws IOException {
        if (charset != null) {
            FileInputStream fileInputStream;
            BufferedInputStream bufferedInputStream;
            UnicodeBOMInputStream unicodeBOMInputStream;
            Object object = UniversalDetector.detectCharset(file);
            if (object != null) {
                charset = Charset.forName((String)object);
            }
            if (!charset.toString().contains("UTF")) {
                FileInputStream fileInputStream2;
                BufferedInputStream bufferedInputStream2;
                object = bufferedInputStream2;
                FileInputStream fileInputStream3 = fileInputStream2;
                fileInputStream2 = new FileInputStream(file);
                bufferedInputStream2 = new BufferedInputStream(fileInputStream3);
                return new InputStreamReader((InputStream)object, charset);
            }
            object = unicodeBOMInputStream;
            BufferedInputStream bufferedInputStream3 = bufferedInputStream;
            FileInputStream fileInputStream4 = fileInputStream;
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream4);
            unicodeBOMInputStream = new UnicodeBOMInputStream(bufferedInputStream3);
            return new InputStreamReader((InputStream)object, charset);
        }
        throw new NullPointerException("defaultCharset must be not null");
    }

    public static Reader createReaderFromFile(File file) throws IOException {
        return ReaderFactory.createReaderFromFile(file, Charset.defaultCharset());
    }
}

